/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.PrintStream;

public class ViewPane
extends Gadget {
    String titleString = "ViewPane #";
    String selectString = "Clicked";
    int viewPaneNumber = -1;
    int mpX = 5;
    int mpY = 5;
    int mpX2 = 0;
    int mpY2 = 0;
    int mpWidth = 0;
    int mpHeight = 0;
    Color frameColor1 = null;
    Color frameColor2 = null;
    Color frameColor3 = null;
    Color menuPaneColor = null;
    Color textColor = null;
    int fontHeight = 12;
    Font f1 = null;
    HyperKeyboard keyboard = null;

    ViewPane() {
        this.totalAttached = 0;
        this.maxAttached = 64;
        this.attachedIndex = 0;
        this.curAttached = 0;
        this.attachedGob = new Gob[this.maxAttached];
        this.moveNum = -1;
        this.mX = new int[32];
        this.mX2 = new int[32];
        this.mY = new int[32];
        this.mY2 = new int[32];
    }

    ViewPane(HyperView tView, int tx, int ty, int tWidth, int tHeight) {
        this(tView, tx, ty, tWidth, tHeight, null, null, null, (Color)null);
    }

    ViewPane(HyperView tView, int tx, int ty, int tWidth, int tHeight, Color fc1, Color fc2, Color fc3, Color mpc) {
        this.totalAttached = 0;
        this.maxAttached = 64;
        this.attachedIndex = 0;
        this.curAttached = 0;
        this.moveNum = -1;
        this.mX = new int[32];
        this.mX2 = new int[32];
        this.mY = new int[32];
        this.mY2 = new int[32];
        if (this.attachedGob == null) {
            this.attachedGob = new Gob[this.maxAttached];
        }
        this.curView = tView;
        this.x = tx;
        this.y = ty;
        this.fGPen = this.curView.fGPen;
        this.bGPen = this.curView.bGPen;
        this.width = tWidth;
        this.height = tHeight;
        if (this.curView.totalGobs >= 255) {
            this.curView.guru("ViewPane() Goblist overflow");
            return;
        }
        this.frameColor1 = fc1 == null ? this.curView.color[1] : fc1;
        this.frameColor2 = fc2 == null ? this.curView.color[9] : fc2;
        this.frameColor3 = fc3 == null ? this.curView.color[8] : fc3;
        this.menuPaneColor = mpc == null ? this.curView.color[1] : mpc;
        this.textColor = this.curView.color[0];
        this.addDispatch(new Dispatch(this.curView));
        this.gadFlags &= 0xFF7FFFFF;
        this.gadNumber = this.curView.totalGads;
        this.method.setID(this.gadNumber);
        this.gobName = "ViewPane(" + this.curView.totalGobs + ")";
        this.curView.flags |= 0x20;
        this.gobFlags |= 4;
        this.gadFlags |= 0x10000001;
        this.f1 = FontBase.f2;
        this.fontHeight = FontBase.fontHeight[2];
        this.makeBitMap();
        this.curView.addGadget(this, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void makeBitMap() {
        Object object = this.curView.blitterLock;
        synchronized (object) {
            this.x2 = this.width + this.x;
            this.y2 = this.height + this.y;
            this.mpX2 = this.width - this.mpX;
            this.mpY2 = this.height - this.mpY;
            this.mpWidth = this.mpX2 - this.mpX;
            this.mpHeight = this.mpY2 - this.mpY;
            this.selectImage = this.curView.createImage(this.width, this.height);
            this.selectGraphics = this.selectImage.getGraphics();
            this.asynchImage1 = this.curView.createImage(this.width, this.height);
            this.asynchGraphics1 = this.asynchImage1.getGraphics();
            this.asynchGraphics1.setFont(FontBase.hyperConFont12);
            this.gobPic = this.asynchImage1;
            this.graphics = this.asynchGraphics1;
            this.asynchImage2 = this.curView.createImage(this.width, this.height);
            this.asynchGraphics2 = this.asynchImage2.getGraphics();
            this.selectGraphics.setFont(FontBase.hyperConFont12);
            this.erase();
            this.asynchGraphics2.setFont(FontBase.hyperConFont12);
            this.asynchGraphics2.setColor(this.frameColor1);
            this.asynchGraphics2.drawLine(0, this.height - 1, 0, 0);
            this.asynchGraphics2.drawLine(1, 0, this.width - 1, 0);
            this.asynchGraphics2.setColor(this.frameColor3);
            this.asynchGraphics2.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            this.asynchGraphics2.drawLine(this.width - 1, this.height - 1, 1, this.height - 1);
            this.asynchGraphics2.setColor(this.frameColor2);
            this.asynchGraphics2.fillRect(1, 1, this.width - 2, this.height - 2);
            this.asynchGraphics2.setColor(this.menuPaneColor);
            this.asynchGraphics2.fillRect(this.mpX, this.mpY, this.mpWidth, this.mpHeight);
            this.curView.blitterLock.notifyAll();
        }
    }

    public synchronized void setFont(int n) {
        this.f1 = FontBase.fonts[n];
        this.fontHeight = FontBase.fontHeight[2];
        this.graphics.setFont(this.f1);
    }

    public void reSize(int tWidth, int tHeight) {
        this.width = tWidth;
        this.height = tHeight;
        this.makeBitMap();
    }

    public void drawString(String str, int tx, int ty) {
        this.graphics.drawString(str, tx, ty);
    }

    public void drawString(String str, int tPen, int tx, int ty) {
        this.graphics.setColor(this.curView.color[tPen]);
        this.graphics.drawString(str, tx, ty);
    }

    public void drawStrings(String[] str, int tX, int tY) {
        int len = str.length;
        this.graphics.setColor(this.menuPaneColor);
        this.graphics.fillRect(this.mpX, this.mpY, this.mpWidth, this.mpHeight);
        this.graphics.setColor(this.textColor);
        for (int i = 0; i < len; ++i) {
            this.graphics.drawString(str[i], this.mpX + 2, 20 + i * this.fontHeight);
        }
    }

    public void eraseMenuPane() {
        this.graphics.setColor(this.menuPaneColor);
        this.graphics.fillRect(this.mpX, this.mpY, this.mpWidth, this.mpHeight);
    }

    public void erase() {
        int tx = 0;
        int ty = this.fontHeight + this.height >> 1;
        this.graphics.setColor(this.frameColor1);
        this.graphics.drawLine(0, this.height - 1, 0, 0);
        this.graphics.drawLine(1, 0, this.width - 1, 0);
        this.graphics.setColor(this.frameColor3);
        this.graphics.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
        this.graphics.drawLine(this.width - 1, this.height - 1, 1, this.height - 1);
        this.graphics.setColor(this.frameColor2);
        this.graphics.fillRect(1, 1, this.width - 2, this.height - 2);
        this.graphics.setColor(this.menuPaneColor);
        this.graphics.fillRect(this.mpX, this.mpY, this.mpWidth, this.mpHeight);
        this.selectGraphics.setColor(this.frameColor1);
        this.selectGraphics.drawLine(0, this.height - 1, 0, 0);
        this.selectGraphics.drawLine(1, 0, this.width - 1, 0);
        this.selectGraphics.setColor(this.frameColor3);
        this.selectGraphics.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
        this.selectGraphics.drawLine(this.width - 1, this.height - 1, 1, this.height - 1);
        FontMetrics fm1 = null;
        try {
            fm1 = this.graphics.getFontMetrics(this.f1);
        }
        catch (Exception zip) {
            if (this.graphics == null) {
                HyperView.hyperViewOut("viewPane null graphics!");
            }
            if (this.f1 == null) {
                HyperView.hyperViewOut("null font in ViewPane()");
            }
            zip.printStackTrace(new PrintStream(HyperView.fp));
        }
        tx = (this.width >> 1) - (fm1.stringWidth(this.selectString) >> 1);
        this.selectGraphics.setColor(this.frameColor2);
        this.selectGraphics.fillRect(1, 1, this.width - 1, this.height - 1);
        this.selectGraphics.setColor(this.curView.color[1]);
        this.selectGraphics.drawString(this.selectString, tx, ty);
        this.selectGraphics.setColor(this.curView.color[0]);
        this.selectGraphics.drawString(this.selectString, tx - 1, ty - 2);
    }

    public void setTitle(String str) {
        this.titleString = str;
    }

    Dimension getSize() {
        return new Dimension(this.mpWidth, this.mpHeight);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.frameColor1 = null;
        this.frameColor2 = null;
        this.frameColor3 = null;
        this.menuPaneColor = null;
        this.textColor = null;
        this.f1 = null;
    }
}

