/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class TextPane
extends BasicPane
implements TextPaneConstants,
HyperFileRequestPopListener,
BufferControl {
    CloseListener closeListener;
    FontBaseButton fontBaseButton;
    boolean gettingFile;
    boolean binaryOutput;
    boolean binarySource;
    HyperFileRequestPopListener hyperFileRequestPopListener;
    TextPane childPane;
    int count;
    int textPaneFlags;
    Dispatch updateDispatch;
    int rows;
    int columns;
    int displayMaxRows;
    int displayMaxColumns;
    volatile int dataEnd;
    int maxRows;
    int maxColumns;
    int maxPages;
    int pageSize;
    int inBytes;
    int wraps;
    int bufferSize;
    int pageXOffset;
    int pageYOffset;
    volatile byte[] sourceByte;
    volatile byte[] controlBuffer;
    volatile ByteBuffer byteBuffer;
    volatile String fileName;
    volatile FileChannel fileChannel;
    String[] displayString;
    int[] sourceStringLength;
    int[] displayStringStart;
    int printX;
    int printY;
    int currentRow;
    int currentColumn;
    int currentPage;
    int titleHeight;
    int mpTextHeight;
    int currentDataOffset;
    int currentPrintOffset;
    int mWidth;
    int displayTextHeight;
    int frameWidth;
    Color frameColor;
    Color textPaneColor;
    Color textColor;
    Font textFont;
    FontMetrics textFontMetrics;
    int fontHeight;
    int textPaneWidth;
    int textPaneHeight;
    Color frameTopColor;
    Color frameFaceColor;
    Color frameBottomColor;
    Color menuPaneColor;
    Color pageRectangleColor;
    String commandString;
    String titleString;
    HyperScrollbar rowScrollbar;
    Gadget forceBinaryGadget;
    String currentDirName;
    char fileSeparator;

    TextPane() {
        this.hyperFileRequestPopListener = this;
    }

    TextPane(HyperView tView, int tWidth, int tHeight) {
        this(tView, null, tView.width + tWidth << 2, tView.height + tHeight << 2, tWidth, tHeight, null, null, null, Color.black, 80, 24);
    }

    TextPane(HyperView tView, int tWidth, int tHeight, Color tfc1, Color tfc2, Color tfc3, Color tmpc) {
        this(tView, null, tView.width - tWidth >> 1, tView.height - tHeight >> 1, tWidth, tHeight, tfc1, tfc2, tfc3, tmpc, 80, 24);
    }

    TextPane(HyperView tView, String tTitle, int tX, int tY, int tWidth, int tHeight, Color fc1, Color fc2, Color fc3, Color mpc, int tMaxColumns, int tMaxRows) {
        this(tView, tTitle, tX, tY, tWidth, tHeight, null, fc1, fc2, fc3, mpc, 1, tMaxColumns, tMaxRows);
    }

    TextPane(HyperView tView, String tTitle, int tX, int tY, int tWidth, int tHeight, Font tFont, Color fc1, Color fc2, Color fc3, Color mpc, int tMaxPages, int tMaxColumns, int tMaxRows) {
        boolean tZ = false;
        if (tFont == null) {
            tFont = FontBase.arial12;
        }
        this.moveNum = -1;
        this.mX = new int[32];
        this.mX2 = new int[32];
        this.mY = new int[32];
        this.mY2 = new int[32];
        this.hyperFileRequestPopListener = this;
        this.binarySource = false;
        this.binaryOutput = false;
        this.gettingFile = false;
        this.totalAttached = 0;
        this.maxAttached = 64;
        this.attachedIndex = 0;
        this.curAttached = 0;
        this.attachedGob = new Gob[this.maxAttached];
        this.dataEnd = 0;
        this.wraps = 0;
        this.currentPage = 0;
        this.currentPrintOffset = 0;
        this.currentDataOffset = 0;
        this.count = 0;
        this.curView = tView;
        this.fileSeparator = HyperView.fileSeparator;
        this.maxRows = tMaxRows;
        this.maxColumns = tMaxColumns;
        this.maxPages = tMaxPages;
        this.pageXOffset = 2;
        this.pageYOffset = 0;
        if (tTitle != null) {
            this.titleString = tTitle;
        }
        this.updateDispatch = new Dispatch(tView);
        this.width = tWidth;
        this.height = tHeight;
        this.gobName = "TextPane()";
        this.x = tX;
        this.y = tY;
        this.frameTopColor = fc1 == null ? this.curView.color[1] : fc1;
        this.frameFaceColor = fc2 == null ? this.curView.color[9] : fc2;
        this.pageRectangleColor = this.frameFaceColor.darker().darker();
        this.frameBottomColor = fc3 == null ? this.curView.color[8] : fc3;
        this.menuPaneColor = mpc == null ? this.curView.color[1] : mpc;
        this.makeBitMap(tFont);
        this.textColor = Color.black;
        this.curView.addGadget(this, 0);
        ImageGadget fileGadget = new ImageGadget(this.curView, "disk.gif", 587, 3, 35, 31, FontBase.hyperConFont10);
        fileGadget.gobFlags |= 0x200;
        this.addGob(fileGadget);
        fileGadget.addDispatch(new GetFileDispatch(this.curView));
        int tInt = (this.height >> 1) - 75;
        this.rowScrollbar = new HyperScrollbar(this.curView, this.width - 18, this.mpY, 1, 75, 64);
        this.rowScrollbar.move(this.width - 18, this.height - this.rowScrollbar.height >> 1);
        this.rowScrollbar.thumbPaneMethod = new TextPaneThumbMethod();
        this.rowScrollbar.upperArrowMethod = new TextPaneUpperArrowMethod();
        this.rowScrollbar.lowerArrowMethod = new TextPaneLowerArrowMethod();
        this.rowScrollbar.thumbRatio = (double)this.rowScrollbar.maxVal / (double)this.bufferSize;
        this.addGob(this.rowScrollbar);
        this.rowScrollbar.gobFlags = this.maxPages > 1 ? (this.rowScrollbar.gobFlags |= 0x200) : (this.rowScrollbar.gobFlags &= 0xFFFFFDFF);
        this.forceBinaryGadget = new Gadget(tView, " Binary ", 523, 4);
        this.forceBinaryGadget.addDispatch(new SetBinaryToggle());
        this.addGob(this.forceBinaryGadget);
        this.fontBaseButton = new FontBaseButton(this.curView);
        this.fontBaseButton.move(502, 4);
        this.addGob(this.fontBaseButton);
        this.fontBaseButton.gobFlags |= 0x200;
        this.forceBinaryGadget.gobFlags |= 0x200;
        this.gobFlags |= 0x8284;
        this.gadFlags |= 0x4000001;
    }

    @Override
    public void update() {
        boolean working = true;
        String tString = null;
        int tCharHeight = this.displayTextHeight;
        int maxAdvance = this.mpWidth - this.mWidth - this.mWidth;
        int tAdvance = 0;
        int addChar = 0;
        int binaryOffset = 0;
        this.currentPage = (int)((double)this.currentPrintOffset / (double)this.pageSize);
        this.graphics.setFont(this.textFont);
        this.graphics.setColor(this.menuPaneColor);
        this.graphics.fillRect(this.mpX, this.mpY, this.mpWidth, this.mpHeight);
        this.graphics.setColor(this.pageRectangleColor);
        this.graphics.fillRect(this.mpX + this.pageXOffset, 2, 170, tCharHeight + 1 << 1);
        this.graphics.setColor(Color.black);
        this.graphics.drawString("Page:" + (this.currentPage + 1), this.mpX + this.pageXOffset + 1, tCharHeight + 1);
        this.graphics.setColor(Color.cyan);
        this.graphics.drawString("Page:" + (this.currentPage + 1), this.mpX + this.pageXOffset, tCharHeight);
        if (this.fileName == null) {
            this.fileName = " print() ";
        }
        if (!this.binaryOutput) {
            binaryOffset = 0;
            this.graphics.setColor(Color.black);
            this.graphics.drawString("ASC:" + this.fileName, this.mpX + this.pageXOffset + 1, (tCharHeight + 1 << 1) - 2);
            this.graphics.setColor(Color.cyan);
            this.graphics.drawString("ASC:" + this.fileName, this.mpX + this.pageXOffset, (tCharHeight + 1 << 1) - 3);
        } else {
            binaryOffset = 100;
            this.graphics.setColor(Color.black);
            this.graphics.drawString("BIN:" + this.fileName, this.mpX + this.pageXOffset + 1, (tCharHeight + 1 << 1) - 2);
            this.graphics.setColor(Color.cyan);
            this.graphics.drawString("BIN:" + this.fileName, this.mpX + this.pageXOffset, (tCharHeight + 1 << 1) - 3);
        }
        this.graphics.setColor(Color.black);
        int tMaxDisplayRows = this.displayMaxRows;
        int lineStep = this.displayMaxRows;
        int tZ = 0;
        int tRowDrawOffset = this.titleHeight + tCharHeight + this.frameWidth;
        int tOffSet = this.currentPrintOffset;
        this.graphics.setClip(this.mpX, this.mpY, this.mpWidth, this.mpHeight);
        try {
            if (!this.binaryOutput) {
                for (int tY = 0; tY < tMaxDisplayRows && working; ++tY) {
                    if (tOffSet < this.bufferSize - this.displayMaxColumns) {
                        tString = new String(this.sourceByte, tOffSet, this.displayMaxColumns);
                        int stringWidth = this.textFontMetrics.stringWidth(tString);
                        addChar = 0;
                        while (stringWidth + addChar < maxAdvance) {
                            if (this.sourceByte[tOffSet] == 13) {
                                this.sourceByte[tOffSet] = 32;
                                tString = new String(this.sourceByte, tOffSet, this.displayMaxColumns + addChar);
                                this.sourceByte[tOffSet] = 13;
                                continue;
                            }
                            if (this.sourceByte[tOffSet] == 10) {
                                this.sourceByte[tOffSet] = 32;
                                tString = new String(this.sourceByte, tOffSet, this.displayMaxColumns + addChar);
                                stringWidth = this.textFontMetrics.stringWidth(tString);
                                continue;
                            }
                            tString = new String(this.sourceByte, tOffSet, this.displayMaxColumns + ++addChar);
                            stringWidth = this.textFontMetrics.stringWidth(tString);
                        }
                    } else {
                        int tMod = this.bufferSize - tOffSet;
                        tString = tMod > 0 ? new String(this.sourceByte, tOffSet, tMod) : "";
                    }
                    tOffSet += this.displayMaxColumns + addChar;
                    this.displayString[tZ] = tString;
                    this.graphics.drawString(this.displayString[tZ], this.frameWidth + 2 + binaryOffset, tRowDrawOffset);
                    ++tZ;
                    tRowDrawOffset += tCharHeight;
                }
            } else {
                this.graphics.setFont(FontBase.hyperConFont12);
                HexFormat.formatByteArray(this.displayString, tOffSet, this.sourceByte);
                int tSize2 = this.displayString.length;
                for (int tY = 0; tY < tMaxDisplayRows && working; ++tY) {
                    this.graphics.drawString(this.displayString[tY], this.frameWidth + 2, tRowDrawOffset);
                    tRowDrawOffset += tCharHeight;
                    if (--tSize2 > 0) continue;
                    working = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.graphics.setClip(0, 0, this.width, this.height);
    }

    @Override
    public void makeBitMap(Font tFont) {
        int tCharWidth;
        int tTimeout2 = 50;
        int tZ = 0;
        int tY = 0;
        boolean widestFont = false;
        this.currentDataOffset = 0;
        if (tFont == null) {
            System.out.println("TPN: Font default " + this.textFont.toString());
            this.textFont = FontBase.hyperConFont12;
        } else {
            this.textFont = tFont;
        }
        this.textFontMetrics = this.curView.screenGraphics.getFontMetrics(this.textFont);
        this.titleHeight = this.displayTextHeight = this.textFontMetrics.getHeight();
        int tCharHeight = this.displayTextHeight;
        this.conFont = tFont;
        this.frameWidth = 20;
        this.inBytes = 0;
        this.currentRow = 0;
        this.currentColumn = 0;
        this.mpWidth = this.width - (this.frameWidth << 1);
        this.mpHeight = this.height - (this.frameWidth << 1) - this.titleHeight;
        this.mpX = this.frameWidth;
        this.mpY = this.frameWidth + this.titleHeight;
        this.mpX2 = this.frameWidth + this.mpWidth;
        this.mpY2 = this.mpY + this.mpHeight;
        this.displayMaxRows = this.mpHeight / this.titleHeight;
        if (this.displayMaxRows < 1) {
            return;
        }
        this.fGPen = this.curView.fGPen;
        this.bGPen = this.curView.bGPen;
        this.mWidth = tCharWidth = this.textFontMetrics.getMaxAdvance();
        this.height += this.titleHeight;
        this.displayMaxColumns = (int)((double)this.mpWidth / (double)tCharWidth) << 1;
        this.displayString = new String[this.displayMaxRows];
        this.displayStringStart = new int[this.displayMaxRows];
        this.sourceStringLength = new int[this.displayMaxRows];
        this.pageSize = this.displayMaxColumns * this.displayMaxRows;
        this.bufferSize = this.pageSize * this.maxPages;
        this.sourceByte = new byte[this.bufferSize];
        this.controlBuffer = new byte[this.bufferSize];
        this.x2 = this.width + this.x;
        this.y2 = this.height + this.y;
        tZ = this.bufferSize;
        while (tY < tZ) {
            this.sourceByte[tY++] = 32;
        }
        tZ = 0;
        tY = 0;
        this.gobPic = this.curView.createImage(this.width, this.height);
        this.graphics = this.gobPic.getGraphics();
        if (tFont == null) {
            System.out.println("TPN: tFont == null");
        } else {
            this.graphics.setFont(tFont);
        }
        this.graphics.setColor(this.frameTopColor);
        this.graphics.fillRect(0, 0, this.width - 1, this.height - 1);
        this.graphics.setColor(this.frameFaceColor);
        this.graphics.drawLine(0, 0, this.width - 1, 0);
        this.graphics.drawLine(0, 0, 0, this.height - 1);
        this.graphics.setColor(this.frameBottomColor);
        this.graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
        this.graphics.drawLine(this.width - 1, this.height - 1, this.width - 1, 1);
        this.graphics.setColor(Color.black);
        this.graphics.drawLine(this.mpX - 1, this.mpY - 1, this.mpX2 + 1, this.mpY - 1);
        this.graphics.drawLine(this.mpX - 1, this.mpY2 + 1, this.mpX - 1, this.mpY - 1);
        this.graphics.drawLine(this.mpX2 + 1, this.mpY - 1, this.mpX2 + 1, this.mpY2 + 1);
        this.graphics.drawLine(this.mpX2 + 1, this.mpY2 + 1, this.mpX - 1, this.mpY2 + 1);
        while (!this.graphics.drawImage(this.curView.mainComponentImage, this.width - 12, 1, this.width - 2, 9, 74, 0, 84, 8, this.curView) && --tTimeout2 <= 0) {
            HyperView.delay(200);
        }
        this.currentPage = 0;
        this.graphics.setColor(this.menuPaneColor);
        this.graphics.fillRect(this.mpX, this.mpY, this.mpWidth, this.mpHeight);
        this.graphics.setColor(Color.black);
        this.graphics.setColor(this.pageRectangleColor);
        this.graphics.fillRect(this.mpX + this.pageXOffset, 2, 170, tCharHeight + 1 << 1);
        this.graphics.setColor(Color.black);
        this.graphics.drawString("Page:" + (this.currentPage + 1), this.mpX + this.pageXOffset + 1, tCharHeight + 1);
        this.graphics.setColor(Color.cyan);
        this.graphics.drawString("Page:" + (this.currentPage + 1), this.mpX + this.pageXOffset, tCharHeight);
        this.graphics.setColor(this.textColor);
    }

    @Override
    public void erase() {
        this.graphics.setColor(this.frameTopColor);
        this.graphics.drawLine(0, this.height - 1, 0, 0);
        this.graphics.drawLine(1, 0, this.width - 1, 0);
        this.graphics.setColor(this.frameBottomColor);
        this.graphics.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
        this.graphics.drawLine(this.width - 1, this.height - 1, 0, this.height - 1);
        this.graphics.setColor(this.frameFaceColor);
        this.graphics.fillRect(1, 1, this.width - 2, this.height - 2);
        this.graphics.setColor(this.menuPaneColor);
        this.graphics.fillRect(this.mpX, this.mpY, this.mpWidth, this.mpHeight);
        this.graphics.setColor(this.textColor);
    }

    public void load(byte[] tInByteArray) {
        int tZ;
        Object fin = null;
        byte[] tOldSourceBytes = this.sourceByte;
        System.out.println("TPN: load(byte[" + tInByteArray.getClass().getName());
        this.binarySource = false;
        this.binaryOutput = false;
        int tInputBufferLength = tInByteArray.length;
        if (tInputBufferLength < 1) {
            return;
        }
        this.maxPages = tInputBufferLength / this.pageSize + 1;
        this.rowScrollbar.gobFlags = this.maxPages > 1 ? (this.rowScrollbar.gobFlags |= 0x200) : (this.rowScrollbar.gobFlags &= 0xFFFFFDFF);
        int tBufferLength = this.bufferSize = this.maxPages * this.pageSize;
        this.sourceByte = new byte[this.bufferSize];
        this.dataEnd = tInputBufferLength;
        this.binarySource = false;
        this.binaryOutput = false;
        for (tZ = 0; tZ < tInputBufferLength; ++tZ) {
            byte tByte = (byte)(tInByteArray[tZ] & 0xFF);
            if (tByte < 0 || tByte > 128) {
                this.binarySource = true;
                this.binaryOutput = true;
            }
            this.sourceByte[tZ] = tByte;
        }
        System.out.println("Load() binarySource = " + this.binarySource + " binaryOutput = " + this.binaryOutput);
        if (this.dataEnd < tBufferLength) {
            while (tZ < tBufferLength) {
                this.sourceByte[tZ++] = 32;
            }
        }
        this.currentPage = 0;
        this.currentPrintOffset = 0;
        this.update();
    }

    public int load(String tFileName) {
        int tZ;
        boolean inCRLF = false;
        FileInputStream fin = null;
        boolean tLineLength = false;
        boolean tLineStart = false;
        byte[] tOldSourceBytes = this.sourceByte;
        int tFileLength = 0;
        System.out.println("TPN: load(file: " + tFileName + ")");
        File tFile = new File(this.currentDirName + this.fileSeparator + tFileName);
        if (!tFile.exists()) {
            return 0;
        }
        tFileLength = (int)tFile.length();
        if (tFileLength < 1) {
            this.load("File " + tFileName + " is empty. ");
        }
        this.fileName = tFileName;
        this.maxPages = tFileLength / this.pageSize + 1;
        this.rowScrollbar.gobFlags = this.maxPages > 1 ? (this.rowScrollbar.gobFlags |= 0x200) : (this.rowScrollbar.gobFlags &= 0xFFFFFDFF);
        this.bufferSize = this.maxPages * this.pageSize;
        this.sourceByte = new byte[this.bufferSize];
        this.controlBuffer = new byte[this.displayMaxRows * this.displayMaxColumns];
        this.dataEnd = tFileLength;
        if (this.dataEnd < this.bufferSize) {
            tZ = this.dataEnd;
            while (tZ < this.bufferSize) {
                this.sourceByte[tZ++] = 32;
            }
        }
        this.currentPage = 0;
        this.currentPrintOffset = 0;
        try {
            fin = new FileInputStream(tFile);
            fin.read(this.sourceByte);
            fin.close();
        }
        catch (IOException ioex) {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.sourceByte = tOldSourceBytes;
            return -1;
        }
        this.binarySource = false;
        this.binaryOutput = false;
        for (tZ = 0; tZ < tFileLength; ++tZ) {
            short tWord = (short)(this.sourceByte[tZ] & 0xFF);
            if (tWord >= 0 && tWord <= 128) continue;
            this.binarySource = true;
            this.binaryOutput = true;
            break;
        }
        this.update();
        return tFileLength;
    }

    public void load(String[] tPrintStringArray) {
        boolean lastCharCR = false;
        int tLen = tPrintStringArray.length;
        int bufferEnd = this.sourceByte.length;
        boolean lineStep = false;
        int tFrameWidth = this.frameWidth;
        int tCharHeight = this.displayTextHeight;
        int tBufferOffset = 0;
        try {
            for (int tY = 0; tY < tLen; ++tY) {
                byte[] inputStringBytes = tPrintStringArray[tY].getBytes("UTF-8");
                int inputStringLength = inputStringBytes.length;
                if (inputStringLength < 1) {
                    return;
                }
                tBufferOffset = this.pageSize * this.currentPage + (this.currentRow * this.displayMaxColumns + this.currentColumn);
                if (tBufferOffset + inputStringLength >= bufferEnd && (this.textPaneFlags & 0x200) == 0) {
                    this.increaseBufferSize();
                }
                this.binaryOutput = false;
                for (int tZ = 0; tZ < inputStringLength; ++tZ) {
                    byte tByte = (byte)(tPrintStringArray[tY].charAt(tZ) & 0xFF);
                    if (tZ % 80 == 0) {
                        // empty if block
                    }
                    if (tByte < 0 || tByte > 128) {
                        this.binaryOutput = true;
                    }
                    this.sourceByte[tBufferOffset] = tByte;
                    ++tBufferOffset;
                    ++this.currentColumn;
                    if (this.currentColumn < this.displayMaxColumns) continue;
                    this.currentColumn = 0;
                    ++this.currentRow;
                    if (this.currentRow < this.displayMaxRows) continue;
                    this.currentColumn = 0;
                    this.currentRow = 0;
                    if (this.currentPage < this.maxPages) {
                        ++this.currentPage;
                        continue;
                    }
                    if ((this.textPaneFlags & 0x200) != 0) continue;
                    ++this.wraps;
                    this.currentPage = 0;
                }
            }
        }
        catch (UnsupportedEncodingException usee1) {
            return;
        }
        this.dataEnd = tBufferOffset;
        this.update();
        this.currentPrintOffset = 0;
    }

    public void print(String tPrintString) {
        byte[] inputStringBytes;
        int bufferEnd = tPrintString.length();
        int lineStep = 0;
        int tFrameWidth = this.frameWidth;
        int tCharHeight = this.displayTextHeight;
        int tStringStart = 0;
        try {
            inputStringBytes = tPrintString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException usee2) {
            return;
        }
        int inputStringLength = inputStringBytes.length;
        if (inputStringLength < 1) {
            return;
        }
        int tBufferOffset = this.dataEnd;
        if (inputStringLength + tBufferOffset >= this.bufferSize && (this.textPaneFlags & 0x200) == 0) {
            this.increaseBufferSize();
        }
        for (int tZ = 0; tZ < inputStringLength; ++tZ) {
            this.sourceByte[tBufferOffset] = inputStringBytes[tZ];
            ++tBufferOffset;
            ++this.currentColumn;
            if (this.sourceByte[tZ] == 13) {
                this.currentColumn = 0;
                this.sourceByte[tBufferOffset] = 32;
            } else if (this.sourceByte[tZ] == 10) {
                this.sourceStringLength[this.currentRow++] = tZ - tStringStart;
                ++this.currentRow;
                tStringStart = tZ + 1;
            } else if (this.currentColumn >= this.displayMaxColumns) {
                this.currentColumn = 0;
                ++this.currentRow;
                if (this.currentRow >= this.displayMaxRows) {
                    this.currentRow = 0;
                    ++this.currentPage;
                }
            }
            if ((this.textPaneFlags & 0x200) == 0 || tBufferOffset < bufferEnd) continue;
            ++this.wraps;
            tBufferOffset = 0;
            this.currentColumn = 0;
            this.currentRow = 0;
            this.currentPage = 0;
        }
        this.graphics.setColor(this.pageRectangleColor);
        this.graphics.fillRect(this.mpX, 2, 170, tCharHeight + 1 << 1);
        this.graphics.setColor(Color.black);
        this.graphics.drawString("Page:" + (this.currentPage + this.currentPage + this.pageXOffset + 1), this.mpX + this.pageXOffset + 1, tCharHeight + 1);
        this.graphics.setColor(Color.cyan);
        this.graphics.drawString("Page:" + (this.currentPage + this.pageXOffset + 1), this.mpX + this.pageXOffset, tCharHeight);
        this.graphics.setColor(this.menuPaneColor);
        this.graphics.fillRect(this.mpX, this.mpY, this.mpWidth, this.mpHeight);
        this.graphics.setColor(this.textColor);
        int tSize = this.displayMaxRows;
        lineStep = this.displayMaxRows;
        int tRowDrawOffset = this.titleHeight + tCharHeight + this.frameWidth;
        int offSet = this.currentPrintOffset;
        this.dataEnd = tBufferOffset;
        this.update();
    }

    public void print(byte[] tInByte) {
        int bufferEnd = this.sourceByte.length;
        int lineStep = 0;
        int tFrameWidth = this.frameWidth;
        int tCharHeight = this.displayTextHeight;
        byte[] inputStringBytes = tInByte;
        int inputStringLength = inputStringBytes.length;
        if (inputStringLength < 1) {
            return;
        }
        int tBufferOffset = this.dataEnd;
        if (inputStringLength + tBufferOffset >= this.bufferSize && (this.textPaneFlags & 0x200) == 0) {
            this.increaseBufferSize();
        }
        for (int tZ = 0; tZ < inputStringLength; ++tZ) {
            this.sourceByte[tBufferOffset] = inputStringBytes[tZ];
            ++tBufferOffset;
            ++this.currentColumn;
            if (this.sourceByte[tZ] == 13) {
                this.currentColumn = 0;
            } else if (this.sourceByte[tZ] == 10) {
                ++this.currentRow;
            } else if (this.currentColumn >= this.displayMaxColumns) {
                this.currentColumn = 0;
                ++this.currentRow;
                if (this.currentRow >= this.displayMaxRows) {
                    ++this.currentPage;
                }
            }
            if ((this.textPaneFlags & 0x200) == 0 || tBufferOffset < bufferEnd) continue;
            ++this.wraps;
            tBufferOffset = 0;
            this.currentColumn = 0;
            this.currentRow = 0;
            this.currentPage = 0;
        }
        this.graphics.setColor(this.pageRectangleColor);
        this.graphics.fillRect(this.mpX, 2, 170, tCharHeight + 1 << 1);
        this.graphics.setColor(Color.black);
        this.graphics.drawString("Page:" + (this.currentPage + 1), this.mpX + this.pageXOffset + 1, tCharHeight + 1);
        this.graphics.setColor(Color.cyan);
        this.graphics.drawString("Page:" + (this.currentPage + this.pageXOffset + 1), this.mpX + this.pageXOffset, tCharHeight);
        this.graphics.setColor(this.menuPaneColor);
        this.graphics.fillRect(this.mpX, this.mpY, this.mpWidth, this.mpHeight);
        this.graphics.setColor(this.textColor);
        int tSize = this.displayMaxRows;
        lineStep = this.displayMaxRows;
        int tRowDrawOffset = this.titleHeight + tCharHeight + this.frameWidth;
        int offSet = this.currentPrintOffset;
        this.dataEnd = tBufferOffset;
    }

    @Override
    public boolean inView() {
        int tPrintOffset = this.currentPrintOffset;
        int tCurrentPage = this.pageSize * this.currentPage;
        return tPrintOffset >= tCurrentPage && tPrintOffset <= tCurrentPage + this.pageSize;
    }

    public int increaseBufferSize() {
        int tY;
        long maxMem = this.curView.curRun.maxMemory();
        long maxMemAllowed = (long)((double)maxMem * 0.5);
        if ((long)this.bufferSize >= maxMemAllowed) {
            new HyperPop("TEXTPANE: maximum " + maxMemAllowed + " heap exceeded reverting to autowrap");
            this.textPaneFlags = 512;
        }
        this.maxPages = this.maxPages < 2 ? ++this.maxPages : (this.maxPages += this.maxPages >> 1);
        this.rowScrollbar.gobFlags |= 0x200;
        int tNewBufferSize = this.maxPages * this.pageSize;
        int tOldBufferSize = this.bufferSize;
        byte[] tNewBuffer = new byte[tNewBufferSize];
        int tZ = 0;
        for (tY = 0; tY < tOldBufferSize; ++tY) {
            tNewBuffer[tY] = this.sourceByte[tY];
        }
        while (tY < tNewBufferSize) {
            tNewBuffer[tY] = 32;
            ++tY;
        }
        this.bufferSize = tNewBufferSize;
        this.sourceByte = null;
        this.sourceByte = tNewBuffer;
        return tNewBufferSize;
    }

    @Override
    public void inKey() {
        KeyEvent tmpKey = null;
        int index = 0;
        int inLength = 0;
        HyperKeyEvent[] keyMsg = this.keyboard.keyMsg;
        StringBuilder inStringBuilder = new StringBuilder(48000);
        index = this.keyboard.mainBufferIndex;
        while (this.keyboard.mainBufferIndex != this.keyboard.intBufferIndex) {
            if ((keyMsg[index].flags & 1) != 0) {
                tmpKey = keyMsg[index].keyEvent;
                char tmpChar = tmpKey.getKeyChar();
                switch (tmpChar) {
                    case '\b': {
                        if (inLength > 0) {
                            inStringBuilder.deleteCharAt(inLength);
                            --inLength;
                            break;
                        }
                        this.commandString = "";
                        inLength = 0;
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if (inLength > 1) {
                            this.curView.doCommand();
                        }
                        this.commandString = "";
                        this.print("\n-><-");
                        break;
                    }
                    default: {
                        this.commandString = this.commandString + tmpChar;
                        if (this.curView.frame instanceof HyperFrame) {
                            this.curView.getAppletContext().showStatus("" + tmpChar);
                            break;
                        }
                        this.curView.getAppletContext().showStatus("-><-" + this.commandString);
                    }
                }
            }
            ++this.keyboard.mainBufferIndex;
            if (this.keyboard.mainBufferIndex < 512) continue;
            this.keyboard.mainBufferIndex = 0;
        }
        tmpKey = null;
    }

    @Override
    public void onFileSelect(String tCurrentDirName, String tFileString) {
        this.gettingFile = false;
        this.fileName = tFileString;
        this.currentDirName = tCurrentDirName;
        if (tFileString != null) {
            this.load(tFileString);
        }
    }

    @Override
    public void drawString(String str, int tPen, int tx, int ty) {
        this.graphics.setColor(this.curView.color[tPen]);
        this.graphics.drawString(str, tx, ty);
    }

    public void print(String[] str, int tX, int tY) {
        int len = str.length;
        this.graphics.setColor(this.menuPaneColor);
        this.graphics.fillRect(this.mpX, this.mpY, this.mpWidth, this.mpHeight);
        this.graphics.setColor(this.textColor);
        for (int i = 0; i < len; ++i) {
            this.graphics.drawString(str[i], this.mpX + 2, 20 + i * this.fontHeight);
        }
    }

    @Override
    public void setFont(Font tFont) {
        this.conFont = tFont;
    }

    @Override
    public void setPaneColor(int tColorIndex) {
        this.menuPaneColor = this.curView.color[tColorIndex];
        this.graphics.setColor(this.frameTopColor);
        this.graphics.drawLine(0, this.height - 1, 0, 0);
        this.graphics.drawLine(1, 0, this.width - 1, 0);
        this.graphics.setColor(this.frameBottomColor);
        this.graphics.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
        this.graphics.drawLine(this.width - 1, this.height - 1, 0, this.height - 1);
        this.graphics.setColor(this.frameFaceColor);
        this.graphics.fillRect(1, 1, this.width - 2, this.height - 2);
        this.graphics.setColor(this.menuPaneColor);
        this.graphics.fillRect(this.mpX, this.mpY, this.mpWidth, this.mpHeight);
    }

    @Override
    public void onClick() {
        int tCX = this.clickX;
        int tCY = this.clickY;
        int tBX = this.width - 13;
        int tBY = this.width - 1;
        if (tCX > tBX && tCX < tBY) {
            if (tCY > 2 && tCY < 8) {
                if (this.closeListener != null) {
                    this.closeListener.onClose();
                }
                this.gobFlags2 |= 2;
            }
        } else {
            this.update();
        }
    }

    public String callToString() {
        return this.toString();
    }

    @Override
    public String toString() {
        char[] crlfchars = "\r\n".toCharArray();
        StringBuilder tStringBuilder = new StringBuilder(1024);
        tStringBuilder.append("rows: ");
        tStringBuilder.append(this.rows);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("columns: ");
        tStringBuilder.append(this.columns);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("displayMaxRows: ");
        tStringBuilder.append(this.displayMaxRows);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("displayMaxColumns: ");
        tStringBuilder.append(this.displayMaxColumns);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("maxRows: ");
        tStringBuilder.append(this.maxRows);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("maxColumns: ");
        tStringBuilder.append(this.maxColumns);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("maxPages: ");
        tStringBuilder.append(this.maxPages);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("pageSize: ");
        tStringBuilder.append(this.pageSize);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("inBytes: ");
        tStringBuilder.append(this.inBytes);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("wraps: ");
        tStringBuilder.append(this.wraps);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("bufferSize: ");
        tStringBuilder.append(this.bufferSize);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("currentRow: ");
        tStringBuilder.append(this.currentRow);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("currentColumn: ");
        tStringBuilder.append(this.currentColumn);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("currentPage: ");
        tStringBuilder.append(this.columns);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("currentDataOffset ");
        tStringBuilder.append(this.currentDataOffset);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("currentPrintOffset ");
        tStringBuilder.append(this.currentPrintOffset);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("titleHeight: ");
        tStringBuilder.append(this.columns);
        tStringBuilder.append(crlfchars);
        tStringBuilder.append("sourceByte: {\r\n");
        int tY = this.sourceByte.length;
        char[] tC = new char[tY];
        for (int tZ = 0; tZ < tY; ++tZ) {
            tC[tZ] = (char)this.sourceByte[tZ];
        }
        tStringBuilder.append(tC);
        tStringBuilder.append("\r\n};");
        tStringBuilder.append(crlfchars);
        return tStringBuilder.toString();
    }

    class SetBinaryToggle
    extends Dispatch {
        SetBinaryToggle() {
        }

        @Override
        public boolean begin(HyperView tView) {
            TextPane.this.binaryOutput = TextPane.this.binarySource ? true : !TextPane.this.binaryOutput;
            TextPane.this.update();
            return true;
        }
    }

    class GetFileDispatch
    extends Dispatch {
        GetFileDispatch(HyperView ttView) {
            this.curView = ttView;
        }

        @Override
        public boolean begin(HyperView tView) {
            if (!TextPane.this.gettingFile) {
                TextPane.this.gettingFile = true;
                HyperFileRequestPop tHyperFileRequestPop = new HyperFileRequestPop(tView);
                tHyperFileRequestPop.addHyperFileRequestPopListener(TextPane.this.hyperFileRequestPopListener);
                tHyperFileRequestPop.gobFlags |= 0x200;
            }
            return true;
        }
    }

    class TextPaneThumbMethod
    extends ThumbPaneMethod {
        TextPaneThumbMethod() {
        }

        @Override
        public void function(HyperScrollbar hsb) {
            int tY = TextPane.this.y;
            int tInt = (int)((double)(hsb.thumbY - hsb.thumbMinY) * hsb.thumbRatio);
            TextPane.this.currentPrintOffset = (int)((double)(tInt * TextPane.this.displayMaxColumns) + 1.0 * hsb.thumbRatio);
            if (TextPane.this.currentPrintOffset < 0) {
                TextPane.this.currentPrintOffset = 0;
            }
            TextPane.this.update();
        }
    }

    class TextPaneLowerArrowMethod
    extends LowerArrowMethod {
        TextPaneLowerArrowMethod() {
        }

        @Override
        public void function(HyperScrollbar hsb) {
            int tEnd = TextPane.this.displayMaxColumns * TextPane.this.displayMaxRows;
            int tInt = TextPane.this.bufferSize - TextPane.this.pageSize;
            TextPane.this.currentPrintOffset += TextPane.this.displayMaxColumns;
            if (TextPane.this.currentPrintOffset > tInt) {
                TextPane.this.currentPrintOffset = tInt;
            }
            TextPane.this.update();
            hsb.updateThumbPane(TextPane.this.currentPrintOffset, TextPane.this.bufferSize);
        }
    }

    class TextPaneUpperArrowMethod
    extends UpperArrowMethod {
        TextPaneUpperArrowMethod() {
        }

        @Override
        public void function(HyperScrollbar hsb) {
            if (TextPane.this.currentPrintOffset >= TextPane.this.displayMaxColumns) {
                TextPane.this.currentPrintOffset -= TextPane.this.displayMaxColumns;
            } else if (TextPane.this.currentPrintOffset > 0) {
                --TextPane.this.currentPrintOffset;
            }
            TextPane.this.update();
            hsb.updateThumbPane(TextPane.this.currentPrintOffset, TextPane.this.bufferSize);
        }
    }
}

