/*
 * Decompiled with CFR 0.152.
 */
public class SystemTimer
extends Linkable
implements Runnable {
    static final int ST_TIMER_REPEAT = 1;
    static final int ST_TIMED_OUT = 2;
    static final int ST_THREAD_ENA = 4;
    static final int DEFAULT_TIMEOUT = 1;
    static int uniqueID = 0;
    static int checkTime = 5;
    volatile Object notifier;
    static SystemClock systemClock = SystemClock.getSystemClock();
    int number = -1;
    int tmFlags = 0;
    Thread task;
    int timeout;
    volatile int count;
    long iteration = 0L;

    SystemTimer() {
        this.timeout = 1;
        this.count = 0;
    }

    SystemTimer(int tTimeoutSeconds) {
        this.count = 0;
        this.timeout = tTimeoutSeconds;
        this.number = uniqueID++;
        this.name = "SystemTimer(" + this.number + ")";
    }

    SystemTimer(Thread tThread, int tTimeoutSeconds) {
        this.count = 0;
        this.task = null;
        this.task = tThread;
        this.timeout = tTimeoutSeconds;
        this.number = uniqueID++;
        this.name = "SystemTimer(" + this.number + ")";
    }

    SystemTimer(String tName, int tTimeoutSeconds) {
        this.count = 0;
        this.timeout = tTimeoutSeconds;
        this.number = uniqueID++;
        this.setName("SystemTimer(" + this.number + ")");
    }

    SystemTimer(Thread tThread, String tName, int tTimeoutSeconds) {
        this.count = 0;
        this.task = tThread;
        this.timeout = tTimeoutSeconds;
        this.number = uniqueID++;
        this.name = "SystemTimer." + tName;
    }

    SystemTimer(int tTimeoutSeconds, boolean tRepeat) {
        this.count = 0;
        this.timeout = tTimeoutSeconds;
        if (tRepeat) {
            this.tmFlags |= 1;
        }
        this.number = uniqueID++;
        this.name = "SystemTimer(" + this.number + ")";
    }

    SystemTimer(Thread tThread, int tTimeoutSeconds, Object tNotifier) {
        this.count = 0;
        this.task = tThread;
        this.timeout = tTimeoutSeconds;
        this.notifier = tNotifier;
        this.number = uniqueID++;
        this.name = "SystemTimer(" + this.number + ")";
    }

    public void start() {
        if (this.task == null) {
            this.task = new Thread(this);
        }
        this.task.setName(this.name);
        this.task.start();
    }

    public void stop() {
        this.task = null;
    }

    void setTimerRepeat(boolean tBoolean) {
        this.tmFlags = tBoolean ? (this.tmFlags |= 1) : (this.tmFlags &= 0xFFFFFFFE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        double lagpercent = 0.0;
        Thread controlThread = Thread.currentThread();
        try {
            while (controlThread == this.task) {
                if (this.timeout > 0) {
                    SystemTimer systemTimer = this;
                    synchronized (systemTimer) {
                        block13: {
                            try {
                                this.wait(this.timeout);
                                if (this.notifier == null) break block13;
                                Object object = this.notifier;
                                synchronized (object) {
                                    this.notifier.notifyAll();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        this.notifyAll();
                    }
                }
                if ((this.tmFlags & 1) == 0) {
                    this.notifier = null;
                    this.task = null;
                    return;
                }
                ++this.iteration;
            }
        }
        catch (Exception any) {
            System.out.println("SYS: aborting");
            any.printStackTrace();
        }
    }

    public void setNotify(Object tObject) {
        this.notifier = tObject;
    }

    public void function() {
        System.out.println("SYS: default:SystemTimer( " + this.name + " ).function()");
    }
}

