/*
 * Decompiled with CFR 0.152.
 */
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class SystemClock
implements Runnable {
    static final int SC_RUNNING = 1;
    static final String version = "1.3";
    static final int YEAR = 1;
    static final int MONTH = 2;
    static final int MONTH_DAY = 5;
    static final int HOUR = 10;
    static final int MINUTE = 12;
    static final int SECOND = 13;
    static volatile SystemClock clockBase = null;
    static String clock = "";
    static Date date = new Date(System.currentTimeMillis());
    static int waitTime = 1000;
    static Calendar calendar = Calendar.getInstance();
    volatile Thread task;
    int scFlags = 0;
    int iteration = 0;
    int timeout = 5;
    volatile int idleCount = 60;
    long startTime;
    volatile long now;
    volatile int second;
    volatile int minute;
    volatile int hour;
    volatile int day;
    volatile int month;
    volatile int year;
    SimpleDateFormat dateFormat;
    volatile HyperLinkedList timerList;

    SystemClock() {
        long now = this.startTime = System.currentTimeMillis();
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
        this.day = 0;
        this.month = 0;
        this.year = 0;
        this.dateFormat = new SimpleDateFormat("s", Locale.getDefault());
        this.dateFormat.applyPattern("EEE MMM dd HH:mm:ss yyyy");
        this.timerList = new HyperLinkedList("timerList");
        if (clockBase == null) {
            clockBase = this;
        } else {
            System.out.println("Illegal reedundant SystemClock() only 1 allowed; aborting");
            System.exit(0);
        }
    }

    SystemClock(HyperConnectionHandler tHandler) {
        long now = this.startTime = System.currentTimeMillis();
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
        this.day = 0;
        this.month = 0;
        this.year = 0;
        this.dateFormat = new SimpleDateFormat("s", Locale.getDefault());
        this.dateFormat.applyPattern("EEE MMM dd HH:mm:ss yyyy");
        this.timerList = new HyperLinkedList("timerList");
        if (clockBase == null) {
            clockBase = this;
        } else {
            System.out.println("Illegal reedundant SystemClock() only 1 allowed; aborting");
            System.exit(0);
        }
    }

    public void start() {
        this.task = new Thread(this);
        clockBase = this;
        this.task.setName("SystemClock 1.3");
        this.now = System.currentTimeMillis();
        date.setTime(this.now);
        clock = this.dateFormat.format(date);
        this.task.start();
    }

    public void stop() {
        Thread tThread = this.task;
        if (tThread != null) {
            this.task = null;
            try {
                tThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        clockBase = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread controlThread = Thread.currentThread();
        SystemTimer tSystemTimer1 = null;
        SystemTimer tSystemTimer2 = null;
        this.scFlags |= 1;
        try {
            while (controlThread == this.task) {
                Object object = this;
                synchronized (object) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                }
                if (this.task == null) {
                    return;
                }
                this.now = System.currentTimeMillis();
                date.setTime(this.now);
                calendar.setTimeInMillis(this.now);
                clock = this.dateFormat.format(date);
                this.second = calendar.get(13);
                this.minute = calendar.get(12);
                this.hour = calendar.get(10);
                this.month = calendar.get(2);
                this.day = calendar.get(5);
                object = this.timerList;
                synchronized (object) {
                    if (this.timerList.listBase != null) {
                        tSystemTimer1 = (SystemTimer)this.timerList.listBase;
                        while (tSystemTimer1 != null) {
                            ++tSystemTimer1.count;
                            if (tSystemTimer1.count >= tSystemTimer1.timeout) {
                                tSystemTimer1.count = 0;
                                if (tSystemTimer1.notifier != null) {
                                    System.out.println("SystemClock() synching " + tSystemTimer1.notifier);
                                    Object object2 = tSystemTimer1.notifier;
                                    synchronized (object2) {
                                        tSystemTimer1.notifier.notifyAll();
                                    }
                                }
                                try {
                                    tSystemTimer1.function();
                                }
                                catch (Exception any) {
                                    any.printStackTrace();
                                }
                            }
                            if ((tSystemTimer1.tmFlags & 1) == 0) {
                                tSystemTimer2 = (SystemTimer)tSystemTimer1.next;
                                this.timerList.dlDelete(tSystemTimer1);
                                tSystemTimer1 = tSystemTimer2;
                                tSystemTimer2 = null;
                                continue;
                            }
                            if (tSystemTimer1 == tSystemTimer1.next) {
                                tSystemTimer1 = null;
                                continue;
                            }
                            tSystemTimer1 = (SystemTimer)tSystemTimer1.next;
                        }
                    }
                    this.timerList.notifyAll();
                }
            }
            this.scFlags &= 0xFFFFFFFE;
        }
        catch (Exception any) {
            this.scFlags &= 0xFFFFFFFE;
            any.printStackTrace();
            System.exit(0);
        }
    }

    void setWaitTime(int tMillis) {
        waitTime = tMillis;
    }

    static SystemClock getSystemClock() {
        if (clockBase == null) {
            clockBase = new SystemClock();
            clockBase.start();
        }
        return clockBase;
    }

    static String getClockString() {
        if (clockBase == null) {
            clockBase = new SystemClock();
        }
        return clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SystemTimer getTimer(int tSeconds) {
        SystemTimer tSystemTimer = new SystemTimer(1);
        tSystemTimer.timeout = tSeconds;
        SystemClock systemClock = this;
        synchronized (systemClock) {
            this.timerList.dlStore(tSystemTimer);
            this.notifyAll();
        }
        return tSystemTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SystemTimer getTimer(int tSeconds, boolean tRepeat) {
        SystemTimer tSystemTimer = new SystemTimer(tSeconds);
        if (tRepeat) {
            tSystemTimer.tmFlags |= 1;
        }
        SystemClock systemClock = this;
        synchronized (systemClock) {
            this.timerList.dlStore(tSystemTimer);
            this.notifyAll();
        }
        return tSystemTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SystemTimer getTimer() {
        SystemTimer tSystemTimer = new SystemTimer(1);
        SystemClock systemClock = this;
        synchronized (systemClock) {
            this.timerList.dlStore(tSystemTimer);
            this.notifyAll();
        }
        return tSystemTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimer(SystemTimer tTimer) {
        SystemClock systemClock = this;
        synchronized (systemClock) {
            this.timerList.dlStore(tTimer);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimer(SystemTimer[] tTimer, boolean tRepeat) {
        int tLength = tTimer.length;
        SystemClock systemClock = this;
        synchronized (systemClock) {
            if (tRepeat) {
                for (int tZ = 0; tZ < tLength; ++tZ) {
                    this.timerList.dlStore(tTimer[tZ]);
                    tTimer[tZ].tmFlags |= 1;
                }
            } else {
                for (int tZ = 0; tZ < tLength; ++tZ) {
                    this.timerList.dlStore(tTimer[tZ]);
                }
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimer(HyperLinkedList tList) {
        SystemClock systemClock = this;
        synchronized (systemClock) {
            this.timerList.dlStore(tList);
            this.notifyAll();
        }
    }

    public synchronized void remove(Linkable tTimer) {
        this.timerList.dlDelete(tTimer);
    }

    public synchronized void remove(SystemTimer[] tTimer) {
        int tLength = tTimer.length;
        for (int tZ = 0; tZ < tLength; ++tZ) {
            this.timerList.dlDelete(tTimer[tZ]);
        }
    }

    public boolean isRunning() {
        return (this.scFlags & 1) != 0;
    }

    public void join() throws InterruptedException {
        this.task.join();
    }
}

