/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyEvent;
import java.awt.image.MemoryImageSource;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;

public class SuperBitmapConsole
extends SuperBitmap
implements HyperConsoleConstants,
HyperConstants,
ConnectionConstants,
SplineConstants,
TextConstants {
    long startTime = 0L;
    InetAddress localHost = null;
    int consoleNumber = 0;
    int curString = 0;
    char[][] screenChar;
    String[] viewString;
    int rowStride = 12;
    int curViewColumn = 0;
    int curViewRow = 0;
    int textOutputColumn = 0;
    int textOutputColumn2 = 0;
    int textOutputLastCol = 0;
    int textOutputRow = 0;
    int textOutputRow2 = 0;
    int viewColumnNumber = 10;
    int viewRowNumber = 1;
    int maxStartColumn = 10;
    int superColumnNumber = 10;
    int superRowNumber = 255;
    int[] stringLength = new int[255];
    int curSuperColumn = 0;
    int curSuperRow = 0;
    int startCursor = 12;
    int startChar = 0;
    int startRow = 0;
    int statusRow = 0;
    int charX = 0;
    int charY = 12;
    int tint = 0;
    int tint2 = 0;
    int lastSourceX = 0;
    int lastSourceY = 0;
    KeyEvent tmpKey = null;
    char tmpChar = '\u0000';
    String tmpString = "";
    String cursorName = "cursor.gif";

    SuperBitmapConsole(HyperView tView) {
        this.mX = new int[32];
        this.mX2 = new int[32];
        this.mY = new int[32];
        this.mY2 = new int[32];
        this.curView = tView;
        this.x = 0;
        this.y = 0;
        this.width = 320;
        this.height = 240;
        this.superHeight = 240;
        this.superWidth = 640;
        this.fGColor = this.curView.color[1];
        this.backColor = this.curView.color[0];
        this.conFont = FontBase.hyperConFont12;
        this.gobName = "Console(" + (this.curView.totalGads - 1) + ")";
        this.gobFlags |= 0x4008280;
        this.gadFlags |= 0x4100005;
        this.gobFlags2 &= 0xFFFFFFFE;
    }

    SuperBitmapConsole(HyperView tView, int tWidth, int tHeight, int pX, int pY) {
        super(tView, tWidth, tHeight, tWidth << 1, tHeight << 1, pX, pY);
        this.gobFlags2 &= 0xFFFFFFFE;
        this.curView = tView;
        this.fGColor = this.curView.color[1];
        this.backColor = this.curView.color[0];
        this.x = pX;
        this.y = pY;
        this.width = tWidth;
        this.height = tHeight;
        this.sourceX2 = this.sourceX + this.width;
        this.sourceY2 = this.sourceY + this.height;
        this.conFont = FontBase.hyperConFont12;
        this.cursorWidth = this.curView.screenGraphics.getFontMetrics(this.conFont).stringWidth("M");
        this.cursorHeight = this.curView.screenGraphics.getFontMetrics(this.conFont).getHeight();
        this.cursorImage = this.curView.createImage(this.cursorWidth, this.cursorHeight);
        this.cursorGraphics = this.cursorImage.getGraphics();
        this.lineColorA = this.curView.color[1];
        this.lineColorB = this.lineColorA.darker();
        this.lineColorC = this.lineColorB.darker();
        try {
            this.cursorImage = (this.curView.ioFlags & 0x20) != 0 ? this.getImageFromJar(this.cursorName) : this.curView.getAppletContext().getImage(new URL(this.curView.getCodeBase(), this.cursorName));
        }
        catch (Exception m) {
            m.printStackTrace(new PrintStream(HyperView.fp));
            this.curView.guru("GetString() Image()");
        }
        this.graphics.setFont(FontBase.hyperConFont12);
        this.curView.addConsole(this);
        this.gobName = "Console(" + (this.curView.totalGads - 1) + ")";
        this.gobFlags |= 0x4008284;
        this.gadFlags |= 0x4100001;
        this.defaultMemoryImage();
        this.superGraphics.drawImage(this.memoryImage, 0, 0, this.curView);
        this.superGraphics.setColor(this.curView.color[9]);
        this.superGraphics.fillRect(0, 0, this.superWidth, 9);
        this.superGraphics.setColor(this.curView.color[1]);
        this.superGraphics.drawLine(0, 7, 0, 0);
        this.superGraphics.drawLine(0, 0, this.superWidth - 1, 0);
        this.superGraphics.drawLine(0, 9, 0, 1);
        this.superGraphics.setColor(this.curView.color[8]);
        this.superGraphics.drawLine(this.superWidth - 1, 1, this.superWidth - 1, 9);
        this.superGraphics.drawLine(this.superWidth - 1, 9, 1, 9);
        this.superGraphics.setColor(this.curView.color[0]);
        this.superGraphics.drawLine(0, 9, this.superWidth, 9);
        while (!this.superGraphics.drawImage(this.curView.mainComponentImage, this.width - 11, 1, this.width - 1, 9, 74, 0, 84, 8, this.curView)) {
            HyperView.delay(300);
        }
        this.superGraphics.setFont(FontBase.hyperConFont10);
        this.superGraphics.setColor(this.curView.color[0]);
        this.superGraphics.drawString("Con :" + this.consoleNumber + " 127.0.0.1", 1, 7);
        this.superGraphics.setFont(FontBase.hyperConFont12);
        this.superGraphics.setColor(this.curView.color[1]);
        this.cursorX = 0;
        this.cursorY = 10;
        this.lastCursorX = this.width - this.cursorWidth;
        this.lastCursorY = this.height - this.cursorHeight;
        this.viewRowNumber = this.height / this.cursorHeight - 1;
        this.viewString = new String[this.viewRowNumber];
        this.lastSuperTopRow = this.superRowNumber - this.viewRowNumber;
        this.startChar = this.charY = this.cursorY + this.cursorHeight - (this.cursorHeight >> 2);
        this.startCursor = this.cursorY;
        this.superColumnNumber = (int)((double)this.superWidth / (double)this.cursorWidth);
        this.screenChar = new char[this.superRowNumber][this.superColumnNumber];
        this.viewColumnNumber = this.width / this.cursorWidth - 1;
        this.textOutputColumn2 = this.textOutputColumn + this.viewColumnNumber - 1;
        this.textOutputLastCol = this.superColumnNumber - this.viewColumnNumber;
        this.textOutputRow2 = this.textOutputRow + this.viewRowNumber - 1;
        this.maxStartColumn = this.superColumnNumber - this.viewColumnNumber;
        this.tint = 0;
        while (this.tint < this.superRowNumber) {
            int i;
            int offset;
            int n;
            byte[] b;
            this.stringLength[this.tint] = 1;
            this.screenChar[this.tint][0] = 126;
            this.tint2 = 1;
            while (this.tint2 < this.superColumnNumber) {
                this.screenChar[this.tint][this.tint2] = 32;
                ++this.tint2;
            }
            if (this.tint == 0) {
                b = "     Right mouse grabs the SuperBitmap.".getBytes();
                n = b.length;
                offset = 1;
                for (i = 0; i < n; ++i) {
                    this.screenChar[this.tint][offset] = (char)b[offset - 1];
                    ++offset;
                }
            } else {
                if (this.tint == 1) {
                    b = "     Left mouse scrolls the SuperBitmap".getBytes();
                    n = b.length;
                    offset = 1;
                    for (i = 0; i < n; ++i) {
                        this.screenChar[this.tint][offset] = (char)b[offset - 1];
                        ++offset;
                    }
                }
                if (this.tint == 2) {
                    b = " ".getBytes();
                    n = b.length;
                    offset = 1;
                    for (i = 0; i < n; ++i) {
                        this.screenChar[this.tint][offset] = (char)b[offset - 1];
                        ++offset;
                    }
                }
                if (this.tint == 3) {
                    b = " This (needs work (100th down my todo list)".getBytes();
                    n = b.length;
                    offset = 1;
                    for (i = 0; i < n; ++i) {
                        this.screenChar[this.tint][offset] = (char)b[offset - 1];
                        ++offset;
                    }
                }
            }
            if (this.tint < this.viewRowNumber) {
                this.viewString[this.tint] = new String(this.screenChar[this.tint]);
            }
            ++this.tint;
        }
        this.graphics.drawImage(this.superImage, this.sourceX, this.sourceY, this.sourceX + this.width, this.sourceY + this.height, 0, 0, this.width, this.height, this.curView);
        this.updateText();
        this.drawCursor();
        this.graphics.setClip(0, 10, this.width, this.height);
    }

    @Override
    public void center() {
        int cw = this.curView.width;
        int ch = this.curView.height;
        int tx = (cw + this.width >> 2) - (this.width >> 2);
        int ty = (cw + this.height >> 2) - (this.height >> 2);
        this.x = tx;
        this.y = ty;
        this.x2 = tx + this.width;
        this.y2 = ty + this.height;
    }

    @Override
    public void inKey() {
        int index = 0;
        while (this.keyboard.mainBufferIndex != this.keyboard.intBufferIndex) {
            if ((this.keyboard.keyMsg[index].flags & 1) != 0) {
                index = this.keyboard.mainBufferIndex;
                this.tmpKey = this.keyboard.keyMsg[index].keyEvent;
                this.tmpChar = this.tmpKey.getKeyChar();
                switch (this.tmpChar) {
                    case '\b': {
                        if (this.curViewColumn > 0) {
                            if (this.cursorX >= 0 && this.cursorX <= this.sourceX2 && this.cursorY >= 0 && this.cursorY <= this.sourceY2) {
                                if ((this.bitmapFlags & 1) != 0) {
                                    this.graphics.drawImage(this.memoryImage, this.cursorX, this.cursorY, this.cursorX + this.cursorWidth, this.cursorY + this.cursorHeight, this.cursorX + this.sourceX, this.cursorY + this.sourceY, this.cursorX + this.cursorWidth + this.sourceX, this.cursorY + this.cursorHeight + this.sourceY, this.curView);
                                } else {
                                    this.graphics.setColor(this.backColor);
                                    this.graphics.fillRect(this.cursorX, this.cursorY, this.cursorWidth, this.cursorHeight);
                                }
                            }
                            this.lastSourceY = 0;
                            this.lastSourceX = 0;
                            this.cursorX -= this.cursorWidth;
                            this.screenChar[this.curViewRow][--this.curViewColumn] = 32;
                            this.charX -= this.cursorWidth;
                            --this.curSuperColumn;
                            this.gadFlags |= 0x80000;
                        } else {
                            this.viewColumnUnder();
                        }
                        this.showPosition();
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if (this.cursorX >= 0 && this.cursorX <= this.sourceX2 && this.cursorY >= 0 && this.cursorY <= this.sourceY2) {
                            if ((this.bitmapFlags & 1) != 0) {
                                this.graphics.drawImage(this.memoryImage, this.cursorX, this.cursorY, this.cursorX + this.cursorWidth, this.cursorY + this.cursorHeight, this.cursorX + this.sourceX, this.cursorY + this.sourceY, this.cursorX + this.cursorWidth + this.sourceX, this.cursorY + this.cursorHeight + this.sourceY, this.curView);
                            } else {
                                this.graphics.setColor(this.backColor);
                                this.graphics.fillRect(this.cursorX, this.cursorY, this.cursorWidth, this.cursorHeight);
                            }
                        } else {
                            this.screenChar[this.curSuperRow][this.curSuperColumn] = 32;
                        }
                        this.carriageReturn(this);
                        this.lastSourceX = 0;
                        ++this.curSuperRow;
                        ++this.curViewRow;
                        this.cursorX = 0;
                        this.cursorY += this.cursorHeight;
                        this.charX = 0;
                        this.charY += this.cursorHeight;
                        this.curViewColumn = 0;
                        this.curSuperColumn = 0;
                        this.tint2 = this.curSuperRow + this.viewRowNumber;
                        this.textOutputColumn = 0;
                        this.textOutputColumn2 = this.textOutputColumn + this.viewColumnNumber - 1;
                        this.sourceX = 0;
                        this.sourceX2 = this.sourceX + this.width;
                        this.graphics.drawImage(this.superImage, 0, 0, this.width, this.height, this.sourceX, this.sourceY, this.sourceX2, this.sourceY2, this.curView);
                        this.updateText();
                        this.showPosition();
                        this.gadFlags |= 0x80000;
                        break;
                    }
                    case '\u001b': {
                        this.home();
                        break;
                    }
                    default: {
                        if ((this.bitmapFlags & 1) != 0) {
                            this.graphics.drawImage(this.memoryImage, this.cursorX, this.cursorY, this.cursorX + this.cursorWidth, this.cursorY + this.cursorHeight, this.cursorX + this.sourceX, this.cursorY + this.sourceY, this.cursorX + this.cursorWidth + this.sourceX, this.cursorY + this.cursorHeight + this.sourceY, this.curView);
                        } else {
                            this.graphics.setColor(this.backColor);
                            this.graphics.fillRect(this.cursorX, this.cursorY, this.cursorWidth, this.cursorHeight);
                        }
                        if (this.tmpChar <= '\u001f' || this.tmpChar >= '~') break;
                        if (this.stringLength[this.curSuperRow] > this.curSuperColumn) {
                            this.stringLength[this.curSuperColumn] = this.curSuperColumn;
                        }
                        this.cursorX += this.cursorWidth;
                        this.graphics.setColor(this.fGColor);
                        this.graphics.drawString(String.valueOf(this.tmpChar), this.charX, this.charY);
                        this.screenChar[this.curSuperRow][this.curSuperColumn] = this.tmpChar;
                        this.charX += this.cursorWidth;
                        ++this.curViewColumn;
                        ++this.curSuperColumn;
                        if (this.stringLength[this.curSuperRow] < this.curSuperColumn) {
                            this.stringLength[this.curSuperRow] = this.curSuperColumn;
                        }
                        this.showPosition();
                        if (this.curViewColumn >= this.viewColumnNumber) {
                            this.viewColumnOver();
                        }
                        this.gadFlags |= 0x80000;
                    }
                }
            }
            ++this.keyboard.mainBufferIndex;
            if (this.keyboard.mainBufferIndex < 512) continue;
            this.keyboard.mainBufferIndex = 0;
        }
    }

    public synchronized void viewColumnUnder() {
        this.curView.toolkit.beep();
        --this.curSuperColumn;
        if (this.curSuperColumn > 0) {
            this.tint = this.sourceX;
            this.tint2 = 5 * this.cursorWidth;
            this.scrollLeft(this.tint2, this);
            this.deltaX = this.sourceX - this.tint;
            this.cursorX -= this.deltaX;
            this.lastSourceX -= this.deltaX;
            this.lClickX = this.clickX;
            this.charX -= this.deltaX;
            this.tint2 = this.deltaX / this.cursorWidth;
            this.textOutputColumn -= this.tint2;
            if (this.textOutputColumn < 0) {
                this.textOutputColumn = 0;
            }
            if (this.stringLength[this.curSuperRow] > this.curSuperColumn) {
                this.stringLength[this.curSuperColumn] = this.curSuperColumn;
            }
        } else {
            this.superColumnUnder();
        }
        this.graphics.drawImage(this.superImage, 0, 0, this.width, this.height, this.sourceX, this.sourceY, this.sourceX2, this.sourceY2, this.curView);
        this.updateText();
        this.showPosition();
    }

    public synchronized void superColumnUnder() {
        --this.curSuperRow;
        if (this.curSuperRow < 0) {
            this.curSuperRow = 0;
        }
        this.tint = this.cursorWidth * this.stringLength[this.curSuperRow];
        this.sourceX = this.tint - (this.width - this.cursorWidth);
        if (this.sourceX < 0) {
            this.sourceX = 0;
        }
        if (this.sourceX > this.superWidth - this.width) {
            this.sourceX = this.superWidth - this.width;
        }
        this.sourceX2 = this.sourceX + this.width;
        this.charX = this.cursorX = this.tint - this.sourceX;
        this.lastSourceX = this.sourceX;
        this.lastSourceY = this.sourceY;
        this.gadFlags |= 0x80000;
        this.curSuperColumn = this.stringLength[this.curSuperRow];
        this.curViewColumn = this.width / this.cursorWidth - 1;
        this.textOutputColumn = this.curViewColumn - this.viewColumnNumber;
        this.textOutputColumn2 = this.textOutputColumn + this.viewColumnNumber - 1;
        this.tint2 = this.curSuperRow + this.viewRowNumber;
        if (this.curViewRow <= 0) {
            this.tint = this.sourceY;
            this.lastSourceY = 0;
            this.sourceY -= 5 * this.cursorHeight;
            if (this.sourceY < 0) {
                this.sourceY = 0;
            }
            this.deltaY = Math.abs(this.tint - this.sourceY);
            this.sourceY2 = this.sourceY + this.height;
        } else {
            this.cursorY -= this.cursorHeight;
            this.charY -= this.cursorHeight;
        }
        this.scrollUp(this);
        this.lastSourceX = 0;
        --this.curViewRow;
    }

    public synchronized void viewColumnOver() {
        if (this.curSuperColumn < this.superColumnNumber) {
            this.tint = this.sourceX;
            this.tint2 = 5 * this.cursorWidth;
            this.scrollRight(this.tint2, this);
            this.deltaX = this.sourceX - this.tint;
            this.cursorX -= this.deltaX;
            this.lastSourceX += this.deltaX;
            this.lClickX = this.clickX;
            this.charX -= this.deltaX;
            this.tint2 = this.deltaX / this.cursorWidth;
            this.curViewColumn -= this.tint2;
            this.textOutputColumn += this.tint2;
            if (this.textOutputColumn > this.textOutputLastCol) {
                this.textOutputColumn = this.textOutputLastCol;
            }
        } else {
            this.superColumnOver();
        }
        this.graphics.drawImage(this.superImage, 0, 0, this.width, this.height, this.sourceX, this.sourceY, this.sourceX2, this.sourceY2, this.curView);
        this.updateText();
        this.showPosition();
    }

    public synchronized void superColumnOver() {
        this.carriageReturn(this);
        if (this.curViewRow >= this.viewRowNumber) {
            this.lastSourceY = 0;
            this.lineFeed(this);
        } else {
            this.cursorY += this.cursorHeight;
            this.charY += this.cursorHeight;
        }
        this.carriageReturn(this);
        this.lastSourceX = 0;
        ++this.curSuperRow;
        ++this.curViewRow;
        this.cursorX = 0;
        this.charX = 0;
        this.gadFlags |= 0x80000;
        this.curViewColumn = 0;
        this.curSuperColumn = 0;
        this.tint2 = this.curSuperRow + this.viewRowNumber;
        this.textOutputColumn = 0;
        this.textOutputColumn2 = this.textOutputColumn + this.viewColumnNumber - 1;
        this.sourceX = 0;
        this.sourceX2 = this.sourceX + this.width;
        this.graphics.drawImage(this.superImage, 0, 0, this.width, this.height, this.sourceX, this.sourceY, this.sourceX2, this.sourceY2, this.curView);
        this.updateText();
        this.showPosition();
    }

    @Override
    public synchronized void drawOutline() {
    }

    @Override
    public synchronized void drawOutline2() {
    }

    @Override
    public void drawCursor() {
        if (this.graphics.drawImage(this.cursorImage, this.cursorX, this.cursorY, this.cursorWidth, this.cursorHeight, this.curView)) {
            this.gadFlags &= 0xFFF7FFFF;
        }
    }

    @Override
    public synchronized void updateText() {
        try {
            this.rowStride = this.startChar - this.sourceY % this.cursorHeight;
            this.graphics.setColor(this.fGColor);
            this.gadFlags |= 0x80000;
            this.curString = 0;
            this.textOutputRow = this.sourceY / this.cursorHeight;
            this.textOutputRow2 = this.textOutputRow + this.viewRowNumber;
            this.textOutputColumn = this.sourceX / this.cursorWidth;
            this.graphics.setColor(this.backColor);
            this.graphics.fillRect(0, this.height - this.cursorHeight, this.width, this.height);
            this.graphics.setColor(this.curView.color[1]);
            this.graphics.drawString("Row " + this.textOutputRow + " Col" + this.textOutputColumn, 0, this.height - (this.cursorHeight >> 2));
            this.tint = this.textOutputRow;
            while (this.tint < this.textOutputRow2) {
                this.viewString[this.curString] = new String(this.screenChar[this.tint], this.textOutputColumn, this.viewColumnNumber);
                this.graphics.drawString(this.viewString[this.curString], this.cursorWidth - this.sourceX % this.cursorWidth - this.cursorWidth, this.rowStride);
                ++this.curString;
                this.rowStride += this.cursorHeight;
                ++this.tint;
            }
        }
        catch (Exception any) {
            this.dataOut("UpdateText() Exception");
            any.printStackTrace();
        }
    }

    @Override
    public synchronized void onMouseOver() {
        this.keyboard.focus = this;
        this.gadFlags |= 0x80000;
    }

    @Override
    public synchronized void onClick() {
        if (this.clickX > 309 && this.clickX < 319 && this.clickY > 0 && this.clickY < 9) {
            this.gobFlags2 |= 2;
            this.gobFlags &= 0xFFFFFDFF;
            return;
        }
        this.mouse.mouseFlags |= 0x20;
        this.mouse.leftGrabGadget = this;
        this.keyboard.focus = this;
        if ((this.lClickX & Integer.MIN_VALUE) != 0) {
            this.lClickX = this.clickX;
            this.lClickY = this.clickY;
        }
        this.deltaX = this.clickX - this.lClickX;
        this.deltaY = this.clickY - this.lClickY;
        if (this.deltaX == 0 && this.deltaY == 0) {
            return;
        }
        this.sourceX -= this.deltaX;
        this.sourceY -= this.deltaY;
        if (this.sourceX < 0) {
            this.sourceX = 0;
        } else if (this.sourceX > this.superWidth - this.width) {
            this.sourceX = this.superWidth - this.width;
        }
        if (this.sourceY < 0) {
            this.sourceY = 0;
        } else if (this.sourceY > this.superHeight - this.height) {
            this.sourceY = this.superHeight - this.height;
        }
        this.sourceX2 = this.sourceX + this.width;
        this.sourceY2 = this.sourceY + this.height;
        this.graphics.drawImage(this.superImage, 0, 0, this.width, this.height, this.sourceX, this.sourceY, this.sourceX2, this.sourceY2, this.curView);
        this.rowStride = this.startCursor;
        this.graphics.setColor(this.fGColor);
        this.gadFlags |= 0x80000;
        this.deltaX = this.lastSourceX - this.sourceX;
        this.deltaY = this.lastSourceY - this.sourceY;
        if (this.deltaX != 0) {
            this.cursorX += this.deltaX;
        }
        if (this.deltaY != 0) {
            this.cursorY += this.deltaY;
        }
        this.charX = this.cursorX;
        this.charY = this.cursorY + this.cursorHeight - (this.cursorHeight >> 2);
        this.updateText();
        this.showPosition();
        this.lastSourceY = this.sourceY;
        this.lastSourceX = this.sourceX;
        this.lClickX = this.clickX;
        this.lClickY = this.clickY;
    }

    public synchronized void saveText() {
        this.tint = 0;
        while (this.tint < this.superRowNumber) {
            try {
                HyperView.hyperViewOut("" + this.tint + ":" + new String(this.screenChar[this.tint], 0, this.viewColumnNumber));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++this.tint;
        }
    }

    public void home() {
        this.charX = 0;
        this.cursorX = 0;
        this.cursorY = 10;
        this.charY = this.cursorY + this.cursorHeight - (this.cursorHeight >> 2);
        this.curSuperColumn = 0;
        this.curSuperRow = 0;
        this.curViewRow = 0;
        this.curViewColumn = 0;
        this.lastSourceX = 0;
        this.lastSourceY = 0;
        this.sourceY = 0;
        this.sourceX = 0;
        this.sourceX2 = this.sourceX + this.width;
        this.sourceY2 = this.sourceY + this.height;
        this.gadFlags |= 0x80000;
        this.carriageReturn(this);
        this.graphics.drawImage(this.superImage, 0, 0, this.width, this.height, this.sourceX, this.sourceY, this.sourceX2, this.sourceY2, this.curView);
        this.updateText();
        this.showPosition();
    }

    public void defaultMemoryImage() {
        for (int i = 0; i < this.superHeight; ++i) {
            int red = i * 255 / (this.superHeight - 1);
            for (int sx = 0; sx < this.superWidth; ++sx) {
                int blue = sx * 255 / (this.superWidth - 1);
                this.rasterBits[this.index++] = 0xFF000000 | red << 16 | blue | 0xFF000000;
            }
        }
        this.memoryImageSource = new MemoryImageSource(this.superWidth, this.superHeight, this.rasterBits, 0, this.superWidth);
        this.memoryImage = this.curView.createImage(this.memoryImageSource);
        this.setMemoryImage(this.memoryImageSource);
    }

    public synchronized void showPosition() {
        this.graphics.setColor(this.backColor);
        this.graphics.fillRect(0, this.height - this.cursorHeight, this.width, this.height);
        this.graphics.setColor(this.curView.color[1]);
        this.graphics.drawString("sx" + this.sourceX + "sy" + this.sourceY + "cr" + this.cursorX + " cry" + this.cursorY + " chx" + this.charX + "chy" + this.charY + "vc" + this.curViewColumn + "csc" + this.curSuperColumn, 0, this.height - (this.cursorHeight >> 2));
    }

    public void setMemoryImage(MemoryImageSource mis) {
        this.memoryImageSource = mis;
        this.bitmapFlags |= 1;
    }

    public void dataOut(String str) {
        HyperView.hyperViewOut("<CONDATA>" + str);
        HyperView.hyperViewOut("curSuperColumn    " + this.curSuperColumn);
        HyperView.hyperViewOut("curSuperRow       " + this.curSuperRow);
        HyperView.hyperViewOut("rowStride         " + this.rowStride);
        HyperView.hyperViewOut("curViewColumn     " + this.curViewColumn);
        HyperView.hyperViewOut("curViewRow        " + this.curViewRow);
        HyperView.hyperViewOut("textOutputColumn  " + this.textOutputColumn);
        HyperView.hyperViewOut("textOutputColumn2 " + this.textOutputColumn2);
        HyperView.hyperViewOut("textOutputLastCol " + this.textOutputLastCol);
        HyperView.hyperViewOut("OutputColumnDiff" + (this.textOutputColumn2 - this.textOutputColumn));
        HyperView.hyperViewOut("textOutputRow     " + this.textOutputRow);
        HyperView.hyperViewOut("textOutputRow2    " + this.textOutputRow2);
        HyperView.hyperViewOut("viewColumnNumber  " + this.viewColumnNumber);
        HyperView.hyperViewOut("viewRowNumber     " + this.viewRowNumber);
        HyperView.hyperViewOut("maxStartColumn    " + this.maxStartColumn);
        HyperView.hyperViewOut("superColumnNumber " + this.superColumnNumber);
        HyperView.hyperViewOut("superRowNumber    " + this.superRowNumber);
        HyperView.hyperViewOut("lastSuperTopRow   " + this.lastSuperTopRow);
        HyperView.hyperViewOut("startCursor       " + this.startCursor);
        HyperView.hyperViewOut("startChar         " + this.startChar);
        HyperView.hyperViewOut("startRow          " + this.startRow);
        HyperView.hyperViewOut("statusRow         " + this.statusRow);
        HyperView.hyperViewOut("charX             " + this.charX);
        HyperView.hyperViewOut("charY             " + this.charY);
        HyperView.hyperViewOut("tint              " + this.tint);
        HyperView.hyperViewOut("tint2             " + this.tint2);
        HyperView.hyperViewOut("lastSourceX       " + this.lastSourceX);
        HyperView.hyperViewOut("lastSourceY       " + this.lastSourceY);
        HyperView.hyperViewOut("tmpKey            " + this.tmpKey);
        HyperView.hyperViewOut("tmpChar           " + this.tmpChar);
        HyperView.hyperViewOut("</CONDATA>");
    }
}

