/*
 * Decompiled with CFR 0.152.
 */
import java.nio.ByteBuffer;

public class StateMachine
implements StateMachineConstants,
StateMachineListener {
    public volatile int stateFlags;
    private StateMachineListener notifier;
    public static final int MAX_STATES = 8;
    StateDispatch[] stateDispatch;
    private int allocatedStates;
    int currentState;
    volatile int userBufferIndex;
    volatile int systemBufferIndex;
    byte[] buffer;
    int bufferSize;

    StateMachine() {
        this.stateFlags = 0;
        this.bufferSize = 512;
    }

    StateMachine(StateMachineListener tNotifier) {
        this.stateDispatch = new StateDispatch[8];
        this.buffer = new byte[4096];
        this.notifier = tNotifier;
        this.stateFlags = 0;
        this.makeStateObjects();
    }

    StateMachine(HyperConnectionNode tNode, StateMachineListener tNotifier) {
        this.stateDispatch = new StateDispatch[8];
        this.buffer = tNode.buffer;
        if (this.buffer == null) {
            System.out.println("ERROR! Null buffer in constructor");
        }
        this.notifier = tNotifier;
        this.makeStateObjects();
    }

    @Override
    public int getStateFlags() {
        return this.stateFlags;
    }

    @Override
    public int orStateFlags(int tInt) {
        this.stateFlags |= tInt;
        return this.stateFlags;
    }

    public void makeStateObjects() {
        StateDispatch[] tStateDispatch = new StateDispatch[]{new GetByte(), new GetShort(), new GetChar(), new GetInt(), new GetLong(), new GetString(), new GetData()};
        this.stateDispatch = tStateDispatch;
    }

    int add(StateDispatch tDispatch) throws OutOfChannelSpaceException {
        if (this.allocatedStates >= 8) {
            throw new OutOfChannelSpaceException();
        }
        tDispatch.id = this.allocatedStates;
        this.stateDispatch[this.allocatedStates++] = tDispatch;
        return this.allocatedStates;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(4096);
        sb.append("StateMachine{");
        sb.append("stateFlags" + this.stateFlags);
        if (this.notifier != null) {
            sb.append("(StateMachineListener)notifier = " + this.notifier.toString() + "\r\n");
        } else {
            sb.append("notifier = null\r\n");
        }
        if (this.stateDispatch != null) {
            int ty = this.stateDispatch.length;
            for (int tz = 0; tz < ty; ++tz) {
                sb.append(this.stateDispatch[tz].toString());
            }
        } else {
            sb.append("stateDispatch Table null\r\n");
        }
        sb.append("allocatedStates = " + this.allocatedStates);
        sb.append("\r\ncurrentState  = " + this.currentState);
        sb.append("\r\nuserBufferIndex = " + this.userBufferIndex);
        sb.append("\r\nsystemBufferIndex = " + this.systemBufferIndex);
        sb.append("\r\nbufferSize = " + this.bufferSize + " };\r\n");
        return sb.toString();
    }

    public void addNotifier(StateMachineListener tObject) throws IllegalStateMachineAddObjectNotifierException {
        if (tObject == null || this.notifier != null) {
            throw new IllegalStateMachineAddObjectNotifierException();
        }
        this.notifier = tObject;
    }

    public void removeNotifier() {
        this.notifier = null;
    }

    public void cleanUp() {
        Object notifier = null;
        this.stateDispatch = null;
        this.buffer = null;
    }

    class IllegalStateMachineAddObjectNotifierException
    extends Exception {
        IllegalStateMachineAddObjectNotifierException() {
            super("OutOfChannelSpaceException");
        }
    }

    class OutOfChannelSpaceException
    extends Exception {
        OutOfChannelSpaceException() {
            super("OutOfChannelSpaceException");
        }
    }

    class GetData
    extends StateDispatch {
        GetData() {
        }

        @Override
        public int processInput(HyperNodeReadVector tReadVector, int tLength) {
            return -1;
        }
    }

    class GetString
    extends StateDispatch {
        GetString() {
        }

        @Override
        public int processInput(HyperNodeReadVector tReadVector, int tLength) {
            return -1;
        }
    }

    class GetLong
    extends StateDispatch {
        GetLong() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int processInput(HyperNodeReadVector tReadVector, int tLength) {
            int retVal = 0;
            int tFlags = 0;
            int inPos = 0;
            boolean mask = false;
            int currentByte = 0;
            byte[] tByte = new byte[8];
            System.out.println("getLong() " + tLength);
            ByteBuffer readBuffer = tReadVector.readBuffer;
            if (StateMachine.this.buffer == null) {
                System.out.println("STATE: null buffer error");
                System.exit(1);
            }
            while (inPos < tLength) {
                StateMachine.this.buffer[StateMachine.this.systemBufferIndex] = readBuffer.get();
                System.out.println("[" + StateMachine.this.buffer[StateMachine.this.systemBufferIndex] + "]");
                retVal |= (StateMachine.this.buffer[StateMachine.this.systemBufferIndex] & 0xFF) << (currentByte << 2);
                ++StateMachine.this.systemBufferIndex;
                if (StateMachine.this.systemBufferIndex >= StateMachine.this.bufferSize) {
                    StateMachine.this.systemBufferIndex = 0;
                }
                ++inPos;
            }
            if ((tFlags & 4) != 0 && StateMachine.this.notifier != null) {
                StateMachineListener stateMachineListener = StateMachine.this.notifier;
                synchronized (stateMachineListener) {
                    StateMachine.this.notifier.notifyAll();
                }
            }
            return -1;
        }
    }

    class GetInt
    extends StateDispatch {
        public volatile int inLength = 0;
        private int currentByte = 0;
        private int retVal = 0;

        GetInt() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int processInput(HyperNodeReadVector tReadVector, int tLength) {
            int retVal = 0;
            int tFlags = 0;
            int inPos = 0;
            boolean mask = false;
            System.out.println("getInt() " + tLength);
            ByteBuffer readBuffer = tReadVector.readBuffer;
            if (StateMachine.this.buffer == null) {
                System.out.println("OOps null buffer in StateMachine");
                System.exit(1);
            }
            while (inPos < tLength) {
                StateMachine.this.buffer[StateMachine.this.systemBufferIndex] = readBuffer.get();
                System.out.println("[" + StateMachine.this.buffer[StateMachine.this.systemBufferIndex] + "]");
                retVal |= (StateMachine.this.buffer[StateMachine.this.systemBufferIndex] & 0xFF) << (this.currentByte << 2);
                ++StateMachine.this.systemBufferIndex;
                if (StateMachine.this.systemBufferIndex >= StateMachine.this.bufferSize) {
                    StateMachine.this.systemBufferIndex = 0;
                }
                ++inPos;
            }
            if ((tFlags & 4) != 0 && StateMachine.this.notifier != null) {
                StateMachineListener stateMachineListener = StateMachine.this.notifier;
                synchronized (stateMachineListener) {
                    StateMachine.this.notifier.notifyAll();
                }
            }
            return -1;
        }
    }

    class GetChar
    extends StateDispatch {
        public volatile int inLength = 0;
        private int currentByte = 0;
        private int retVal = 0;

        GetChar() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int processInput(HyperNodeReadVector tReadVector, int tLength) {
            int retVal = 0;
            int tFlags = 0;
            int inPos = 0;
            boolean mask = false;
            System.out.println("getInt() " + tLength);
            ByteBuffer readBuffer = tReadVector.readBuffer;
            if (StateMachine.this.buffer == null) {
                System.out.println("OOps null buffer in StateMachine");
                System.exit(1);
            }
            while (inPos < tLength) {
                StateMachine.this.buffer[StateMachine.this.systemBufferIndex] = readBuffer.get();
                System.out.println("[" + StateMachine.this.buffer[StateMachine.this.systemBufferIndex] + "]");
                retVal |= (StateMachine.this.buffer[StateMachine.this.systemBufferIndex] & 0xFF) << (this.currentByte << 2);
                ++StateMachine.this.systemBufferIndex;
                if (StateMachine.this.systemBufferIndex >= StateMachine.this.bufferSize) {
                    StateMachine.this.systemBufferIndex = 0;
                }
                ++inPos;
            }
            if ((tFlags & 4) != 0 && StateMachine.this.notifier != null) {
                StateMachineListener stateMachineListener = StateMachine.this.notifier;
                synchronized (stateMachineListener) {
                    StateMachine.this.notifier.notifyAll();
                }
            }
            return -1;
        }
    }

    class GetShort
    extends StateDispatch {
        int count = 0;
        short inVal = 0;
        int currentByte = 0;

        GetShort() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int processInput(HyperNodeReadVector tReadVector, int tLength) {
            int inPos = 0;
            int tFlags = 0;
            System.out.println("getByte() " + tLength);
            ByteBuffer readBuffer = tReadVector.readBuffer;
            if (StateMachine.this.buffer == null) {
                System.out.println("OOps null buffer in StateMachine");
                System.exit(1);
            }
            while (inPos < tLength) {
                StateMachine.this.buffer[StateMachine.this.systemBufferIndex] = readBuffer.get();
                System.out.println("[" + StateMachine.this.buffer[StateMachine.this.systemBufferIndex] + "]");
                ++StateMachine.this.systemBufferIndex;
                if (StateMachine.this.systemBufferIndex >= StateMachine.this.bufferSize) {
                    StateMachine.this.systemBufferIndex = 0;
                }
                if ((tFlags & 4) != 0 && StateMachine.this.notifier != null) {
                    StateMachineListener stateMachineListener = StateMachine.this.notifier;
                    synchronized (stateMachineListener) {
                        StateMachine.this.notifier.orStateFlags(tFlags);
                        StateMachine.this.notifier.notifyAll();
                    }
                }
                ++inPos;
            }
            return -1;
        }
    }

    class GetByte
    extends StateDispatch {
        GetByte() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int processInput(HyperNodeReadVector tReadVector, int tLength) {
            int inPos = 0;
            ByteBuffer readBuffer = tReadVector.readBuffer;
            if (StateMachine.this.buffer == null) {
                System.out.println("OOps null buffer in StateMachine");
                System.exit(1);
            }
            while (inPos < tLength) {
                StateMachine.this.buffer[StateMachine.this.systemBufferIndex] = readBuffer.get();
                ++StateMachine.this.systemBufferIndex;
                if (StateMachine.this.systemBufferIndex >= StateMachine.this.bufferSize) {
                    StateMachine.this.systemBufferIndex = 0;
                }
                if (StateMachine.this.notifier != null) {
                    StateMachineListener stateMachineListener = StateMachine.this.notifier;
                    synchronized (stateMachineListener) {
                        StateMachine.this.notifier.notifyAll();
                    }
                }
                ++inPos;
            }
            return -1;
        }
    }
}

