/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class Spline
implements SplineConstants {
    HyperView curView = null;
    Color lineColor = Color.white;
    int maximumX = 0;
    int minimumX = Integer.MAX_VALUE;
    int maximumY = 0;
    int minimumY = Integer.MAX_VALUE;
    int deltaX = 1;
    int deltaY = 1;
    int targetX = 0;
    int targetY = 0;
    int targetZ = 0;
    int flags = 0;
    byte mapType = 0;
    int mass = 1;
    int curPoint = 0;
    int curRadius = 1;
    int totalPoints = 0;
    int[] x;
    int[] y;
    int[] z;
    int[] dX;
    int[] dY;
    int[] dZ;
    int[] fX;
    int[] fY;
    int[] fZ;
    int[] fDX;
    int[] fDY;
    int[] fDZ;
    int[] fOctant;
    int[] rX;
    int[] rY;
    int[] rZ;
    int[] rDX;
    int[] rDY;
    int[] rDZ;
    int[] rOctant;
    int velocity = 1;
    int[] acceleration;
    Spline next = null;
    Spline prev = null;
    int fGPen = 1;

    Spline() {
    }

    Spline(HyperView tView, int tV, int[] tx, int[] ty) {
        int i = 0;
        this.curView = tView;
        this.velocity = tV;
        this.totalPoints = tx.length;
        if (this.totalPoints != ty.length) {
            System.out.println("Uneven integers in Spline Constructor");
            System.exit(1);
        }
        this.x = tx;
        this.y = ty;
        this.z = new int[this.totalPoints];
        this.fZ = new int[this.totalPoints];
        this.fOctant = new int[this.totalPoints];
        this.rX = new int[this.totalPoints];
        this.rY = new int[this.totalPoints];
        this.rZ = new int[this.totalPoints];
        this.rDX = new int[this.totalPoints];
        this.rDY = new int[this.totalPoints];
        this.rDZ = new int[this.totalPoints];
        this.rOctant = new int[this.totalPoints];
        this.computeDeltas();
        int j = this.totalPoints;
        this.fX = this.x;
        this.fY = this.y;
        this.fZ = this.z;
        this.fDX = this.dX;
        this.fDY = this.dY;
        this.fDZ = this.dZ;
        while (i < this.totalPoints) {
            this.z[i] = 1;
            this.rX[i] = this.x[j];
            this.rY[i] = this.y[j];
            this.rZ[i] = this.z[j--];
            ++i;
        }
        this.computeRDeltas();
        this.flags |= 0x8040;
        if ((this.flags & 0x800) == 0) {
            this.flags |= 0x4000;
        }
    }

    Spline(HyperView tView, int tV, int[] tx, int[] ty, int spf) {
        this(tView, tV, tx, ty, null, spf);
    }

    Spline(HyperView tView, int tV, int[] tx, int[] ty, int[] tz, int spf) {
        int i = 0;
        this.curView = tView;
        this.totalPoints = tx.length;
        this.velocity = tV;
        this.flags |= spf;
        this.x = tx;
        this.y = ty;
        if (tz == null) {
            this.z = new int[this.totalPoints];
        } else {
            this.flags |= 0x800;
            this.z = tz;
        }
        if (this.totalPoints != ty.length || this.totalPoints != this.z.length) {
            System.out.println("Uneven integers in Spline Constructor");
            System.exit(1);
        }
        this.dX = new int[this.totalPoints];
        this.dY = new int[this.totalPoints];
        this.dZ = new int[this.totalPoints];
        this.fX = this.x;
        this.fY = this.y;
        this.fZ = this.z;
        this.fOctant = new int[this.totalPoints];
        this.rX = new int[this.totalPoints];
        this.rY = new int[this.totalPoints];
        this.rZ = new int[this.totalPoints];
        this.rDX = new int[this.totalPoints];
        this.rDY = new int[this.totalPoints];
        this.rDZ = new int[this.totalPoints];
        this.rOctant = new int[this.totalPoints];
        this.computeDeltas();
        this.fDX = this.dX;
        this.fDY = this.dY;
        this.fDZ = this.dY;
        int j = this.totalPoints - 1;
        for (i = 0; i < this.totalPoints; ++i) {
            this.rX[j] = this.x[i];
            this.rY[j] = this.y[i];
            this.rZ[j] = this.z[i];
            --j;
        }
        this.fDX = this.dX;
        this.fDY = this.dY;
        this.fDZ = this.dZ;
        this.computeRDeltas();
        this.flags |= 0x8840;
        if ((this.flags & 0x800) == 0) {
            this.flags |= 0x4000;
        }
    }

    public void setView(HyperView tView) {
        this.curView = tView;
    }

    public void ZBufferEna() {
        this.flags |= 0x840;
        this.flags &= 0xFFFFBFFF;
    }

    public void ZBufferDisable() {
        this.flags &= 0xFFFFF7FF;
        this.flags |= 0x4000;
    }

    public void computeDeltas() {
        int secondLastPoint;
        int v = 0;
        int i = 0;
        int j = secondLastPoint = this.totalPoints - 1;
        int tZ0 = 0;
        int tZ1 = 0;
        this.targetX = this.x[1];
        this.targetY = this.y[1];
        block11: for (i = 0; i < secondLastPoint; ++i) {
            if ((this.flags & 0x800) != 0) {
                tZ0 = this.z[i];
                tZ1 = this.z[i + 1];
                if (tZ0 == tZ1) {
                    this.dZ[i] = 0;
                    this.flags |= 0x4000;
                } else {
                    this.dZ[i] = tZ0 > tZ1 ? -this.velocity : this.velocity;
                }
            }
            v = Octant.getOctant(this.x[i], this.y[i], this.x[i + 1], this.y[i + 1]);
            switch (v) {
                case 0: {
                    this.dY[i] = -this.velocity;
                    this.dX[i] = 0;
                    continue block11;
                }
                case 1: {
                    this.dY[i] = -this.velocity;
                    this.dX[i] = this.velocity;
                    continue block11;
                }
                case 2: {
                    this.dY[i] = 0;
                    this.dX[i] = this.velocity;
                    continue block11;
                }
                case 3: {
                    this.dY[i] = this.velocity;
                    this.dX[i] = this.velocity;
                    continue block11;
                }
                case 4: {
                    this.dY[i] = this.velocity;
                    this.dX[i] = 0;
                    continue block11;
                }
                case 5: {
                    this.dY[i] = this.velocity;
                    this.dX[i] = -this.velocity;
                    continue block11;
                }
                case 6: {
                    this.dY[i] = 0;
                    this.dX[i] = -this.velocity;
                    continue block11;
                }
                case 7: {
                    this.dY[i] = -this.velocity;
                    this.dX[i] = -this.velocity;
                    continue block11;
                }
                case 8: {
                    this.dY[i] = 0;
                    this.dX[i] = 0;
                }
            }
        }
    }

    public void computeRDeltas() {
        int v = 0;
        int i = 0;
        int tRZ1 = 0;
        int tRZ2 = 0;
        int secondLastPoint = this.totalPoints - 1;
        block11: for (i = 0; i < secondLastPoint; ++i) {
            if ((this.flags & 0x800) != 0) {
                tRZ1 = this.rZ[i];
                tRZ2 = this.rZ[i + 1];
                if (tRZ1 == tRZ2) {
                    this.rDZ[i] = 0;
                    this.flags |= 0x4000;
                } else {
                    this.rDZ[i] = tRZ1 > tRZ2 ? -this.velocity : this.velocity;
                }
            }
            this.rOctant[i] = v = Octant.getOctant(this.rX[i], this.rY[i], this.rX[i + 1], this.rY[i + 1]);
            switch (v) {
                case 0: {
                    this.rDY[i] = -this.velocity;
                    this.rDX[i] = 0;
                    continue block11;
                }
                case 1: {
                    this.rDY[i] = -this.velocity;
                    this.rDX[i] = this.velocity;
                    continue block11;
                }
                case 2: {
                    this.rDY[i] = 0;
                    this.rDX[i] = this.velocity;
                    continue block11;
                }
                case 3: {
                    this.rDY[i] = this.velocity;
                    this.rDX[i] = this.velocity;
                    continue block11;
                }
                case 4: {
                    this.rDY[i] = this.velocity;
                    this.rDX[i] = 0;
                    continue block11;
                }
                case 5: {
                    this.rDY[i] = this.velocity;
                    this.rDX[i] = -this.velocity;
                    continue block11;
                }
                case 6: {
                    this.rDY[i] = 0;
                    this.rDX[i] = -this.velocity;
                    continue block11;
                }
                case 7: {
                    this.rDY[i] = -this.velocity;
                    this.rDX[i] = -this.velocity;
                    continue block11;
                }
                case 8: {
                    this.rDY[i] = 0;
                    this.rDX[i] = 0;
                }
            }
        }
    }

    public void cleanUp() {
        this.curView = null;
        this.x = null;
        this.y = null;
        this.z = null;
        this.dX = null;
        this.dY = null;
        this.dZ = null;
        this.fX = null;
        this.fY = null;
        this.fZ = null;
        this.fDX = null;
        this.fDY = null;
        this.fDZ = null;
        this.fOctant = null;
        this.rX = null;
        this.rY = null;
        this.rZ = null;
        this.rDX = null;
        this.rDY = null;
        this.rDZ = null;
        this.rOctant = null;
        this.acceleration = null;
        this.next = null;
        this.prev = null;
    }

    public String toString() {
        boolean j = false;
        boolean deltaX = true;
        boolean deltaY = true;
        return "targetX = " + this.targetX + " targetY = " + this.targetY + "targetZ = " + this.targetZ + "\r\nflags = " + Integer.toHexString(this.flags) + " mapType" + this.mapType + " mass " + this.mass + " curPoint" + this.curPoint + this.getFlagString();
    }

    public String getFlagString() {
        String tStr = "(";
        if ((this.flags & 1) != 0) {
            tStr = tStr + "XPLANE_ENA|";
        }
        if ((this.flags & 2) != 0) {
            tStr = tStr + "YPLANE_ENA|";
        }
        if ((this.flags & 4) != 0) {
            tStr = tStr + "ZPLANE_ENA|";
        }
        if ((this.flags & 8) != 0) {
            tStr = tStr + "PATH_LINE_ENA|";
        }
        if ((this.flags & 0x10) != 0) {
            tStr = tStr + "TRACE_LINE_ENA|";
        }
        if ((this.flags & 0x20) != 0) {
            tStr = tStr + "EDIT_ENA|";
        }
        if ((this.flags & 0x40) != 0) {
            tStr = tStr + "SPLINE_ON|";
        }
        if ((this.flags & 0x80) != 0) {
            tStr = tStr + "STOP_AT_END|";
        }
        if ((this.flags & 0x100) != 0) {
            tStr = tStr + "BOUNCE_AT_END|";
        }
        if ((this.flags & 0x200) != 0) {
            tStr = tStr + "COLLIDE_AT_END|";
        }
        if ((this.flags & 0x400) != 0) {
            tStr = tStr + "WRAP_AT_END|";
        }
        if ((this.flags & 0x800) != 0) {
            tStr = tStr + "SP_ZBUFFER_ENA|";
        }
        if ((this.flags & 0x1000) != 0) {
            tStr = tStr + "AT_TARGETX|";
        }
        if ((this.flags & 0x2000) != 0) {
            tStr = tStr + "AT_TARGETY|";
        }
        if ((this.flags & 0x4000) != 0) {
            tStr = tStr + "AT_TARGETZ|";
        }
        if ((this.flags & 0x8000) != 0) {
            tStr = tStr + "SP_FORWARD|";
        }
        if ((this.flags & 0x7000) == 28672) {
            tStr = tStr + "ARRIVED|";
        }
        tStr = tStr + ")";
        return tStr;
    }
}

