/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;

public class ServerTest {
    static int MAX_SOCKETS = 2;
    String externalAddress = "66.18.241.3";
    int[] portList = null;
    int port = 23232;
    Socket[] socket = null;
    InputStream[] inputStream = null;
    OutputStream[] outputStream = null;
    Runtime runTime;

    ServerTest() {
        this.socket = new Socket[MAX_SOCKETS];
        this.inputStream = new InputStream[MAX_SOCKETS];
        this.outputStream = new OutputStream[MAX_SOCKETS];
    }

    ServerTest(int tVal) {
        MAX_SOCKETS = tVal;
        this.socket = new Socket[MAX_SOCKETS];
        this.inputStream = new InputStream[MAX_SOCKETS];
        this.outputStream = new OutputStream[MAX_SOCKETS];
    }

    public void run() {
        int z = 0;
        boolean curSocket = false;
        boolean working = true;
        String testString = "This is a test. I will write then disconnect\r\n";
        byte[] buffer = new byte[4096];
        int readLen = 0;
        int inRead = 0;
        int iteration = 0;
        int length = 0;
        this.runTime = Runtime.getRuntime();
        while (true) {
            System.out.println("ServerTest V-1.1 " + iteration);
            if (this.portList != null) {
                length = this.portList.length;
                int tPort = (int)(Math.random() * (double)length);
                this.port = this.portList[tPort];
            }
            System.out.println("Trying port " + this.port);
            for (z = 0; z < MAX_SOCKETS; ++z) {
                try {
                    if (z > 9 && z % 100 == 0) {
                        System.out.println("Connecting " + z);
                        this.showMemory();
                    }
                    this.socket[z] = new Socket(this.externalAddress, this.port);
                    this.inputStream[z] = this.socket[z].getInputStream();
                    this.outputStream[z] = this.socket[z].getOutputStream();
                    continue;
                }
                catch (ConnectException jnce) {
                    jnce.printStackTrace();
                    System.exit(1);
                    continue;
                }
                catch (Exception any) {
                    any.printStackTrace();
                    System.exit(1);
                }
            }
            System.out.println("Connected " + MAX_SOCKETS);
            this.pause(1000);
            System.out.println("Reading");
            for (z = 0; z < MAX_SOCKETS; ++z) {
                try {
                    working = true;
                    while (working) {
                        working = false;
                        inRead = this.inputStream[z].available();
                        if (inRead == 0) continue;
                        readLen = this.inputStream[z].read(buffer, 0, inRead);
                        String str = "";
                        char[] c = new char[readLen];
                        for (int n = 0; n < readLen; ++n) {
                            c[n] = (char)buffer[n];
                        }
                        System.out.println(new String(c));
                    }
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            System.out.println("Closing sockets and pausing");
            for (z = 0; z < MAX_SOCKETS; ++z) {
                try {
                    this.socket[z].close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++iteration;
            this.pause(500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pause(int millis) {
        ServerTest serverTest = this;
        synchronized (serverTest) {
            try {
                this.wait(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void showMemory() {
        long freeMemory = this.runTime.freeMemory();
        long maxMemory = this.runTime.maxMemory();
        long totalMemory = this.runTime.totalMemory();
        long usedMemory = totalMemory - freeMemory;
        int percentUsed = (int)((double)usedMemory * 100.0 / (double)totalMemory);
        System.out.println("RAM: free = " + freeMemory + " total = " + totalMemory + " " + percentUsed + "% used.");
    }

    public static void main(String[] args) {
        ServerTest test = null;
        int length = args.length;
        int tPort = 23232;
        int[] tPortList = null;
        int tMaxCons = -1;
        if (length == 0) {
            test = new ServerTest();
        } else {
            if (length == 1) {
                test = new ServerTest(Integer.parseInt(args[0]));
            }
            if (length > 1) {
                int numPorts = 0;
                for (int i = 0; i < length; ++i) {
                    if (args[i].charAt(0) != '-' || args[i].charAt(1) != 'p') continue;
                    ++numPorts;
                }
                if (numPorts > 0) {
                    tPortList = new int[numPorts];
                }
                int tCurrentPort = 0;
                for (int i = 0; i < length; ++i) {
                    if (args[i].charAt(0) == '-' && args[i].charAt(1) == 'p') {
                        String tStr = args[i].substring(2, args[i].length());
                        tPortList[tCurrentPort++] = Integer.parseInt(tStr);
                        tPort = tPortList[0];
                        continue;
                    }
                    try {
                        tMaxCons = Integer.parseInt(args[i]);
                        continue;
                    }
                    catch (Exception any) {
                        tMaxCons = 2;
                    }
                }
                System.out.println("Total test ports = " + tCurrentPort);
                test = new ServerTest(tMaxCons);
                test.port = tPort;
                test.portList = tPortList;
            }
        }
        test.run();
    }
}

