/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.comm.CommDriver;
import javax.comm.CommPortIdentifier;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class SerialHandler
implements Runnable,
SerialPortEventListener,
SerialHandlerConstants {
    StringBuilder stringBuilder;
    static final int[] bpsRates = new int[]{115200, 57600, 38400, 19200, 14400, 9600, 4800, 2400, 1200, 300};
    final int TOTAL_BPS_RATES = bpsRates.length;
    int viewWidth = -1;
    int viewHeight = -1;
    Color textColor;
    Color faceColor;
    Color topColor;
    Color bottomColor;
    Font titleFont;
    Font itemFont;
    public static int bufferSize = 1024;
    static final String version = "SerialHandler V1.1";
    int flags = 0;
    int tint = 0;
    String errorString = "SerialHandler V1.1 - no errors";
    int BPSRate = 19200;
    static SerialPort serialPort1;
    static OutputStream outputStream1;
    static String portName;
    static CommPortIdentifier portID;
    static Enumeration portList;
    Gob gobNotifier;
    Object objectNotifier;
    int recvCount = 0;
    volatile byte[] serial1Buffer = new byte[bufferSize];
    volatile int ser1IntPtr = 0;
    volatile int ser1MainPtr = 0;
    InputStream inputStream1 = null;
    Thread task = null;
    int iteration = 0;
    volatile long timeout = 50L;

    public void out(String string) {
        try {
            outputStream1.write(string.getBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    SerialHandler() {
        this(null, "COM1", 19200);
    }

    SerialHandler(Object object, String string, int n) {
        this.textColor = Color.white;
        this.faceColor = Color.black;
        this.topColor = this.faceColor.brighter();
        this.bottomColor = this.faceColor.darker();
        if (object instanceof Gob) {
            this.gobNotifier = (Gob)object;
        } else {
            this.objectNotifier = object;
        }
        this.BPSRate = n;
        portName = string;
        this.stringBuilder = new StringBuilder(bufferSize);
        String string2 = "com.sun.comm.Win32Driver";
        try {
            CommDriver commDriver = (CommDriver)Class.forName(string2).newInstance();
            commDriver.initialize();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        try {
            portList = CommPortIdentifier.getPortIdentifiers();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            Throwable throwable = exceptionInInitializerError.getCause();
            Throwable throwable2 = exceptionInInitializerError.getException();
            System.out.println("Error: " + throwable.toString() + " : " + throwable2.toString());
        }
        while (portList.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)portList.nextElement();
            if (commPortIdentifier.getPortType() != 1 || !commPortIdentifier.getName().equals("/dev/term/a") && !commPortIdentifier.getName().equals(string)) continue;
            portID = commPortIdentifier;
        }
        if (portID == null) {
            System.out.println("Can't resolve port " + string);
            this.stop();
            System.exit(1);
            return;
        }
        try {
            serialPort1 = (SerialPort)portID.open("Serial1", 2000);
        }
        catch (PortInUseException portInUseException) {
            System.out.println("port " + portID + " already in use");
            this.stop();
            return;
        }
        try {
            this.inputStream1 = serialPort1.getInputStream();
        }
        catch (IOException iOException) {
            System.out.println(" " + iOException.toString());
            return;
        }
        try {
            outputStream1 = serialPort1.getOutputStream();
        }
        catch (IOException iOException) {
            System.out.println(" " + iOException.toString());
            return;
        }
        try {
            serialPort1.setSerialPortParams(this.BPSRate, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            try {
                System.out.println("Unsupported Comm operation defaulting to 19200,8N1");
                serialPort1.setSerialPortParams(this.BPSRate, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException2) {
                return;
            }
        }
        try {
            serialPort1.addEventListener((SerialPortEventListener)this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            System.out.println("Listener overflow");
        }
        serialPort1.notifyOnDataAvailable(true);
        this.start();
    }

    public synchronized void start() {
        this.task = new Thread(this);
        this.task.start();
    }

    public synchronized void stop() {
        this.task = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 0;
        Thread thread = Thread.currentThread();
        int n2 = 1000000;
        SerialHandler serialHandler = this;
        synchronized (serialHandler) {
            while (thread == this.task) {
                Object object;
                this.notifyAll();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    n = this.inputStream1.available();
                    if (n > 0) {
                        for (int i = 0; i < n; ++i) {
                            this.serial1Buffer[this.ser1IntPtr] = (byte)this.inputStream1.read();
                            this.ser1IntPtr = this.ser1IntPtr < bufferSize ? ++this.ser1IntPtr : 0;
                            ++this.recvCount;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(1);
                }
                if (this.gobNotifier != null) {
                    object = this.gobNotifier;
                    synchronized (object) {
                        this.gobNotifier.notifyAll();
                        continue;
                    }
                }
                if (this.objectNotifier == null) continue;
                object = this.objectNotifier;
                synchronized (object) {
                    this.objectNotifier.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialEvent(SerialPortEvent serialPortEvent) {
        switch (serialPortEvent.getEventType()) {
            case 10: {
                break;
            }
            case 7: {
                break;
            }
            case 9: {
                break;
            }
            case 8: {
                break;
            }
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 1: {
                SerialHandler serialHandler = this;
                synchronized (serialHandler) {
                    this.notifyAll();
                    break;
                }
            }
        }
    }

    char getChar(Object object) {
        boolean bl = false;
        this.errorString = this.flush();
        return '\u0000';
    }

    char getC() {
        return '\u0000';
    }

    String flush() {
        int n = 1000000;
        return null;
    }

    int getBPSRate1() {
        for (int i = 0; i < this.TOTAL_BPS_RATES; ++i) {
            try {
                System.out.println("Setting " + bpsRates[i]);
                serialPort1.setSerialPortParams(bpsRates[i], 8, 1, 0);
                if (this.gobNotifier != null) {
                    this.showBuffer();
                }
                this.ser1Out("AT\r\n");
                String string = this.getString();
                System.out.println("Got -> " + string);
                if (this.gobNotifier != null) {
                    // empty if block
                }
                if (string.equals("OK")) {
                    return bpsRates[i];
                }
                System.out.println("Not OK Got -> " + string);
                System.exit(1);
                continue;
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                // empty catch block
            }
        }
        return -1;
    }

    int setBPSRate1(int n) {
        try {
            serialPort1.setSerialPortParams(n, 8, 1, 0);
            return n;
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            unsupportedCommOperationException.printStackTrace();
            return -1;
        }
    }

    public void ser1Out(String string) {
        try {
            outputStream1.write(string.getBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public String getString() {
        int n = 0;
        long l = this.timeout;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        this.stringBuilder.setLength(0);
        this.stringBuilder.setLength(1024);
        SerialHandler serialHandler = this;
        synchronized (serialHandler) {
            while (true) {
                if (this.ser1MainPtr == this.ser1IntPtr) {
                    this.notifyAll();
                    try {
                        this.wait(200L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    --l;
                    if (this.timeout >= 0L) continue;
                    return "TIMEOUT main = " + this.ser1MainPtr + " int = " + this.ser1IntPtr + " cr_lf = " + n2;
                }
                byte by = this.serial1Buffer[this.ser1MainPtr];
                ++n;
                if (by == 10) {
                    bl2 = true;
                    if (bl && ++n2 == 3) {
                        ++this.ser1MainPtr;
                        System.out.println("int = " + this.ser1IntPtr + " main = " + this.ser1MainPtr);
                        this.notifyAll();
                        return this.stringBuilder.toString();
                    }
                }
                if (by == 13) {
                    bl2 = true;
                    ++n2;
                    ++this.ser1MainPtr;
                    bl = true;
                } else {
                    ++this.ser1MainPtr;
                    bl = false;
                }
                if (bl2) {
                    bl2 = false;
                } else {
                    System.out.println("append " + (char)by);
                    this.stringBuilder.append((char)by);
                }
                ++this.ser1MainPtr;
            }
        }
    }

    public void ser1Flush() {
        while (this.ser1MainPtr != this.ser1IntPtr) {
            this.ser1MainPtr = this.ser1IntPtr;
        }
    }

    public void showBuffer() {
        if (this.gobNotifier != null) {
            this.showBuffer((BasicPane)this.gobNotifier);
        }
    }

    public void showBuffer(BasicPane basicPane) {
        Graphics graphics = basicPane.graphics;
        int n = 0;
        int n2 = 0;
        int n3 = 6;
        int n4 = 34;
        this.viewWidth = basicPane.width;
        this.viewHeight = basicPane.height;
        if ((this.viewWidth & Integer.MIN_VALUE) != 0) {
            this.titleFont = new Font("courier", 0, 14);
            this.itemFont = new Font("courier", 0, 11);
        }
        int n5 = 29;
        int n6 = bufferSize / n5;
        int n7 = this.viewWidth - 1;
        int n8 = this.viewHeight - 1;
        graphics.setColor(this.faceColor);
        graphics.fillRect(basicPane.mpX, basicPane.mpY, basicPane.mpWidth, basicPane.mpHeight);
        graphics.setColor(this.topColor);
        graphics.drawLine(basicPane.mpX, basicPane.mpY, 0, 0);
        graphics.drawLine(0, 0, basicPane.mpWidth, 0);
        graphics.setColor(this.bottomColor);
        graphics.drawLine(basicPane.mpWidth - 1, 0, basicPane.mpWidth - 1, basicPane.mpHeight - 1);
        graphics.drawLine(basicPane.mpWidth - 1, basicPane.mpHeight - 1, 0, basicPane.mpHeight - 1);
        graphics.setFont(this.titleFont);
        graphics.setColor(Color.yellow);
        graphics.drawString("Serial Buffer", 10, 20);
        StringBuilder stringBuilder = new StringBuilder();
        graphics.setColor(Color.white);
        graphics.setFont(this.itemFont);
        for (int i = 0; i < n6; ++i) {
            char c;
            int n9;
            stringBuilder.setLength(0);
            n2 = n;
            for (n9 = 0; n9 < n5; ++n9) {
                c = (char)this.serial1Buffer[n];
                stringBuilder.append(HexByte.toString((byte)c));
                ++n;
            }
            stringBuilder.append(' ');
            n = n2;
            for (n9 = 0; n9 < n5; ++n9) {
                c = (char)this.serial1Buffer[n];
                if (Character.isLetterOrDigit(c)) {
                    stringBuilder.append(c);
                } else {
                    stringBuilder.append(".");
                }
                ++n;
            }
            graphics.drawString(stringBuilder.toString(), n3, n4);
            n4 += 10;
        }
    }

    public void setGobNotifier(Gob gob) {
        this.gobNotifier = gob;
    }

    public void setObjectNotifier(Object object) {
        this.objectNotifier = object;
    }
}

