/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.StringTokenizer;

class STDInputHandler
implements Runnable {
    String commandString;
    boolean connecting;
    static int viewNumber;
    static final int ANYKEY_ENA = 1;
    static final String NO_CHANNEL_MSG = "No HyperChannels are active";
    int STDINFlags;
    HyperConnectionHandler parentConnectionHandler;
    ByteBuffer byteBuffer;
    Thread inputTask;
    ReadableByteChannel readChannel;
    InputStream inputStream;
    int lastCommand;
    int iteration;

    STDInputHandler() {
        this.readChannel = Channels.newChannel(System.in);
        this.inputStream = Channels.newInputStream(this.readChannel);
        viewNumber = 0;
        this.lastCommand = -1;
        this.iteration = 0;
        this.byteBuffer = ByteBuffer.allocateDirect(16384);
        this.connecting = false;
        this.STDINFlags = 0;
    }

    STDInputHandler(HyperProcess tProcess) {
        this.readChannel = Channels.newChannel(tProcess.stdin);
        this.inputStream = Channels.newInputStream(this.readChannel);
        viewNumber = 0;
        this.lastCommand = -1;
        this.iteration = 0;
        this.byteBuffer = ByteBuffer.allocateDirect(16384);
        this.connecting = false;
        this.STDINFlags = 0;
    }

    STDInputHandler(HyperConnectionHandler tHandler) {
        this();
        this.parentConnectionHandler = tHandler;
    }

    public void start() {
        this.inputTask = new Thread(this);
        this.inputTask.setName("STDInputHandler()");
        this.inputTask.start();
    }

    public void stop() {
        Thread tThread = this.inputTask;
        this.inputTask = null;
        tThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        String[] args = null;
        int returnValue = 0;
        Thread controlThread = Thread.currentThread();
        byte[] b = new byte[16384];
        Object monitor = new Object();
        while (controlThread == this.inputTask) {
            try {
                this.byteBuffer.clear();
                while (this.readChannel.read(this.byteBuffer) != -1) {
                    this.STDINFlags &= 0xFFFFFFFE;
                    int y = this.byteBuffer.position();
                    this.byteBuffer.flip();
                    for (int z = 0; z < y; ++z) {
                        b[z] = this.byteBuffer.get();
                        if (b[z] != 10 && b[z] != 13) continue;
                        y = z;
                    }
                    this.commandString = new String(b, 0, y);
                    StringTokenizer st = new StringTokenizer(this.commandString);
                    int tokens = st.countTokens();
                    int tokenCount = 0;
                    if (tokens > 1) {
                        args = new String[tokens];
                        while (st.hasMoreTokens()) {
                            args[tokenCount++] = st.nextToken();
                        }
                        this.commandString = args[0];
                        returnValue = this.isCommand(args);
                    } else {
                        args = new String[]{this.commandString};
                        returnValue = this.isCommand(args);
                    }
                    if (returnValue > 0) {
                        this.processCommand(returnValue, args);
                    } else if (this.commandString.length() > 0) {
                        System.out.println("STDIN: unknown command " + this.commandString);
                    }
                    this.byteBuffer.clear();
                }
                returnValue = -1;
                try {
                    Object y = monitor;
                    synchronized (y) {
                        monitor.wait(300L);
                    }
                }
                catch (InterruptedException y) {}
            }
            catch (NullPointerException y) {
            }
            catch (Exception any) {
                any.printStackTrace();
            }
            ++this.iteration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void anyKey() {
        Object tempSynch = new Object();
        this.STDINFlags |= 1;
        System.out.print("\r\n <CR> to continue: ");
        while ((this.STDINFlags & 1) != 0) {
            Object object = tempSynch;
            synchronized (object) {
                try {
                    tempSynch.wait(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCommand(int returnValue, String[] args) {
        int z = 0;
        switch (returnValue) {
            case 1: {
                HyperConnectionHandler.out("<SYSTEM_LISTS>");
                HyperLinkedList.showLists();
                HyperLinkedList.saveLists();
                HyperConnectionHandler.out("</SYSTEM_LISTS>");
                System.out.println("SYS: lists saved");
                break;
            }
            case 2: {
                this.showMemory();
                break;
            }
            case 3: {
                System.out.println("Garbage collecting");
                HyperConnectionHandler.runTime.gc();
                this.showMemory();
                break;
            }
            case 4: {
                this.showCommands();
                break;
            }
            case 5: {
                if (this.lastCommand <= 0 || this.lastCommand == 5) break;
                System.out.println("." + this.getCommandString(this.lastCommand));
                this.processCommand(this.lastCommand, args);
                break;
            }
            case 6: {
                System.out.print(this.parentConnectionHandler.ioString());
                break;
            }
            case 7: {
                System.out.print(this.parentConnectionHandler.ioString());
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                System.out.println("*** HyperConnectionHandler(s) ***\r\nport | connected\r\n" + HyperConnectionHandler.getConnected());
                break;
            }
            case 10: {
                HyperConnectionHandler.inputHandler.readFlags ^= 0x200;
                if ((HyperConnectionHandler.inputHandler.readFlags & 0x200) != 0) {
                    System.out.println("Trace reads enabled");
                    break;
                }
                System.out.println("Trace reads disabled");
                break;
            }
            case 11: {
                HyperConnectionHandler.outputHandler.writeFlags ^= 0x400;
                if ((HyperConnectionHandler.outputHandler.writeFlags & 0x400) != 0) {
                    System.out.println("Trace writes enabled");
                    break;
                }
                System.out.println("Trace writes disabled");
                break;
            }
            case 12: {
                String[] targs = new String[]{"", ""};
                HyperFrame hyperFrame = new HyperFrame(this, ++viewNumber, targs, 640, 480);
                break;
            }
            case 13: {
                System.out.println("connectionPool.items = " + this.parentConnectionHandler.connectionPool.items);
                break;
            }
            case 14: {
                System.out.println("Running main thread iterations");
                System.out.println("CON: " + this.parentConnectionHandler.iteration);
                System.out.println("IN:  " + HyperConnectionHandler.inputHandler.iteration);
                System.out.println("OUT: " + HyperConnectionHandler.outputHandler.iteration);
                System.out.println("DTM: " + HyperConnectionHandler.disconnectTimer.iteration);
                System.out.println("DIS: " + this.parentConnectionHandler.iteration);
                break;
            }
            case 15: {
                this.parentConnectionHandler.conFlags ^= 0x40;
                if ((this.parentConnectionHandler.conFlags & 0x40) != 0) {
                    System.out.println("Connection echo enabled");
                    break;
                }
                System.out.println("Connection echo disabled");
                break;
            }
            case 16: {
                this.parentConnectionHandler.conFlags ^= 0x80;
                if ((this.parentConnectionHandler.conFlags & 0x80) != 0) {
                    System.out.println("Connection save enabled");
                    break;
                }
                System.out.println("Connection save disabled");
                break;
            }
            case 17: {
                HyperConnectionHandler.disconnectTimer.dtmFlags ^= 8;
                if ((HyperConnectionHandler.disconnectTimer.dtmFlags & 8) != 0) {
                    System.out.println("DisconnectTimer echo enabled");
                    break;
                }
                System.out.println("DisconnectTimer echo disabled");
                break;
            }
            case 18: {
                if (args == null || args.length != 2) {
                    System.out.println("\r\nUsage parselist {listname}");
                    break;
                }
                HyperLinkedList tList = SystemListRegistry.getSystemList();
                SystemListNode tSystemNode = (SystemListNode)tList.listBase;
                System.out.println("Processing SystemLists ");
                int n = tSystemNode.name.compareTo(args[1]);
                if (n == 0) {
                    HyperLinkedList tList2 = tSystemNode.parentList;
                    while (tList2 != null) {
                        System.out.println("   >");
                        this.anyKey();
                        tList2 = (HyperLinkedList)tList2.next;
                    }
                    System.out.println("             -><-");
                    tList = null;
                    break;
                }
                System.out.println("no match " + tList.name);
                tList = (HyperLinkedList)tList.next;
                break;
            }
            case 19: {
                System.out.println("STDIN: connect disabled for repair ATM");
                break;
            }
            case 20: {
                System.out.println("*** External connections. ***");
                HyperLinkedList tList = HyperExternalConnectionHandler.externalFinishList;
                synchronized (tList) {
                    System.out.println("Impending =" + HyperExternalConnectionHandler.externalFinishList.items);
                    HyperExternalConnectionHandler.externalFinishList.notifyAll();
                }
                tList = HyperExternalConnectionHandler.externalConnectionList;
                synchronized (tList) {
                    if (HyperExternalConnectionHandler.externalConnectionList.listBase != null) {
                        System.out.println("--- External Connections ---");
                        ExternalConnectionNode tExtNode = (ExternalConnectionNode)HyperExternalConnectionHandler.externalConnectionList.listBase;
                        int tNumber = 0;
                        while (tExtNode != null) {
                            System.out.println(tNumber + ") " + tExtNode.host + ':' + tExtNode.port);
                            ++tNumber;
                            tExtNode = (ExternalConnectionNode)tExtNode.next;
                        }
                    } else {
                        System.out.println("--- No External Connections ---");
                    }
                    HyperExternalConnectionHandler.externalConnectionList.notifyAll();
                    break;
                }
            }
            case 21: {
                if (args.length <= 1) break;
                int num = Integer.parseInt(args[1]);
                HyperLinkedList tExternalConnectionList = HyperExternalConnectionHandler.externalConnectionList;
                if (tExternalConnectionList == null) break;
                HyperLinkedList tNumber = tExternalConnectionList;
                synchronized (tNumber) {
                    ExternalConnectionNode tExtNode = (ExternalConnectionNode)tExternalConnectionList.listBase;
                    int tNumber2 = 0;
                    while (tExtNode != null) {
                        if (tNumber2 == num) {
                            ExternalConnectionNode tExtNode0 = (ExternalConnectionNode)tExtNode.next;
                            System.out.println(" Disconnecting " + tNumber2 + ") " + tExtNode.host + ':' + tExtNode.port);
                            tExternalConnectionList.dlDelete(tExtNode);
                            try {
                                tExtNode.socketChannel.close();
                            }
                            catch (Exception any) {
                                any.printStackTrace();
                            }
                            tExtNode = tExtNode0;
                            tExtNode0 = null;
                            break;
                        }
                        ++tNumber2;
                        tExtNode = (ExternalConnectionNode)tExtNode.next;
                    }
                    tExternalConnectionList.notifyAll();
                    break;
                }
            }
            case 22: {
                STDInputHandler sTDInputHandler = this;
                String[] tString = sTDInputHandler.parentConnectionHandler.getConnectionHandlerListStringArray();
                int n = tString.length;
                for (int i = 0; i < n; ++i) {
                    System.out.println(tString[i]);
                    tString[i] = null;
                }
                tString = null;
                break;
            }
            case 23: {
                if (args.length < 2) {
                    System.out.println("Usage: join [CHANNEL_NAME]");
                    break;
                }
                HyperChannel tChannel2 = HyperChannelRegistry.find(args[1]);
                if (tChannel2 == null) {
                    System.out.println("No such HyperChannel");
                    break;
                }
                tChannel2.join(this);
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                HyperChannel[] tChannel = HyperChannelRegistry.getChannelList();
                if (tChannel == null) {
                    System.out.println(NO_CHANNEL_MSG);
                    break;
                }
                int i = HyperChannelRegistry.totalChannels;
                if (i == 0) {
                    System.out.println(NO_CHANNEL_MSG);
                    break;
                }
                System.out.println("Channel name : Connections : Total channels = " + HyperChannelRegistry.totalChannels);
                for (z = 0; z < i; ++z) {
                    System.out.println(tChannel[z].name + " " + tChannel[z].serverChannelJoinedList.items);
                }
                break;
            }
            case 26: {
                if (args.length > 1) {
                    HyperChannel tChannel2 = null;
                    tChannel2 = HyperChannelRegistry.find(args[1]);
                    if (tChannel2 != null) {
                        System.out.println(tChannel2.name + " active");
                        tChannel2.print();
                        break;
                    }
                    System.out.println("HyperChannel [" + args[1] + "] doesn't exist");
                    break;
                }
                System.out.println("Usage: find [CHANNEL_NAME");
                break;
            }
            case 27: {
                if (args.length != 2) {
                    System.out.println("Usage: newchannel [NAME]");
                    break;
                }
                try {
                    HyperChannel tChannel2 = HyperChannelRegistry.getChannel(args[1]);
                    tChannel2.join(this);
                }
                catch (Exception any) {
                    any.printStackTrace();
                    System.exit(1);
                }
                break;
            }
            case 28: {
                if (args.length == 2) {
                    int n2 = Integer.parseInt(args[1]);
                    if (n2 < 1 || n2 > 65535) {
                        System.out.println("invalid port #" + n2);
                        break;
                    }
                    HyperConnectionHandler tHyperConnectionHandler = HyperConnectionHandler.getConnectionHandler(n2);
                    tHyperConnectionHandler.start();
                    break;
                }
                System.out.println("usage: listen [port]");
                break;
            }
            case 29: {
                if (args.length == 2) {
                    int n2 = Integer.parseInt(args[1]);
                    if (n2 < 1 || n2 > 65535) {
                        System.out.println("invalid port #" + n2);
                        break;
                    }
                    System.out.println("Stopping port " + n2);
                    HyperConnectionHandler.shutDown(n2);
                    break;
                }
                System.out.println("usage: stop [port]");
                break;
            }
            case 30: {
                this.parentConnectionHandler.conFlags ^= 0x400;
                break;
            }
            case 999: {
                this.about();
            }
        }
        if (returnValue != 5) {
            this.lastCommand = returnValue;
        }
    }

    void showMemory() {
        long freeMemory = HyperConnectionHandler.runTime.freeMemory();
        long maxMemory = HyperConnectionHandler.runTime.maxMemory();
        long totalMemory = HyperConnectionHandler.runTime.totalMemory();
        long usedMemory = totalMemory - freeMemory;
        int percentUsed = (int)((double)usedMemory * 100.0 / (double)totalMemory);
        System.out.println("RAM: free = " + freeMemory + " total = " + totalMemory + " " + percentUsed + "% used.");
    }

    void about() {
        System.out.println("HyperConnectionHandler() by Tony Swain tswain@hyperbyte.ab.ca");
    }

    int isCommand(String[] tStringArray) {
        String tString = tStringArray[0];
        if (tString.equals("lists")) {
            return 1;
        }
        if (tString.equals("mem")) {
            return 2;
        }
        if (tString.equals("gc")) {
            return 3;
        }
        if (tString.equals("help")) {
            return 4;
        }
        if (tString.equals("?")) {
            return 4;
        }
        if (tString.equals(".")) {
            return 5;
        }
        if (tString.equals("io")) {
            return 6;
        }
        if (tString.equals("nodeio")) {
            return 7;
        }
        if (tString.equals("savenodes")) {
            return 8;
        }
        if (tString.equals("totalnodes")) {
            return 9;
        }
        if (tString.equals("tracereads")) {
            return 10;
        }
        if (tString.equals("tracewrites")) {
            return 11;
        }
        if (tString.equals("newview")) {
            return 12;
        }
        if (tString.equals("cpool")) {
            return 13;
        }
        if (tString.equals("iterations")) {
            return 14;
        }
        if (tString.equals("printcons")) {
            return 15;
        }
        if (tString.equals("savecons")) {
            return 16;
        }
        if (tString.equals("dtmecho")) {
            return 17;
        }
        if (tString.equals("parselist")) {
            return 18;
        }
        if (tString.equals("connect")) {
            return 19;
        }
        if (tString.equals("external")) {
            return 20;
        }
        if (tString.equals("disconnect")) {
            return 21;
        }
        if (tString.equals("listening")) {
            return 22;
        }
        if (tString.equals("join")) {
            return 23;
        }
        if (tString.equals("leave")) {
            return 24;
        }
        if (tString.equals("channels")) {
            return 25;
        }
        if (tString.equals("find")) {
            return 26;
        }
        if (tString.equals("newchannel")) {
            return 27;
        }
        if (tString.equals("listen")) {
            return 28;
        }
        if (tString.equals("stop")) {
            return 29;
        }
        if (tString.equals("echo")) {
            return 29;
        }
        if (tString.equals("about")) {
            return 999;
        }
        return 0;
    }

    String getCommandString(int tInt) {
        switch (tInt) {
            case 1: {
                return "lists";
            }
            case 2: {
                return "mem";
            }
            case 3: {
                return "gc";
            }
            case 4: {
                return "help";
            }
            case 5: {
                System.out.println("Returning dot -> ");
                return ".";
            }
            case 6: {
                return "io";
            }
            case 7: {
                return "nodeio";
            }
            case 8: {
                return "savenodes";
            }
            case 9: {
                return "totalnodes";
            }
            case 10: {
                return "tracereads";
            }
            case 11: {
                return "tracewrites";
            }
            case 12: {
                return "newview";
            }
            case 13: {
                return "cpool";
            }
            case 14: {
                return "iterations";
            }
            case 15: {
                return "printcons";
            }
            case 16: {
                return "savecons";
            }
            case 17: {
                return "dtmecho";
            }
            case 18: {
                return "parselist";
            }
            case 19: {
                return "connect";
            }
            case 20: {
                return "external";
            }
            case 21: {
                return "disconnect";
            }
            case 22: {
                return "listening";
            }
            case 23: {
                return "join";
            }
            case 24: {
                return "leave";
            }
            case 25: {
                return "channels";
            }
            case 26: {
                return "find";
            }
            case 27: {
                return "newchannel";
            }
            case 28: {
                return "listen";
            }
            case 29: {
                return "stop";
            }
            case 999: {
                return "about";
            }
        }
        return "Unknown command";
    }

    void showCommands() {
        System.out.println("             *** CLI Commands ***\r\n");
        System.out.println("lists                Save lists to nio_server.txt");
        System.out.println("mem                  Show available memory");
        System.out.println("gc                   Run garbage collector");
        System.out.println("io                   Show total io count");
        System.out.println("nodeio               Show individual node io count");
        System.out.println("totalnodes           Show total connected node #");
        System.out.println("tracereads           Inputhandler trace toggle");
        System.out.println("tracewrites          Outputhandler trace toggle");
        System.out.println("newview              Open new HyperView() GUI");
        System.out.println("cpool                Show connection pool items");
        System.out.println("printcons            toggle echo connects/disconnects");
        System.out.println("savecons             toggle save connects/disconnects");
        System.out.println("dtmecho              toggle disconnect timer echo");
        System.out.println("parselist [listname] show system list ");
        System.out.println("connect [InetAddress] [port] connect to remote server");
        System.out.println("external             show external connections");
        System.out.println("listening            show listening servers ");
        System.out.println("join [Channel name]  join exiting channel");
        System.out.println("leave [Channel name] leave the named channel");
        System.out.println("channels             list current channels");
        System.out.println("find                 find if channel exists");
        System.out.println("newchannel [name]    create channel");
        System.out.println("listen [port]        start listening @ port #");
        System.out.println("stop   [port]        stop listening  @ port #");
        System.out.println("\".\"                  repeat last command");
        System.out.println("help or \"?\"    Show this menu");
        System.out.println("             ********************");
    }

    public synchronized void setConnectionHandler(HyperConnectionHandler tHandler) {
        this.parentConnectionHandler = tHandler;
        System.out.println("STDIN: " + tHandler.toString());
        this.notifyAll();
    }

    public synchronized HyperConnectionHandler setConnectionHandler() {
        this.notifyAll();
        return this.parentConnectionHandler;
    }

    public static void main(String[] args) {
        STDInputHandler stdin = new STDInputHandler();
        stdin.start();
        try {
            stdin.inputTask.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

