/*
 * Decompiled with CFR 0.152.
 */
public class PortInfo
implements PortConstants {
    volatile HyperView currentView;
    static volatile boolean isLoaded = false;
    static volatile boolean isSaved = true;
    static volatile int maximumPorts = 255;
    static volatile HyperLinkedList portList = new HyperLinkedList("portNodeList");
    int cntlFlags;
    static volatile int totalPorts = 0;
    int x;
    int y;

    PortInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void open() {
        HyperLinkedList tPortList = PortInfo.getPortList();
        PortNode tPortNode = (PortNode)tPortList.listBase;
        HyperLinkedList hyperLinkedList = tPortList;
        synchronized (hyperLinkedList) {
            while (tPortNode != null) {
                if ((tPortNode.portFlags & 1) != 0) {
                    tPortNode.connectionHandler = HyperConnectionHandler.startConnectionHandler(tPortNode);
                }
                tPortNode = (PortNode)tPortNode.next;
            }
            tPortList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void open(HyperView tView) {
        HyperLinkedList tPortList = PortInfo.getPortList();
        PortNode tPortNode = (PortNode)tPortList.listBase;
        if (tView.parentConnectionHandler == null) {
            HyperLinkedList hyperLinkedList = tPortList;
            synchronized (hyperLinkedList) {
                while (tPortNode != null) {
                    if ((tPortNode.portFlags & 1) != 0) {
                        tView.parentConnectionHandler = tPortNode.connectionHandler = HyperConnectionHandler.startConnectionHandler(tPortNode);
                    }
                    tPortNode = (PortNode)tPortNode.next;
                }
                tPortList.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        HyperLinkedList tPortList = PortInfo.getPortList();
        PortNode tPortNode = (PortNode)tPortList.listBase;
        Object tThread = null;
        HyperLinkedList hyperLinkedList = tPortList;
        synchronized (hyperLinkedList) {
            isLoaded = false;
            while (tPortNode != null) {
                if ((tPortNode.portFlags & 1) != 0 && tPortNode.connectionHandler != null) {
                    tPortNode.connectionHandler.stop();
                }
                tPortNode = (PortNode)tPortNode.next;
            }
            tPortList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(HyperView tView) {
        HyperLinkedList tPortList = PortInfo.getPortList();
        PortNode tPortNode = (PortNode)tPortList.listBase;
        Object tThread = null;
        tView.parentConnectionHandler = null;
        HyperLinkedList hyperLinkedList = tPortList;
        synchronized (hyperLinkedList) {
            isLoaded = false;
            while (tPortNode != null) {
                if ((tPortNode.portFlags & 1) != 0 && tPortNode.connectionHandler != null) {
                    tPortNode.connectionHandler.stop();
                }
                tPortNode = (PortNode)tPortNode.next;
            }
            tPortList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HyperLinkedList getPortList() {
        HyperLinkedList tPortList = portList;
        PortNode tPortNode = null;
        String tPortString = "";
        String tPortFlagString = "";
        if (tPortList != null) {
            try {
                HyperLinkedList hyperLinkedList = tPortList;
                synchronized (hyperLinkedList) {
                    if (!isLoaded) {
                        HyperPreferences tPortNumberPreference = new HyperPreferences("portnumber", "0");
                        int tTotalPorts = Integer.valueOf(tPortNumberPreference.value);
                        if (tTotalPorts > 512 || tTotalPorts < 0) {
                            System.out.println("PortControl port number error " + tTotalPorts);
                            return null;
                        }
                        if (tTotalPorts == 0) {
                            System.out.println("PCP: 0 ports initializing");
                            tPortNode = new PortNode(HyperView.getDefaultPort(), 4);
                            HyperPreferences tPortPreferences = new HyperPreferences("port0", "1");
                            HyperPreferences tPortFlagPreferences = new HyperPreferences("portflag0", "4");
                            PortInfo.addPort(tPortNode);
                        } else {
                            tPortNode = (PortNode)tPortList.listBase;
                            int tZ = 0;
                            for (tZ = 0; tZ < tTotalPorts; ++tZ) {
                                tPortString = "port" + tZ;
                                tPortFlagString = "portflag" + tZ;
                                HyperPreferences tPortPreferences = new HyperPreferences(tPortString, "-1");
                                HyperPreferences tPortFlagPreferences = new HyperPreferences(tPortFlagString, "-1");
                                tPortNode = null;
                                tPortNode = new PortNode(Integer.parseInt(tPortPreferences.value), Integer.parseInt(tPortFlagPreferences.value, 16));
                                tPortList.dlStore(tPortNode);
                            }
                        }
                        isLoaded = true;
                    }
                    tPortList.notifyAll();
                }
            }
            catch (Exception any) {
                any.printStackTrace();
            }
        }
        return portList;
    }

    public static int getPortFlags(int tIndex) {
        HyperLinkedList tPortList = portList;
        HyperPreferences tPortPreferences = new HyperPreferences("portflag" + tIndex, Integer.toHexString(4));
        return Integer.parseInt(tPortPreferences.value, 16);
    }

    public static int savePortFlags(int tIndex, PortNode tPortNodeReference) {
        HyperLinkedList tPortList = portList;
        HyperPreferences tPortPreferences = null;
        tPortPreferences = new HyperPreferences("portflag" + tIndex, Integer.toHexString(4));
        tPortPreferences.put("portflag" + tIndex, Integer.toHexString(tPortNodeReference.portFlags));
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePortList() {
        HyperLinkedList tPortList = portList;
        PortNode tPortNode = null;
        HyperPreferences tPortNumberPreference = new HyperPreferences("portnumber", "0");
        tPortNumberPreference.put("portnumber", Integer.toString(tPortList.items));
        tPortNode = (PortNode)tPortList.listBase;
        if (tPortNode != null) {
            HyperLinkedList hyperLinkedList = tPortList;
            synchronized (hyperLinkedList) {
                int tZ = 0;
                while (tPortNode != null) {
                    HyperPreferences tPortPreferences = new HyperPreferences("port" + tZ, Integer.toString(tPortNode.portNumber));
                    tPortPreferences.put("port" + tZ, Integer.toString(tPortNode.portNumber));
                    tPortPreferences = new HyperPreferences("portflag" + tZ, Integer.toHexString(4));
                    tPortPreferences.put("portflag" + tZ, Integer.toHexString(tPortNode.portFlags));
                    ++tZ;
                    tPortNode = (PortNode)tPortNode.next;
                }
                tPortList.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addPort(PortNode tPortNode) {
        HyperLinkedList tPortList;
        HyperLinkedList hyperLinkedList = tPortList = portList;
        synchronized (hyperLinkedList) {
            PortNode tPortNodeIndex = (PortNode)tPortList.listBase;
            while (tPortNodeIndex != null) {
                if (tPortNode.portNumber == tPortNodeIndex.portNumber) {
                    tPortNodeIndex.portFlags = tPortNode.portFlags;
                    break;
                }
                tPortNodeIndex = (PortNode)tPortNodeIndex.next;
            }
            if (tPortNodeIndex == null) {
                tPortList.dlStore(tPortNode);
            }
            PortInfo.savePortList();
            tPortList.notifyAll();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removePort(PortNode tPortNode) {
        HyperLinkedList tPortList = portList;
        Object tMatchedNode = null;
        PortNode tPortNodeIndex = null;
        HyperLinkedList hyperLinkedList = tPortList;
        synchronized (hyperLinkedList) {
            System.out.println("PortInfo.removePort()");
            tPortNodeIndex = (PortNode)tPortList.listBase;
            while (tPortNodeIndex != null) {
                if (tPortNode == tPortNodeIndex) {
                    System.out.println("PortInfo.removePort() match");
                    break;
                }
                tPortNode = (PortNode)tPortNode.next;
            }
            if (tPortNodeIndex != null) {
                System.out.println("PortInfo.removePort.delete()");
                tPortList.dlDelete(tPortNode);
                return 1;
            }
            tPortList.notifyAll();
        }
        System.out.println("PortInfo.removePort.delete(null) :/");
        return 0;
    }

    public void setMaximumPorts(int tPortNumber) {
        if (tPortNumber < 0 || tPortNumber > 65535) {
            System.out.println("PortInfo.setMaximumPorts(int tPortNumber) range error " + tPortNumber);
        }
        maximumPorts = tPortNumber;
    }

    public static PortNode getPortNodeIndex(int tIndex) {
        int tZ = 0;
        HyperLinkedList tPortList = PortInfo.getPortList();
        PortNode tPortNode = null;
        if (tPortList == null) {
            return null;
        }
        tPortNode = (PortNode)tPortList.listBase;
        while (tPortNode != null) {
            if (tZ == tIndex) {
                return tPortNode;
            }
            ++tZ;
            tPortNode = (PortNode)tPortNode.next;
        }
        return null;
    }

    static PortNode getViewDefaultPort(HyperView tView) {
        return PortInfo.getPortNode(Integer.parseInt(HyperView.defaults.listenPort.value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PortNode getPortNode(int tPortNumber) {
        HyperLinkedList tPortList = portList;
        PortNode tPortNode = null;
        if (tPortList == null) {
            return null;
        }
        HyperLinkedList hyperLinkedList = tPortList;
        synchronized (hyperLinkedList) {
            tPortNode = (PortNode)tPortList.listBase;
            while (tPortNode != null) {
                if (tPortNumber == tPortNode.portNumber) {
                    tPortList.notifyAll();
                    return tPortNode;
                }
                tPortNode = (PortNode)tPortNode.next;
            }
            tPortList.notifyAll();
            return new PortNode(tPortNumber);
        }
    }

    public void addPortListener(PortListener tPortListener) {
    }

    public void remPortListener(PortListener tPortListener) {
    }

    public static PortNode updatePort(PortNode tPortUpdateNode) {
        HyperLinkedList tPortList = PortInfo.getPortList();
        PortNode tMatchedPort = null;
        PortNode tPortNode = (PortNode)tPortList.listBase;
        while (tPortNode != null) {
            if (tPortNode.portNumber == tPortUpdateNode.portNumber) {
                tMatchedPort = tPortNode;
                break;
            }
            tPortNode = (PortNode)tPortNode.next;
        }
        if (tMatchedPort == null) {
            tPortList.dlStore(tPortUpdateNode);
            PortInfo.savePortList();
            return tPortUpdateNode;
        }
        tMatchedPort.portFlags = tPortUpdateNode.portFlags;
        PortInfo.savePortList();
        return tMatchedPort;
    }

    public static String getPortString() {
        String tString;
        String flagPrefix = " flags:";
        String crlf = "\r\n";
        PortNode tPortNode = null;
        int tLen = 0;
        HyperLinkedList tPortList = PortInfo.getPortList();
        tLen = tPortList.items;
        StringBuilder stringBuilder = new StringBuilder(100 * tLen);
        stringBuilder.append("PortInfo total defined ports = " + tLen + " \r\n");
        if (tPortList != null) {
            int tZ = 0;
            tPortNode = (PortNode)tPortList.listBase;
            while (tPortNode != null) {
                stringBuilder.append("Port " + tZ + ") " + tPortNode.portNumber);
                stringBuilder.append(flagPrefix + tPortNode.portFlags + crlf);
                tPortNode = (PortNode)tPortNode.next;
                ++tZ;
            }
            stringBuilder.append("\r\n");
            tString = stringBuilder.toString();
        } else {
            tString = "PNF: No ports defined.";
        }
        return tString;
    }

    public static void main(String[] args) {
        System.out.println(PortInfo.getPortString());
    }
}

