/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Image;

public class PortControlPane
extends BasicPane {
    static int[][] connectionStateOffset = new int[][]{{99, 19, 110, 30}, {121, 19, 131, 30}, {110, 19, 121, 30}};
    static int[][] connectionCommandOffset = new int[][]{{53, 43, 74, 64}, {53, 43, 74, 64}, {0, 43, 21, 64}};
    static final String PORT_PREFIX = "port";
    static final int MAX_DISPLAY_PORTS = 16;
    HyperScrollbar scrollBar;
    Color portPaneColor0;
    Color portPaneColor1;
    RadioButton runServerAtStartRadioButton;
    RadioButton linkChannelRadioButton;
    Gadget addPortGadget;
    Gadget deletePortGadget;
    Gadget saveGadget;
    Gadget loadGadget;
    Gadget defaultGadget;
    Gadget startGadget;
    Gadget stopGadget;
    volatile HyperNumberPop getPortNumberPop;
    String[] portString;
    int totalPorts;
    volatile int currentPort;
    static final int UPDATE_DISPLAY = 1;
    volatile int displayFlags;

    PortControlPane(HyperView tView) {
        super(tView, 522, 432);
        if (tView.viewNumber == 1) {
            PortInfo.open(tView);
        }
        this.textColor = Palette.color[Palette.WHITE];
        this.currentPort = 0;
        this.portPaneColor0 = new Color(127, 127, 255);
        this.portPaneColor1 = this.portPaneColor0.darker();
        this.gobFlags |= 0x8000;
        this.gadFlags |= 0x4100000;
        Gadget a = new Gadget(tView, " X ", 10, 16);
        a.move(this.width - a.width - 2, 2);
        a.addDispatch(new PortControlPaneAbort(this));
        this.addGob(a);
        a.gobFlags |= 0x200;
        this.addPortGadget = new Gadget(tView, " Add ", 451, 156, 62, 24);
        this.addPortGadget.addDispatch(new AddPort(tView));
        this.deletePortGadget = new Gadget(tView, " Delete ", 451, 134, 62, 24);
        this.deletePortGadget.addDispatch(new DeletePort(tView));
        this.saveGadget = new Gadget(tView, " Save ", 453, 44, 62, 24);
        this.loadGadget = new Gadget(tView, " Load ", 453, 22, 62, 24);
        this.curView.curFont = 2;
        this.runServerAtStartRadioButton = new RadioButton(tView, " run at start ");
        this.linkChannelRadioButton = new RadioButton(tView, " Channel ");
        this.linkChannelRadioButton.move(328, 17);
        this.runServerAtStartRadioButton.gobFlags &= 0xFFFF7FFF;
        this.runServerAtStartRadioButton.addDispatch(new DoServerRunAtStartToggle(tView));
        this.linkChannelRadioButton.gobFlags &= 0xFFFF7FFF;
        this.linkChannelRadioButton.addDispatch(new ChannelControlPop(tView));
        this.addGob(this.addPortGadget);
        this.addGob(this.deletePortGadget);
        this.addGob(this.saveGadget);
        this.addGob(this.loadGadget);
        this.addGob(this.runServerAtStartRadioButton);
        this.addGob(this.linkChannelRadioButton);
        this.addPortGadget.gobFlags |= 0x200;
        this.deletePortGadget.gobFlags |= 0x200;
        this.saveGadget.gobFlags |= 0x200;
        this.loadGadget.gobFlags |= 0x200;
        this.center();
        this.update();
    }

    @Override
    public void update() {
        int tZ;
        int tConnectionState = 0;
        HyperLinkedList tPortList = PortInfo.portList;
        boolean tBool = false;
        Image tImage = this.curView.mainComponentImage;
        int PRINT_WIDTH = 320;
        Color tColor0 = this.portPaneColor0;
        Color tColor1 = this.portPaneColor1;
        int cY = 16;
        int cX = 6;
        boolean tLen = false;
        int tTimeout = 0;
        this.graphics.setColor(this.menuPaneColor);
        this.graphics.fillRect(this.mpX, this.mpY, this.mpWidth, this.mpHeight);
        this.graphics.setColor(this.textColor);
        int tX = this.mpX + 12;
        int tY = this.mpY + 12;
        this.runServerAtStartRadioButton.gobFlags &= 0xFFFFFDFF;
        this.linkChannelRadioButton.gobFlags &= 0xFFFFFDFF;
        for (tZ = 0; tZ < 16; ++tZ) {
            if ((tZ & 1) == 0) {
                this.graphics.setColor(tColor0);
                this.graphics.fillRect(cX, cY, PRINT_WIDTH, 22);
            } else {
                this.graphics.setColor(tColor1);
                this.graphics.fillRect(cX, cY, PRINT_WIDTH, 22);
            }
            cY += 22;
        }
        this.curView.fGPen = 1;
        this.graphics.setColor(Color.white);
        tPortList = PortInfo.getPortList();
        int tPortListLength = tPortList.items;
        this.graphics.drawString(" Defined Ports " + tPortListLength + " -><-", 8, 12);
        cY += 22;
        cY = 30;
        PortNode tPortNode = (PortNode)tPortList.listBase;
        tZ = 0;
        while (tPortNode != null) {
            Color tColor3;
            Color tColor2;
            if ((tZ & 1) == 0) {
                this.graphics.setColor(Palette.color[Palette.WHITE]);
            } else {
                this.graphics.setColor(Palette.color[Palette.BLACK]);
            }
            this.graphics.drawString("" + tZ + ')' + ' ' + tPortNode.portNumber + " ", 9, cY);
            int selectY = cY - 14;
            tConnectionState = tPortNode.runState();
            while (!this.graphics.drawImage(tImage, 66, cY - 8, 77, cY + 4, connectionStateOffset[tConnectionState][0], connectionStateOffset[tConnectionState][1], connectionStateOffset[tConnectionState][2], connectionStateOffset[tConnectionState][3], this.curView)) {
                if (++tTimeout > 10) {
                    System.out.println("PCP: can't draw image");
                    break;
                }
                HyperView.delay(100);
            }
            if (tZ == this.currentPort && tPortList.items > 0) {
                int tFlags = PortInfo.getPortFlags(this.currentPort);
                if ((tFlags & 1) != 0) {
                    this.runServerAtStartRadioButton.setSelected();
                } else {
                    this.runServerAtStartRadioButton.deSelect();
                }
                this.runServerAtStartRadioButton.move(207, cY - 13);
                this.runServerAtStartRadioButton.gobFlags |= 0x200;
                if ((tFlags & 0x40) != 0) {
                    this.linkChannelRadioButton.setSelected();
                } else {
                    this.linkChannelRadioButton.deSelect();
                }
                this.linkChannelRadioButton.move(328, cY - 13);
                this.linkChannelRadioButton.gobFlags |= 0x200;
                tColor2 = Palette.color[Palette.GREEN];
                tColor3 = Palette.color[Palette.DARK_GREEN];
                this.graphics.setColor(tColor2);
                while (!this.graphics.drawImage(tImage, 120, cY - 13, 142, cY + 8, connectionCommandOffset[tConnectionState][0], connectionCommandOffset[tConnectionState][1], connectionCommandOffset[tConnectionState][2], connectionCommandOffset[tConnectionState][3], this.curView)) {
                    if (++tTimeout > 10) {
                        System.out.println("PCP: can't draw");
                        break;
                    }
                    HyperView.delay(100);
                }
            } else {
                tColor2 = Palette.color[Palette.RED];
                tColor3 = Palette.color[Palette.DARK_RED];
                this.graphics.setColor(tColor2);
            }
            this.graphics.drawLine(6, selectY, 325, selectY);
            this.graphics.drawLine(325, selectY, 325, selectY + 21);
            this.graphics.setColor(tColor3);
            this.graphics.drawLine(325, selectY + 21, 6, selectY + 21);
            this.graphics.drawLine(6, selectY + 21, 6, selectY);
            cY += 22;
            ++tZ;
            tPortNode = (PortNode)tPortNode.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClick() {
        Image tImage = this.curView.mainComponentImage;
        PortNode tPortNode = null;
        int testX = 6;
        int testY = 16;
        HyperLinkedList tPortList = PortInfo.portList;
        boolean tTimeout = false;
        HyperConnectionHandler tHandler = null;
        this.currentPort = (this.clickY - testY) / 22;
        this.runServerAtStartRadioButton.gobFlags |= 0x200;
        HyperLinkedList hyperLinkedList = tPortList;
        synchronized (hyperLinkedList) {
            if (this.clickX > 120 && this.clickX < 141) {
                tPortNode = PortInfo.getPortNodeIndex(this.currentPort);
                int tConnectionState = tPortNode.runState();
                switch (tConnectionState) {
                    case 0: {
                        try {
                            System.out.println("*********  PCP: Starting Handler on Port  " + tPortNode.portNumber);
                            tPortNode.connectionHandler = tHandler = HyperConnectionHandler.startConnectionHandler(tPortNode);
                            tHandler.portNode = tPortNode;
                        }
                        catch (Exception any) {
                            any.printStackTrace();
                        }
                        break;
                    }
                    case 1: {
                        System.out.println("PCP: already starting Port  " + tPortNode.portNumber);
                        break;
                    }
                    case 2: {
                        tHandler = HyperConnectionHandler.getConnectionHandler(tPortNode.portNumber);
                        if (tHandler != null) {
                            tHandler.stop();
                        }
                        tHandler.portNode = null;
                        break;
                    }
                    default: {
                        System.out.println("PCP: State default port " + tPortNode.portNumber);
                    }
                }
            }
            tPortList.notifyAll();
        }
        HyperView.delay(50);
        this.update();
    }

    class PortControlPaneAbort
    extends Abort {
        PortControlPane parentPane;

        PortControlPaneAbort(PortControlPane tPane) {
            this.parentPane = tPane;
        }

        PortControlPaneAbort(HyperView tView, PortControlPane tPane) {
            super(tView);
            this.parentPane = tPane;
        }

        @Override
        public boolean begin(HyperView tView) {
            if ((this.curView.listFlags & 2) == 0) {
                this.parentPane.gobFlags &= 0xFFFFFDFF;
                this.parentPane.gobFlags2 |= 2;
                this.parentPane = null;
                return false;
            }
            return true;
        }
    }

    class DeletePort
    extends Dispatch {
        DeletePort(HyperView tView) {
        }

        @Override
        public boolean begin(HyperView tView) {
            PortNode tNode = null;
            HyperLinkedList tPortList = PortInfo.getPortList();
            if (PortControlPane.this.currentPort > -1) {
                int tZ = 0;
                tNode = (PortNode)tPortList.listBase;
                while (tNode != null) {
                    if (PortControlPane.this.currentPort == tZ) {
                        tNode = (PortNode)tNode.next;
                        break;
                    }
                    ++tZ;
                }
            }
            if (tNode != null) {
                tPortList.dlDelete(tNode);
                PortInfo.savePortList();
                PortControlPane.this.update();
            }
            return true;
        }
    }

    class ChannelControlPop
    extends Dispatch {
        ChannelControlPop(HyperView tView) {
        }

        @Override
        public boolean begin(HyperView tView) {
            PortNode tPortNode = PortInfo.getPortNodeIndex(PortControlPane.this.currentPort);
            if (tPortNode != null) {
                if (((tPortNode.portFlags ^= 0x40) & 0x40) != 0) {
                    System.out.println(" PORT_CHANNEL_ENA");
                    PortControlPane.this.linkChannelRadioButton.setSelected();
                } else {
                    System.out.println("!PORT_CHANNEL_ENA");
                    PortControlPane.this.linkChannelRadioButton.deSelect();
                }
                PortInfo.savePortFlags(PortControlPane.this.currentPort, tPortNode);
            } else {
                System.out.println(" PortInfo.getPortNodeIndex() = null");
            }
            PortInfo.savePortFlags(PortControlPane.this.currentPort, tPortNode);
            return true;
        }
    }

    class DoServerRunAtStartToggle
    extends Dispatch {
        DoServerRunAtStartToggle(HyperView tView) {
        }

        @Override
        public boolean begin(HyperView tView) {
            PortNode tPortNode = PortInfo.getPortNodeIndex(PortControlPane.this.currentPort);
            if (tPortNode != null) {
                if (((tPortNode.portFlags ^= 1) & 1) != 0) {
                    PortControlPane.this.runServerAtStartRadioButton.setSelected();
                } else {
                    PortControlPane.this.runServerAtStartRadioButton.deSelect();
                }
                PortInfo.savePortFlags(PortControlPane.this.currentPort, tPortNode);
            } else {
                System.out.println(" PortInfo.getPortNodeIndex() = null");
            }
            return true;
        }
    }

    class AddPort
    extends Dispatch {
        AddPort(HyperView tView) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean begin(HyperView tView) {
            AddPort addPort = this;
            synchronized (addPort) {
                if (PortControlPane.this.getPortNumberPop != null) {
                    this.notifyAll();
                    return true;
                }
                HyperConnectionHandler tHyperConnectionHandler = null;
                int tPort = 0;
                PortControlPane.this.getPortNumberPop = new HyperNumberPop(tView, -1, -1, "Enter port #", 5, 1);
                PopupListener.waitForPopClose(tView);
                if (PortControlPane.this.getPortNumberPop.getString[0].textStr != null) {
                    tPort = Integer.parseInt(PortControlPane.this.getPortNumberPop.getString[0].textStr) & 0xFFFFFFFF;
                    if (tPort <= -1 || tPort >= 65535) {
                        new HyperPop(tView, " Port #" + tPort + " out of range ");
                        return true;
                    }
                    tHyperConnectionHandler = HyperConnectionHandler.getConnectionHandler(tPort);
                    PortNode tPortNode = new PortNode(tPort, tHyperConnectionHandler);
                    PortInfo.updatePort(tPortNode);
                }
                PortControlPane.this.update();
                PortControlPane.this.getPortNumberPop = null;
                this.notifyAll();
            }
            return true;
        }
    }

    class PortPaneListener
    extends PortListener {
        PortPaneListener() {
        }

        @Override
        void onPortChange(int tPortNumber, int tValue) {
        }
    }
}

