/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ObjectRegistry
implements DataConstants {
    static final byte majorVersion = 1;
    static final byte minorVersion = 2;
    static final int MAX_OBJECTS = 255;
    public static HyperLinkedList serializationList;
    public static HyperLinkedList listenerList;
    String sourceURL;
    public static ObjectRegistry registryBase;
    public static int totalObjectEntries;

    ObjectRegistry() {
        if (registryBase == null) {
            registryBase = this;
            serializationList = new HyperLinkedList();
            listenerList = new HyperLinkedList();
            ObjectRegistry.load();
        }
    }

    public static ObjectRegistry getRegistry() {
        if (registryBase == null) {
            registryBase = new ObjectRegistry();
        }
        return registryBase;
    }

    public static HyperLinkedList load() {
        boolean registrySize = false;
        File registryFile = null;
        FileInputStream registryInputStream = null;
        byte[] totalObjectBytes = new byte[4];
        byte[] classNameLengthBytes = new byte[4];
        byte[] fieldLengthBytes = new byte[4];
        byte[] fieldNameBytes = new byte[4];
        byte[] totalFieldBytes = new byte[4];
        byte[] b = new byte[4];
        int totalObjects = 0;
        ObjectRegistry parentRegistry = ObjectRegistry.getRegistry();
        HyperLinkedList tSerializationList = serializationList;
        if (tSerializationList == null) {
            tSerializationList = serializationList = new HyperLinkedList();
            tSerializationList.name = "ObjectRegistry.SerializationList";
        } else {
            tSerializationList.drain();
        }
        String baseDir = System.getProperty("user.home");
        char fileChar = System.getProperty("file.separator").charAt(0);
        try {
            int v3;
            int v2;
            int v1;
            registryFile = new File(baseDir + fileChar + "ObjectRegistry.dat");
            if (!registryFile.exists()) {
                if (!registryFile.createNewFile()) {
                    new HyperPop(" Cannot create Object Registry :( ");
                }
                return tSerializationList;
            }
            registryInputStream = new FileInputStream(registryFile);
            byte tMajorVersion = (byte)registryInputStream.read();
            byte tMinorVersion = (byte)registryInputStream.read();
            if (tMajorVersion == -1 || tMinorVersion == -1) {
                return tSerializationList;
            }
            if (tMajorVersion != 1 || tMinorVersion != 2) {
                System.out.println(" ObjectRegistry is version" + tMajorVersion + '.' + tMinorVersion + " but current version is " + tMajorVersion + '.' + tMinorVersion);
                return tSerializationList;
            }
            int v0 = registryInputStream.read();
            totalObjects = (v0 << 24) + ((v1 = registryInputStream.read()) << 16) + ((v2 = registryInputStream.read()) << 8) + ((v3 = registryInputStream.read()) << 0);
            if (totalObjects < 255 && totalObjects > -1) {
                for (int z = 0; z < totalObjects; ++z) {
                    int objectSize = 0;
                    SerializationLink tSerializationLink = new SerializationLink();
                    tSerializationList.dlStore(tSerializationLink);
                    v0 = registryInputStream.read();
                    v1 = registryInputStream.read();
                    v2 = registryInputStream.read();
                    v3 = registryInputStream.read();
                    int classNameLength = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                    if (classNameLength > 255 && classNameLength < 1) {
                        System.out.println("ObjectRegistry class name length error " + classNameLength);
                    }
                    classNameLengthBytes = null;
                    classNameLengthBytes = new byte[classNameLength];
                    registryInputStream.read(classNameLengthBytes);
                    String classNameString = new String(classNameLengthBytes, "UTF-8");
                    v0 = registryInputStream.read();
                    v1 = registryInputStream.read();
                    v2 = registryInputStream.read();
                    v3 = registryInputStream.read();
                    int totalFields = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                    for (int i = 0; i < totalFields; ++i) {
                        v0 = registryInputStream.read();
                        int fieldNameLength = (v0 << 24) + ((v1 = registryInputStream.read()) << 16) + ((v2 = registryInputStream.read()) << 8) + ((v3 = registryInputStream.read()) << 0);
                        if (fieldNameLength > 255 && fieldNameLength < 1) {
                            System.out.println("ObjectRegistry class name length error " + classNameLength);
                        }
                        fieldNameBytes = null;
                        fieldNameBytes = new byte[fieldNameLength];
                        int tReadLen = registryInputStream.read(fieldNameBytes);
                        String fieldNameString = new String(fieldNameBytes, "UTF-8");
                        byte tType = (byte)registryInputStream.read();
                        byte addressBits = (byte)(tType & 0xFFFFFFE0);
                        FieldLink tFieldLink = new FieldLink();
                        tFieldLink.type = tType;
                        tType = (byte)(tType & 0x1F);
                        tFieldLink.name = fieldNameString;
                        switch (tType) {
                            case 0: {
                                ++objectSize;
                                break;
                            }
                            case 1: {
                                objectSize += 2;
                                break;
                            }
                            case 2: {
                                objectSize += 2;
                                break;
                            }
                            case 3: {
                                objectSize += 4;
                                break;
                            }
                            case 4: {
                                objectSize += 8;
                                break;
                            }
                            case 5: {
                                objectSize += 4;
                                break;
                            }
                            case 6: {
                                objectSize += 8;
                                break;
                            }
                            case 7: {
                                break;
                            }
                            case 8: {
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1;
                                break;
                            }
                            case 9: {
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 << 1;
                                break;
                            }
                            case 10: {
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 << 1;
                                break;
                            }
                            case 11: {
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 << 2;
                                break;
                            }
                            case 12: {
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 << 3;
                                break;
                            }
                            case 13: {
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 << 2;
                                break;
                            }
                            case 14: {
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 << 3;
                                break;
                            }
                            case 15: {
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                int len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                break;
                            }
                            case 16: {
                                int len2;
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength1 = len2 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 * len2;
                                break;
                            }
                            case 17: {
                                int len2;
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength1 = len2 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 * len2 << 1;
                                break;
                            }
                            case 18: {
                                int len2;
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength1 = len2 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 * len2 << 1;
                                break;
                            }
                            case 19: {
                                int len2;
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength1 = len2 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 * len2 << 2;
                                break;
                            }
                            case 20: {
                                int len2;
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength1 = len2 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 * len2 << 3;
                                break;
                            }
                            case 21: {
                                int len2;
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength1 = len2 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 * len2 << 2;
                                break;
                            }
                            case 22: {
                                int len2;
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength1 = len2 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 * len2 << 3;
                                break;
                            }
                            case 23: {
                                int len2;
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength1 = len2 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                break;
                            }
                            case 24: {
                                int len3;
                                int len2;
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength1 = len2 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength2 = len3 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 * len2 * len3;
                                break;
                            }
                            case 25: {
                                int len3;
                                int len2;
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength1 = len2 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength2 = len3 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 * len2 * len3 << 1;
                                break;
                            }
                            case 26: {
                                int len3;
                                int len2;
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength1 = len2 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength2 = len3 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 * len2 * len3 << 1;
                                break;
                            }
                            case 27: {
                                int len3;
                                int len2;
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength1 = len2 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength2 = len3 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 * len2 * len3 << 2;
                                break;
                            }
                            case 28: {
                                int len3;
                                int len2;
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength1 = len2 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength2 = len3 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 * len2 * len3 << 3;
                                break;
                            }
                            case 29: {
                                int len3;
                                int len2;
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength1 = len2 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength2 = len3 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 * len2 * len3 << 2;
                                break;
                            }
                            case 30: {
                                int len3;
                                int len2;
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength1 = len2 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength2 = len3 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                objectSize += len1 * len2 * len3 << 3;
                                break;
                            }
                            case 31: {
                                int len3;
                                int len2;
                                int len1;
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength0 = len1 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength1 = len2 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                                v0 = registryInputStream.read();
                                v1 = registryInputStream.read();
                                v2 = registryInputStream.read();
                                v3 = registryInputStream.read();
                                tFieldLink.arrayLength2 = len3 = (v0 << 24) + (v1 << 16) + (v2 << 8) + (v3 << 0);
                            }
                        }
                        tSerializationLink.name = classNameString;
                        tSerializationLink.fieldList.dlStore(tFieldLink);
                        tFieldLink = (FieldLink)tFieldLink.next;
                    }
                }
            } else if (totalObjects != -1) {
                System.out.println("ObjectRegistry Object totalObjects error. totalObject = " + totalObjects);
            }
            registryInputStream.close();
        }
        catch (Exception any) {
            try {
                if (registryInputStream != null) {
                    registryInputStream.close();
                }
            }
            catch (Exception any2) {
                any2.printStackTrace();
            }
            any.printStackTrace();
        }
        return serializationList;
    }

    public static void addListener(Object tObject) {
        ObjectRegistryListenerNode tObjectRegistryListenerNode = new ObjectRegistryListenerNode(tObject);
        if (listenerList == null) {
            listenerList = new HyperLinkedList();
            ObjectRegistry.listenerList.name = "ObjectRegistryListenerList";
        }
        listenerList.dlStore(tObjectRegistryListenerNode);
    }

    public static void remListener(Object tObject) {
        HyperLinkedList tListenerList = listenerList;
        boolean foundObject = false;
        if (tListenerList != null) {
            ObjectRegistryListenerNode tObjectRegistryListenerNode = (ObjectRegistryListenerNode)tListenerList.listBase;
            while (tObjectRegistryListenerNode != null && !foundObject) {
                if (tObjectRegistryListenerNode.notifyer == tObject) {
                    foundObject = true;
                    tObjectRegistryListenerNode.notifyer = null;
                    tListenerList.dlDelete(tObjectRegistryListenerNode);
                    continue;
                }
                tObjectRegistryListenerNode = (ObjectRegistryListenerNode)tObjectRegistryListenerNode.next;
            }
        }
    }

    public static SerializationLink retrieve(String tClassName) {
        return ObjectRegistry.retrieve(null, tClassName);
    }

    public static SerializationLink retrieve(HyperView tView, String tClassName) {
        int index = 0;
        ObjectRegistry tObjectRegistry = ObjectRegistry.getRegistry();
        HyperLinkedList tSerializationList = serializationList;
        if (ObjectRegistry.serializationList.items < 1) {
            return null;
        }
        SerializationLink tSerializationLink = (SerializationLink)tSerializationList.listBase;
        boolean compileSource = true;
        while (tSerializationLink != null) {
            String tSerializationClassNameString = tSerializationLink.name;
            if (tSerializationClassNameString.equals(tClassName)) {
                tSerializationLink.index = index;
                try {
                    Serialization tSerialization;
                    Class<?> c = Class.forName(tClassName);
                    String serializeName = "Serialize" + tClassName;
                    Class<?> serializeClass = Class.forName(serializeName);
                    tSerializationLink.serialization = tSerialization = (Serialization)serializeClass.newInstance();
                    return tSerializationLink;
                }
                catch (ClassNotFoundException cnfe) {
                    String fileToCompileName = tSerializationClassNameString + ".java";
                    if (tView != null) {
                        new HyperPop(tView, " You need to compile " + fileToCompileName);
                    }
                }
                catch (Exception any) {
                    any.printStackTrace();
                }
                return tSerializationLink;
            }
            ++index;
            tSerializationLink = (SerializationLink)tSerializationLink.next;
        }
        return null;
    }

    public static int store(String tName, int tByteSize) {
        return ObjectRegistry.store(null, null, tByteSize, tName);
    }

    public static int store(HyperView tView, HyperLinkedList tFieldList, int tByteSize, String tName) {
        SerializationLink tSerializationLink;
        if (registryBase == null) {
            registryBase = new ObjectRegistry();
        }
        if ((tSerializationLink = ObjectRegistry.retrieve(tName)) == null) {
            tSerializationLink = new SerializationLink(tFieldList, tName, tView, tByteSize, null);
            serializationList.dlStore(tSerializationLink);
            registryBase.save();
        } else {
            SerializationLink tSerializationLink2 = new SerializationLink(tFieldList, tName, tView, tByteSize, null);
            serializationList.swap(tSerializationLink, tSerializationLink2);
            tSerializationLink = null;
            registryBase.save();
        }
        return -1;
    }

    public static int save() {
        boolean writeSize = false;
        byte[] b = new byte[4];
        byte[] sByte = new byte[2];
        byte[] iByte = new byte[4];
        byte[] lByte = new byte[8];
        FileOutputStream outStream = null;
        File registryFile = null;
        int tTotalObjectEntries = ObjectRegistry.serializationList.items;
        if (tTotalObjectEntries < 1) {
            return 0;
        }
        String baseDir = System.getProperty("user.home");
        char fileChar = System.getProperty("file.separator").charAt(0);
        registryFile = new File(baseDir + fileChar + "ObjectRegistry.dat");
        try {
            outStream = new FileOutputStream(registryFile);
            outStream.write(1);
            outStream.write(2);
            SerializationLink tSerializationLink = (SerializationLink)ObjectRegistry.serializationList.listBase;
            outStream.write(tTotalObjectEntries >>> 24 & 0xFF);
            outStream.write(tTotalObjectEntries >>> 16 & 0xFF);
            outStream.write(tTotalObjectEntries >>> 8 & 0xFF);
            outStream.write(tTotalObjectEntries >>> 0 & 0xFF);
            while (tSerializationLink != null) {
                byte[] stringBytes = tSerializationLink.name.getBytes();
                int strlen = stringBytes.length;
                outStream.write(strlen >>> 24 & 0xFF);
                outStream.write(strlen >>> 16 & 0xFF);
                outStream.write(strlen >>> 8 & 0xFF);
                outStream.write(strlen >>> 0 & 0xFF);
                outStream.write(stringBytes);
                int totalFields = tSerializationLink.fieldList.items;
                outStream.write(totalFields >>> 24 & 0xFF);
                outStream.write(totalFields >>> 16 & 0xFF);
                outStream.write(totalFields >>> 8 & 0xFF);
                outStream.write(totalFields >>> 0 & 0xFF);
                FieldLink tFieldLink = (FieldLink)tSerializationLink.fieldList.listBase;
                try {
                    while (tFieldLink != null) {
                        byte[] fieldNameBytes = tFieldLink.name.getBytes();
                        int fieldNameLength = fieldNameBytes.length;
                        outStream.write(fieldNameLength >>> 24 & 0xFF);
                        outStream.write(fieldNameLength >>> 16 & 0xFF);
                        outStream.write(fieldNameLength >>> 8 & 0xFF);
                        outStream.write(fieldNameLength >>> 0 & 0xFF);
                        outStream.write(fieldNameBytes);
                        byte typeByte = tFieldLink.type;
                        outStream.write(typeByte);
                        byte addressingBits = (byte)(typeByte & 0xFFFFFFE0);
                        typeByte = (byte)(typeByte & 0x1F);
                        switch (typeByte) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                break;
                            }
                            case 8: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                break;
                            }
                            case 9: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                break;
                            }
                            case 10: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                break;
                            }
                            case 11: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                break;
                            }
                            case 12: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                break;
                            }
                            case 13: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                break;
                            }
                            case 14: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                break;
                            }
                            case 15: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                break;
                            }
                            case 16: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                int len2 = tFieldLink.arrayLength1;
                                outStream.write(len2 >>> 24 & 0xFF);
                                outStream.write(len2 >>> 16 & 0xFF);
                                outStream.write(len2 >>> 8 & 0xFF);
                                outStream.write(len2 >>> 0 & 0xFF);
                                break;
                            }
                            case 17: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                int len2 = tFieldLink.arrayLength1;
                                outStream.write(len2 >>> 24 & 0xFF);
                                outStream.write(len2 >>> 16 & 0xFF);
                                outStream.write(len2 >>> 8 & 0xFF);
                                outStream.write(len2 >>> 0 & 0xFF);
                                break;
                            }
                            case 18: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                int len2 = tFieldLink.arrayLength1;
                                outStream.write(len2 >>> 24 & 0xFF);
                                outStream.write(len2 >>> 16 & 0xFF);
                                outStream.write(len2 >>> 8 & 0xFF);
                                outStream.write(len2 >>> 0 & 0xFF);
                                break;
                            }
                            case 19: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                int len2 = tFieldLink.arrayLength1;
                                outStream.write(len2 >>> 24 & 0xFF);
                                outStream.write(len2 >>> 16 & 0xFF);
                                outStream.write(len2 >>> 8 & 0xFF);
                                outStream.write(len2 >>> 0 & 0xFF);
                                break;
                            }
                            case 20: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                int len2 = tFieldLink.arrayLength1;
                                outStream.write(len2 >>> 24 & 0xFF);
                                outStream.write(len2 >>> 16 & 0xFF);
                                outStream.write(len2 >>> 8 & 0xFF);
                                outStream.write(len2 >>> 0 & 0xFF);
                                break;
                            }
                            case 21: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                int len2 = tFieldLink.arrayLength1;
                                outStream.write(len2 >>> 24 & 0xFF);
                                outStream.write(len2 >>> 16 & 0xFF);
                                outStream.write(len2 >>> 8 & 0xFF);
                                outStream.write(len2 >>> 0 & 0xFF);
                                break;
                            }
                            case 22: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                int len2 = tFieldLink.arrayLength1;
                                outStream.write(len2 >>> 24 & 0xFF);
                                outStream.write(len2 >>> 16 & 0xFF);
                                outStream.write(len2 >>> 8 & 0xFF);
                                outStream.write(len2 >>> 0 & 0xFF);
                                break;
                            }
                            case 23: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                int len2 = tFieldLink.arrayLength1;
                                outStream.write(len2 >>> 24 & 0xFF);
                                outStream.write(len2 >>> 16 & 0xFF);
                                outStream.write(len2 >>> 8 & 0xFF);
                                outStream.write(len2 >>> 0 & 0xFF);
                                break;
                            }
                            case 24: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                int len2 = tFieldLink.arrayLength1;
                                outStream.write(len2 >>> 24 & 0xFF);
                                outStream.write(len2 >>> 16 & 0xFF);
                                outStream.write(len2 >>> 8 & 0xFF);
                                outStream.write(len2 >>> 0 & 0xFF);
                                int len3 = tFieldLink.arrayLength1;
                                outStream.write(len3 >>> 24 & 0xFF);
                                outStream.write(len3 >>> 16 & 0xFF);
                                outStream.write(len3 >>> 8 & 0xFF);
                                outStream.write(len3 >>> 0 & 0xFF);
                                break;
                            }
                            case 25: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                int len2 = tFieldLink.arrayLength1;
                                outStream.write(len2 >>> 24 & 0xFF);
                                outStream.write(len2 >>> 16 & 0xFF);
                                outStream.write(len2 >>> 8 & 0xFF);
                                outStream.write(len2 >>> 0 & 0xFF);
                                int len3 = tFieldLink.arrayLength1;
                                outStream.write(len3 >>> 24 & 0xFF);
                                outStream.write(len3 >>> 16 & 0xFF);
                                outStream.write(len3 >>> 8 & 0xFF);
                                outStream.write(len3 >>> 0 & 0xFF);
                                break;
                            }
                            case 26: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                int len2 = tFieldLink.arrayLength1;
                                outStream.write(len2 >>> 24 & 0xFF);
                                outStream.write(len2 >>> 16 & 0xFF);
                                outStream.write(len2 >>> 8 & 0xFF);
                                outStream.write(len2 >>> 0 & 0xFF);
                                int len3 = tFieldLink.arrayLength1;
                                outStream.write(len3 >>> 24 & 0xFF);
                                outStream.write(len3 >>> 16 & 0xFF);
                                outStream.write(len3 >>> 8 & 0xFF);
                                outStream.write(len3 >>> 0 & 0xFF);
                                break;
                            }
                            case 27: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                int len2 = tFieldLink.arrayLength1;
                                outStream.write(len2 >>> 24 & 0xFF);
                                outStream.write(len2 >>> 16 & 0xFF);
                                outStream.write(len2 >>> 8 & 0xFF);
                                outStream.write(len2 >>> 0 & 0xFF);
                                int len3 = tFieldLink.arrayLength1;
                                outStream.write(len3 >>> 24 & 0xFF);
                                outStream.write(len3 >>> 16 & 0xFF);
                                outStream.write(len3 >>> 8 & 0xFF);
                                outStream.write(len3 >>> 0 & 0xFF);
                                break;
                            }
                            case 28: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                int len2 = tFieldLink.arrayLength1;
                                outStream.write(len2 >>> 24 & 0xFF);
                                outStream.write(len2 >>> 16 & 0xFF);
                                outStream.write(len2 >>> 8 & 0xFF);
                                outStream.write(len2 >>> 0 & 0xFF);
                                int len3 = tFieldLink.arrayLength1;
                                outStream.write(len3 >>> 24 & 0xFF);
                                outStream.write(len3 >>> 16 & 0xFF);
                                outStream.write(len3 >>> 8 & 0xFF);
                                outStream.write(len3 >>> 0 & 0xFF);
                                break;
                            }
                            case 29: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                int len2 = tFieldLink.arrayLength1;
                                outStream.write(len2 >>> 24 & 0xFF);
                                outStream.write(len2 >>> 16 & 0xFF);
                                outStream.write(len2 >>> 8 & 0xFF);
                                outStream.write(len2 >>> 0 & 0xFF);
                                int len3 = tFieldLink.arrayLength1;
                                outStream.write(len3 >>> 24 & 0xFF);
                                outStream.write(len3 >>> 16 & 0xFF);
                                outStream.write(len3 >>> 8 & 0xFF);
                                outStream.write(len3 >>> 0 & 0xFF);
                                break;
                            }
                            case 30: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                int len2 = tFieldLink.arrayLength1;
                                outStream.write(len2 >>> 24 & 0xFF);
                                outStream.write(len2 >>> 16 & 0xFF);
                                outStream.write(len2 >>> 8 & 0xFF);
                                outStream.write(len2 >>> 0 & 0xFF);
                                int len3 = tFieldLink.arrayLength1;
                                outStream.write(len3 >>> 24 & 0xFF);
                                outStream.write(len3 >>> 16 & 0xFF);
                                outStream.write(len3 >>> 8 & 0xFF);
                                outStream.write(len3 >>> 0 & 0xFF);
                                break;
                            }
                            case 31: {
                                int len1 = tFieldLink.arrayLength0;
                                outStream.write(len1 >>> 24 & 0xFF);
                                outStream.write(len1 >>> 16 & 0xFF);
                                outStream.write(len1 >>> 8 & 0xFF);
                                outStream.write(len1 >>> 0 & 0xFF);
                                int len2 = tFieldLink.arrayLength1;
                                outStream.write(len2 >>> 24 & 0xFF);
                                outStream.write(len2 >>> 16 & 0xFF);
                                outStream.write(len2 >>> 8 & 0xFF);
                                outStream.write(len2 >>> 0 & 0xFF);
                                int len3 = tFieldLink.arrayLength1;
                                outStream.write(len3 >>> 24 & 0xFF);
                                outStream.write(len3 >>> 16 & 0xFF);
                                outStream.write(len3 >>> 8 & 0xFF);
                                outStream.write(len3 >>> 0 & 0xFF);
                            }
                        }
                        tFieldLink = (FieldLink)tFieldLink.next;
                    }
                }
                catch (IOException any) {
                    any.printStackTrace();
                }
                tSerializationLink = (SerializationLink)tSerializationLink.next;
            }
            outStream.close();
        }
        catch (IOException any) {
            new HyperPop(' ' + any.toString() + ' ');
            try {
                outStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            any.printStackTrace();
        }
        totalObjectEntries = tTotalObjectEntries;
        return tTotalObjectEntries;
    }

    public static int remove(String tClassName) {
        ObjectRegistry tRegistry = ObjectRegistry.getRegistry();
        SerializationLink tSerializationLink = ObjectRegistry.retrieve(tClassName);
        if (tSerializationLink == null) {
            return -ObjectRegistry.serializationList.items;
        }
        serializationList.dlDelete(tSerializationLink);
        ObjectRegistry.save();
        return ObjectRegistry.serializationList.items;
    }

    public void echo() {
        ObjectRegistry tRegistry = ObjectRegistry.getRegistry();
        HyperLinkedList tSerializationList = serializationList;
        SerializationLink tSerializationLink = (SerializationLink)ObjectRegistry.serializationList.listBase;
        while (tSerializationLink != null) {
            FieldLink tFieldLink = (FieldLink)tSerializationLink.fieldList.listBase;
            while (tFieldLink != null) {
                System.out.print("   " + tFieldLink.name + " Type: " + TYPE_STRING[tFieldLink.type]);
                if (tFieldLink.arrayLength0 != -1) {
                    System.out.println("  Length0 =  " + tFieldLink.arrayLength0);
                }
                if (tFieldLink.arrayLength1 != -1) {
                    System.out.println("  Length1 =  " + tFieldLink.arrayLength1);
                }
                if (tFieldLink.arrayLength2 != -1) {
                    System.out.println("  Length2 =  " + tFieldLink.arrayLength2);
                }
                System.out.print("\r\n");
                tFieldLink = (FieldLink)tFieldLink.next;
            }
            tSerializationLink = (SerializationLink)tSerializationLink.next;
        }
    }

    public static String[] getClassList() {
        String[] registryEmptyString = new String[]{"ObjectRegistry", "Empty"};
        ObjectRegistry tRegistry = ObjectRegistry.getRegistry();
        HyperLinkedList tSerializationList = serializationList;
        SerializationLink tSerializationLink = (SerializationLink)ObjectRegistry.serializationList.listBase;
        int totalClasses = tSerializationList.items;
        if (totalClasses < 1) {
            return registryEmptyString;
        }
        String[] tClassString = new String[totalClasses];
        int z = 0;
        while (tSerializationLink != null) {
            tClassString[z] = tSerializationLink.name;
            ++z;
            tSerializationLink = (SerializationLink)tSerializationLink.next;
        }
        return tClassString;
    }

    public static int getTotalObjects() {
        ObjectRegistry tRegistry = ObjectRegistry.getRegistry();
        return totalObjectEntries;
    }

    public static void main(String[] args) {
        ObjectRegistry ob = ObjectRegistry.getRegistry();
        ob.echo();
    }
}

