/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;

public class InterProcessMemory
extends Linkable
implements InterProcessMemoryConstants,
Runnable,
MemoryInitializer {
    static int totalProcesses = 0;
    static int processIndex = 0;
    MemoryInitializer memoryInitializer;
    Graphics graphics;
    int processNumber;
    public volatile Thread listenerThread;
    InterProcessMemory innerParent;
    MemorySaveTimer memoryTimer;
    long startTime;
    static volatile HyperLinkedList memoryList;
    static volatile int indeces;
    volatile HyperLinkedList fieldList;
    volatile HyperLinkedList listenerList;
    volatile long updateMillis;
    volatile int memFlags;
    String memName;
    MappedByteBuffer mappedByteBuffer;
    volatile String fileName;
    volatile FileChannel fileChannel;
    volatile RandomAccessFile file;
    int memoryMode;
    int memoryType;
    volatile int index;
    volatile int memSize;
    volatile long memSizeLong;
    static volatile int fp0;
    static volatile long fp1;

    InterProcessMemory() {
        this(512);
    }

    InterProcessMemory(int tSize) {
        fp0 = 0;
        this.updateMillis = 0;
        this.innerParent = this;
        this.memName = "memory" + tSize + ".ipc";
        this.memSize = tSize;
        if (this.listenerList == null) {
            this.listenerList = new HyperLinkedList();
            this.listenerList.listName = "listenerList";
        }
    }

    InterProcessMemory(String tName, int tSize) {
        fp0 = 0;
        this.updateMillis = 0;
        this.fileName = tName;
        this.innerParent = this;
        this.memName = tName + ".ipc";
        this.memSize = tSize;
        if (this.listenerList == null) {
            this.listenerList = new HyperLinkedList();
            this.listenerList.listName = "listenerList";
        }
    }

    InterProcessMemory(long tUpdateMillis, int tSize) {
        this(tSize);
        this.updateMillis = tUpdateMillis;
    }

    public void setMemoryInitializer(MemoryInitializer tMemoryInitializer) {
        this.memoryInitializer = tMemoryInitializer;
    }

    public void setDataAligned() {
        this.memFlags |= 0x4000;
    }

    public void setDataUnAligned() {
        this.memFlags &= 0xFFFFBFFF;
    }

    public int seek(int tInt) throws IllegalMemoryAccessException {
        if (tInt < 0 || tInt >= this.memSize) {
            throw new IllegalMemoryAccessException(" illegal seek " + tInt);
        }
        FileLock tLock = this.lock();
        if (tLock == null) {
            return 0;
        }
        fp0 = tInt;
        try {
            this.fileChannel.position(tInt);
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            return -1;
        }
        return tInt;
    }

    public int readInt() throws IllegalMemoryAccessException {
        boolean tLen = true;
        if ((this.memFlags & 0x4000) != 0 && fp0 % 4 != 0) {
            throw new IllegalMemoryAccessException(" 32 bit alignment error " + fp0);
        }
        int tEnd = fp0 + 4;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException("MEM: readInt out of bounds ->" + tEnd);
        }
        FileLock tLock = this.lock();
        if (tLock == null) {
            return 0;
        }
        int tInt = this.mappedByteBuffer.getInt(fp0);
        fp0 = tEnd;
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return tInt;
    }

    public int readInt(int tOffset) throws IllegalMemoryAccessException {
        boolean tLen = true;
        if ((this.memFlags & 0x4000) != 0 && tOffset % 4 != 0) {
            throw new IllegalMemoryAccessException(" 32 bit alignment error " + tOffset);
        }
        int tEnd = tOffset + 4;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        FileLock tLock = this.lock();
        if (tLock == null) {
            return 0;
        }
        int tInt = this.mappedByteBuffer.getInt(tOffset);
        fp0 = tEnd;
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return tInt;
    }

    public int readInt(int tOffset, int[] tInInt) throws IllegalMemoryAccessException {
        int tLength = tInInt.length;
        if ((this.memFlags & 0x4000) != 0 && tOffset % 4 != 0) {
            throw new IllegalMemoryAccessException(" 32 bit alignment error " + tOffset);
        }
        int tEnd = tOffset + tLength;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        FileLock tLock = this.lock();
        if (tLock == null) {
            return 0;
        }
        this.mappedByteBuffer.position(tOffset);
        for (int tZ = 0; tZ < tLength; ++tZ) {
            tInInt[tZ] = this.mappedByteBuffer.getInt();
        }
        fp0 = tEnd;
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return tLength;
    }

    public int writeInt(int tInt) throws IllegalMemoryAccessException {
        if ((this.memFlags & 0x4000) != 0 && fp0 % 4 != 0) {
            throw new IllegalMemoryAccessException(" 32 bit alignment error " + fp0);
        }
        int tEnd = fp0 + 4;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        FileLock tLock = this.lock();
        if (tLock == null) {
            return 0;
        }
        this.mappedByteBuffer.putInt(fp0, tInt);
        fp0 = tEnd;
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return 1;
    }

    public int writeInt(int tOffset, int tInt) throws IllegalMemoryAccessException {
        if ((this.memFlags & 0x4000) != 0 && tOffset % 4 != 0) {
            throw new IllegalMemoryAccessException(" 32 bit alignment error " + tOffset);
        }
        int tEnd = fp0 + 4;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        FileLock tLock = this.lock();
        if (tLock == null) {
            System.exit(0);
            return 0;
        }
        fp0 = tEnd;
        this.mappedByteBuffer.putInt(tOffset, tInt);
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return 1;
    }

    public int writeInt(int tOffset, int[] tInt) throws IllegalMemoryAccessException {
        int tLen = tInt.length;
        if ((this.memFlags & 0x4000) != 0 && tOffset % 4 != 0) {
            throw new IllegalMemoryAccessException(" 32 bit alignment error " + tOffset);
        }
        int tEnd = fp0 + tLen;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException("IPM: out of bounds ->" + tEnd);
        }
        FileLock tLock = this.lock();
        if (tLock == null) {
            System.exit(0);
            return 0;
        }
        for (int tZ = 0; tZ < tLen; ++tZ) {
            this.mappedByteBuffer.putInt(tOffset, tInt[tZ]);
        }
        fp0 = tEnd;
        try {
            System.out.println("IPM: write(String,int,int) releasing lock");
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return 1;
    }

    public short readShort() throws IllegalMemoryAccessException {
        boolean tLen = true;
        if ((this.memFlags & 0x4000) != 0 && fp0 % 2 != 0) {
            throw new IllegalMemoryAccessException(" 32 bit alignment error " + fp0);
        }
        int tEnd = fp0 + 2;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        FileLock tLock = this.lock();
        if (tLock == null) {
            return 0;
        }
        this.mappedByteBuffer.position(fp0);
        short tShort = this.mappedByteBuffer.getShort(fp0);
        fp0 = tEnd;
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return tShort;
    }

    public short readShort(int tOffset) throws IllegalMemoryAccessException {
        boolean tLen = true;
        if ((this.memFlags & 0x4000) != 0 && tOffset % 2 != 0) {
            throw new IllegalMemoryAccessException(" 32 bit alignment error " + tOffset);
        }
        int tEnd = tOffset + 2;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        FileLock tLock = this.lock();
        if (tLock == null) {
            return 0;
        }
        this.mappedByteBuffer.position(tOffset);
        short tShort = this.mappedByteBuffer.getShort(tOffset);
        fp0 = tEnd;
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return tShort;
    }

    public int writeShort(int tOffset, short tShort) throws IllegalMemoryAccessException {
        if ((this.memFlags & 0x4000) != 0 && tOffset % 2 != 0) {
            throw new IllegalMemoryAccessException(" 32 bit alignment error " + tOffset);
        }
        int tEnd = fp0 + 2;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        FileLock tLock = this.lock();
        if (tLock == null) {
            return 0;
        }
        fp0 = tEnd;
        this.mappedByteBuffer.putShort(tOffset, tShort);
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return 1;
    }

    public void setBitWidth(byte tBitWidth) throws IllegalMemoryAccessException {
        switch (tBitWidth) {
            case 8: {
                this.memFlags &= 0xFFFFE3FF;
                break;
            }
            case 16: {
                this.memFlags &= 0xFFFFE3FF;
                this.memFlags |= 0x400;
                break;
            }
            case 32: {
                this.memFlags &= 0xFFFFE3FF;
                this.memFlags |= 0x800;
                break;
            }
            case 64: {
                this.memFlags &= 0xFFFFE3FF;
                this.memFlags |= 0x1000;
                break;
            }
            default: {
                throw new IllegalMemoryAccessException(".illegal_bitwith " + tBitWidth);
            }
        }
    }

    public byte getBitWidth() {
        int tMemFlags = this.memFlags & 0x1C00;
        if ((tMemFlags & 0x1C00) == 0) {
            return 8;
        }
        if ((tMemFlags & 0x400) != 0) {
            return 16;
        }
        if ((tMemFlags & 0x800) != 0) {
            return 32;
        }
        if ((tMemFlags & 0x400) != 0) {
            return 64;
        }
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLock lockRegion(long tPosition, long tSize) {
        int tIteration = 0;
        FileLock tLock = null;
        boolean tWaitTime = false;
        while (tLock == null) {
            InterProcessMemory interProcessMemory;
            try {
                tLock = this.fileChannel.lock(tPosition, tSize, true);
            }
            catch (FileLockInterruptionException flie) {
                System.out.println(flie.toString());
            }
            catch (OverlappingFileLockException olfle) {
                System.out.println(olfle.toString());
            }
            catch (NonWritableChannelException nwce) {
                System.out.println(nwce.toString());
            }
            catch (ClosedChannelException cce) {
                System.out.println(cce.toString());
            }
            catch (IOException ioex) {
                System.out.println(ioex.toString());
            }
            catch (Exception any) {
                any.printStackTrace();
            }
            if (++tIteration == 4) {
                interProcessMemory = this;
                synchronized (interProcessMemory) {
                    try {
                        this.notifyAll();
                        this.wait(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                }
            }
            if (tIteration == 8) {
                interProcessMemory = this;
                synchronized (interProcessMemory) {
                    try {
                        this.notifyAll();
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                }
            }
            if (tIteration > 16) {
                interProcessMemory = this;
                synchronized (interProcessMemory) {
                    try {
                        this.notifyAll();
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                }
            }
            if ((this.memFlags & 0x40000000) == 0 && (tIteration > 300 || this.listenerThread == null)) break;
            if ((this.memFlags & Integer.MIN_VALUE) == 0) continue;
            return null;
        }
        return tLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLock lock() {
        boolean exception = false;
        int tIteration = 0;
        FileLock tLock = null;
        boolean tWaitTime = false;
        while (tLock == null) {
            InterProcessMemory interProcessMemory;
            try {
                tLock = this.fileChannel.lock(0L, this.memSize, true);
                break;
            }
            catch (FileLockInterruptionException flie) {
                exception = true;
                System.out.println(flie.toString());
            }
            catch (OverlappingFileLockException olfle) {
                exception = true;
                System.out.println(olfle.toString());
            }
            catch (NonWritableChannelException nwce) {
                exception = true;
                System.out.println(nwce.toString());
            }
            catch (ClosedChannelException cce) {
                exception = true;
                System.out.println(cce.toString());
            }
            catch (IOException ioex) {
                exception = true;
                System.out.println(ioex.toString());
            }
            if (++tIteration == 4) {
                interProcessMemory = this;
                synchronized (interProcessMemory) {
                    try {
                        this.notifyAll();
                        this.wait(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                }
            }
            if (tIteration > 8) {
                interProcessMemory = this;
                synchronized (interProcessMemory) {
                    try {
                        this.notifyAll();
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                }
            }
            if (tIteration > 16) {
                interProcessMemory = this;
                synchronized (interProcessMemory) {
                    try {
                        this.notifyAll();
                        this.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                }
            }
            if ((this.memFlags & 0x40000000) == 0 && (tIteration > 300 || this.listenerThread == null)) {
                return null;
            }
            if ((this.memFlags & Integer.MIN_VALUE) == 0) continue;
            return null;
        }
        return tLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLock lock(int tFlags, int tStart, int tLength) {
        boolean exception = false;
        int tIteration = 0;
        FileLock tLock = null;
        boolean tWaitTime = false;
        this.memFlags |= tFlags;
        while (tLock == null) {
            InterProcessMemory interProcessMemory;
            try {
                tLock = this.fileChannel.lock(tStart, tLength, true);
            }
            catch (FileLockInterruptionException flie) {
                exception = true;
                System.out.println(flie.toString());
            }
            catch (OverlappingFileLockException olfle) {
                exception = true;
                System.out.println(olfle.toString());
            }
            catch (NonWritableChannelException nwce) {
                exception = true;
                System.out.println(nwce.toString());
            }
            catch (ClosedChannelException cce) {
                exception = true;
                System.out.println(cce.toString());
            }
            catch (IOException ioex) {
                exception = true;
                System.out.println(ioex.toString());
            }
            if (++tIteration == 4) {
                interProcessMemory = this;
                synchronized (interProcessMemory) {
                    try {
                        this.notifyAll();
                        this.wait(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                }
            }
            if (tIteration == 8) {
                interProcessMemory = this;
                synchronized (interProcessMemory) {
                    try {
                        this.notifyAll();
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                }
            }
            if (tIteration > 16) {
                interProcessMemory = this;
                synchronized (interProcessMemory) {
                    try {
                        this.notifyAll();
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                }
            }
            if ((this.memFlags & 0x40000000) == 0 && (tIteration > 300 || this.listenerThread == null)) {
                this.memFlags &= ~tFlags;
                return null;
            }
            if ((this.memFlags & Integer.MIN_VALUE) == 0) continue;
            this.memFlags &= ~tFlags;
            return null;
        }
        this.memFlags &= ~tFlags;
        return tLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLock blockingLock(int tStart, int tLength) {
        boolean exception = false;
        int tIteration = 0;
        FileLock tLock = null;
        boolean tWaitTime = false;
        while (tLock == null) {
            InterProcessMemory interProcessMemory;
            try {
                tLock = this.fileChannel.lock(tStart, tLength, true);
            }
            catch (FileLockInterruptionException flie) {
                exception = true;
                System.out.println(flie.toString());
            }
            catch (OverlappingFileLockException olfle) {
                exception = true;
                System.out.println(olfle.toString());
            }
            catch (NonWritableChannelException nwce) {
                exception = true;
                System.out.println(nwce.toString());
            }
            catch (ClosedChannelException cce) {
                exception = true;
                System.out.println(cce.toString());
            }
            catch (IOException ioex) {
                exception = true;
                System.out.println(ioex.toString());
            }
            if (++tIteration < 4) {
                interProcessMemory = this;
                synchronized (interProcessMemory) {
                    try {
                        this.notifyAll();
                        this.wait(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                }
            }
            if (tIteration < 16) {
                interProcessMemory = this;
                synchronized (interProcessMemory) {
                    try {
                        this.notifyAll();
                        this.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                }
            }
            interProcessMemory = this;
            synchronized (interProcessMemory) {
                try {
                    this.notifyAll();
                    this.wait(333L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.notifyAll();
            }
            if ((this.memFlags & Integer.MIN_VALUE) == 0) continue;
            return null;
        }
        return tLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLock lock(int tFlags) {
        boolean exception = false;
        int tIteration = 0;
        FileLock tLock = null;
        boolean tWaitTime = false;
        this.memFlags |= tFlags;
        while (tLock == null) {
            InterProcessMemory interProcessMemory;
            try {
                tLock = this.fileChannel.lock();
            }
            catch (FileLockInterruptionException flie) {
                exception = true;
                System.out.println(flie.toString());
            }
            catch (OverlappingFileLockException olfle) {
                exception = true;
                System.out.println(olfle.toString());
            }
            catch (NonWritableChannelException nwce) {
                exception = true;
                System.out.println(nwce.toString());
            }
            catch (ClosedChannelException cce) {
                exception = true;
                System.out.println(cce.toString());
            }
            catch (IOException ioex) {
                exception = true;
                System.out.println(ioex.toString());
            }
            if (++tIteration == 4) {
                interProcessMemory = this;
                synchronized (interProcessMemory) {
                    try {
                        this.notifyAll();
                        this.wait(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                }
            }
            if (tIteration == 8) {
                interProcessMemory = this;
                synchronized (interProcessMemory) {
                    try {
                        this.notifyAll();
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                }
            }
            if (tIteration > 16) {
                interProcessMemory = this;
                synchronized (interProcessMemory) {
                    try {
                        this.notifyAll();
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                }
            }
            if ((this.memFlags & 0x40000000) == 0 && (tIteration > 300 || this.listenerThread == null)) {
                this.memFlags &= ~tFlags;
                return null;
            }
            if ((this.memFlags & Integer.MIN_VALUE) == 0) continue;
            this.memFlags &= ~tFlags;
            return null;
        }
        this.memFlags &= ~tFlags;
        return tLock;
    }

    public void start() {
        Thread tThread = this.listenerThread;
        if (tThread != null) {
            this.listenerThread = null;
            tThread.interrupt();
        }
        this.listenerThread = new Thread(this);
        this.memFlags &= Integer.MAX_VALUE;
        this.listenerThread.start();
    }

    public void stop() {
        this.memFlags |= Integer.MIN_VALUE;
        Thread tThread = this.listenerThread;
        if (tThread != null) {
            this.listenerThread = null;
            tThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread controlThread = Thread.currentThread();
        while (controlThread == this.listenerThread) {
            FileLock tLock;
            HyperLinkedList hyperLinkedList = this.listenerList;
            synchronized (hyperLinkedList) {
                tLock = this.lock();
                MemoryFieldLink tMemoryFieldLink = (MemoryFieldLink)this.listenerList.listBase;
                while (tMemoryFieldLink != null) {
                    System.out.println("MEM: calling handlers");
                    tMemoryFieldLink.onMemoryChange();
                    tMemoryFieldLink = (MemoryFieldLink)tMemoryFieldLink.next;
                }
                this.listenerList.notifyAll();
                try {
                    tLock.release();
                    tLock = null;
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                }
                try {
                    this.listenerList.wait();
                    if ((this.memFlags & 0x80) != 0) {
                        this.listenerThread = null;
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (tLock == null) continue;
            try {
                tLock.release();
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
            tLock = null;
        }
        this.purge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveToDevice() {
        int tIteration = 0;
        FileLock tLock = null;
        boolean tWaitTime = false;
        System.out.println("MEM: SaveToDevice()");
        while (tLock == null) {
            try {
                tLock = this.fileChannel.lock();
            }
            catch (FileLockInterruptionException flie) {
                System.out.println(flie.toString());
            }
            catch (OverlappingFileLockException olfle) {
                System.out.println(olfle.toString());
            }
            catch (NonWritableChannelException nwce) {
                System.out.println(nwce.toString());
            }
            catch (ClosedChannelException cce) {
                System.out.println(cce.toString());
            }
            catch (IOException ioex) {
                System.out.println(ioex.toString());
            }
            if ((++tIteration & 4) != 0) {
                InterProcessMemory interProcessMemory = this;
                synchronized (interProcessMemory) {
                    try {
                        this.notifyAll();
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                }
            }
            if (tIteration <= 300 && this.listenerThread != null) continue;
            return 0;
        }
        try {
            tLock.release();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listenerWait() {
        HyperLinkedList hyperLinkedList = this.listenerList;
        synchronized (hyperLinkedList) {
            this.listenerList.notifyAll();
            try {
                this.listenerList.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Object object;
        Object tObject = new Object();
        int tIteration = 0;
        HyperLinkedList tList = this.listenerList;
        File tFile = null;
        boolean tDeleted = false;
        try {
            this.mappedByteBuffer = null;
            this.fileChannel.close();
            this.file.close();
            this.fileChannel = null;
            this.file = null;
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        if (tList != null) {
            object = tList;
            synchronized (object) {
                tList.drain();
                tList.notifyAll();
            }
        }
        if ((this.memFlags & 2) == 0) {
            tFile = new File(this.fileName);
            tFile.delete();
            while (tDeleted = tFile.exists()) {
                System.gc();
                tFile.delete();
                try {
                    object = tObject;
                    synchronized (object) {
                        tObject.notifyAll();
                        tObject.wait(200L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++tIteration <= 150) continue;
                System.out.println("MEM: delete timeout ");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadMemoryList() {
        MappedByteBuffer tMappedByteBuffer = null;
        InterProcessMemory tInterProcessMemory = null;
        if (memoryList != null) {
            HyperLinkedList hyperLinkedList = memoryList;
            synchronized (hyperLinkedList) {
                HyperLinkedList tList = memoryList;
                tInterProcessMemory = (InterProcessMemory)tList.listBase;
                while (tInterProcessMemory != null) {
                    tMappedByteBuffer = tInterProcessMemory.mappedByteBuffer;
                    tMappedByteBuffer.load();
                    tInterProcessMemory = (InterProcessMemory)tList.next;
                }
                memoryList.notifyAll();
            }
        }
    }

    public void load() {
        this.mappedByteBuffer.load();
    }

    public void isLoaded() {
        this.mappedByteBuffer.isLoaded();
    }

    static int notifyListeners() {
        return 1;
    }

    @Override
    public void erase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InterProcessMemory open(InterProcessMemory tInterProcessMemory) throws IllegalAccessException {
        boolean tExists = false;
        HyperLinkedList tMemoryList = memoryList;
        String tName = tInterProcessMemory.fileName;
        if (tMemoryList == null) {
            tMemoryList = memoryList = new HyperLinkedList();
            tMemoryList.listName = "memoryList";
        }
        if (tInterProcessMemory.exists()) {
            System.out.println("*** IPM: found file. Not initializing ->" + tInterProcessMemory.memName);
            tExists = true;
        }
        HyperLinkedList hyperLinkedList = tMemoryList;
        synchronized (hyperLinkedList) {
            InterProcessMemory tMemory = (InterProcessMemory)tMemoryList.listBase;
            while (tMemory != null) {
                if (tMemory.memName.equals(tName)) {
                    throw new IllegalAccessException("MEM: " + tInterProcessMemory.memName + " open(InterProcessMemory) already open.");
                }
                tMemory = (InterProcessMemory)tMemory.next;
            }
            try {
                tInterProcessMemory.fileName = tName + ".ipc";
                tInterProcessMemory.file = new RandomAccessFile(tInterProcessMemory.fileName, "rws");
                tInterProcessMemory.fileChannel = tInterProcessMemory.file.getChannel();
                tInterProcessMemory.mappedByteBuffer = tInterProcessMemory.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, tInterProcessMemory.memSize);
            }
            catch (Exception any) {
                tInterProcessMemory.file = null;
                tInterProcessMemory.fileChannel = null;
                tInterProcessMemory.mappedByteBuffer = null;
                any.printStackTrace();
                return null;
            }
            tMemoryList.dlStore(tInterProcessMemory);
            tMemoryList.notifyAll();
            if (!tExists && tInterProcessMemory.memoryInitializer != null) {
                tInterProcessMemory.memoryInitializer.erase();
            }
        }
        if (!tInterProcessMemory.mappedByteBuffer.isLoaded()) {
            tInterProcessMemory.mappedByteBuffer.load();
        }
        return tInterProcessMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InterProcessMemory open(String tName) {
        HyperLinkedList tList = memoryList;
        InterProcessMemory tMemory = null;
        if (tList == null) {
            tList = memoryList = new HyperLinkedList();
            tList.listName = "memoryList";
        }
        HyperLinkedList hyperLinkedList = tList;
        synchronized (hyperLinkedList) {
            if (tList != null) {
                tMemory = (InterProcessMemory)tList.listBase;
                while (tMemory != null) {
                    if (tMemory.memName.equals(tName)) {
                        tList.notifyAll();
                        return tMemory;
                    }
                    tMemory = (InterProcessMemory)tMemory.next;
                }
            }
            tMemory = new InterProcessMemory();
            try {
                tMemory.fileName = tName + ".ipc";
                tMemory.file = new RandomAccessFile(tMemory.fileName, "rw");
                tMemory.fileChannel = tMemory.file.getChannel();
                tMemory.mappedByteBuffer = tMemory.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 512L);
            }
            catch (Exception any) {
                tMemory.file = null;
                tMemory.fileChannel = null;
                tMemory.mappedByteBuffer = null;
                any.printStackTrace();
                return null;
            }
            tList.dlStore(tMemory);
            memoryList.notifyAll();
        }
        if (!tMemory.mappedByteBuffer.isLoaded()) {
            System.out.println("IPM: loading");
            tMemory.mappedByteBuffer.load();
        }
        return tMemory;
    }

    static InterProcessMemory open(String tName, int tSize) {
        return InterProcessMemory.open(tName, tSize, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InterProcessMemory open(String tName, int tSize, MemoryInitializer tMemoryInitializer) {
        boolean tExists = false;
        File tFile = null;
        HyperLinkedList tList = memoryList;
        InterProcessMemory tMemory = null;
        if (tList == null) {
            tList = memoryList = new HyperLinkedList();
            tList.listName = "memoryList";
        }
        HyperLinkedList hyperLinkedList = tList;
        synchronized (hyperLinkedList) {
            if (tList != null) {
                tMemory = (InterProcessMemory)tList.listBase;
                while (tMemory != null) {
                    if (tMemory.memName.equals(tName)) {
                        tList.notifyAll();
                        return tMemory;
                    }
                    tMemory = (InterProcessMemory)tMemory.next;
                }
            }
            tMemory = new InterProcessMemory();
            tMemory.memoryInitializer = tMemoryInitializer;
            try {
                tFile = new File(tName + ".ipc");
                tExists = tFile.exists();
                if (!tExists) {
                    // empty if block
                }
                tMemory.fileName = tName + ".ipc";
                tMemory.file = new RandomAccessFile(tMemory.fileName, "rw");
                tMemory.fileChannel = tMemory.file.getChannel();
                tMemory.mappedByteBuffer = tMemory.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, tSize);
            }
            catch (Exception any) {
                tMemory.file = null;
                tMemory.fileChannel = null;
                tMemory.mappedByteBuffer = null;
                any.printStackTrace();
                return null;
            }
            tList.dlStore(tMemory);
            memoryList.notifyAll();
        }
        if (!tMemory.mappedByteBuffer.isLoaded()) {
            System.out.println("IPM: loading");
            tMemory.mappedByteBuffer.load();
        }
        return tMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int close(String tName) {
        HyperLinkedList tList = memoryList;
        InterProcessMemory tMemory = null;
        if (tList == null) {
            return -2;
        }
        HyperLinkedList hyperLinkedList = tList;
        synchronized (hyperLinkedList) {
            tMemory = (InterProcessMemory)tList.listBase;
            while (tMemory != null) {
                if (tMemory.memName.equals(tName)) {
                    tList.dlDelete(tMemory);
                    try {
                        tMemory.fileChannel.close();
                    }
                    catch (IOException ioex) {
                        tList.notifyAll();
                        return -3;
                    }
                    tList.notifyAll();
                    return 0;
                }
                tMemory = (InterProcessMemory)tMemory.next;
            }
            tList.notifyAll();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int close() {
        HyperLinkedList tList = memoryList;
        Object tMemory = null;
        if (tList == null) {
            return -2;
        }
        HyperLinkedList hyperLinkedList = tList;
        synchronized (hyperLinkedList) {
            if (this.next == null && this.prev == null) {
                tList.notifyAll();
                return -1;
            }
            tList.dlDelete(this);
            try {
                tMemory.fileChannel.close();
            }
            catch (IOException ioex) {
                tList.notifyAll();
                return -3;
            }
            tList.notifyAll();
        }
        return 0;
    }

    public int write(byte tByte) throws IllegalMemoryAccessException {
        FileLock tLock = this.lock();
        if (tLock == null) {
            return 0;
        }
        int tEnd = fp0 + 1;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        this.mappedByteBuffer.put(tByte);
        ++fp0;
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return 1;
    }

    public int write(byte[] tByte) throws IllegalMemoryAccessException {
        FileLock tLock = this.lock();
        if (tLock == null) {
            return 0;
        }
        int tEnd = fp0 + tByte.length;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        fp0 += tByte.length;
        this.mappedByteBuffer.put(tByte);
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return tByte.length;
    }

    public int write(byte[] tByte, int tOffset, int tLength) throws IllegalMemoryAccessException {
        int tEnd = fp0 + tByte.length + tLength;
        FileLock tLock = this.lock();
        if (tLock == null) {
            return 0;
        }
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        fp0 = tEnd;
        this.mappedByteBuffer.position(tOffset);
        this.mappedByteBuffer.put(tByte, tOffset, tLength);
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return tByte.length;
    }

    public int write(String tString) throws IllegalMemoryAccessException {
        int tLength = tString.length();
        FileLock tLock = this.lock();
        if (tLock == null) {
            return 0;
        }
        int tEnd = fp0 + tLength;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        int tOffset = fp0;
        fp0 = tEnd;
        this.mappedByteBuffer.position(tOffset);
        this.mappedByteBuffer.put(tString.getBytes());
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return tString.length();
    }

    public int write(String tString, int tOffset, int tLength) throws IllegalMemoryAccessException {
        FileLock tLock = this.lock();
        if (tLock == null) {
            return 0;
        }
        int tEnd = fp0 + tString.length();
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        fp0 = tEnd;
        this.mappedByteBuffer.position(tOffset);
        this.mappedByteBuffer.put(tString.getBytes(), tOffset, tLength);
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return tString.length();
    }

    public byte read() throws IllegalMemoryAccessException {
        byte[] tByte = new byte[1];
        boolean tLen = true;
        int tEnd = fp0 + 1;
        FileLock tLock = this.lock();
        if (tLock == null) {
            return 0;
        }
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        this.mappedByteBuffer.position(fp0);
        this.mappedByteBuffer.get(tByte, fp0++, 1);
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            throw new IllegalMemoryAccessException("MEM: read() can't get lock.");
        }
        return tByte[0];
    }

    int writeRegion(byte[] tByte, int tOffset, int tLength) throws IllegalMemoryAccessException {
        int tEnd = fp0 + tByte.length + tLength;
        FileLock tLock = this.lock();
        if (tLock == null) {
            return 0;
        }
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        fp0 = tEnd;
        this.mappedByteBuffer.position(tOffset);
        this.mappedByteBuffer.put(tByte, tOffset, tLength);
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return tByte.length;
    }

    public int read(int[] tInt, int tOffset) throws IllegalMemoryAccessException {
        FileLock tLock;
        int tLength = tInt.length;
        int tAddr = tOffset;
        try {
            tLock = this.fileChannel.lock(tOffset, tLength, true);
            if (tLock == null) {
                return 0;
            }
        }
        catch (Exception any) {
            if ((this.memFlags & Integer.MIN_VALUE) != 0) {
                return -1;
            }
            throw new IllegalMemoryAccessException("MEM: read(tInt[],int) can't get lock");
        }
        int tEnd = tOffset + (tLength << 2);
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException("MEM: overflow " + tEnd);
        }
        this.mappedByteBuffer.position(tAddr);
        for (int tZ = 0; tZ < tLength; ++tZ) {
            this.mappedByteBuffer.getInt(tAddr);
            tAddr += 4;
        }
        fp0 = tAddr;
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            if ((this.memFlags & Integer.MIN_VALUE) != 0) {
                return -1;
            }
            ioex.printStackTrace();
        }
        return tLength;
    }

    public int read(byte[] tByte, int tOffset, int tLength) throws IllegalMemoryAccessException {
        int tLen = tByte.length;
        FileLock tLock = this.lock();
        if (tLock == null) {
            return 0;
        }
        int tEnd = fp0 + tLen;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        fp0 = tEnd;
        this.mappedByteBuffer.position(tOffset);
        this.mappedByteBuffer.get(tByte, tOffset, tLength);
        try {
            tLock.release();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return tLen;
    }

    public int writeDirect(byte tByte) throws IllegalMemoryAccessException {
        int tEnd = fp0 + 1;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        this.mappedByteBuffer.put(tByte);
        ++fp0;
        return 1;
    }

    public int writeDirect(byte[] tByte) throws IllegalMemoryAccessException {
        int tEnd = fp0 + tByte.length;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        fp0 += tByte.length;
        this.mappedByteBuffer.put(tByte);
        return tByte.length;
    }

    public int writeDirect(byte[] tByte, int tOffset, int tLength) throws IllegalMemoryAccessException {
        int tEnd = fp0 + tByte.length + tLength;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        fp0 = tEnd;
        this.mappedByteBuffer.position(tOffset);
        this.mappedByteBuffer.put(tByte, tOffset, tLength);
        return tByte.length;
    }

    public int writeDirect(String tString) throws IllegalMemoryAccessException {
        int tLength = tString.length();
        int tEnd = fp0 + tLength;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        int tOffset = fp0;
        fp0 = tEnd;
        this.mappedByteBuffer.position(tOffset);
        this.mappedByteBuffer.put(tString.getBytes());
        return tString.length();
    }

    public int writeDirect(String tString, int tOffset, int tLength) throws IllegalMemoryAccessException {
        int tEnd = fp0 + tString.length();
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        fp0 = tEnd;
        this.mappedByteBuffer.position(tOffset);
        this.mappedByteBuffer.put(tString.getBytes(), tOffset, tLength);
        return tString.length();
    }

    public int writeIntDirect(int tInt) throws IllegalMemoryAccessException {
        if ((this.memFlags & 0x4000) != 0 && fp0 % 4 != 0) {
            throw new IllegalMemoryAccessException(" 32 bit alignment error " + fp0);
        }
        int tEnd = fp0 + 4;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        this.mappedByteBuffer.putInt(fp0, tInt);
        fp0 = tEnd;
        return 1;
    }

    public int writeIntDirect(int tOffset, int tInt) throws IllegalMemoryAccessException {
        if ((this.memFlags & 0x4000) != 0 && tOffset % 4 != 0) {
            throw new IllegalMemoryAccessException(" 32 bit alignment error " + tOffset);
        }
        int tEnd = fp0 + 4;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        fp0 = tEnd;
        this.mappedByteBuffer.putInt(tOffset, tInt);
        return 1;
    }

    public byte readDirect() throws IllegalMemoryAccessException {
        byte[] tByte = new byte[1];
        boolean tLen = true;
        int tEnd = fp0 + 1;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        this.mappedByteBuffer.position(fp0);
        this.mappedByteBuffer.get(tByte, fp0++, 1);
        return tByte[0];
    }

    public int readIntDirect(int tOffset) throws IllegalMemoryAccessException {
        boolean tLen = true;
        if ((this.memFlags & 0x4000) != 0 && tOffset % 4 != 0) {
            throw new IllegalMemoryAccessException(" 32 bit alignment error " + tOffset);
        }
        int tEnd = tOffset + 4;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        int tInt = this.mappedByteBuffer.getInt(tOffset);
        fp0 = tEnd;
        return tInt;
    }

    int writeRegionDirect(byte[] tByte, int tOffset, int tLength) throws IllegalMemoryAccessException {
        int tEnd = fp0 + tByte.length + tLength;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        fp0 = tEnd;
        this.mappedByteBuffer.position(tOffset);
        this.mappedByteBuffer.put(tByte, tOffset, tLength);
        return tByte.length;
    }

    public int readDirect(int[] tInt, int tOffset) throws IllegalMemoryAccessException {
        int tLength = tInt.length;
        int tAddr = tOffset;
        int tEnd = tOffset + (tLength << 2);
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        this.mappedByteBuffer.position(tAddr);
        for (int tZ = 0; tZ < tLength; ++tZ) {
            this.mappedByteBuffer.getInt(tAddr);
            tAddr += 4;
        }
        fp0 = tAddr;
        return tLength;
    }

    public int readDirect(byte[] tByte, int tOffset, int tLength) throws IllegalMemoryAccessException {
        int tLen = tByte.length;
        int tEnd = fp0 + tLen;
        if (tEnd >= this.memSize) {
            throw new IllegalMemoryAccessException(" out of bounds ->" + tEnd);
        }
        fp0 = tEnd;
        this.mappedByteBuffer.position(tOffset);
        this.mappedByteBuffer.get(tByte, tOffset, tLength);
        return tLen;
    }

    public void setFieldList(HyperLinkedList tList) {
        if (this.fieldList == null) {
            this.fieldList = tList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remakeFieldList(HyperLinkedList tList) {
        if (this.fieldList == null) {
            this.fieldList = tList;
        } else {
            InterProcessMemory interProcessMemory = this;
            synchronized (interProcessMemory) {
                this.fieldList.drain();
                this.fieldList.dlStore(tList);
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendFieldList(HyperLinkedList tList) {
        InterProcessMemory interProcessMemory = this;
        synchronized (interProcessMemory) {
            this.fieldList.dlStore(tList);
            this.notifyAll();
        }
    }

    public String toString() {
        StringBuilder tStringBuilder = new StringBuilder(1024);
        int n = 0;
        int tLimit = this.mappedByteBuffer.limit();
        for (int i = 0; i < tLimit; ++i) {
            char tChar = (char)this.mappedByteBuffer.get(i);
            if (tChar == '\u0000') {
                tStringBuilder.append('0');
            } else {
                tStringBuilder.append(tChar);
            }
            if (n++ <= 39) continue;
            n = 0;
            tStringBuilder.append("\r\n");
        }
        return tStringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SharedMemoryListener tSharedMemoryListener) {
        HyperLinkedList hyperLinkedList = memoryList;
        synchronized (hyperLinkedList) {
            memoryList.dlStore((Linkable)((Object)tSharedMemoryListener));
            memoryList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SharedMemoryListener tSharedMemoryListener) {
        HyperLinkedList hyperLinkedList = memoryList;
        synchronized (hyperLinkedList) {
            memoryList.dlDelete((Linkable)((Object)tSharedMemoryListener));
            memoryList.notifyAll();
        }
    }

    public void enableBackupTimer(int tMillies) {
    }

    public void disableBackupTimer(int tMillies) {
    }

    void setUpdateMillis(long tUpdateMillis) {
    }

    public void setResident() {
        this.memFlags |= 2;
    }

    public boolean isResident() {
        return (this.memFlags & 2) != 0;
    }

    public void unsetResident() {
        this.memFlags &= 0xFFFFFFFD;
    }

    public boolean exists() {
        File tFile = new File(this.memName);
        return tFile.exists();
    }

    public static void main(String[] argv) throws Exception {
        boolean tRunTime = false;
        boolean dontPrint = false;
        String putString = "put";
        String getString = "get";
        int tLen = argv.length;
        InterProcessMemory tInterProcessMemory = null;
        Object waitObject = new Object();
        String tProcessString = "PROCESS: " + ProcessID.getProcessString() + ' ';
        tInterProcessMemory = InterProcessMemory.open("TestIOMemory");
        tInterProcessMemory.setResident();
        int tRead = tInterProcessMemory.readInt(0);
        System.out.println(" IPM:  Initial read tInterProcessMemory.readInt(1); = " + tRead);
        tInterProcessMemory.writeInt(0, tRead);
        Object object = waitObject;
        synchronized (object) {
            while (true) {
                System.out.println(tProcessString);
                tRead = tInterProcessMemory.readInt(0);
                System.out.println("MEM:1 read(0)  " + tRead++);
                System.out.println("MEM:2 write(0) " + tRead);
                tInterProcessMemory.writeInt(0, tRead);
                System.out.println("MEM:3 read(0) " + tInterProcessMemory.readInt(0) + "\r\n");
                try {
                    waitObject.notifyAll();
                    waitObject.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    static {
        indeces = 0;
    }

    class MemorySaveTimer
    implements Runnable {
        Thread memorySaveThread;

        MemorySaveTimer() {
            InterProcessMemory.this.updateMillis = 1000L;
        }

        public void start() {
            if (this.memorySaveThread != null) {
                this.stop();
            }
            this.memorySaveThread = new Thread(this);
            this.memorySaveThread.start();
        }

        public void stop() {
            Thread tThread = this.memorySaveThread;
            this.memorySaveThread = null;
            if (tThread != null) {
                tThread.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread controlThread = Thread.currentThread();
            InterProcessMemory interProcessMemory = InterProcessMemory.this.innerParent;
            synchronized (interProcessMemory) {
                while (controlThread == this.memorySaveThread) {
                    InterProcessMemory.this.innerParent.notifyAll();
                    try {
                        System.out.println("*** IPM: device thread waiting " + InterProcessMemory.this.updateMillis);
                        InterProcessMemory.this.innerParent.wait(InterProcessMemory.this.updateMillis);
                        System.out.println("MST: MemorySaveTimer.saveToDevice()");
                        InterProcessMemory.this.saveToDevice();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

