/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;

public class Image2RGB
extends Dispatch {
    int flags = 4096;
    HyperStringPop loadPop = null;
    HyperStringPop savePop = null;
    Image inImage = null;
    Image processedImage = null;
    Image oldBack = null;
    Graphics inGraphics = null;
    Graphics processedGraphics = null;
    int[] pixelData = null;
    int blockSize = 0;
    int tWidth = 0;
    int tHeight = 0;
    int count = 0;
    int waitMillis = 21;
    int maxWait = 10;
    int timeout = 0;

    Image2RGB(HyperView tView) {
        this.curView = tView;
    }

    @Override
    public boolean run() {
        this.oldBack = this.curView.backImage;
        this.curView.setTitle(" Image2RGB() ");
        Gadget loadGad = new Gadget(this, " Load ", 1, 16);
        loadGad.addDispatch(new LoadImage());
        loadGad.gobFlags |= 0x200;
        Gadget convertGad = new Gadget(this, " Convert ", 97, 16);
        convertGad.addDispatch(new ConvertImage());
        convertGad.gobFlags |= 0x200;
        Gadget saveGad = new Gadget(this, " Save ", 49, 16);
        saveGad.addDispatch(new SaveImage());
        saveGad.gobFlags |= 0x200;
        Gadget stretchGad = new Gadget(this, " Stretch ", 166, 16);
        stretchGad.gobFlags |= 0x200;
        stretchGad.addDispatch(new Image2RGBSetStretch());
        Gadget verbatimGad = new Gadget(this, " Verbatim ", 235, 16);
        verbatimGad.gobFlags |= 0x200;
        verbatimGad.addDispatch(new Image2RGBSetVerbatim());
        this.curView.addAbort(586, 16);
        this.curView.curFont = 3;
        DBText txt = new DBText(this.curView, "URL: Timeout seconds", 350, 30);
        Image2RGBGetTimeout timeoutGetString = new Image2RGBGetTimeout(this.curView, 489, 16);
        return this.function();
    }

    public boolean function() {
        this.curView.runView();
        this.curView.backImage = this.oldBack;
        if (this.curView.backImage != null) {
            this.curView.flags |= 0x8800;
        }
        return true;
    }

    class ConvertImage
    extends Dispatch {
        ConvertImage() {
        }

        @Override
        public boolean begin(HyperView tView) {
            if (this.curView == null) {
                this.curView = HyperView.getCurView();
            }
            if (Image2RGB.this.tWidth < 1 || Image2RGB.this.tHeight < 1) {
                return true;
            }
            Image bltImage = this.curView.createImage(Image2RGB.this.tWidth, Image2RGB.this.tHeight);
            Graphics bltGraphics = bltImage.getGraphics();
            while (!bltGraphics.drawImage(Image2RGB.this.processedImage, 0, 0, this.curView)) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (Image2RGB.this.pixelData != null) {
                Image2RGB.this.pixelData = null;
            }
            Image2RGB.this.pixelData = null;
            Image2RGB.this.blockSize = Image2RGB.this.tWidth * Image2RGB.this.tHeight;
            Image2RGB.this.pixelData = new int[Image2RGB.this.blockSize];
            PixelGrabber pg = new PixelGrabber(bltImage, 0, 0, Image2RGB.this.tWidth, Image2RGB.this.tHeight, Image2RGB.this.pixelData, 0, Image2RGB.this.tWidth);
            pg.startGrabbing();
            boolean working = true;
            int status = 0;
            while (working) {
                status = pg.getStatus();
                if ((status & 0x10) == 0) {
                    try {
                        this.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                working = false;
            }
            bltImage.flush();
            bltGraphics.dispose();
            new HyperPop(" Image converted ");
            return true;
        }
    }

    class LoadImage
    extends Dispatch {
        LoadImage() {
        }

        @Override
        public boolean begin(HyperView tView) {
            boolean tX = false;
            boolean tY = false;
            this.curView = tView;
            Image2RGB.this.loadPop = new HyperStringPop(tView, " Name in URL syntax ie - file:///C:/ ", 60);
            String tmpStr = Image2RGB.this.loadPop.getString[0].textStr;
            if (tmpStr != null && tmpStr.length() > 0) {
                try {
                    if (Image2RGB.this.inImage != null) {
                        Image2RGB.this.inImage.flush();
                        Image2RGB.this.inImage = null;
                        if (Image2RGB.this.inGraphics != null) {
                            Image2RGB.this.inGraphics.dispose();
                            Image2RGB.this.inGraphics = null;
                        }
                        this.curView.curRun.gc();
                    }
                    if (Image2RGB.this.processedImage != null) {
                        Image2RGB.this.processedImage.flush();
                        Image2RGB.this.processedImage = null;
                        if (Image2RGB.this.processedGraphics != null) {
                            Image2RGB.this.processedGraphics.dispose();
                            Image2RGB.this.processedGraphics = null;
                        }
                    }
                    try {
                        Image2RGB.this.processedImage = this.curView.getAppletContext().getImage(new URL(this.curView.getCodeBase(), tmpStr));
                    }
                    catch (MalformedURLException muex) {
                        new HyperPop(this.curView, " Malformed URL ");
                        return true;
                    }
                    Image imageBuffer = this.curView.createImage(20, 20);
                    Graphics tmpGraphics = imageBuffer.getGraphics();
                    Image2RGB.this.count = 0;
                    Image2RGB.this.timeout = Image2RGB.this.maxWait * 1000 / Image2RGB.this.waitMillis;
                    while (!tmpGraphics.drawImage(Image2RGB.this.processedImage, 0, 0, 10, 10, this.curView)) {
                        this.curView.runView(Image2RGB.this.waitMillis);
                        Image2RGB.this.count += Image2RGB.this.waitMillis;
                        if (Image2RGB.this.count <= Image2RGB.this.timeout) continue;
                    }
                    Image2RGB.this.loadPop.gobFlags &= 0xFFFFFDFF;
                    Image2RGB.this.loadPop.gobFlags2 |= 2;
                    Image2RGB.this.tWidth = Image2RGB.this.processedImage.getWidth(this.curView);
                    Image2RGB.this.tHeight = Image2RGB.this.processedImage.getHeight(this.curView);
                    if (Image2RGB.this.tWidth > 0 && Image2RGB.this.tHeight > 0) {
                        Image2RGB.this.oldBack = this.curView.backImage;
                        if (Image2RGB.this.processedImage != null) {
                            this.curView.backImage = Image2RGB.this.processedImage;
                        }
                        this.curView.flags |= 0x8800;
                    } else if (Image2RGB.this.count > Image2RGB.this.timeout) {
                        new HyperPop(this.curView, "Timeout loading " + tmpStr + " ");
                    } else {
                        new HyperPop(this.curView, " Unable to load " + tmpStr + " ");
                    }
                }
                catch (Exception any) {
                    this.curView.guru("Image2RGB() " + any.toString());
                    any.printStackTrace(new PrintStream(HyperView.fp));
                }
            }
            return true;
        }
    }

    class Image2RGBSetVerbatim
    extends Dispatch {
        Image2RGBSetVerbatim() {
        }

        @Override
        public boolean begin(HyperView tView) {
            tView.flags2 &= 0xFFFFFFFD;
            tView.flags |= 0x8000;
            return true;
        }
    }

    class Image2RGBSetStretch
    extends Dispatch {
        Image2RGBSetStretch() {
        }

        @Override
        public boolean begin(HyperView tView) {
            tView.flags2 |= 2;
            tView.flags |= 0x8000;
            return true;
        }
    }

    class SaveImage
    extends Dispatch {
        SaveImage() {
        }

        @Override
        public boolean begin(HyperView tView) {
            if (Image2RGB.this.tWidth < 1 || Image2RGB.this.tHeight < 1) {
                return true;
            }
            Image2RGB.this.savePop = new HyperStringPop(tView, " Save As ", 40);
            String tmpStr = Image2RGB.this.savePop.getString[0].textStr;
            if (tmpStr != null) {
                if (tmpStr.length() > 0) {
                    try {
                        FileOutputStream fos = new FileOutputStream(tmpStr);
                        PrintStream ps = new PrintStream(fos);
                        ps.println("int[] imageData = {");
                        for (int i = 0; i < Image2RGB.this.blockSize; ++i) {
                            if (i % 6 == 0 & i != 0) {
                                ps.println("0x" + Integer.toHexString(Image2RGB.this.pixelData[i]) + ",");
                                continue;
                            }
                            ps.print("0x" + Integer.toHexString(Image2RGB.this.pixelData[i]) + ",");
                        }
                        ps.println("};");
                        ps.close();
                        fos.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    new HyperPop(" Saved ");
                }
            } else {
                new HyperPop(" Null filename abort. ");
            }
            return true;
        }
    }

    class Image2RGBGetTimeout
    extends GetString {
        Image2RGBGetTimeout() {
        }

        Image2RGBGetTimeout(HyperView tView, int tX, int tY) {
            super(tView, tX, tY, 5, 64);
        }

        public void function() {
            Image2RGB.this.maxWait = Integer.parseInt(this.textStr);
            if (Image2RGB.this.waitMillis < 1) {
                Image2RGB.this.waitMillis = 1;
            }
            Image2RGB.this.timeout = Image2RGB.this.maxWait * 1000 / Image2RGB.this.waitMillis;
        }
    }
}

