/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class HyperProcess
extends Process
implements ProcessListener {
    volatile HyperView parentView;
    volatile InputStream stdin;
    volatile OutputStream stdout;
    volatile InputStream stderr;
    public static volatile HyperLinkedList processList = new HyperLinkedList();
    volatile IOStreamHandler stderrHandler;
    volatile IOStreamHandler stdinHandler;
    volatile IOStreamExitHandler exitHandler;
    volatile Process parentProcess;
    volatile ProcessLink link;
    int id;
    static volatile int stringSpace = 80;
    static volatile int totalProcesses = 0;
    static volatile String[] processString = new String[stringSpace];
    static char fileSeparator = System.getProperty("file.separator").charAt(0);

    HyperProcess() {
        this.stdin = System.in;
        this.stdout = System.out;
        this.stderr = this.stdin;
        this.id = -1;
    }

    HyperProcess(String tExecString) {
        this(null, tExecString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HyperProcess(HyperView tView, String tExecString) {
        Process tParentProcess = null;
        try {
            System.out.println("EXEC: Runtime");
            this.parentProcess = tParentProcess = Runtime.getRuntime().exec(tExecString);
            System.out.println("EXEC: /Runtime");
        }
        catch (IOException ioex) {
            System.out.println(" Can't exec " + tExecString);
            return;
        }
        this.stdin = tParentProcess.getInputStream();
        this.stdout = tParentProcess.getOutputStream();
        this.stderr = tParentProcess.getErrorStream();
        System.out.println("EXEC: Getting Link");
        this.link = new ProcessLink(this);
        System.out.println("EXEC: synch processList");
        HyperLinkedList hyperLinkedList = processList;
        synchronized (hyperLinkedList) {
            processList.dlStore(this.link);
            processList.notifyAll();
        }
        this.stderrHandler = new IOStreamHandler(this.stderr, this.stdout);
        this.stdinHandler = new IOStreamHandler(this.stdin, this.stdout);
        this.exitHandler = new IOStreamExitHandler();
        this.stdinHandler.start();
        this.stderrHandler.start();
        this.exitHandler.start();
        this.stdinHandler.ioStreamTask.setName("HyperProcess.stdin");
        this.stderrHandler.ioStreamTask.setName("HyperProcess.stderr");
        System.out.println("stdinHandler  " + this.stdinHandler.toString());
        System.out.println("stderrHandler " + this.stderrHandler.toString());
    }

    public static HyperProcess exec(String tExecString) {
        return new HyperProcess(null, tExecString);
    }

    public void setStringSpace(int tInt) {
        stringSpace = tInt;
        processString = new String[stringSpace];
    }

    public static String[] ps() {
        int tInt = 0;
        String[] tString = processString;
        try {
            Process p = fileSeparator == '/' ? Runtime.getRuntime().exec("ps -e") : Runtime.getRuntime().exec(System.getenv("windir") + "\\system32\\tasklist.exe");
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            if (input == null) {
                System.out.println("PRC: ps() input null");
                System.exit(1);
            }
            while ((tString[tInt++] = input.readLine()) != null) {
            }
            input.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        tString[tInt] = null;
        return tString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        System.out.println("Process.destroy()" + this.toString());
        this.stdinHandler.destroy();
        this.stderrHandler.destroy();
        Object object = processList;
        synchronized (object) {
            processList.dlDelete(this.link);
            processList.notifyAll();
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
        System.out.println("/Process.destroy()" + this.toString());
    }

    @Override
    public int exitValue() {
        return 1;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdin;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitFor() {
        HyperProcess hyperProcess = this;
        synchronized (hyperProcess) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.notifyAll();
        }
        return 0;
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
    }

    public static void main(String[] args) {
        int tZ = 0;
        String tStringRef = null;
        String[] tString = HyperProcess.ps();
        int tLen = tString.length;
        if (tLen > 0) {
            while ((tStringRef = tString[tZ]) != null) {
                System.out.println(tString[tZ++]);
            }
        } else {
            System.out.println("no processes");
        }
    }

    class IOStreamExitHandler
    implements Runnable {
        Thread exitThread;

        IOStreamExitHandler() {
        }

        public void start() {
            this.exitThread = new Thread(this);
            this.exitThread.start();
        }

        public void stop() {
            Thread tThread = this.exitThread;
            this.exitThread = null;
            if (tThread != null) {
                tThread.interrupt();
            }
        }

        @Override
        public void run() {
            if (HyperProcess.this.parentProcess != null) {
                try {
                    System.out.println("EXEC: parentProcess.waitFor()");
                    HyperProcess.this.parentProcess.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            System.out.println("EXEC:destroy()");
            HyperProcess.this.destroy();
        }
    }

    class IOStreamHandler
    implements Runnable {
        volatile Thread ioStreamTask;
        volatile InputStream ios_stdin;
        volatile OutputStream ios_stdout;

        IOStreamHandler(InputStream tIn, OutputStream tOut) {
            this.ios_stdin = tIn;
            this.ios_stdout = tOut;
            this.ioStreamTask = new Thread(this);
        }

        public void start() {
            Thread tIOStreamTask = this.ioStreamTask;
            if (tIOStreamTask != null) {
                this.ioStreamTask = null;
                tIOStreamTask.interrupt();
            }
            this.ioStreamTask = new Thread(this);
            this.ioStreamTask.start();
        }

        public void stop() {
            Thread tIOStreamTask = this.ioStreamTask;
            this.ioStreamTask = null;
            if (tIOStreamTask != null) {
                tIOStreamTask.interrupt();
            }
        }

        @Override
        public void run() {
            InputStreamReader inputStreamReader = new InputStreamReader(this.ios_stdin);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            Thread controlThread = Thread.currentThread();
            String line = "";
            try {
                System.out.println("EXEC: Running IOStreamHandler");
                while (controlThread == this.ioStreamTask) {
                    while ((line = bufferedReader.readLine()) != null) {
                        System.out.println("read >> " + line);
                    }
                }
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
            System.out.println("Process IO Stream handler exited " + this.toString());
        }

        void destroy() {
            Thread tThread = this.ioStreamTask;
            this.ioStreamTask = null;
            tThread.interrupt();
        }
    }

    class ProcessLink
    extends Linkable {
        HyperProcess parentProcess;

        ProcessLink(HyperProcess tProcess) {
            this.parentProcess = tProcess;
        }
    }
}

