/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;

public class HyperNodeWriteVector
extends Linkable
implements HyperNodeVectorConstants {
    HyperChannel channel;
    int writeVectorFlags;
    int writeBufferSize;
    byte[] buffer;
    int number;
    int iteration;
    SocketChannel socketChannel;
    FileChannel fileChannel;
    HyperConnectionHandler parentConnectionHandler;
    HyperConnectionNode parentNode;
    ByteBuffer writeBuffer;
    int totalWrittenBytes;
    int writeSize;

    HyperNodeWriteVector(HyperChannel tChannel, HyperConnectionNode tNode) {
        this.channel = tChannel;
        this.parentNode = tNode;
        this.parentConnectionHandler = this.parentNode.parentConnectionHandler;
        this.number = this.parentNode.totalWriteVectors;
        this.name = "Node(" + this.parentNode.number + ").HyperNodeWriteVector(" + this.number + ") ";
        this.writeBufferSize = 512;
        this.writeBuffer = ByteBuffer.allocateDirect(this.writeBufferSize);
        this.writeVectorFlags = 0;
        this.buffer = new byte[this.writeBufferSize];
        this.number = -1;
        this.iteration = 0;
        this.totalWrittenBytes = 0;
        this.writeSize = 0;
    }

    HyperNodeWriteVector(SocketChannel tChannel, HyperConnectionNode tNode) {
        this.socketChannel = tChannel;
        this.parentNode = tNode;
        this.parentConnectionHandler = this.parentNode.parentConnectionHandler;
        this.number = this.parentNode.totalWriteVectors;
        this.name = "Node(" + this.parentNode.number + ").HyperNodeWriteVector(" + this.number + ") ";
        this.writeBufferSize = 512;
        this.writeBuffer = ByteBuffer.allocateDirect(this.writeBufferSize);
        this.writeVectorFlags = 0;
        this.buffer = new byte[this.writeBufferSize];
        this.number = -1;
        this.iteration = 0;
        this.totalWrittenBytes = 0;
        this.writeSize = 0;
    }

    HyperNodeWriteVector(SocketChannel tChannel, HyperConnectionNode tNode, ByteBuffer tBuffer) {
        this.socketChannel = tChannel;
        this.parentNode = tNode;
        this.parentConnectionHandler = this.parentNode.parentConnectionHandler;
        this.number = this.parentNode.totalWriteVectors;
        this.name = "Node(" + this.parentNode.number + ").HyperNodeWriteVector(" + this.number + ") ";
        this.writeBufferSize = 512;
        this.writeBuffer = tBuffer != null ? tBuffer : ByteBuffer.allocateDirect(this.writeBufferSize);
        this.writeBuffer.clear();
        this.socketChannel = tChannel;
        this.writeVectorFlags = 0;
        this.buffer = new byte[this.writeBufferSize];
        this.number = -1;
        this.iteration = 0;
        this.totalWrittenBytes = 0;
        this.writeSize = 0;
    }

    HyperNodeWriteVector(HyperChannel tChannel, HyperConnectionNode tNode, ByteBuffer tBuffer) {
        this.channel = tChannel;
        this.parentNode = tNode;
        this.parentConnectionHandler = this.parentNode.parentConnectionHandler;
        this.number = this.parentNode.totalWriteVectors;
        this.name = "Node(" + this.parentNode.number + ").HyperNodeWriteVector(" + this.number + ") ";
        this.writeBufferSize = 512;
        this.writeBuffer = tBuffer != null ? tBuffer : ByteBuffer.allocateDirect(this.writeBufferSize);
        this.writeBuffer.clear();
        this.writeVectorFlags = 0;
        this.buffer = new byte[this.writeBufferSize];
        this.number = -1;
        this.iteration = 0;
        this.totalWrittenBytes = 0;
        this.writeSize = 0;
    }

    public int function() {
        AbstractSelector tWriteSelector = null;
        SelectionKey tKey = null;
        int nBytes = 0;
        boolean rVal = false;
        boolean wVal = false;
        try {
            while (this.writeBuffer.hasRemaining()) {
                if (this.socketChannel != null) {
                    if ((nBytes += this.socketChannel.write(this.writeBuffer)) == 0) {
                        if (tWriteSelector == null) {
                            tWriteSelector = SelectorProvider.provider().openSelector();
                        }
                        tKey = this.socketChannel.register(tWriteSelector, 4);
                        tWriteSelector.select();
                    }
                } else {
                    System.out.println("HyperNodeWriteVector.function() SocketChannel = null");
                    StackTrace.show();
                    System.exit(1);
                }
                if (this.fileChannel == null) continue;
                this.writeBuffer.flip();
                if ((nBytes += this.socketChannel.write(this.writeBuffer)) != 0 || tWriteSelector.select(10L) != 0) continue;
                System.out.println("User disconnected");
            }
            this.writeBuffer.flip();
            ++this.iteration;
        }
        catch (IOException ioex) {
            try {
                this.socketChannel.close();
                this.socketChannel.socket().close();
            }
            catch (Exception any) {
                System.out.println("    WVEC: function close error catch 2");
            }
            this.parentNode.nodeFlags |= 0x10;
        }
        return nBytes;
    }

    public void cleanUp() {
        this.iteration = 0;
        this.socketChannel = null;
        this.parentNode = null;
        this.parentConnectionHandler = null;
        this.number = -1;
    }

    public void initialize(HyperChannel tChannel, HyperConnectionNode tNode) {
        this.channel = tChannel;
        this.parentNode = tNode;
        this.parentConnectionHandler = this.parentNode.parentConnectionHandler;
        this.writeBuffer.clear();
    }

    public void initialize(SocketChannel tChannel, HyperConnectionNode tNode) {
        this.socketChannel = tChannel;
        this.parentNode = tNode;
        this.parentConnectionHandler = this.parentNode.parentConnectionHandler;
        this.writeBuffer.clear();
        if (this.socketChannel == null) {
            System.out.println("HyperNodeWriteVector.initialize() NULL socket channel :(");
            Throwable t = new Throwable();
            t.printStackTrace();
            System.exit(1);
        }
    }
}

