/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class HyperNodeReadVector
extends Linkable
implements HyperNodeVectorConstants {
    HyperChannel channel = null;
    IOReply ioReply = null;
    StateMachine stateMachine = null;
    int readVectorFlags = 0;
    int type = 0;
    int readBufferSize = 512;
    int number = -1;
    int iteration = 0;
    int lastIteration = -1;
    SocketChannel socketChannel = null;
    HyperConnectionNode parentNode = null;
    ByteBuffer readBuffer = null;
    byte[] buffer = new byte[this.readBufferSize];
    int readBytes = 0;

    HyperNodeReadVector(SocketChannel tChannel, HyperConnectionNode tNode) {
        this(tChannel, tNode, (ByteBuffer)null);
    }

    HyperNodeReadVector(SocketChannel tChannel, HyperConnectionNode tNode, ByteBuffer tByteBuffer) {
        this.socketChannel = tChannel;
        this.parentNode = tNode;
        this.stateMachine = tNode.stateMachine;
        this.number = this.parentNode.totalReadVectors;
        this.readBuffer = tByteBuffer == null ? ByteBuffer.allocate(this.readBufferSize) : tByteBuffer;
        this.name = "Node(" + this.parentNode.number + ").HyperNodeReadVector(" + this.number + ") ";
        if (this.socketChannel == null) {
            System.out.println("ReadVector NULL socket channel :(");
        }
    }

    HyperNodeReadVector(HyperChannel tChannel, HyperConnectionNode tNode, ByteBuffer tByteBuffer) {
        this.channel = tChannel;
        this.parentNode = tNode;
        this.stateMachine = tNode.stateMachine;
        this.number = this.parentNode.totalReadVectors;
        this.readBuffer = tByteBuffer == null ? ByteBuffer.allocate(this.readBufferSize) : tByteBuffer;
        this.name = "Node(" + this.parentNode.number + ").HyperNodeReadVector(" + this.number + ") ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int function() {
        int inPos = 0;
        int nBytes = 0;
        byte inByte = 0;
        try {
            this.readBuffer.clear();
            System.out.println("HyperNodeReadVector.port " + this.socketChannel.socket().getLocalPort());
            nBytes = this.socketChannel.read(this.readBuffer);
            if (nBytes < 1) {
                return nBytes;
            }
            this.readBuffer.flip();
            if (nBytes > 1) {
                try {
                    if (this.stateMachine != null) {
                        inPos = 0;
                        while (inPos < nBytes) {
                            this.buffer[inPos++] = this.readBuffer.get();
                        }
                    }
                    System.out.println("NODE_RV: 2");
                    this.stateMachine.stateDispatch[this.stateMachine.currentState].processInput(this, nBytes);
                }
                catch (BufferUnderflowException buex) {
                    HyperNodeReadVector hyperNodeReadVector = this;
                    synchronized (hyperNodeReadVector) {
                        try {
                            this.wait(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            } else if (nBytes == 1) {
                if (this.stateMachine == null) {
                    System.out.println("0 state readBuffer.get()");
                    int n = inPos++;
                    byte by = this.readBuffer.get();
                    this.buffer[n] = by;
                    inByte = by;
                } else {
                    this.stateMachine.stateDispatch[this.stateMachine.currentState].processInput(this, 1);
                }
            }
            ++this.iteration;
        }
        catch (IOException ioex) {
            this.parentNode.nodeFlags |= 8;
            return -1;
        }
        return nBytes;
    }

    public void cleanUp() {
        this.iteration = 0;
        this.socketChannel = null;
        this.channel = null;
        this.ioReply = null;
        this.readBuffer = null;
        this.parentNode = null;
        this.number = -1;
        this.stateMachine = null;
    }

    public void initialize(SocketChannel tChannel, HyperConnectionNode tNode) {
        this.readVectorFlags = 512;
        this.socketChannel = tChannel;
        this.parentNode = tNode;
        this.lastIteration = -1;
        this.iteration = 0;
        this.number = this.parentNode.totalReadVectors;
        this.stateMachine = tNode.stateMachine;
        this.readBuffer.clear();
        if (this.socketChannel == null) {
            System.out.println("HyperNodeReadVector NULL socket channel :(");
        }
    }

    public void initialize(HyperChannel tChannel, HyperConnectionNode tNode) {
        this.readVectorFlags = 512;
        this.channel = tChannel;
        this.parentNode = tNode;
        this.stateMachine = tNode.stateMachine;
        this.lastIteration = -1;
        this.iteration = 0;
        this.number = this.parentNode.totalReadVectors;
        this.readBuffer.clear();
    }
}

