/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class HyperMouse
extends Component
implements Runnable,
HyperConstants,
MouseHandlerConstants,
ThreadReport {
    volatile int mouseX;
    volatile int mouseY;
    RunInfo runInfo;
    volatile Gadget leftGrabGadget;
    HyperView curView;
    HyperView setView;
    int iteration;
    int lastIteration;
    long startTime;
    int waitTime;
    long now;
    long runLag;
    long lastRun;
    long doubleClickTime;
    int trace;
    volatile int mouseFlags;
    HyperMenu menuBase;
    HyperKeyboard keyboard;
    Thread task;
    volatile int mainBufferIndex;
    volatile int intBufferIndex;
    int clickCount;
    volatile MouseEvent[] msg;
    int sizeIndex;
    int[][] coordinates;
    int totalCoordinates;
    int maxCoordinates;
    boolean working;
    FileOutputStream fp;

    HyperMouse(HyperView tView) {
        Object tDispatch = null;
        this.curView = tView;
        this.startTime = this.now = HyperView.now;
        this.menuBase = this.curView.menuBase;
        this.keyboard = HyperView.keyboard;
        this.runInfo = new RunInfo(this);
        this.iteration = 0;
        this.lastIteration = -1;
        this.startTime = 0L;
        this.waitTime = 90;
        this.now = HyperView.now;
        this.runLag = 0L;
        this.lastRun = 0L;
        this.doubleClickTime = 750L;
        this.trace = -1;
        this.mouseFlags = 0;
        this.mainBufferIndex = 0;
        this.intBufferIndex = 0;
        this.clickCount = 0;
        this.msg = new MouseEvent[255];
        this.sizeIndex = 0;
        this.coordinates = new int[2][2];
        this.totalCoordinates = 0;
        this.maxCoordinates = 2;
        this.working = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setView(HyperView tView) {
        HyperMouse hyperMouse = this;
        synchronized (hyperMouse) {
            this.curView = tView;
            this.startTime = HyperView.now;
            this.menuBase = this.curView.menuBase;
            this.keyboard = HyperView.keyboard;
            this.notifyAll();
        }
    }

    public void start() {
        this.runInfo.runState = 5;
        this.mouseFlags |= 1;
        this.task = new Thread(this);
        this.task.setName("HyperMouse()");
        this.task.setPriority(10);
        this.task.start();
    }

    public void stop() {
        this.runInfo.runState = 6;
        this.task = null;
    }

    @Override
    public synchronized void run() {
        Gadget oldKeyboardFocus = this.keyboard.focus;
        Thread controlThread = null;
        int msgFlags = 0;
        boolean exceptionCount = false;
        int maxNum = 0;
        int gx = 0;
        int gy = 0;
        int gx2 = 0;
        int gy2 = 0;
        Gadget tGad = null;
        Object tGad2 = null;
        int gadXOff = 0;
        int gadYOff = 0;
        int cnum = 0;
        boolean numAttached = false;
        long timeDiff = 0L;
        Gob tGob = null;
        int itemY = 0;
        int itemX = 0;
        int itemX2 = 0;
        int itemY2 = 0;
        int X = 0;
        int Y = 0;
        int mX = 0;
        int mX2 = 0;
        int mY = 0;
        int mY2 = 0;
        boolean itemSelected = false;
        boolean overGadget = false;
        boolean gadgetWasClicked = false;
        controlThread = Thread.currentThread();
        this.mouseFlags |= 1;
        while (controlThread == this.task) {
            try {
                this.runInfo.runState = 9;
                this.now = HyperView.now;
                if ((this.mouseFlags & 1) != 0) {
                    while (this.mainBufferIndex != this.intBufferIndex) {
                        MouseEvent tMsg = this.msg[this.mainBufferIndex];
                        this.mouseX = this.curView.mouseX = tMsg.getX();
                        this.mouseY = this.curView.mouseY = tMsg.getY();
                        if (this.sizeIndex != 0 && this.mouseX < this.curView.scaledX[this.sizeIndex] && this.mouseY < this.curView.scaledY[this.sizeIndex]) {
                            this.mouseX = (int)((double)this.mouseX * ((double)this.curView.width / (double)this.curView.scaledX[this.sizeIndex]));
                            this.mouseY = (int)((double)this.mouseY * ((double)this.curView.height / (double)this.curView.scaledY[this.sizeIndex]));
                        }
                        if ((this.mouseFlags & 0x200) != 0) {
                            System.out.println("MOUSE: X = " + this.mouseX + " Y = " + this.mouseY);
                        }
                        if (tMsg == null) continue;
                        msgFlags = tMsg.getID();
                        switch (msgFlags) {
                            case 503: {
                                this.clickCount = 0;
                                this.mouseFlags &= 0xFFFFFFF7;
                                if ((this.curView.flags & 0x2000) == 0) {
                                    overGadget = false;
                                    for (int my = this.curView.totalGads - 1; my > -1 && (this.mouseFlags & 8) == 0; --my) {
                                        tGad = this.curView.gads[my];
                                        if ((tGad.gadFlags & 0x1000) != 0) continue;
                                        if ((tGad.gobFlags & 8) == 0) {
                                            if (this.mouseX <= tGad.x || this.mouseX >= tGad.x2 || this.mouseY <= tGad.y || this.mouseY >= tGad.y2) continue;
                                            this.mouseFlags |= 8;
                                            if ((tGad.gadFlags & 0x100000) == 0) continue;
                                            tGad.onMouseOver();
                                            overGadget = true;
                                            continue;
                                        }
                                        if (this.mouseX <= tGad.x + tGad.destGob.x || this.mouseX >= tGad.x2 + tGad.destGob.x || this.mouseY <= tGad.y + tGad.destGob.y || this.mouseY >= tGad.y2 + tGad.destGob.y) continue;
                                        this.mouseFlags |= 8;
                                        if ((tGad.gadFlags & 0x100000) == 0) continue;
                                        tGad.onMouseOver();
                                        overGadget = true;
                                    }
                                }
                                this.mouseFlags &= 0xFFFFFFF7;
                                break;
                            }
                            case 506: {
                                if ((tMsg.getModifiers() & 4) == 4) {
                                    if ((this.mouseFlags & 0x10) != 0 && this.curView.grabbedGad != null) {
                                        this.clickCount = 0;
                                        tGad = this.curView.grabbedGad;
                                        if (tGad.moveNum < 25) {
                                            ++tGad.moveNum;
                                        }
                                        tGad.mX[tGad.moveNum] = mX;
                                        tGad.mY[tGad.moveNum] = mY;
                                        tGad.mX2[tGad.moveNum] = mX2;
                                        tGad.mY2[tGad.moveNum] = mY2;
                                        tGad.x = this.mouseX - gadXOff;
                                        tGad.x2 = tGad.x + tGad.width;
                                        tGad.y = this.mouseY - gadYOff;
                                        tGad.y2 = tGad.y + tGad.height;
                                        if (tGad.x < 0) {
                                            tGad.x = 0;
                                            tGad.x2 = tGad.width;
                                        }
                                        if (tGad.y < 0) {
                                            tGad.y = 0;
                                            tGad.y2 = tGad.height;
                                        }
                                        if ((tGad.gobFlags & 8) == 0) {
                                            if (tGad.x2 > this.curView.width) {
                                                tGad.x2 = this.curView.width;
                                                tGad.x = tGad.x2 - tGad.width;
                                            }
                                            if (tGad.y2 > this.curView.height) {
                                                tGad.y2 = this.curView.height;
                                                tGad.y = tGad.y2 - tGad.height;
                                            }
                                        } else {
                                            tGob = tGad.destGob;
                                            if (tGad.x2 > tGob.width) {
                                                tGad.x2 = tGob.width;
                                                tGad.x = tGad.x2 - tGad.width;
                                            }
                                            if (tGad.y2 > tGob.height) {
                                                tGad.y2 = tGob.height;
                                                tGad.y = tGad.y2 - tGad.height;
                                            }
                                        }
                                        mX = tGad.x;
                                        mX2 = tGad.x2;
                                        mY = tGad.y;
                                        mY2 = tGad.y2;
                                        break;
                                    }
                                    this.menuBase = this.curView.menuBase;
                                    if ((this.curView.flags & 0x80) == 0 || this.menuBase == null) break;
                                    itemY2 = 0;
                                    itemX2 = 0;
                                    itemX = 0;
                                    itemY = 0;
                                    X = this.mouseX;
                                    Y = this.mouseY;
                                    itemSelected = false;
                                    itemY = this.menuBase.menuPaneY + this.menuBase.y;
                                    itemX = this.menuBase.menuPaneX + this.menuBase.x;
                                    itemX2 = itemX + this.menuBase.menuPaneX2;
                                    itemY2 = itemY + this.menuBase.itemHeight * this.menuBase.totalItems;
                                    this.menuBase.curItem = -1;
                                    if (X <= itemX || X >= itemX2 || Y <= itemY || Y >= itemY2) break;
                                    this.menuBase.curItem = (this.mouseY - this.menuBase.y) / this.menuBase.itemHeight - 1;
                                    if (this.menuBase.curItem < 0) {
                                        this.menuBase.curItem = 0;
                                    } else if (this.menuBase.curItem >= this.menuBase.totalItems) {
                                        this.menuBase.curItem = this.menuBase.totalItems - 1;
                                    }
                                    itemSelected = true;
                                    break;
                                }
                                if ((this.mouseFlags & 0x20) == 0) break;
                                this.leftGrabGadget.clickY = this.mouseY - this.leftGrabGadget.y;
                                this.leftGrabGadget.clickX = this.mouseX - this.leftGrabGadget.x;
                                this.leftGrabGadget.gobFlags |= 0x10000;
                                break;
                            }
                            case 501: {
                                timeDiff = this.now - this.lastRun;
                                this.lastRun = this.now;
                                if (timeDiff < this.doubleClickTime) {
                                    ++this.clickCount;
                                } else if (timeDiff > this.doubleClickTime) {
                                    this.clickCount = 1;
                                }
                                if (this.clickCount > 1000000) break;
                                if ((tMsg.getModifiers() & 4) == 4) {
                                    this.mouseFlags |= 0x80;
                                    this.mouseFlags &= 0xFFFFFFF7;
                                    for (cnum = maxNum = this.curView.totalGads - 1; cnum > -1 && (this.mouseFlags & 8) == 0; --cnum) {
                                        tGad = this.curView.gads[cnum];
                                        if ((tGad.gadFlags & 0x1000) != 0) continue;
                                        if ((tGad.gobFlags & 8) == 0) {
                                            gx = tGad.x;
                                            gy = tGad.y;
                                            gx2 = tGad.x2;
                                            gy2 = tGad.y2;
                                        } else {
                                            tGob = null;
                                            tGob = tGad.destGob;
                                            gx = tGad.x + tGob.x;
                                            gy = tGad.y + tGob.y;
                                            gx2 = tGad.x2 + tGob.x;
                                            gy2 = tGad.y2 + tGob.y;
                                        }
                                        if (this.mouseX <= gx || this.mouseX >= gx2 || this.mouseY <= gy || this.mouseY >= gy2 || (tGad.gadFlags & 1) == 0 || (tGad.gobFlags & 0x200) == 0) continue;
                                        this.curView.grabbedGad = null;
                                        this.curView.grabbedGad = tGad;
                                        mX = gx;
                                        mX2 = gx2;
                                        mY = gy;
                                        mY2 = gy2;
                                        this.clickCount = 0;
                                        this.mouseFlags |= 0x18;
                                        if ((tGad.gobFlags & 0x80) == 0) {
                                            tGad.selectTime = this.now;
                                            tGad.gobFlags |= 0x400000;
                                        }
                                        gadXOff = this.mouseX - tGad.x;
                                        gadYOff = this.mouseY - tGad.y;
                                    }
                                    if ((this.mouseFlags & 8) != 0 || (this.curView.flags & 0x80) == 0 || (this.curView.flags & 0x2000) != 0 || this.clickCount >= 2 || this.sizeIndex != 0) break;
                                    this.curView.flags |= 0x2000;
                                    this.menuBase = this.curView.menuBase;
                                    if (this.menuBase == null) break;
                                    this.curView.flags |= 0x2000;
                                    this.menuBase.gobFlags |= 0x200;
                                    this.menuBase.curItem = (this.mouseY - this.menuBase.y) / this.menuBase.itemHeight - 1;
                                    if (this.menuBase.curItem < 0) {
                                        this.menuBase.curItem = 0;
                                    } else if (this.menuBase.curItem >= this.menuBase.totalItems) {
                                        this.menuBase.curItem = this.menuBase.totalItems - 1;
                                    }
                                    gadXOff = this.mouseX - (this.menuBase.width >> 1);
                                    if (gadXOff < 0) {
                                        gadXOff = 0;
                                    } else if (gadXOff + (this.menuBase.width >> 1) > this.curView.width) {
                                        gadXOff = this.curView.width - (this.menuBase.width >> 1);
                                    }
                                    gadYOff = this.mouseY - (this.menuBase.height >> 1);
                                    if (gadYOff < 0) {
                                        gadYOff = 0;
                                    } else if (gadYOff > this.curView.height - this.menuBase.height) {
                                        gadYOff = this.curView.height - this.menuBase.height;
                                    }
                                    this.menuBase.x = gadXOff;
                                    this.menuBase.y = gadYOff;
                                    this.curView.swapGad = null;
                                    this.curView.swapGad = this.menuBase;
                                    this.curView.flags |= 0x200;
                                    break;
                                }
                                this.mouseFlags |= 0x40;
                                this.curView.flags &= 0xFFBFFFFF;
                                if ((this.mouseFlags & 0x100) == 0) {
                                    if ((this.curView.flags & 0x2000) != 0 || (this.curView.flags & 0x20) == 0) break;
                                    this.mouseFlags &= 0xFFFFFFF7;
                                    if ((this.mouseFlags & 0x10) != 0 && this.curView.grabbedGad != null) {
                                        this.curView.grabbedGad.gobFlags &= 0xFFBFFFFF;
                                        this.curView.grabbedGad = null;
                                    }
                                    gadgetWasClicked = false;
                                    for (cnum = this.curView.totalGads - 1; cnum > -1 && (this.mouseFlags & 8) == 0; --cnum) {
                                        tGad = this.curView.gads[cnum];
                                        if ((tGad.gadFlags & 0x200000) == 0) {
                                            if ((tGad.gobFlags & 8) == 0) {
                                                gx = tGad.x;
                                                gy = tGad.y;
                                                gx2 = tGad.x2;
                                                gy2 = tGad.y2;
                                            } else {
                                                tGob = tGad.destGob;
                                                gx = tGad.x + tGob.x;
                                                gy = tGad.y + tGob.y;
                                                gx2 = tGad.x2 + tGob.x;
                                                gy2 = tGad.y2 + tGob.y;
                                            }
                                            if (this.mouseX > gx && this.mouseX < gx2 && this.mouseY > gy && this.mouseY < gy2) {
                                                gadgetWasClicked = true;
                                                if ((tGad.gadFlags & 1) != 0 && (tGad.gobFlags & 0x200) != 0) {
                                                    this.curView.clickedGad = tGad;
                                                    tGad.clickX = this.mouseX;
                                                    tGad.clickY = this.mouseY;
                                                    if ((tGad.gadFlags & 0x8000) != 0) {
                                                        this.keyboard.focus = tGad;
                                                        if (oldKeyboardFocus != null) {
                                                            if ((oldKeyboardFocus.gadFlags & 0x1000000) != 0) {
                                                                oldKeyboardFocus.drawOutline2();
                                                                if ((oldKeyboardFocus.gadFlags & 0x1000000) != 0) {
                                                                    tGad.drawOutline2();
                                                                }
                                                            }
                                                            oldKeyboardFocus = this.keyboard.focus;
                                                        } else {
                                                            oldKeyboardFocus = this.keyboard.focus;
                                                        }
                                                    } else if (oldKeyboardFocus != null) {
                                                        if ((oldKeyboardFocus.gadFlags & 0x100) != 0) {
                                                            oldKeyboardFocus.drawOutline2();
                                                        }
                                                        this.keyboard.focus = null;
                                                    }
                                                    if ((tGad.gobFlags & 0x80) == 0) {
                                                        tGad.gobFlags |= 0x400000;
                                                        tGad.selectTime = this.now;
                                                    }
                                                    if ((tGad.gobFlags & 0x8000) != 0) {
                                                        if ((this.curView.eventFlags & 0x20) != 0) {
                                                            // empty if block
                                                        }
                                                        tGad.clickX = this.mouseX - tGad.x;
                                                        tGad.clickY = this.mouseY - tGad.y;
                                                        tGad.gobFlags |= 0x10000;
                                                        this.mouseFlags |= 8;
                                                    } else {
                                                        if ((tGad.gadFlags & 0x800000) != 0) {
                                                            tGad.gobEventFlags |= 1;
                                                        }
                                                        this.mouseFlags |= 8;
                                                        if ((this.curView.eventFlags & 0x20) != 0) {
                                                            // empty if block
                                                        }
                                                    }
                                                }
                                                if ((tGad.gadFlags & 0x4000000) != 0) {
                                                    this.curView.swapGad = null;
                                                    this.curView.swapGad = tGad;
                                                    this.curView.flags |= 0x200;
                                                }
                                            }
                                        }
                                        if (!gadgetWasClicked) continue;
                                        if (this.keyboard.focus != null) {
                                            if (oldKeyboardFocus != null) {
                                                oldKeyboardFocus.drawOutline2();
                                            }
                                            this.keyboard.focus.gadFlags &= 0xFFF7FFFF;
                                            this.keyboard.focus.drawOutline();
                                            oldKeyboardFocus = this.keyboard.focus;
                                            this.keyboard.focus.gadFlags |= 0x80000;
                                            continue;
                                        }
                                        if (oldKeyboardFocus == null) continue;
                                        oldKeyboardFocus.drawOutline2();
                                        oldKeyboardFocus = this.keyboard.focus;
                                    }
                                    break;
                                }
                                if (this.totalCoordinates >= this.maxCoordinates) {
                                    this.mouseFlags &= 0xFFFFFEFF;
                                    break;
                                }
                                this.coordinates[this.totalCoordinates][0] = this.mouseX;
                                this.coordinates[this.totalCoordinates++][1] = this.mouseY;
                                break;
                            }
                            case 502: {
                                if ((tMsg.getModifiers() & 4) == 4) {
                                    this.mouseFlags &= 0xFFFFFF7F;
                                    if ((this.mouseFlags & 8) != 0) {
                                        tGad = null;
                                        tGad = this.curView.grabbedGad;
                                        if (tGad != null) {
                                            gx = tGad.x;
                                            gy = tGad.y;
                                            gx2 = tGad.x2;
                                            gy2 = tGad.y2;
                                            if (this.mouseX > gx && this.mouseX < gx2 && this.mouseY > gy && this.mouseY < gy2 && (tGad.gadFlags & 1) != 0) {
                                                if ((tGad.gadFlags & 0x10) == 0) {
                                                    tGad.gobFlags &= 0xFFBFFFFF;
                                                }
                                                gadYOff = 0;
                                                gadXOff = 0;
                                            }
                                            this.mouseFlags &= 0xFFFFFFE7;
                                            this.curView.grabbedGad = null;
                                        }
                                    } else {
                                        this.menuBase = this.curView.menuBase;
                                        if ((this.curView.flags & 0x80) != 0 && this.menuBase != null) {
                                            if (this.menuBase.curItem > -1) {
                                                try {
                                                    this.menuBase.gobFlags &= 0xFFFFFDFF;
                                                    this.curView.menuDispatch = this.menuBase.menuDispatch[this.menuBase.curItem];
                                                    this.curView.menuBase.gobFlags &= 0xFFFFFDFF;
                                                    this.curView.eventFlags |= 3;
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                            }
                                            this.menuBase.curItem = -1;
                                        }
                                    }
                                } else {
                                    this.mouseFlags &= 0xFFFFFFBF;
                                    this.mouseFlags &= 0xFFFFFFF7;
                                    maxNum = this.curView.totalGads - 1;
                                    if (this.curView.clickedGad != null) {
                                        tGad = this.curView.clickedGad;
                                        tGad.selectTime = this.now;
                                        this.mouseX = tGad.x;
                                        this.mouseY = tGad.y;
                                        gx = tGad.x;
                                        gy = tGad.y;
                                        gx2 = tGad.x2;
                                        gy2 = tGad.y2;
                                    }
                                    if ((tGad.gobFlags2 & 0x40) != 0) {
                                        tGad.gobFlags2 |= 0x80;
                                    }
                                }
                                this.menuBase = this.curView.menuBase;
                                if (this.menuBase != null) {
                                    this.curView.menuBase.gobFlags &= 0xFFFFFDFF;
                                }
                                this.curView.flags &= 0xFFFFDFFF;
                                if (this.leftGrabGadget == null) break;
                                this.mouseFlags &= 0xFFFFFFDF;
                                this.leftGrabGadget.lClickY = -1;
                                this.leftGrabGadget.lClickX = -1;
                                this.leftGrabGadget.gobFlags &= 0xFFFEFFFF;
                                break;
                            }
                            case 504: 
                            case 505: {
                                break;
                            }
                            default: {
                                this.curView.statusText("Unknown msg: " + msgFlags);
                            }
                        }
                        ++this.mainBufferIndex;
                        if (this.mainBufferIndex < 255) continue;
                        this.mainBufferIndex = 0;
                    }
                }
                try {
                    this.runInfo.runState = 1;
                    ++this.iteration;
                    this.notifyAll();
                    this.wait();
                    this.runInfo.runState = 9;
                    this.menuBase = this.curView.menuBase;
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Exception allMouse) {
                allMouse.printStackTrace();
                try {
                    this.runInfo.runState = 12;
                    this.wait(70L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.runInfo.runState = 8;
    }

    public synchronized void forbid() {
        this.mouseFlags &= 0xFFFFFFFE;
        this.curView.grabbedGad = null;
    }

    public synchronized void permit() {
        this.mouseFlags |= 1;
    }

    public synchronized void flush() {
        boolean n = false;
    }

    @Override
    public RunInfo getRunInfo() {
        this.runInfo.now = this.now;
        this.runInfo.runLag = this.runLag;
        this.runInfo.lastRun = this.lastRun;
        this.runInfo.startTime = this.startTime;
        this.runInfo.waitTime = this.waitTime;
        this.runInfo.iteration = this.iteration;
        return this.runInfo;
    }

    public synchronized void wake() {
        this.notify();
    }

    public String kickStart() {
        String str = "";
        str = str + "thread Task switch.";
        if (this.task == null) {
            str = str + " [null]";
            this.task = new Thread(this);
            this.task.start();
        } else {
            try {
                Thread tTask = this.task;
                this.task.interrupt();
                tTask = null;
            }
            catch (Exception allMouse) {
                System.out.println("Mouse dumpStack() exception" + this.task.toString());
            }
            try {
                this.task = new Thread(this);
                this.task.start();
            }
            catch (Exception rs) {
                rs.printStackTrace(new PrintStream(HyperView.fp));
            }
        }
        return str;
    }
}

