/*
 * Decompiled with CFR 0.152.
 */
public class HyperLinkedList
extends Linkable {
    Object lock = this;
    int items;
    int listFlags;
    int listNumber;
    static int totalLists;
    volatile Linkable listBase;
    volatile Linkable listTail;
    volatile String listName;
    SystemListNode systemListNode;
    static int seed;

    HyperLinkedList() {
        this.listName = "blank";
        this.listFlags = 16;
    }

    HyperLinkedList(String tString) {
        this.listFlags = 16;
        this.listName = tString;
        this.listNumber = seed++;
        if (this.listName == null) {
            this.name = this.listName = "HyperLinkedList(" + this.listNumber + ')';
        }
        SystemListRegistry tRegistry = SystemListRegistry.getRegistry();
        this.systemListNode = new SystemListNode(this);
        tRegistry.register(this.systemListNode);
        ++totalLists;
    }

    HyperLinkedList(SystemListRegistry tRegistry) {
        this.name = this.listName = "SystemLists";
        this.listNumber = seed++;
        this.systemListNode = new SystemListNode(this);
        tRegistry.register(this.systemListNode);
        ++totalLists;
    }

    static synchronized long getNumber() {
        return seed++;
    }

    synchronized void showLinks() {
        int count = 0;
        int tNumber = 0;
        Linkable tLinkable1 = this.listBase;
        Linkable tLinkable2 = null;
        System.out.println("List \"" + this.listName + ' ' + '\"' + " items = " + this.items + '\"');
        if (this.listBase == null) {
            return;
        }
        if (this.listBase != null) {
            System.out.println(" listBase = " + this.listBase.name);
        } else {
            System.out.println(" Tail = null");
        }
        if (this.listTail != null) {
            System.out.println(" Tail = " + this.listTail.name);
        } else {
            System.out.println(" Tail = null");
        }
        if (this.listBase == this.listTail || this.listBase.next == this.listBase) {
            System.out.println(" " + tLinkable1.name + " L# " + ++tNumber + " N# " + tLinkable1.index + " " + tNumber + " = Base * Tail " + this.listBase.name);
            if (tLinkable1.prev != null) {
                System.out.println(" " + tLinkable1.name + ".prev = " + tLinkable1.prev.name + " ");
            } else {
                System.out.println(" " + tLinkable1.name + ".prev = NULL ");
            }
            if (tLinkable1.next != null) {
                System.out.println(" " + tLinkable1.name + ".next = " + tLinkable1.next.name);
            } else {
                System.out.println(" " + tLinkable1.name + ".next = NULL");
            }
        } else {
            while (tLinkable1 != null && count < this.items) {
                System.out.println("  <LINK " + ++tNumber + ">");
                System.out.println(" Node " + tLinkable1.name + "  # " + tNumber);
                if (tLinkable1.prev != null) {
                    System.out.println(" " + tLinkable1.name + ".prev = " + tLinkable1.prev.name + " ");
                } else {
                    System.out.println(" " + tLinkable1.name + ".prev = NULL ");
                }
                if (tLinkable1.next != null) {
                    System.out.println(" " + tLinkable1.name + ".next = " + tLinkable1.next.name);
                } else {
                    System.out.println(" " + tLinkable1.name + ".next = NULL");
                }
                tLinkable2 = tLinkable1;
                tLinkable1 = null;
                tLinkable1 = tLinkable2.next;
                tLinkable2 = null;
                System.out.println("  </LINK " + tNumber + ">");
                ++count;
            }
        }
        System.out.println("\r\n");
        this.notifyAll();
    }

    synchronized void stdShowLinks() {
        int count = 0;
        int tNumber = 0;
        Linkable tLinkable1 = this.listBase;
        Linkable tLinkable2 = null;
        System.out.println("<HYPER_LINKED_LIST \"" + this.listName + '\"' + '>');
        if (this.listBase == null) {
            System.out.println("<NAME> " + this.listName + " empty</NAME>");
            return;
        }
        System.out.println(" <BASE>" + this.listBase.name + " </BASE>");
        if (this.listTail != null) {
            System.out.println(" <TAIL> " + this.listTail.name + " </TAIL>");
        } else {
            System.out.println(" <TAIL> NULL </TAIL>");
        }
        if (this.listBase == this.listTail || this.listBase.next == this.listBase) {
            System.out.println("   <LINK #" + ++tNumber + " == BASE & TAIL>");
            System.out.println("  -><- Node " + this.listBase.name + " -><-");
            if (tLinkable1.prev != null) {
                System.out.println("      " + tLinkable1.name + ".prev = " + tLinkable1.prev.name + " ");
            } else {
                System.out.println("      " + tLinkable1.name + ".prev = NULL ");
            }
            if (tLinkable1.next != null) {
                System.out.println("      " + tLinkable1.name + ".next = " + tLinkable1.next.name);
            } else {
                System.out.println("      " + tLinkable1.name + ".next = NULL");
            }
            System.out.println("   </LINK " + tNumber + ">");
        } else {
            while (tLinkable1 != null && count < this.items) {
                System.out.println("   <LINK " + ++tNumber + ">");
                System.out.println("  Node -><- " + tLinkable1.name + " -><-");
                if (tLinkable1.prev != null) {
                    System.out.println("      " + tLinkable1.name + ".prev = " + tLinkable1.prev.name + " ");
                } else {
                    System.out.println("      " + tLinkable1.name + ".prev = NULL ");
                }
                if (tLinkable1.next != null) {
                    System.out.println("      " + tLinkable1.name + ".next = " + tLinkable1.next.name);
                } else {
                    System.out.println("      " + tLinkable1.name + ".next = NULL");
                }
                tLinkable2 = tLinkable1;
                tLinkable1 = null;
                tLinkable1 = tLinkable2.next;
                tLinkable2 = null;
                System.out.println("   </LINK " + tNumber + ">");
                ++count;
            }
        }
        System.out.println("</HYPER_LINKED_LIST \"" + this.listName + '\"' + '>');
        this.notifyAll();
    }

    public void swap(Linkable removeLink, Linkable replaceLink) {
        Linkable prevLink = removeLink.prev;
        Linkable nextLink = removeLink.next;
        removeLink.next = removeLink.prev = (Linkable)null;
        if (prevLink != null) {
            prevLink.next = replaceLink;
            replaceLink.prev = this.prev;
        }
        if (nextLink != null) {
            nextLink.prev = replaceLink;
        }
        replaceLink.next = nextLink;
        if (this.listBase == removeLink) {
            this.listBase = replaceLink;
        }
        if (this.listTail == removeLink) {
            this.listTail = replaceLink;
        }
    }

    static void showLinks(Linkable tLinkable) {
        int tNumber = 0;
        Linkable tLinkable1 = tLinkable;
        Linkable tLinkable2 = null;
        boolean working = true;
        if (tLinkable1 == null) {
            System.out.println("ERROR null Linkable()");
            System.exit(0);
        }
        while (working) {
            ++tNumber;
            if (tLinkable.next == tLinkable) {
                working = false;
            }
            System.out.println(" " + tLinkable1.name + " L# " + tNumber + " N# " + tLinkable1.index);
            if (tLinkable1.prev != null) {
                System.out.println(" " + tLinkable1.name + ".prev = " + tLinkable1.prev.name + " ");
            } else {
                System.out.println(" " + tLinkable1.name + ".prev = NULL ");
            }
            if (tLinkable1.next != null) {
                System.out.println(" " + tLinkable1.name + ".next = " + tLinkable1.next.name);
            } else {
                System.out.println(" " + tLinkable1.name + ".next = NULL");
            }
            tLinkable2 = tLinkable1;
            tLinkable1 = null;
            tLinkable1 = tLinkable2.next;
            tLinkable2 = null;
            if (tLinkable1 != null) continue;
            working = false;
        }
    }

    public static void showLists() {
    }

    public static HyperLinkedList getList(String tName) {
        SystemListRegistry.getRegistry();
        return SystemListRegistry.getList(tName);
    }

    public static void saveLists() {
        Object tList = null;
        SystemListNode tNode = null;
        SystemListRegistry tRegistry = SystemListRegistry.getRegistry();
        if (totalLists > 0) {
            if (tRegistry == null) {
                System.out.println("saveLists() SystemListRegistry() null system registry");
                return;
            }
            System.out.println("List Name: " + tRegistry.listName + " items " + tRegistry.items);
            if (tRegistry.listBase != null) {
                tNode = (SystemListNode)tRegistry.listBase;
            } else {
                System.out.println("null tempnode in LinkedList`");
                return;
            }
            while (tNode != null) {
                if (tNode.parentList.items == 1) {
                    System.out.println("List -> " + tNode.parentList.listName + "  " + tNode.parentList.items + " link");
                } else {
                    System.out.println("HyperLinkedList(" + tNode.parentList.listName + "," + tNode.parentList.items + "); links");
                }
                tNode.parentList.showLinks();
                tNode = (SystemListNode)tNode.next;
            }
        }
    }

    void clear() {
        this.listFlags = 16;
        this.listBase = null;
        this.listTail = null;
        this.items = 0;
    }

    int rand(int maxVal) {
        int val = 0;
        val = (int)(Math.random() * (double)maxVal);
        if (val < 0) {
            val = 0;
        } else if (val >= maxVal) {
            val = maxVal;
        }
        return val;
    }

    int dlStore(HyperLinkedList tList) {
        int tItems = tList.items;
        if (this.listBase == null) {
            this.listBase = tList.listBase;
            this.listTail = tList.listTail;
        } else if (this.listTail == null) {
            if (tList.listTail == null) {
                this.listTail = tList.listBase;
                this.listTail.prev = this.listBase;
                this.listBase.next = this.listTail;
            } else {
                this.listTail = tList.listTail;
                tList.listBase.prev = this.listBase;
                this.listBase.next = tList.listBase;
            }
        } else if (tList.listTail != null) {
            this.listTail.next = tList.listBase;
            tList.listBase.prev = this.listTail;
            this.listTail = tList.listTail;
        } else {
            this.listTail.next = tList.listBase;
            tList.listBase.prev = this.listTail;
            this.listTail = tList.listBase;
        }
        tList.listFlags = 16;
        tList.listBase = null;
        tList.listTail = null;
        tList.items = 0;
        this.items += tItems;
        return this.items;
    }

    int dlStore(Linkable tLinkable) {
        if (this.listBase == null) {
            this.listBase = tLinkable;
        } else if (this.listTail == null) {
            this.listTail = tLinkable;
            this.listTail.prev = this.listBase;
            this.listBase.next = this.listTail;
        } else {
            this.listTail.next = tLinkable;
            tLinkable.prev = this.listTail;
            this.listTail = tLinkable;
        }
        ++this.items;
        return this.items;
    }

    int dlDelete(Linkable tLinkable) {
        if (tLinkable == this.listBase) {
            if (this.listBase.next != null) {
                if (this.listBase.next == this.listTail) {
                    this.listBase = this.listTail;
                    this.listTail.prev = null;
                    this.listTail = null;
                } else {
                    this.listBase = this.listBase.next;
                    this.listBase.prev = null;
                }
            } else {
                tLinkable.next = null;
                tLinkable.prev = null;
            }
        } else if (tLinkable == this.listTail) {
            if (this.listTail.prev == this.listBase) {
                this.listTail.prev = null;
                this.listTail = null;
                this.listBase.next = null;
            } else {
                this.listTail = this.listTail.prev;
                this.listTail.next = null;
            }
        } else {
            if (tLinkable.prev != null) {
                tLinkable.prev.next = tLinkable.next;
            }
            if (tLinkable.next != null) {
                tLinkable.next.prev = tLinkable.prev;
            }
        }
        --this.items;
        if (this.items == 0) {
            this.listTail = null;
            this.listBase = null;
        }
        tLinkable.prev = null;
        tLinkable.next = null;
        return this.items;
    }

    synchronized void removeAll() {
        Linkable tLinkable1 = this.listBase;
        Linkable tLinkable2 = null;
        while (tLinkable1 != null) {
            tLinkable1.prev = null;
            tLinkable2 = tLinkable1.next;
            tLinkable1.next = null;
            tLinkable1 = null;
            tLinkable1 = tLinkable2;
            tLinkable2 = null;
        }
        this.listTail = null;
        this.listBase = null;
    }

    public void synchEnable() {
        this.listFlags |= 8;
    }

    void echoLinks(int x) {
        Linkable tLink = this.listBase;
        if (x < 100) {
            return;
        }
        System.out.println("\r\n---------LIST_ECHO: (" + x + ")" + this.listName + " items=" + this.items);
        if (this.listBase != null) {
            System.out.println(" B=" + this.listBase.name);
            if (this.listBase == this.listTail) {
                System.out.println("ERROR listBase == listTail");
                int z = 0;
                z /= z;
            }
        } else {
            System.out.println(" B=null");
        }
        if (this.listTail != null) {
            System.out.println(" T=" + this.listTail.name);
        } else {
            System.out.println(" T=null");
        }
        int iterationCount = 0;
        while (tLink != null) {
            System.out.println("LINK = " + tLink.name);
            if (tLink.prev != null) {
                System.out.print(iterationCount + "<- p=" + tLink.prev.name);
            } else {
                System.out.print(" p=null,");
            }
            if (tLink.next != null) {
                System.out.println(" n=" + tLink.next.name);
            } else {
                System.out.println(" n=null,");
            }
            tLink = tLink.next;
            if (++iterationCount <= 25) continue;
            System.out.println("iteration overload");
            System.exit(1);
        }
        System.out.println("\r\n---------");
    }

    public int detach(Linkable tLink) {
        int tNum = 0;
        if (tLink.prev != null) {
            tLink.prev.next = null;
            tLink.prev = null;
            Linkable sLink = tLink;
            while (sLink != null) {
                sLink = sLink.next;
            }
            this.items -= tNum;
            return tNum;
        }
        this.listTail = null;
        this.listBase = null;
        this.items = 0;
        return 0;
    }

    public void drain() {
        Linkable tLinkable = this.listBase;
        while (tLinkable != null) {
            Linkable tLinkable2 = tLinkable.next;
            tLinkable.prev = null;
            tLinkable.next = null;
            tLinkable = tLinkable2;
            tLinkable2 = null;
        }
        this.items = 0;
        this.listTail = null;
        this.listBase = null;
    }

    public void destroy() {
    }

    protected void finalize() throws Throwable {
        if ((this.listFlags & 0x40) != 0) {
            SystemListRegistry tRegistry = SystemListRegistry.getRegistry();
            tRegistry.unregister(this.systemListNode);
        }
        throw new Throwable();
    }

    static {
        seed = 0;
    }
}

