/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.net.URL;

public class HyperEditBuffer
extends Gadget
implements Externalizable {
    static final int APPEND_MODE = 1;
    static final int ON_DISPLAY = 2;
    int editFlags = 1;
    int maxRows = 50;
    int maxCols = 80;
    String[] screenText = null;
    StringBuffer[] screenBuffer = null;
    short[][] emulationFlag = null;
    String version = "1.0";
    String fileName = "";
    HyperKeyboard keyboard = null;
    char tmpChar = '\u0000';
    KeyEvent tmpKey = null;
    int keyCode = 0;
    int lineStart = 0;
    int textX = 0;
    int textY = 0;
    int curCol = 0;
    int curRow = 0;
    Color textPaneColor = Color.black;
    Color textColor = Color.white;
    int textPaneWidth = 0;
    int textPaneHeight = 0;
    int frameWidth = 5;
    int topBarHeight = 10;
    int charWidth = 0;
    int charHeight = 0;
    int fontHeight = 0;
    HyperEditBuffer next = null;
    HyperEditBuffer previous = null;
    int cursorX = 0;
    int cursorY = 0;
    int cursorWidth = 0;
    int cursorHeight = 0;
    Image cursorImage = null;
    String cursorName = "cursor.gif";

    HyperEditBuffer() {
        this(HyperView.getCurView());
    }

    HyperEditBuffer(HyperView tView) {
        this(tView, "HyperEdit.obj");
    }

    HyperEditBuffer(HyperView tView, String tFileName) {
        this.curView = tView;
        this.fileName = tFileName;
    }

    HyperEditBuffer(HyperView tView, int tWidth, int tHeight) {
        this(tView, tWidth, tHeight, null, (String)null);
    }

    HyperEditBuffer(HyperView tView, int tMaxCols, int tMaxRows, Font tFont, String tFileName) {
        this.curView = tView;
        this.fileName = tFileName;
        this.maxRows = tMaxRows;
        this.maxCols = tMaxCols;
        this.screenBuffer = new StringBuffer[this.maxRows];
        this.emulationFlag = new short[this.maxRows][this.maxCols];
        for (int i = 0; i < this.maxRows; ++i) {
            this.screenBuffer[i] = new StringBuffer(this.maxCols);
        }
        this.gobFlags = 644;
        this.gadFlags = 1073774593;
        this.conFont = tFont == null ? FontBase.hyperConFont12 : tFont;
        this.cursorWidth = this.curView.screenGraphics.getFontMetrics(this.conFont).stringWidth("M");
        this.cursorHeight = this.curView.screenGraphics.getFontMetrics(this.conFont).getHeight();
        this.cursorImage = this.curView.createImage(this.cursorWidth, this.cursorHeight);
        this.cursorGraphics = this.cursorImage.getGraphics();
        try {
            this.cursorImage = (this.curView.ioFlags & 0x20) != 0 ? this.getImageFromJar(this.cursorName) : this.curView.getAppletContext().getImage(new URL(this.curView.getCodeBase(), this.cursorName));
        }
        catch (Exception m) {
            m.printStackTrace(new PrintStream(HyperView.fp));
            this.curView.guru("GetString() Image()");
        }
        this.makeBitMap(this.conFont);
        this.cursorX = this.frameWidth + 1;
        this.cursorY = this.frameWidth + this.topBarHeight + 1;
        this.textX = this.cursorX;
        this.textY = this.cursorY + this.cursorHeight - this.curView.screenGraphics.getFontMetrics(this.conFont).getDescent();
        this.curView.addGadget(this, 0);
        this.keyboard = HyperView.keyboard;
        this.keyboard.focus = this;
        while (!this.graphics.drawImage(this.cursorImage, this.cursorX, this.cursorY, this.cursorWidth, this.cursorHeight, this.curView)) {
            this.curView.updateDisplay();
        }
    }

    public void makeBitMap(Font tmpFont) {
        this.fGPen = 1;
        this.bGPen = 16;
        this.charWidth = this.curView.screenGraphics.getFontMetrics(this.conFont).charWidth('M');
        this.charHeight = this.curView.screenGraphics.getFontMetrics(this.conFont).getHeight();
        this.textPaneWidth = this.charWidth * this.maxCols;
        this.textPaneHeight = this.charHeight * this.maxRows;
        this.width = this.textPaneWidth + (this.frameWidth << 1);
        this.height = this.textPaneHeight + (this.frameWidth << 1) + this.topBarHeight;
        this.x = (this.curView.width >> 1) - (this.width >> 1);
        this.y = (this.curView.height >> 1) - (this.height >> 1);
        this.x2 = this.x + this.width;
        this.y2 = this.y + this.height;
        this.gobPic = this.curView.createImage(this.width, this.height);
        this.graphics = this.gobPic.getGraphics();
        this.graphics.setFont(this.conFont);
        this.tc1 = this.curView.color[this.bGPen].darker();
        this.tc2 = this.tc1.darker();
        this.tc3 = this.curView.color[this.bGPen].brighter();
        this.tc4 = this.curView.color[this.fGPen].darker();
        this.graphics.setColor(this.curView.color[this.bGPen]);
        this.graphics.fillRect(0, 0, this.width, this.height);
        this.graphics.setColor(this.tc3);
        this.graphics.drawLine(0, 0, this.width - 1, 0);
        this.graphics.drawLine(0, 0, 0, this.height - 2);
        this.graphics.setColor(this.tc1);
        this.graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
        this.graphics.drawLine(this.width - 1, this.height - 1, this.width - 1, 0);
        this.graphics.setColor(Color.black);
        this.graphics.drawString(this.gobName, this.stringX + 1, this.stringY + 1);
        this.graphics.setColor(this.curView.color[this.fGPen]);
        this.graphics.drawString(this.gobName, this.stringX, this.stringY);
        this.graphics.setColor(this.tc1);
        this.graphics.drawLine(this.frameWidth - 1, this.height - this.frameWidth, this.frameWidth - 1, this.frameWidth - 1 + this.topBarHeight);
        this.graphics.drawLine(this.frameWidth - 1, this.frameWidth - 1 + this.topBarHeight, this.width - this.frameWidth - 1, this.frameWidth - 1 + this.topBarHeight);
        this.graphics.setColor(this.tc1.darker());
        this.graphics.drawLine(this.width - this.frameWidth, this.frameWidth - 1 + this.topBarHeight, this.width - this.frameWidth, this.height - this.frameWidth - 1);
        this.graphics.drawLine(this.width - this.frameWidth, this.height - this.frameWidth, this.frameWidth - 1, this.height - this.frameWidth);
        this.graphics.setColor(this.textPaneColor);
        this.graphics.fillRect(this.frameWidth, this.frameWidth + this.topBarHeight, this.textPaneWidth, this.textPaneHeight);
        this.tc3 = null;
        this.tc2 = null;
        this.tc1 = null;
    }

    @Override
    public void inKey() {
        int index = 0;
        while (this.keyboard.mainBufferIndex != this.keyboard.intBufferIndex) {
            index = this.keyboard.mainBufferIndex;
            if ((this.keyboard.keyMsg[index].flags & 1) != 0) {
                this.tmpKey = this.keyboard.keyMsg[index].keyEvent;
                this.tmpChar = this.tmpKey.getKeyChar();
                this.keyCode = this.tmpKey.getKeyCode();
                switch (this.tmpChar) {
                    case '\b': {
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        break;
                    }
                    default: {
                        if (!HyperKeyboard.isPrintable(this.keyCode)) break;
                        this.graphics.setColor(this.textPaneColor);
                        this.graphics.fillRect(this.cursorX, this.cursorY, this.cursorWidth, this.cursorHeight);
                        this.cursorX += this.cursorWidth;
                        this.graphics.drawImage(this.cursorImage, this.cursorX, this.cursorY, this.cursorWidth, this.cursorHeight, this.curView);
                        if (this.emulationFlag[this.curRow][this.curCol] != 0) {
                            // empty if block
                        }
                        if ((this.editFlags & 1) == 0) break;
                        this.screenBuffer[this.curRow].append(this.tmpChar);
                        this.graphics.setColor(this.textColor);
                        this.graphics.drawString(this.screenBuffer[this.curRow].substring(this.curCol), this.textX, this.textY);
                        ++this.curCol;
                        this.textX += this.cursorWidth;
                    }
                }
            }
            ++this.keyboard.mainBufferIndex;
            if (this.keyboard.mainBufferIndex < 512) continue;
            this.keyboard.mainBufferIndex = 0;
        }
    }

    @Override
    public void readExternal(ObjectInput in) {
    }

    @Override
    public void writeExternal(ObjectOutput out) {
    }

    public void paint(Graphics g) {
    }
}

