/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class HyperConnectionNode
extends Linkable
implements BufferConstants,
HyperNodeConstants {
    byte[] buffer;
    StateMachine stateMachine;
    volatile int nodeFlags;
    static final int BUFFER_SIZE = 512;
    int timeout;
    int timeTillTimeout;
    int inactivityTimer;
    int number;
    int readBytes;
    int readBlockSize;
    int securityLevel;
    int pingNumber;
    volatile long totalReadBytes;
    volatile long totalWrittenBytes;
    Socket socket;
    SocketAddress remoteAddress;
    InetSocketAddress remoteInetAddress;
    SocketChannel socketChannel;
    HyperChannel channel;
    HyperConnectionHandler parentConnectionHandler;
    HyperNBOutputHandler parentOutputHandler;
    HyperNBInputHandler parentInputHandler;
    ExternalConnectionNode externalConnectionNode;
    volatile int totalReadVectors;
    volatile int totalWriteVectors;
    int ioReturnVectorTimeout;
    OutputStream outputStream;
    Object socketChannelLock;
    volatile HyperLinkedList readVectorReturnList;
    volatile HyperLinkedList writeVectorReturnList;
    DisconnectVector disconnectVector;
    volatile Object serverIOWriteChangeClass;
    volatile Object serverIOReadChangeClass;
    volatile IOReply serverIOWriteClass;
    volatile IOReply serverIOReadClass;
    PortNode portNode;

    HyperConnectionNode() {
        this.totalWriteVectors = 0;
        this.totalReadVectors = 0;
        this.ioReturnVectorTimeout = 0;
        this.nodeFlags = 0;
        this.timeout = 60;
        this.timeTillTimeout = 3;
        this.inactivityTimer = 0;
        this.number = -1;
        this.readBytes = 0;
        this.readBlockSize = 0;
        this.securityLevel = 0;
        this.pingNumber = 0;
        this.totalReadBytes = 0L;
        this.totalWrittenBytes = 0L;
        this.totalReadVectors = 0;
        this.totalWriteVectors = 0;
        this.ioReturnVectorTimeout = 0;
    }

    HyperConnectionNode(int tNodeNumber, HyperChannel tChannel) {
        this.channel = tChannel;
        this.number = tNodeNumber;
        this.name = "ChannelNode(" + this.number + ")";
        this.readVectorReturnList = new HyperLinkedList(this.name + ".readVectorReturnList");
        this.writeVectorReturnList = new HyperLinkedList(this.name + ".writeVectorReturnList");
        this.parentConnectionHandler = tChannel.parentConnectionHandler;
        this.parentOutputHandler = HyperConnectionHandler.outputHandler;
        this.parentInputHandler = HyperConnectionHandler.inputHandler;
        this.buffer = new byte[512];
        this.stateMachine = new ServerStateMachine(this, null);
        this.nodeFlags = 0;
        this.timeout = 60;
        this.timeTillTimeout = 3;
        this.inactivityTimer = 0;
        this.readBytes = 0;
        this.readBlockSize = 0;
        this.securityLevel = 0;
        this.pingNumber = 0;
        this.totalReadBytes = 0L;
        this.totalWrittenBytes = 0L;
        this.totalReadVectors = 0;
        this.totalWriteVectors = 0;
        this.ioReturnVectorTimeout = 0;
    }

    HyperConnectionNode(HyperConnectionHandler tHandler, int tNodeNumber, ServerSocketChannel tServerSocketChannel) {
        this.nodeFlags = 0;
        this.timeout = 60;
        this.timeTillTimeout = 3;
        this.inactivityTimer = 0;
        this.readBytes = 0;
        this.readBlockSize = 0;
        this.securityLevel = 0;
        this.pingNumber = 0;
        this.totalReadBytes = 0L;
        this.totalWrittenBytes = 0L;
        this.totalReadVectors = 0;
        this.totalWriteVectors = 0;
        this.ioReturnVectorTimeout = 0;
        this.number = tNodeNumber;
        this.name = "Node(" + this.number + ")";
        this.readVectorReturnList = new HyperLinkedList(this.name + ".readVectorReturnList");
        this.writeVectorReturnList = new HyperLinkedList(this.name + ".writeVectorReturnList");
        this.parentConnectionHandler = tHandler;
        this.parentOutputHandler = HyperConnectionHandler.outputHandler;
        this.parentInputHandler = HyperConnectionHandler.inputHandler;
        this.buffer = new byte[512];
        this.stateMachine = new StateMachine(this, null);
        try {
            this.socket = tServerSocketChannel.accept().socket();
            try {
                this.socket.setSoLinger(true, 0);
            }
            catch (SocketException sex) {
                sex.printStackTrace();
            }
            this.outputStream = this.socket.getOutputStream();
            this.socketChannel = this.socket.getChannel();
            this.socketChannel.configureBlocking(false);
            this.socket.setSoTimeout(1000);
            this.socket.setTcpNoDelay(true);
            this.socket.setSoLinger(false, 0);
            this.socket.setReuseAddress(false);
            this.socket.setKeepAlive(false);
            this.socket.setReceiveBufferSize(512);
            this.socket.setSendBufferSize(512);
            this.remoteAddress = this.socket.getRemoteSocketAddress();
            if ((this.parentConnectionHandler.conFlags & 0x80) != 0) {
                HyperConnectionHandler.out("Connect: + " + this.parentConnectionHandler.port + " " + this.name + " from " + this.remoteAddress.toString() + " connected = " + this.parentConnectionHandler.masterNodeList.items + " total = " + HyperConnectionHandler.totalConnections);
            }
            if ((this.parentConnectionHandler.conFlags & 0x40) != 0) {
                System.out.println("Connect: + " + this.parentConnectionHandler.port + " " + this.name + " from " + this.remoteAddress.toString() + " connected = " + this.parentConnectionHandler.masterNodeList.items + " total = " + HyperConnectionHandler.totalConnections);
                System.out.flush();
            }
        }
        catch (IOException ioex) {
            System.out.println("HyperConnectionNode.serverSocketChannel exception #1");
            ioex.printStackTrace();
        }
    }

    HyperConnectionNode(PortNode tPortNode) {
        this.nodeFlags = 0;
        this.timeout = 60;
        this.timeTillTimeout = 3;
        this.inactivityTimer = 0;
        this.readBytes = 0;
        this.readBlockSize = 0;
        this.securityLevel = 0;
        this.pingNumber = 0;
        this.totalReadBytes = 0L;
        this.totalWrittenBytes = 0L;
        this.totalReadVectors = 0;
        this.totalWriteVectors = 0;
        this.ioReturnVectorTimeout = 0;
        this.number = -1;
        this.name = "Node(" + this.number + ")";
        this.readVectorReturnList = new HyperLinkedList(this.name + ".readVectorReturnList");
        this.writeVectorReturnList = new HyperLinkedList(this.name + ".writeVectorReturnList");
        this.parentOutputHandler = HyperConnectionHandler.outputHandler;
        this.parentInputHandler = HyperConnectionHandler.inputHandler;
        this.buffer = new byte[512];
        this.stateMachine = new StateMachine(this, null);
    }

    public byte getByte() {
        return 1;
    }

    public short getShort() {
        return 1;
    }

    public int getInt() {
        return 1;
    }

    public long getLong() {
        return 1L;
    }

    public byte[] getData(int tLength) {
        return new byte[tLength];
    }

    public byte[] getData() {
        return new byte[1];
    }

    public void saveNode() {
        this.saveNode(this.number);
    }

    public void saveNode(int tInt) {
        HyperConnectionHandler.out("--- Node L#" + tInt + " nodeFlags =" + this.nodeFlags + " timeout = " + this.timeout);
        HyperConnectionHandler.out("timeTillTimeout = " + this.timeTillTimeout);
        HyperConnectionHandler.out("inactivityTimer = " + this.inactivityTimer);
        HyperConnectionHandler.out("number = " + this.number);
        HyperConnectionHandler.out("readBytes = " + this.readBytes);
        HyperConnectionHandler.out("readBlockSize = " + this.readBlockSize);
        HyperConnectionHandler.out("securityLevel =" + this.securityLevel);
        HyperConnectionHandler.out("pingNumber = " + this.pingNumber);
        HyperConnectionHandler.out("totalReadBytes = " + this.totalReadBytes);
        HyperConnectionHandler.out("totalWrittenBytes" + this.totalWrittenBytes);
        HyperConnectionHandler.out("socket = " + this.socket.toString());
        HyperConnectionHandler.out("remoteAddress = " + this.remoteAddress.toString());
        HyperConnectionHandler.out("SocketChannel =" + this.socketChannel.toString());
        HyperConnectionHandler.out("parentConnectionHandler = " + this.parentConnectionHandler.toString());
        HyperConnectionHandler.out("parentOutputHandler =" + this.parentOutputHandler.toString());
        HyperConnectionHandler.out("parentInputHandler = " + this.parentInputHandler);
        HyperConnectionHandler.out("totalReadVectors = " + this.totalReadVectors);
        HyperConnectionHandler.out("totalWriteVectors = " + this.totalWriteVectors);
        HyperConnectionHandler.out("socketChannelLock = " + this.socketChannelLock.toString());
        HyperConnectionHandler.out("socketChannelLock = " + this.socketChannelLock.toString());
        HyperConnectionHandler.out("*** readVectorReturnList items = " + this.readVectorReturnList.items + " {");
        HyperConnectionHandler.out("*** writeVectorReturnList items = " + this.writeVectorReturnList.items + " {");
        if (this.disconnectVector != null) {
            System.out.println("disconnectVector = " + this.disconnectVector.toString() + "\r\n};");
        } else {
            System.out.println("disconnectVector = null");
        }
    }

    public void initialize(HyperConnectionHandler tHandler, int tNodeNumber, ServerSocketChannel tServerSocketChannel) {
        String str = "Welcome to the HyperView java.NIO server\r\n";
        this.buffer = new byte[512];
        if (this.readVectorReturnList == null) {
            this.readVectorReturnList = new HyperLinkedList(this.name + ".readVectorReturnList");
        }
        if (this.writeVectorReturnList == null) {
            this.writeVectorReturnList = new HyperLinkedList(this.name + ".writeVectorReturnList");
        }
        this.parentConnectionHandler = tHandler;
        this.parentOutputHandler = HyperConnectionHandler.outputHandler;
        this.parentInputHandler = HyperConnectionHandler.inputHandler;
        if (this.stateMachine == null) {
            this.stateMachine = new ServerStateMachine(this, null);
        }
        this.pingNumber = 0;
        try {
            this.socket = tServerSocketChannel.accept().socket();
            try {
                this.socket.setSoLinger(true, 0);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            this.outputStream = this.socket.getOutputStream();
            this.socketChannel = this.socket.getChannel();
            this.socketChannelLock = this.socketChannel.blockingLock();
            this.socketChannel.configureBlocking(false);
            this.setSocketDefaults();
            this.remoteAddress = this.socket.getRemoteSocketAddress();
            if ((this.parentConnectionHandler.conFlags & 0x80) != 0) {
                HyperConnectionHandler.out("Connect: - " + this.parentConnectionHandler.port + " " + this.name + " " + this.remoteAddress.toString() + " connected = " + this.parentConnectionHandler.masterNodeList.items + " total = " + HyperConnectionHandler.totalConnections);
            }
            if ((this.parentConnectionHandler.conFlags & 0x40) != 0) {
                System.out.println("Connect: - " + this.parentConnectionHandler.port + " " + this.name + " " + this.remoteAddress.toString() + " connected = " + this.parentConnectionHandler.masterNodeList.items + " total = " + HyperConnectionHandler.totalConnections);
                System.out.flush();
            }
        }
        catch (IOException ioex) {
            System.out.println("HyperConnectionNode.socketChannel exception #1");
        }
    }

    public void initialize(HyperConnectionHandler tHandler, int tNodeNumber, SocketChannel tSocketChannel) {
        this.parentConnectionHandler = tHandler;
        this.parentOutputHandler = HyperConnectionHandler.outputHandler;
        this.parentInputHandler = HyperConnectionHandler.inputHandler;
        this.socketChannel = tSocketChannel;
        this.pingNumber = 0;
        try {
            this.socket = tSocketChannel.socket();
            try {
                this.socket.setSoLinger(true, 0);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            this.outputStream = this.socket.getOutputStream();
            this.socketChannelLock = this.socketChannel.blockingLock();
            this.socketChannel.configureBlocking(false);
            this.setSocketDefaults();
            this.remoteInetAddress = (InetSocketAddress)this.socket.getRemoteSocketAddress();
            if ((this.parentConnectionHandler.conFlags & 0x80) != 0) {
                HyperConnectionHandler.out("Connect: - " + this.name + " " + this.remoteAddress.toString() + " connected = " + this.parentConnectionHandler.masterNodeList.items + " total = " + HyperConnectionHandler.totalConnections);
            }
            if ((this.parentConnectionHandler.conFlags & 0x40) != 0) {
                System.out.println("Connect: - " + this.name + " " + this.remoteAddress.toString() + " connected = " + this.parentConnectionHandler.masterNodeList.items + " total = " + HyperConnectionHandler.totalConnections);
                System.out.flush();
            }
        }
        catch (IOException ioex) {
            System.out.println("HyperConnectionNode.socketChannel exception #1");
        }
    }

    public void initialize(int tNodeNumber, HyperChannel tChannel) {
        this.parentConnectionHandler = tChannel.parentConnectionHandler;
        this.parentOutputHandler = HyperConnectionHandler.outputHandler;
        this.parentInputHandler = HyperConnectionHandler.inputHandler;
        this.channel = tChannel;
        this.pingNumber = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendIO(byte[] data, int tLen) {
        HyperNodeWriteVector tWriteVector = null;
        HyperLinkedList tWriteAddList = HyperNBOutputHandler.writeAddList;
        tWriteVector = this.getWriteVector();
        if (tWriteVector == null) {
            System.out.println("Node.sendIO() tWriteVector = null");
            return -1;
        }
        tWriteVector.writeSize = tLen;
        try {
            tWriteVector.writeBuffer.clear();
            try {
                tWriteVector.writeBuffer.put(data, 0, tLen);
            }
            catch (BufferOverflowException bofe) {
                System.out.println("SendIO Buffer OverFlow exception exception");
                System.out.println("write.limit(" + tWriteVector.writeBuffer.limit() + ");");
                System.out.println("writeBuffer.position(" + tWriteVector.writeBuffer.position() + ");");
                System.exit(1);
            }
            tWriteVector.writeBuffer.flip();
            tWriteVector.writeVectorFlags |= 0x800;
            HyperLinkedList bofe = tWriteAddList;
            synchronized (bofe) {
                tWriteAddList.dlStore(tWriteVector);
                tWriteVector = null;
                tWriteAddList.notifyAll();
            }
        }
        catch (Exception any) {
            any.printStackTrace();
            System.exit(1);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendIO(HyperLinkedList tVectorList) {
        try {
            HyperLinkedList hyperLinkedList = HyperNBOutputHandler.writeAddList;
            synchronized (hyperLinkedList) {
                if (tVectorList.items > 1) {
                    HyperNBOutputHandler.writeAddList.dlStore(tVectorList);
                } else {
                    HyperNBOutputHandler.writeAddList.dlStore(tVectorList.listBase);
                }
                HyperNBOutputHandler.writeAddList.notifyAll();
            }
        }
        catch (Exception any) {
            any.printStackTrace();
            System.exit(1);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getIO(HyperLinkedList tList) {
        HyperLinkedList hyperLinkedList = HyperNBInputHandler.readAddList;
        synchronized (hyperLinkedList) {
            HyperNBInputHandler.readAddList.dlStore(tList);
            tList.clear();
            HyperNBInputHandler.readAddList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getIO(HyperNodeReadVector tempReadVector) {
        HyperLinkedList hyperLinkedList = HyperNBInputHandler.readAddList;
        synchronized (hyperLinkedList) {
            HyperNBInputHandler.readAddList.dlStore(tempReadVector);
            HyperNBInputHandler.readAddList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HyperNodeReadVector getIO() {
        HyperNodeReadVector tReadVector = this.getReadVector();
        if (tReadVector == null) {
            return null;
        }
        HyperLinkedList hyperLinkedList = HyperNBInputHandler.readAddList;
        synchronized (hyperLinkedList) {
            HyperNBInputHandler.readAddList.dlStore(tReadVector);
            HyperNBInputHandler.readAddList.notifyAll();
        }
        return tReadVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendIO(byte data) {
        boolean returnVal = false;
        ByteBuffer tByteBuffer = null;
        HyperNodeWriteVector tWriteVector = null;
        tWriteVector = this.getWriteVector();
        if (tWriteVector == null) {
            return -1;
        }
        try {
            HyperLinkedList hyperLinkedList = HyperNBOutputHandler.writeAddList;
            synchronized (hyperLinkedList) {
                tByteBuffer = tWriteVector.writeBuffer;
                tByteBuffer.clear();
                tByteBuffer.put(data);
                tByteBuffer.flip();
                HyperNBOutputHandler.writeAddList.dlStore(tWriteVector);
                tWriteVector.writeVectorFlags |= 0x800;
                HyperNBOutputHandler.writeAddList.notifyAll();
            }
        }
        catch (Exception any) {
            any.printStackTrace();
            return -1;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnMsg(HyperNodeWriteVector tVector) {
        HyperLinkedList hyperLinkedList = this.writeVectorReturnList;
        synchronized (hyperLinkedList) {
            tVector.writeVectorFlags = 0;
            this.writeVectorReturnList.dlStore(tVector);
            this.writeVectorReturnList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnMsg(HyperNodeReadVector tVector) {
        Object tVector2 = null;
        Object tVector3 = null;
        HyperLinkedList hyperLinkedList = this.readVectorReturnList;
        synchronized (hyperLinkedList) {
            tVector.lastIteration = tVector.iteration;
            this.readVectorReturnList.dlStore(tVector);
            this.readVectorReturnList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HyperNodeReadVector getReadVector(HyperChannel tChannel, IOReply tReply) {
        HyperNodeReadVector tHyperNodeReadVector = null;
        HyperLinkedList hyperLinkedList = this.readVectorReturnList;
        synchronized (hyperLinkedList) {
            if (this.readVectorReturnList.listBase == null) {
                tHyperNodeReadVector = new HyperNodeReadVector(tChannel, this, (ByteBuffer)null);
                ++this.totalReadVectors;
            } else {
                tHyperNodeReadVector = (HyperNodeReadVector)this.readVectorReturnList.listBase;
                this.readVectorReturnList.dlDelete(tHyperNodeReadVector);
                tHyperNodeReadVector.initialize(tChannel, this);
                if (this.readVectorReturnList.items == 0) {
                    this.readVectorReturnList.clear();
                }
            }
            tHyperNodeReadVector.ioReply = tReply;
            this.readVectorReturnList.notifyAll();
            return tHyperNodeReadVector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HyperNodeWriteVector getWriteVector(HyperChannel tChannel) {
        if (this.writeVectorReturnList == null) {
            System.out.println("null writeVectorReturnList");
            System.exit(1);
        }
        HyperLinkedList hyperLinkedList = this.writeVectorReturnList;
        synchronized (hyperLinkedList) {
            HyperNodeWriteVector tHyperNodeWriteVector;
            if (this.writeVectorReturnList.listBase == null) {
                tHyperNodeWriteVector = new HyperNodeWriteVector(tChannel, this, (ByteBuffer)null);
                ++this.totalWriteVectors;
            } else {
                tHyperNodeWriteVector = (HyperNodeWriteVector)this.writeVectorReturnList.listBase;
                this.writeVectorReturnList.dlDelete(tHyperNodeWriteVector);
                tHyperNodeWriteVector.initialize(tChannel, this);
            }
            this.writeVectorReturnList.notifyAll();
            return tHyperNodeWriteVector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HyperNodeWriteVector getWriteVector() {
        HyperLinkedList hyperLinkedList = this.writeVectorReturnList;
        synchronized (hyperLinkedList) {
            HyperNodeWriteVector tHyperNodeWriteVector;
            if (this.writeVectorReturnList.listBase == null) {
                tHyperNodeWriteVector = new HyperNodeWriteVector(this.socketChannel, this, (ByteBuffer)null);
                ++this.totalWriteVectors;
            } else {
                tHyperNodeWriteVector = (HyperNodeWriteVector)this.writeVectorReturnList.listBase;
                this.writeVectorReturnList.dlDelete(tHyperNodeWriteVector);
                tHyperNodeWriteVector.initialize(this.socketChannel, this);
            }
            this.writeVectorReturnList.notifyAll();
            return tHyperNodeWriteVector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HyperNodeReadVector getReadVector() {
        HyperNodeReadVector tHyperNodeReadVector = null;
        HyperLinkedList hyperLinkedList = this.readVectorReturnList;
        synchronized (hyperLinkedList) {
            if (this.readVectorReturnList.listBase == null) {
                tHyperNodeReadVector = new HyperNodeReadVector(this.socketChannel, this, (ByteBuffer)null);
                ++this.totalReadVectors;
            } else {
                tHyperNodeReadVector = (HyperNodeReadVector)this.readVectorReturnList.listBase;
                this.readVectorReturnList.dlDelete(tHyperNodeReadVector);
                tHyperNodeReadVector.initialize(this.socketChannel, this);
                if (this.readVectorReturnList.items == 0) {
                    this.readVectorReturnList.clear();
                }
            }
            this.readVectorReturnList.notifyAll();
            return tHyperNodeReadVector;
        }
    }

    public boolean cleanUp() {
        this.buffer = null;
        boolean tBool = true;
        this.nodeFlags = 0;
        this.timeout = 60;
        this.securityLevel = 0;
        this.inactivityTimer = 0;
        this.readBytes = 0;
        this.readBlockSize = 0;
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
        this.socketChannel = null;
        this.socketChannelLock = null;
        this.parentOutputHandler = null;
        this.parentInputHandler = null;
        return tBool;
    }

    public void showBufferInfo(ByteBuffer tBuffer) {
        System.out.println("<ByteBuffer()>");
        System.out.println("capacity  = " + tBuffer.capacity());
        System.out.println("limit     = " + tBuffer.limit());
        System.out.println("position  = " + tBuffer.position());
        System.out.println("remaining = " + tBuffer.remaining());
        System.out.println("</ByteBuffer>");
    }

    void setSocketDefaults() {
        try {
            this.socket.setSoTimeout(1000);
            this.socket.setTcpNoDelay(true);
            this.socket.setSoLinger(false, 0);
            this.socket.setReuseAddress(false);
            this.socket.setKeepAlive(false);
            this.socket.setReceiveBufferSize(512);
            this.socket.setSendBufferSize(512);
        }
        catch (Exception any) {
            any.printStackTrace();
        }
    }

    String getExceptionBits() {
        return "Node " + ((this.nodeFlags & 0x18) == 24 ? "RW" : ((this.nodeFlags & 0x10) != 0 ? "_W" : ((this.nodeFlags & 8) != 0 ? "R_" : "XX")));
    }

    public String getNodeBits() {
        StringBuilder sb = new StringBuilder(4096);
        int tNodeMask = 1;
        int tNodeFlags = this.nodeFlags;
        int tLength = nodeFlagString.length;
        sb.append(856);
        for (int tZ = 0; tZ < tLength; ++tZ) {
            sb.append(nodeFlagString[tZ] + '=' + ((tNodeFlags & tNodeMask) != 0 ? (char)'1' : '0'));
            sb.append("\r\n");
        }
        sb.append("]\r\n");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(4096);
        if (this.buffer != null) {
            sb.append("buffer[" + this.buffer.length + ']' + '{' + '\r' + '\n');
            int tY = this.buffer.length;
            for (int tZ = 0; tZ < tY; ++tZ) {
                sb.append(this.buffer[tZ]);
            }
            sb.append(171);
        }
        if (this.stateMachine != null) {
            sb.append(this.stateMachine.toString());
        }
        sb.append(this.getNodeBits());
        if (this.remoteAddress != null) {
            sb.append("\r\nremoteAddress = " + this.remoteAddress.toString());
        } else {
            sb.append("\r\nremoteAddress null\r\n");
        }
        if (this.remoteInetAddress != null) {
            sb.append("\r\nremoteInetAddress = " + this.remoteInetAddress.toString() + "\r\n");
        } else {
            sb.append("\r\nremoteInetAddress null\r\n");
        }
        return sb.toString();
    }
}

