/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Set;

public class HyperConnectionHandler
extends Linkable
implements HyperConnectionHandlerConstants,
Runnable,
ThreadReport {
    static final String VERSION_STRING = "1.45";
    static final String noConnectionsString = "No connections";
    static final String runString = "0x0000";
    static Object delayWaitObject = new Object();
    static int startupDelay = 100;
    static boolean debug = false;
    static long now = System.currentTimeMillis();
    static volatile HyperLinkedList connectionHandlerList = new HyperLinkedList();
    static volatile int atomicNumber = 0;
    static volatile long broadcastBytes = 0L;
    static HyperChannelRegistry hyperChannelRegistry;
    static SystemClock clock;
    static SystemListRegistry systemListRegistry;
    static volatile HyperExternalConnectionHandler externalConnectionHandler;
    static volatile HyperNBInputHandler inputHandler;
    static volatile HyperNBOutputHandler outputHandler;
    static volatile HyperDisconnectHandler disconnectHandler;
    static volatile STDInputHandler stdInputHandler;
    static volatile DisconnectTimer disconnectTimer;
    static volatile Runtime runTime;
    public static volatile int serverEchoMillis;
    static volatile int runFlags;
    static ByteBuffer closeMessageByteBuffer;
    static final byte[] disconnectMessage;
    static final String serverOutName = "nio_server.txt";
    public static Object masterSocketChannelLock;
    volatile HyperView parentView;
    volatile int conFlags;
    volatile RunInfo runInfo;
    Iterator iterator;
    Set readyKeys;
    int iteration;
    int totalIncomingNodes;
    int maximumNodes;
    int keysAdded;
    int totalConnectionPoolNodes;
    volatile transient int totalNodes;
    static volatile int totalConnections;
    static volatile long totalReadBytes;
    static volatile long totalWrittenBytes;
    volatile long totalPortReadBytes;
    volatile long totalPortWrittenBytes;
    String name;
    int connectionHandlerNumber;
    volatile HyperLinkedList impendingConnectionInputList;
    volatile HyperLinkedList connectionPool;
    volatile HyperLinkedList masterNodeList;
    volatile HyperLinkedList masterNodeAddList;
    volatile Thread task;
    static volatile Object outLock;
    int port;
    Selector acceptSelector;
    ServerSocketChannel serverSocketChannel;
    InetAddress mainLocalServerAddress;
    InetSocketAddress inetSocketAddress;
    SelectionKey acceptKey;
    String initialConnectionMessage;
    int initialConnectionMessageByteSize = 0;
    byte[] initialConnectionMessageData;
    static volatile FileOutputStream fp;
    public IOReply serverIOReadClass;
    volatile PortNode portNode;
    volatile boolean bindError;

    public HyperConnectionHandler() {
        this.bindError = false;
        this.name = "Default server " + this.port;
        this.totalPortWrittenBytes = 0L;
        this.totalPortReadBytes = 0L;
        HyperConnectionHandler.connectionHandlerList.name = "ConnectionHandler.port(" + this.port + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HyperConnectionHandler(HyperView tView, int tPort) {
        boolean startAll = false;
        this.iteration = 0;
        this.totalIncomingNodes = 0;
        this.maximumNodes = 0;
        this.keysAdded = 0;
        this.totalConnectionPoolNodes = 0;
        this.totalNodes = 0;
        totalConnections = 0;
        long totalReadBytes = 0L;
        long totalWrittenBytes = 0L;
        this.initialConnectionMessageByteSize = 0;
        this.bindError = false;
        this.conFlags = 224;
        this.parentView = tView;
        this.runInfo = new RunInfo();
        this.totalPortWrittenBytes = 0L;
        this.totalPortReadBytes = 0L;
        HyperConnectionHandler.connectionHandlerList.name = "ConnectionHandler.port(" + this.port + ")";
        if (hyperChannelRegistry == null) {
            hyperChannelRegistry = HyperChannelRegistry.getChannelRegistry();
            return;
        }
        this.port = tPort;
        this.connectionPool = new HyperLinkedList();
        this.connectionPool.listName = "Con(" + this.port + ").connectionPool";
        this.masterNodeList = new HyperLinkedList();
        this.masterNodeList.listName = "Con(" + tPort + ").masterNodeList";
        this.masterNodeAddList = new HyperLinkedList();
        this.masterNodeAddList.listName = "Con(" + this.port + ").masterNodeAddList";
        HyperLinkedList hyperLinkedList = connectionHandlerList;
        synchronized (hyperLinkedList) {
            this.connectionHandlerNumber = atomicNumber++;
            connectionHandlerList.notifyAll();
        }
        if (disconnectHandler == null) {
            disconnectHandler = new HyperDisconnectHandler(this);
            outputHandler = new HyperNBOutputHandler(this);
            inputHandler = new HyperNBInputHandler(this);
            clock = new SystemClock(this);
            HyperConnectionHandler.outputHandler.inputHandler = inputHandler;
        }
        disconnectHandler.start();
        System.out.println("HCN: HyperConnectionHandler(HyperView tView,int tPort) OUT start");
        outputHandler.start();
        inputHandler.start();
        clock.start();
        disconnectTimer = new DisconnectTimer(1, this);
        clock.addTimer(disconnectTimer);
    }

    public HyperConnectionHandler(String[] tArgs, int tPort) {
        this(tPort);
        stdInputHandler = new STDInputHandler(this);
        stdInputHandler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HyperConnectionHandler(int tPort) {
        int tTimeout = startupDelay * 100;
        this.iteration = 0;
        this.totalIncomingNodes = 0;
        this.maximumNodes = 0;
        this.keysAdded = 0;
        this.totalConnectionPoolNodes = 0;
        this.totalNodes = 0;
        totalConnections = 0;
        long totalReadBytes = 0L;
        long totalWrittenBytes = 0L;
        this.initialConnectionMessageByteSize = 0;
        this.bindError = false;
        this.runInfo = new RunInfo();
        this.port = tPort;
        this.connectionPool = new HyperLinkedList();
        this.connectionPool.listName = "Con(" + this.port + ").connectionPool";
        this.masterNodeList = new HyperLinkedList();
        this.masterNodeList.listName = "Con(" + tPort + ").masterNodeList";
        this.masterNodeAddList = new HyperLinkedList();
        this.masterNodeAddList.listName = "Con(" + this.port + ").masterNodeAddList";
        HyperLinkedList hyperLinkedList = connectionHandlerList;
        synchronized (hyperLinkedList) {
            this.connectionHandlerNumber = atomicNumber++;
            connectionHandlerList.notifyAll();
        }
        if (disconnectHandler == null) {
            disconnectHandler = new HyperDisconnectHandler(this);
            outputHandler = new HyperNBOutputHandler(this);
            HyperConnectionHandler.outputHandler.inputHandler = inputHandler = new HyperNBInputHandler(this);
            outputHandler.start();
            while (!outputHandler.isAlive()) {
                if (--tTimeout >= 1) {
                    this.delay(startupDelay);
                    continue;
                }
                System.out.println("CON: can't start output handler");
                break;
            }
            inputHandler.start();
            while (!HyperConnectionHandler.inputHandler.readTask.isAlive()) {
                this.delay(startupDelay);
            }
            disconnectHandler.start();
            if (clock == null) {
                clock = new SystemClock(this);
            }
            clock.start();
            while (true) {
                if ((HyperConnectionHandler.clock.scFlags & 1) != 0) break;
                this.delay(startupDelay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delay(int tMillis) {
        Object object = delayWaitObject;
        synchronized (object) {
            try {
                delayWaitObject.wait(tMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            delayWaitObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        boolean isAlive = false;
        this.runInfo.runState = 5;
        HyperConnectionHandler tHandler = this;
        if (externalConnectionHandler == null) {
            externalConnectionHandler = HyperExternalConnectionHandler.getExternalHandler(tHandler);
        }
        try {
            HyperLinkedList hyperLinkedList = connectionHandlerList;
            synchronized (hyperLinkedList) {
                if (this.task != null) {
                    System.out.println("CON: Thread.start() race");
                    System.exit(0);
                }
                if (this.prev == null && this.next == null) {
                    connectionHandlerList.dlStore(this);
                } else {
                    System.out.println("CON: illegal HyperConnectionList store race");
                    System.exit(0);
                }
                if (HyperConnectionHandler.connectionHandlerList.items == 1) {
                    disconnectHandler.start();
                    outputHandler.start();
                    inputHandler.start();
                    clock.start();
                    while (true) {
                        if ((HyperConnectionHandler.clock.scFlags & 1) != 0) break;
                        this.delay(startupDelay);
                    }
                    disconnectTimer = new DisconnectTimer(1, this);
                    clock.addTimer(disconnectTimer);
                }
                this.task = new Thread(this);
                connectionHandlerList.notifyAll();
            }
        }
        catch (Exception any) {
            any.printStackTrace();
        }
        this.task.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Thread tTask = this.task;
        this.task = null;
        try {
            tTask.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.runInfo.runState = 6;
        HyperLinkedList hyperLinkedList = connectionHandlerList;
        synchronized (hyperLinkedList) {
            connectionHandlerList.dlDelete(this);
            if (HyperConnectionHandler.connectionHandlerList.items < 1) {
                try {
                    tTask = HyperConnectionHandler.clock.task;
                    clock.stop();
                    tTask.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tTask = HyperConnectionHandler.disconnectHandler.task;
                    disconnectHandler.stop();
                    tTask.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tTask = HyperNBInputHandler.task;
                    inputHandler.stop();
                    tTask.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tTask = HyperExternalConnectionHandler.task;
                    externalConnectionHandler.stop();
                    tTask.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tTask = HyperNBOutputHandler.task;
                    outputHandler.stop();
                    tTask.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                disconnectHandler = null;
                outputHandler = null;
                inputHandler = null;
                clock = null;
            }
            connectionHandlerList.notifyAll();
        }
        try {
            System.out.println("CON: f closing socket port " + this.port + " -> SPort = " + this.serverSocketChannel.socket().getLocalPort());
            this.serverSocketChannel.socket().setSoTimeout(100);
            this.serverSocketChannel.close();
        }
        catch (IOException ioEx) {
            System.out.println(ioEx.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeMessage() {
        if (closeMessageByteBuffer == null) {
            closeMessageByteBuffer = ByteBuffer.allocate(80);
            closeMessageByteBuffer.put(disconnectMessage);
        }
        closeMessageByteBuffer.flip();
        HyperLinkedList hyperLinkedList = this.masterNodeList;
        synchronized (hyperLinkedList) {
            Object object = masterSocketChannelLock;
            synchronized (object) {
                HyperConnectionNode tNode = (HyperConnectionNode)this.masterNodeList.listBase;
                SocketChannel tSocketChannel = null;
                boolean working = true;
                int nBytes = 0;
                while (working) {
                    try {
                        while (tNode != null) {
                            if (tNode.parentConnectionHandler.port == this.port) {
                                nBytes = 0;
                                tSocketChannel = tNode.socketChannel;
                                while (closeMessageByteBuffer.hasRemaining()) {
                                    if (tSocketChannel == null) continue;
                                    nBytes = tSocketChannel.write(closeMessageByteBuffer);
                                    if (nBytes > 0) {
                                        broadcastBytes += (long)nBytes;
                                    }
                                    if (broadcastBytes != 0L) continue;
                                    System.out.println("socketChannel 0 write ");
                                }
                                closeMessageByteBuffer.flip();
                            }
                            tNode = (HyperConnectionNode)tNode.next;
                        }
                        working = false;
                    }
                    catch (IOException ioex) {
                        closeMessageByteBuffer.flip();
                        tNode = (HyperConnectionNode)tNode.next;
                    }
                }
                masterSocketChannelLock.notifyAll();
                try {
                    masterSocketChannelLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                masterSocketChannelLock.notifyAll();
            }
            this.masterNodeList.notifyAll();
        }
    }

    public void showListLinks() {
        System.out.println("prev = " + this.prev + " next =" + this.next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object preemptObject = new Object();
        ServerSocketChannel nextReady = null;
        SelectionKey selectionKey = null;
        HyperConnectionNode tempConNode = null;
        Thread currentThread = Thread.currentThread();
        HyperConnectionHandler.waitIOExec(this);
        currentThread.setName("HyperCo nnectionHandler(" + this.port + ")");
        if (this.parentView != null) {
            this.parentView.hyperExec.addThread(this.task, this.runInfo);
        }
        try {
            this.acceptSelector = SelectorProvider.provider().openSelector();
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.configureBlocking(false);
            String tString = HyperView.getDefaultHost();
            this.mainLocalServerAddress = tString != null ? InetAddress.getByName(tString) : InetAddress.getLocalHost();
            this.inetSocketAddress = new InetSocketAddress(this.mainLocalServerAddress, this.port);
            ServerSocket tServerSocket = this.serverSocketChannel.socket();
            tServerSocket.setReuseAddress(true);
            tServerSocket.setSoTimeout(1);
            try {
                this.serverSocketChannel.socket().bind(this.inetSocketAddress);
            }
            catch (UnsupportedAddressTypeException uaex) {
                System.out.println("CON: uaex");
            }
            catch (ClosedChannelException ccex) {
                System.out.println("CON: ccex");
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
                this.bindError = true;
                new HyperPop(" Can't bind to " + this.inetSocketAddress.toString() + " Set Listenhost in preferences and restart ");
            }
            catch (SecurityException seex) {
                System.out.println("CON: seex");
            }
            catch (Exception any) {
                any.printStackTrace();
            }
            this.acceptKey = this.serverSocketChannel.register(this.acceptSelector, 16);
        }
        catch (Exception any) {
            any.printStackTrace();
            System.out.println(this.mainLocalServerAddress + " " + this.port);
            System.exit(1);
            this.runInfo.runState = 8;
            return;
        }
        if (this.parentView == null && (this.conFlags & 0x400) != 0) {
            System.out.println("\r\n*** HyperConnectionHandler 1.45 ***\r\n  listening   " + this.mainLocalServerAddress.toString() + ":" + this.port + " '?' for menu \r\n*************************\r\n\r\n");
        }
        StopWatch tStopWatch = new StopWatch();
        tStopWatch.start();
        while (currentThread == this.task) {
            block35: {
                try {
                    this.runInfo.runState = 21;
                    while ((this.keysAdded = this.acceptSelector.select(300L)) > 0) {
                        this.runInfo.runState = 9;
                        this.readyKeys = this.acceptSelector.selectedKeys();
                        this.iterator = this.readyKeys.iterator();
                        if (this.iterator.hasNext()) {
                            this.totalIncomingNodes = 0;
                            while (this.iterator.hasNext()) {
                                selectionKey = (SelectionKey)this.iterator.next();
                                this.iterator.remove();
                                nextReady = (ServerSocketChannel)selectionKey.channel();
                                tempConNode = this.getNode(nextReady);
                                if (tempConNode != null) {
                                    this.masterNodeAddList.dlStore(tempConNode);
                                    if (this.initialConnectionMessage != null) {
                                        if (this.initialConnectionMessageByteSize == 0) {
                                            this.initialConnectionMessageByteSize = this.initialConnectionMessage.length();
                                            this.initialConnectionMessageData = this.initialConnectionMessage.getBytes();
                                        }
                                        tempConNode.sendIO(this.initialConnectionMessageData, this.initialConnectionMessageByteSize);
                                    } else {
                                        String tString = "-><- Connect Node #" + tempConNode.number + " Welcome to HyperNBIOServer on port " + this.port + ' ' + '\r' + '\n' + '\r' + '\n';
                                        tempConNode.sendIO(tString.getBytes(), tString.length());
                                    }
                                    nextReady = null;
                                    try {
                                        HyperNodeReadVector tReadVector = tempConNode.getReadVector();
                                        tReadVector.readVectorFlags |= 0x200;
                                        tempConNode.getIO(tReadVector);
                                        ++this.totalIncomingNodes;
                                        tempConNode = null;
                                    }
                                    catch (NullPointerException npe) {
                                        System.out.println("CON: npe #1");
                                    }
                                } else {
                                    System.out.println("HyerConnectionHandler.getNode() -> tempConNode == null");
                                }
                                ++this.iteration;
                            }
                            this.readyKeys = null;
                            this.iterator = null;
                        }
                        if (this.masterNodeAddList.listBase != null) {
                            HyperLinkedList npe = this.masterNodeAddList;
                            synchronized (npe) {
                                this.totalNodes += this.totalIncomingNodes;
                                if (this.masterNodeAddList.listBase != null) {
                                    HyperConnectionNode tNode0 = (HyperConnectionNode)this.masterNodeAddList.listBase;
                                    if (this.masterNodeAddList.items == 1) {
                                        this.masterNodeAddList.dlDelete(this.masterNodeAddList.listBase);
                                        this.masterNodeList.dlStore(tNode0);
                                    } else {
                                        this.masterNodeList.dlStore(this.masterNodeAddList);
                                    }
                                }
                                this.masterNodeAddList.notifyAll();
                            }
                        }
                        this.runInfo.runState = 21;
                    }
                }
                catch (IOException ioException) {
                    if (this.runInfo.runState != 6) break block35;
                    try {
                        this.serverSocketChannel.close();
                    }
                    catch (Exception any) {
                        any.printStackTrace();
                    }
                    runFlags &= 0xFFFFFFFE;
                    this.runInfo.runState = 8;
                    return;
                }
                catch (Exception any) {
                    if (!(any instanceof InterruptedException)) break block35;
                    System.out.println("CON:(" + this.port + ')' + " interrupt");
                    break;
                }
            }
            this.runInfo.runState = 9;
            ++this.iteration;
            if ((this.conFlags & 0x400) == 0 || this.iteration % serverEchoMillis != 0 || this.iteration <= 0 || this.task == null) continue;
            System.out.println("HyperConnectionHandler running on port " + this.port + " ");
        }
        tStopWatch.stop();
        System.out.println(tStopWatch.toString());
        try {
            this.serverSocketChannel.close();
        }
        catch (Exception any) {
            any.printStackTrace();
        }
        runFlags &= 0xFFFFFFFE;
        this.runInfo.runState = 8;
        System.out.println("ConnectionHandler.run() returning");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void anyKey() {
        try {
            while ((long)System.in.available() < 0L) {
                HyperConnectionHandler hyperConnectionHandler = this;
                synchronized (hyperConnectionHandler) {
                    try {
                        this.wait(20000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void showServerInfo() {
        System.out.println(" totalNodes " + this.totalNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HyperConnectionNode getNode(ServerSocketChannel tNextReady) {
        Object os = null;
        HyperConnectionNode tempNode = null;
        HyperLinkedList hyperLinkedList = this.connectionPool;
        synchronized (hyperLinkedList) {
            ++totalConnections;
            if (this.connectionPool.listBase == null) {
                tempNode = new HyperConnectionNode(this, this.masterNodeList.items, tNextReady);
            } else {
                tempNode = (HyperConnectionNode)this.connectionPool.listBase;
                this.connectionPool.dlDelete(this.connectionPool.listBase);
                tempNode.initialize(this, totalConnections, this.serverSocketChannel);
            }
            this.connectionPool.notifyAll();
        }
        return tempNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HyperConnectionNode getBlankNode() {
        Object os = null;
        HyperConnectionNode tempNode = null;
        if (this.connectionPool == null) {
            return new HyperConnectionNode();
        }
        HyperLinkedList hyperLinkedList = this.connectionPool;
        synchronized (hyperLinkedList) {
            ++totalConnections;
            if (this.connectionPool.listBase == null) {
                this.connectionPool.notifyAll();
                return new HyperConnectionNode();
            }
            this.connectionPool.notifyAll();
            tempNode = (HyperConnectionNode)this.connectionPool.listBase;
            this.connectionPool.dlDelete(tempNode);
            this.connectionPool.notifyAll();
            return tempNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HyperConnectionNode getNode(HyperChannel tChannel) {
        Object os = null;
        HyperConnectionNode tempNode = null;
        HyperLinkedList hyperLinkedList = this.connectionPool;
        synchronized (hyperLinkedList) {
            if (this.connectionPool.listBase == null) {
                tempNode = new HyperConnectionNode(this.masterNodeList.items, tChannel);
            } else {
                tempNode = (HyperConnectionNode)this.connectionPool.listBase;
                this.connectionPool.dlDelete(this.connectionPool.listBase);
                tempNode.initialize(this.masterNodeList.items, tChannel);
            }
            this.connectionPool.notifyAll();
        }
        return tempNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showAllPorts() {
        HyperLinkedList tPortList = PortInfo.getPortList();
        if (tPortList == null) {
            System.out.println("CON: startAll() No active ports");
            return;
        }
        HyperLinkedList hyperLinkedList = tPortList;
        synchronized (hyperLinkedList) {
            PortNode tPortNode = (PortNode)tPortList.listBase;
            while (tPortNode != null) {
                tPortNode = (PortNode)tPortNode.next;
            }
            tPortList.notifyAll();
        }
    }

    public HyperConnectionHandler getConnectionBase() {
        try {
            return (HyperConnectionHandler)PortInfo.portList.listBase;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public boolean isRunning() {
        return (this.runInfo.runFlags & 9 | 0x15) != 0;
    }

    public boolean runAtStart() {
        if (this.portNode == null) {
            this.portNode = PortInfo.getPortNode(this.port);
            if ((this.portNode.portFlags & 1) != 0) {
                return true;
            }
        }
        return false;
    }

    public void startIO() {
        disconnectHandler.start();
        outputHandler.start();
        inputHandler.start();
        clock.start();
    }

    public String echoRunState() {
        char s0 = '0';
        char s1 = '1';
        StringBuilder tStringBuilder = new StringBuilder(127);
        tStringBuilder.append("\r\nSDIOC\r\n");
        if ((this.runInfo.runFlags & 6) == 0) {
            tStringBuilder.append(s0);
        } else {
            tStringBuilder.append(s1);
        }
        if ((runFlags & 8) == 0) {
            tStringBuilder.append(s0);
        } else {
            tStringBuilder.append(s1);
        }
        if ((runFlags & 4) == 0) {
            tStringBuilder.append(s0);
        } else {
            tStringBuilder.append(s1);
        }
        if ((runFlags & 2) == 0) {
            tStringBuilder.append(s0);
        } else {
            tStringBuilder.append(s1);
        }
        if ((runFlags & 1) == 0) {
            tStringBuilder.append(s0);
        } else {
            tStringBuilder.append(s1);
        }
        return tStringBuilder.toString();
    }

    public int runState() {
        if (this.runInfo.runState == 9 || this.runInfo.runState == 21) {
            return 2;
        }
        if (this.runInfo.runFlags == 5) {
            return 1;
        }
        return 0;
    }

    public static boolean isRunning(HyperConnectionHandler tHandler) {
        return (tHandler.runInfo.runFlags & 0xE) == 14;
    }

    public void saveListState() {
        HyperConnectionHandler.out("<LISTS_STATE>");
        if (this.connectionPool.listBase == null) {
            HyperConnectionHandler.out("<CON: Connection pool empty>");
        } else {
            HyperConnectionHandler.out("<CON: Connection pool>");
            HyperLinkedList.showLinks(this.connectionPool.listBase);
        }
        HyperConnectionHandler.out("<CON: ConnectionPool>");
        if (HyperConnectionHandler.inputHandler.readList.listBase == null) {
            HyperConnectionHandler.out("  <CON: readList empty>");
        } else {
            HyperConnectionHandler.out("  <CON: readList>");
            HyperLinkedList.showLinks(HyperConnectionHandler.inputHandler.readList.listBase);
        }
        HyperConnectionHandler.out("  <CON: </readList>");
        if (HyperConnectionHandler.outputHandler.writeList.listBase == null) {
            HyperConnectionHandler.out("  <CON: writeList empty>");
        } else {
            HyperConnectionHandler.out("  <CON: writeList>");
            HyperLinkedList.showLinks(HyperConnectionHandler.outputHandler.writeList.listBase);
        }
        HyperConnectionHandler.out("  <CON: </writeList>");
        HyperConnectionHandler.out("</LISTS_STATE>");
    }

    void pause(int pauseTime) {
        try {
            Thread.sleep(pauseTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void out(String Data) {
        int len = 0;
        Object object = outLock;
        synchronized (object) {
            if (fp == null) {
                try {
                    fp = new FileOutputStream(serverOutName);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            len = Data.length();
            try {
                Data = Data + "\r\n";
                fp.write(Data.getBytes());
                fp.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            outLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void out_cr(String Data, int tCRToggle) {
        int len = 0;
        Object object = outLock;
        synchronized (object) {
            if (fp == null) {
                try {
                    fp = new FileOutputStream(serverOutName);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            len = Data.length();
            try {
                if (tCRToggle != 0) {
                    Data = Data + "\r\n";
                }
                fp.write(Data.getBytes());
                fp.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            outLock.notifyAll();
        }
    }

    static HyperLinkedList getHandlerList() {
        return connectionHandlerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isListening(int tPort) {
        HyperLinkedList hyperLinkedList = connectionHandlerList;
        synchronized (hyperLinkedList) {
            HyperConnectionHandler tNode = (HyperConnectionHandler)HyperConnectionHandler.connectionHandlerList.listBase;
            while (tNode != null) {
                if (tNode.port == tPort) {
                    connectionHandlerList.notifyAll();
                    return true;
                }
                tNode = (HyperConnectionHandler)tNode.next;
            }
            connectionHandlerList.notifyAll();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConnected() {
        String tString = "";
        if (connectionHandlerList == null) {
            return "CON: No active connections; connectionHandlerList == null.";
        }
        HyperLinkedList hyperLinkedList = connectionHandlerList;
        synchronized (hyperLinkedList) {
            if (HyperConnectionHandler.connectionHandlerList.items < 1) {
                connectionHandlerList.notifyAll();
                return "No HyperConnectionHandler running";
            }
            tString = tString + "Total active server ports = " + HyperConnectionHandler.connectionHandlerList.items + "\r\n";
            HyperConnectionHandler tNode = (HyperConnectionHandler)HyperConnectionHandler.connectionHandlerList.listBase;
            int tCons = 0;
            while (tNode != null) {
                tCons += tNode.masterNodeList.items;
                tString = tString + "    port = (" + tNode.port + ") connected = (" + tNode.masterNodeList.items + ")\r\n";
                tNode = (HyperConnectionHandler)tNode.next;
            }
            tString = tString + "\r\nTotal port connections on all ports = " + tCons;
            connectionHandlerList.notifyAll();
        }
        return tString;
    }

    public static void main(String[] args) {
        int tmPort = 23232;
        boolean stdinENA = true;
        if (args != null) {
            int len = args.length;
            for (int z = 0; z < len; ++z) {
                String str = args[z];
                if (str.equals("-stdin")) {
                    stdinENA = false;
                    continue;
                }
                if (!str.equals("-port")) continue;
                try {
                    tmPort = Integer.parseInt(args[z + 1]);
                    continue;
                }
                catch (Exception any) {
                    tmPort = 23232;
                    if (!stdinENA) continue;
                    System.out.println(any.toString() + " default port: " + 23232);
                }
            }
        }
        try {
            HyperConnectionHandler hnbs = null;
            hnbs = stdinENA ? new HyperConnectionHandler(args, tmPort) : new HyperConnectionHandler(tmPort);
            hnbs.start();
            hnbs.task.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public RunInfo getRunInfo() {
        this.runInfo.now = now;
        this.runInfo.runLag = 0L;
        this.runInfo.lastRun = 0L;
        this.runInfo.startTime = 0L;
        this.runInfo.waitTime = 0L;
        this.runInfo.iteration = this.iteration;
        return this.runInfo;
    }

    static void waitIOExec() {
        HyperConnectionHandler.waitForRunMask(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitIOExec(HyperConnectionHandler tHandler) {
        int timer = 0;
        Object tempLock = new Object();
        if ((runFlags & 0xE) == 14) {
            return;
        }
        Object object = tempLock;
        synchronized (object) {
            while ((runFlags & 0xE) != 14) {
                try {
                    tempLock.wait(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++timer <= 50) continue;
                timer = 0;
                HyperConnectionHandler.echoIOExecMask();
                System.out.println("CON: Server failed to start");
            }
            tempLock.notifyAll();
        }
        HyperConnectionHandler.echoIOExecMask();
    }

    static void waitForRunMask() {
        HyperConnectionHandler.waitForRunMask(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitForRunMask(HyperView tView) {
        int timer = 0;
        Object tempLock = new Object();
        if ((runFlags & 0xE) == 14) {
            return;
        }
        Object object = tempLock;
        synchronized (object) {
            while ((runFlags & 0xE) != 14) {
                try {
                    tempLock.wait(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++timer <= 50) continue;
                timer = 0;
                HyperConnectionHandler.echoIOExecMask();
                System.out.println("CON: Server failed to start");
                if (tView != null) continue;
                System.exit(1);
            }
            tempLock.notifyAll();
        }
    }

    public static void echoIOExecMask() {
        int tMask = runFlags;
        StringBuffer s = new StringBuffer(120);
        if ((tMask & 2) != 0) {
            s.append("OUTPUT_HANDLER_RUNNING|");
        } else {
            s.append("OUTPUT_HANDLER_NOT_RUNNING|");
        }
        if ((tMask & 4) != 0) {
            s.append("INPUT_HANDLER_RUNNING|");
        } else {
            s.append("INPUT_HANDLER_NOT_RUNNING|");
        }
        if ((tMask & 8) != 0) {
            s.append("DISCONNECT_HANDLER_RUNNING|");
        } else {
            s.append("DISCONNECT_HANDLER_NOT_RUNNING|");
        }
        if (clock.isRunning()) {
            s.append("SYSTEM_CLOCK_RUNNING");
        } else {
            s.append("SYSTEM_CLOCK_NOT_RUNNING");
        }
        System.out.println(s.toString());
        System.out.flush();
    }

    static boolean Debug() {
        return debug;
    }

    public String toString() {
        return "HyperConnectionHandler 1.45 port (" + this.port + ");";
    }

    static boolean shutDown(int tPort) {
        HyperConnectionHandler tHandler = HyperConnectionHandler.getExistingConnectionHandler(tPort);
        System.out.println("shutdown getExistingConnectionHandler returned " + tHandler.port);
        if (tHandler == null) {
            System.out.println("no handler on port " + tPort);
            return false;
        }
        System.out.println("CHyerConnectionHandler.stop() port " + tPort);
        if (tHandler.port == tPort) {
            tHandler.stop();
        } else {
            System.out.println("CON: shutdown() Port mismatch overrride");
        }
        return true;
    }

    static HyperConnectionHandler getConnectionHandler(HyperView tView, int tPort) {
        HyperConnectionHandler tHandler = HyperConnectionHandler.getConnectionHandler(tPort);
        tHandler.parentView = tView;
        return tHandler;
    }

    static HyperConnectionHandler getConnectionHandler(int tPort) {
        return HyperConnectionHandler.getConnectionHandler(tPort, 0);
    }

    static HyperConnectionHandler getConnectionHandler(PortNode tPortNode) {
        tPortNode.connectionHandler = HyperConnectionHandler.getConnectionHandler(tPortNode.portNumber, 0);
        if ((tPortNode.portFlags & 0x20) != 0 && tPortNode.connectionHandler.task == null) {
            tPortNode.connectionHandler.start();
            tPortNode.connectionHandler.portNode = tPortNode;
        }
        return tPortNode.connectionHandler;
    }

    static HyperConnectionHandler startConnectionHandler(PortNode tPortNode) {
        tPortNode.portFlags |= 0x20;
        tPortNode.connectionHandler = HyperConnectionHandler.getConnectionHandler(tPortNode.portNumber, 32);
        tPortNode.connectionHandler.portNode = tPortNode;
        return tPortNode.connectionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HyperConnectionHandler getConnectionHandler(int tPort, int tStartFlags) {
        HyperConnectionHandler tNode = null;
        HyperConnectionHandler tMatchedHandler = null;
        if (connectionHandlerList == null) {
            return null;
        }
        HyperLinkedList hyperLinkedList = connectionHandlerList;
        synchronized (hyperLinkedList) {
            int tItems = HyperConnectionHandler.connectionHandlerList.items;
            if (tItems > 0) {
                tNode = (HyperConnectionHandler)HyperConnectionHandler.connectionHandlerList.listBase;
                while (tNode != null) {
                    if (tNode.port != tPort) {
                        tNode = (HyperConnectionHandler)tNode.next;
                        continue;
                    }
                    connectionHandlerList.notifyAll();
                    tMatchedHandler = tNode;
                    tNode = null;
                }
            }
            tNode = tMatchedHandler == null ? new HyperConnectionHandler(tPort) : tMatchedHandler;
            if ((tStartFlags & 0x20) != 0 && tNode.task == null) {
                tNode.start();
                HyperConnectionHandler.waitIOExec(tNode);
            }
            connectionHandlerList.notifyAll();
        }
        return tNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HyperConnectionHandler getExistingConnectionHandler(int tPort) {
        if (HyperConnectionHandler.connectionHandlerList.items > 0) {
            HyperLinkedList hyperLinkedList = connectionHandlerList;
            synchronized (hyperLinkedList) {
                HyperConnectionHandler tNode = (HyperConnectionHandler)HyperConnectionHandler.connectionHandlerList.listBase;
                while (tNode != null) {
                    if (tNode.port == tPort) {
                        connectionHandlerList.notifyAll();
                        return tNode;
                    }
                    tNode = (HyperConnectionHandler)tNode.next;
                }
                connectionHandlerList.notifyAll();
            }
        }
        return null;
    }

    String ioString() {
        return "Total system read bytes  = " + totalReadBytes + ".\r\nWrite bytes = " + totalWrittenBytes + '.' + '\r' + '\n';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getConnectionHandlerListStringArray() {
        try {
            HyperLinkedList hyperLinkedList = connectionHandlerList;
            synchronized (hyperLinkedList) {
                HyperConnectionHandler tNode = (HyperConnectionHandler)HyperConnectionHandler.connectionHandlerList.listBase;
                int tItems = HyperConnectionHandler.connectionHandlerList.items;
                if (tItems > 0) {
                    String[] tString = new String[tItems + 1];
                    tString[0] = ++tItems > 2 ? "Hosts " : "Host  ";
                    int tZ = 0;
                    while (tNode != null) {
                        ++tZ;
                        if (tItems == 1) {
                            tString[0] = tString[0] + tNode.mainLocalServerAddress.toString();
                        }
                        tString[tZ] = tZ + ") " + tNode.port;
                        tNode = (HyperConnectionHandler)tNode.next;
                    }
                    connectionHandlerList.notifyAll();
                    return tString;
                }
                System.out.println("connectionHandlerList.items " + tItems);
                connectionHandlerList.notifyAll();
            }
        }
        catch (Exception any) {
            any.printStackTrace();
            if (connectionHandlerList != null) {
                HyperLinkedList tString = connectionHandlerList;
                synchronized (tString) {
                    connectionHandlerList.notifyAll();
                }
            }
            String[] err = new String[]{"Exception getting connectionHandlers", any.toString()};
            return err;
        }
        String[] noConnectionString = new String[]{"----------------------------------", "No HyperConnectionHandlers active "};
        return noConnectionString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(ByteBuffer tempBuffer) {
        tempBuffer.flip();
        HyperLinkedList hyperLinkedList = this.masterNodeList;
        synchronized (hyperLinkedList) {
            Object object = masterSocketChannelLock;
            synchronized (object) {
                HyperConnectionNode tNode = (HyperConnectionNode)this.masterNodeList.listBase;
                SocketChannel tSocketChannel = null;
                boolean working = true;
                int nBytes = 0;
                while (working) {
                    try {
                        while (tNode != null) {
                            nBytes = 0;
                            tSocketChannel = tNode.socketChannel;
                            while (tempBuffer.hasRemaining()) {
                                if (tSocketChannel == null) continue;
                                nBytes = tSocketChannel.write(tempBuffer);
                                if (nBytes > 0) {
                                    broadcastBytes += (long)nBytes;
                                }
                                if (broadcastBytes != 0L) continue;
                                System.out.println("socketChannel 0 write ");
                            }
                            tempBuffer.flip();
                            tNode = (HyperConnectionNode)tNode.next;
                        }
                        working = false;
                    }
                    catch (IOException ioex) {
                        tempBuffer.flip();
                        tNode = (HyperConnectionNode)tNode.next;
                    }
                }
                masterSocketChannelLock.notifyAll();
                try {
                    masterSocketChannelLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                masterSocketChannelLock.notifyAll();
            }
            this.masterNodeList.notifyAll();
        }
    }

    static {
        systemListRegistry = new SystemListRegistry();
        externalConnectionHandler = null;
        runTime = Runtime.getRuntime();
        serverEchoMillis = 100;
        runFlags = 0;
        disconnectMessage = "Connection closed\r\n".getBytes();
        masterSocketChannelLock = new Object();
        totalReadBytes = 0L;
        totalWrittenBytes = 0L;
        outLock = new Object();
    }
}

