/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class HyperClip
extends Linkable {
    boolean playable;
    int sampleBits = 8;
    boolean endian;
    Thread task;
    AudioInputStream audioInputStream;
    AudioFormat audioFormat;
    AudioFormat playFormat;
    String name;
    URL url;
    DataLine.Info info;
    SourceDataLine line;
    int soundBufferSize = 64353;
    int internalBufferSize = -1;
    byte[] soundData;
    static final String mixerName = "Clip";
    Clip clip;

    HyperClip(HyperView tView, String tName) {
        this(tName, tView);
    }

    HyperClip(String tName, Applet tApplet) {
        this.name = tName;
        this.playable = false;
        if (tApplet != null) {
            try {
                this.url = this.getClass().getClassLoader().getResource(tName);
                this.audioInputStream = AudioSystem.getAudioInputStream(this.url);
            }
            catch (Exception any) {
                any.printStackTrace();
                return;
            }
        }
        File soundFile = new File(tName);
        try {
            this.audioInputStream = AudioSystem.getAudioInputStream(soundFile);
        }
        catch (Exception any) {
            any.printStackTrace();
            System.exit(1);
        }
        this.audioFormat = this.audioInputStream.getFormat();
        if (this.audioFormat.getEncoding() == AudioFormat.Encoding.ULAW || this.audioFormat.getEncoding() == AudioFormat.Encoding.ALAW) {
            this.endian = this.audioFormat.isBigEndian();
            this.playFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.audioFormat.getSampleRate(), this.audioFormat.getSampleSizeInBits() << 1, this.audioFormat.getChannels(), this.audioFormat.getFrameSize() << 1, this.audioFormat.getFrameRate(), true);
            this.audioInputStream = AudioSystem.getAudioInputStream(this.playFormat, this.audioInputStream);
            this.audioFormat = this.playFormat;
        }
        this.info = new DataLine.Info(Clip.class, this.audioFormat, this.internalBufferSize);
        boolean isSupported = AudioSystem.isLineSupported(this.info);
        try {
            this.clip = (Clip)AudioSystem.getLine(this.info);
            this.clip.open(this.audioInputStream);
        }
        catch (Exception any) {
            any.printStackTrace();
            System.exit(1);
        }
        if (this.clip == null) {
            System.out.println("null line");
            System.exit(1);
        }
        int bytesRead = 0;
        int bytesWritten = 0;
        if (this.soundData == null) {
            this.soundData = new byte[this.soundBufferSize];
        }
        try {
            bytesRead = this.audioInputStream.read(this.soundData, 0, this.soundData.length);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (bytesRead >= 0) {
            System.out.println("writing ");
            System.out.println("bytesWritten = " + bytesWritten);
        }
        this.playable = true;
    }

    public String toString() {
        String returnString = "Format = ulaw\r\nSample rate    = " + this.audioFormat.getSampleRate() + "\r\nSample bitsize = " + this.audioFormat.getSampleSizeInBits() + "\r\nMax Channels   = " + this.audioFormat.getChannels() + "\r\nFrame size     = " + this.audioFormat.getFrameSize() + "\r\nAudio format   = " + this.audioFormat.getFrameRate() + "\r\nBig endian     = " + this.audioFormat.isBigEndian() + "\r\n";
        return returnString;
    }

    public static void main(String[] args) {
        HyperClip h = null;
        int iterations = 1;
        long startTime = System.currentTimeMillis();
        long endTime = 0L;
        long total = 0L;
        try {
            try {
                if (args[1] != null) {
                    iterations = Integer.parseInt(args[1]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            h = new HyperClip(args[0], (Applet)null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Clip tClip = h.clip;
        for (int i = 0; i < iterations; ++i) {
            h.play();
            while (h.clip.isActive()) {
                HyperView.delay(20);
            }
        }
    }

    public void play() {
        this.clip.setFramePosition(0);
        this.clip.start();
    }

    public void stop() {
        this.clip.stop();
    }

    public void cleanUp() {
        this.clip.drain();
        this.clip.close();
        this.playable = false;
    }
}

