/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;

public class HyperChannel
extends Linkable
implements Channel,
BufferConstants,
HyperChannelConstants,
ChannelIOReply {
    static Object graphicsLock = new Object();
    volatile Graphics graphics;
    static HyperConnectionNode channelNode;
    volatile ChannelView channelView;
    ChannelIOReply channelIOReply;
    int id = -1;
    int waitTime = 20;
    long now = 0L;
    long startTime = System.currentTimeMillis();
    long totalOutBytes = 0L;
    long totalInBytes = 0L;
    int iteration = 0;
    Thread task;
    HyperView parentView;
    String name;
    int channelFlags;
    int securityLevel;
    static HyperChannelRegistry hyperChannelRegistry;
    public HyperOutputStream hyperOutputStream;
    public HyperInputStream hyperInputStream;
    HyperChannel[] channel;
    boolean[] impendingI0;
    static boolean serverRunning;
    public int totalChannels;
    ChannelTempLink[] channelTempLink;
    HyperLinkedList[] channelIOList;
    HyperConnectionHandler parentConnectionHandler;
    HyperNBOutputHandler parentOutputHandler;
    HyperNBInputHandler parentInputHandler;
    volatile HyperLinkedList serverChannelJoinedList;

    HyperChannel() {
        this.name = "";
        this.channelFlags = 2;
        this.securityLevel = 0;
        this.totalChannels = 0;
    }

    HyperChannel(String tName, HyperConnectionHandler tHandler) {
        this(tName, tHandler, tHandler == null ? (HyperView)null : tHandler.parentView);
    }

    HyperChannel(String tName, HyperConnectionHandler tHandler, HyperConnectionNode tNode) {
        this.channelFlags = 2;
        this.securityLevel = 0;
        this.totalChannels = 0;
        this.name = tName;
        this.parentConnectionHandler = tHandler;
        this.serverChannelJoinedList = new HyperLinkedList(tName + ".serverChannelJoinedList");
        this.channelIOReply = this;
        hyperChannelRegistry = HyperChannelRegistry.getRegistry();
        this.parentOutputHandler = HyperConnectionHandler.outputHandler;
        this.parentInputHandler = HyperConnectionHandler.inputHandler;
        if (channelNode == null) {
            try {
                channelNode = this.parentConnectionHandler.getNode(this);
            }
            catch (Exception any) {
                any.printStackTrace();
                System.exit(1);
            }
        }
        try {
            HyperChannelRegistry.synch(this);
        }
        catch (Exception any) {
            any.printStackTrace();
        }
    }

    HyperChannel(String tName, HyperConnectionHandler tHandler, HyperView tView) {
        this.channelFlags = 2;
        this.securityLevel = 0;
        this.totalChannels = 0;
        this.name = tName;
        this.parentView = tView;
        this.channelIOReply = this;
        this.parentConnectionHandler = tHandler;
        this.serverChannelJoinedList = new HyperLinkedList(tName + ".serverChannelJoinedList");
        hyperChannelRegistry = HyperChannelRegistry.getRegistry();
        if (channelNode == null && this.parentConnectionHandler == null) {
            HyperLinkedList handlerList = HyperConnectionHandler.getHandlerList();
            this.parentInputHandler = HyperConnectionHandler.inputHandler;
            this.parentOutputHandler = HyperConnectionHandler.outputHandler;
        }
        try {
            if (this.parentConnectionHandler == null) {
                System.out.println(" -><- -><- No server!");
                System.exit(1);
            }
            channelNode = this.parentConnectionHandler.getNode(this);
            HyperChannelRegistry.synch(this);
        }
        catch (Exception any) {
            any.printStackTrace();
            System.exit(1);
        }
        System.out.println("=========  /HyperChannel Constructor At synch " + tHandler.toString());
    }

    public static HyperChannel open(String tName) throws Exception {
        if (hyperChannelRegistry == null) {
            hyperChannelRegistry = HyperChannelRegistry.getRegistry();
        }
        HyperChannel tChannel = HyperChannelRegistry.getChannel(tName);
        return tChannel;
    }

    @Override
    public void close() throws ClosedChannelException {
        if ((this.channelFlags & 1) == 0) {
            throw new ClosedChannelException();
        }
    }

    @Override
    public boolean isOpen() {
        return (this.channelFlags & 1) != 0;
    }

    public int sendIO(byte[] byteReference, int tLength) throws ClosedChannelException {
        return this.sendIO(byteReference, 0, tLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendIO(byte[] byteReference, int tStart, int tLength) throws ClosedChannelException {
        HyperConnectionNode tNode = null;
        HyperNodeWriteVector tWriteVector = null;
        tNode = channelNode;
        tWriteVector = tNode.getWriteVector(this);
        System.out.println("HyperChannel.sendIO() Got WriteVector");
        tWriteVector.writeSize = tLength;
        try {
            HyperNBOutputHandler cfr_ignored_0 = tNode.parentOutputHandler;
            HyperLinkedList hyperLinkedList = HyperNBOutputHandler.writeAddList;
            synchronized (hyperLinkedList) {
                tWriteVector.writeBuffer.clear();
                try {
                    tWriteVector.writeBuffer.put(byteReference, tStart, tLength);
                }
                catch (BufferOverflowException bofe) {
                    System.out.println("HyperChannel.SendIO Buffer OverFlow exception exception");
                    System.out.println("write.limit(" + tWriteVector.writeBuffer.limit() + ");");
                    System.out.println("writeBuffer.position(" + tWriteVector.writeBuffer.position() + ");");
                    System.exit(1);
                }
                tWriteVector.writeBuffer.flip();
                tWriteVector.writeVectorFlags |= 0x800;
                HyperNBOutputHandler cfr_ignored_1 = tNode.parentOutputHandler;
                HyperNBOutputHandler.writeAddList.dlStore(tWriteVector);
                tWriteVector = null;
                HyperNBOutputHandler cfr_ignored_2 = tNode.parentOutputHandler;
                HyperNBOutputHandler.writeAddList.notifyAll();
            }
        }
        catch (Exception any) {
            any.printStackTrace();
            System.exit(0);
        }
        return 1;
    }

    public byte getByte() {
        return 1;
    }

    public short getShort() {
        return 1;
    }

    public int getInt() {
        return 1;
    }

    public long getLong() {
        return 1L;
    }

    public byte[] getData(int tLength) {
        return new byte[tLength];
    }

    public byte[] getData() {
        return new byte[1];
    }

    public int sendIO(byte byteReference) {
        return 1;
    }

    public void join(STDInputHandler tSTDIN) {
        HyperConnectionNode tNode = tSTDIN.parentConnectionHandler.getBlankNode();
        tNode.parentConnectionHandler = tSTDIN.parentConnectionHandler;
        tNode.nodeFlags |= 0x2000;
        this.join(tNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(HyperConnectionNode tNode) {
        if ((this.channelFlags & 2) != 0) {
            HyperChannel hyperChannel = this;
            synchronized (hyperChannel) {
                HyperChannelNodeLink tLink = new HyperChannelNodeLink(tNode);
                this.serverChannelJoinedList.dlStore(tLink);
                this.notifyAll();
            }
        } else {
            HyperChannelNodeLink tLink = new HyperChannelNodeLink(tNode);
            this.serverChannelJoinedList.dlStore(tLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(ServerChannelPane tPane) {
        if (tPane.inChannel[this.id]) {
            new HyperPop(tPane.curView, " You already joined " + this.name + " channel");
            return;
        }
        if ((this.channelFlags & 2) != 0) {
            HyperChannel hyperChannel = this;
            synchronized (hyperChannel) {
                tPane.currentChannel = this.id;
                HyperChannelNodeLink tLink = new HyperChannelNodeLink(tPane);
                this.serverChannelJoinedList.dlStore(tLink);
                tPane.inChannel[this.id] = true;
                tPane.serverChannelJoinedList[this.id] = tLink;
                this.notifyAll();
            }
        } else {
            HyperChannelNodeLink tLink = new HyperChannelNodeLink(tPane);
            this.serverChannelJoinedList.dlStore(tLink);
            tPane.inChannel[this.id] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave(ServerChannelPane tPane) {
        if ((this.channelFlags & 2) != 0) {
            HyperChannel hyperChannel = this;
            synchronized (hyperChannel) {
                if (tPane.inChannel[this.id]) {
                    this.serverChannelJoinedList.dlDelete(tPane.serverChannelJoinedList[this.id]);
                    tPane.serverChannelJoinedList[this.id] = null;
                    tPane.inChannel[this.id] = false;
                } else {
                    new HyperPop(tPane.curView, " You didn't join that channel. ");
                }
            }
        } else if (tPane.inChannel[this.id]) {
            this.serverChannelJoinedList.dlDelete(tPane.serverChannelJoinedList[this.id]);
            tPane.serverChannelJoinedList[this.id] = null;
            tPane.inChannel[this.id] = false;
        } else {
            new HyperPop(tPane.curView, " You didn't join that channel. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave(HyperConnectionNode tNode) {
        if ((this.channelFlags & 2) != 0) {
            HyperChannel hyperChannel = this;
            synchronized (hyperChannel) {
                HyperChannelNodeLink tLink = new HyperChannelNodeLink(tNode);
                this.notifyAll();
            }
        } else {
            HyperChannelNodeLink hyperChannelNodeLink = new HyperChannelNodeLink(tNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJoined(HyperChannelNodeLink tNode) {
        if ((this.channelFlags & 2) != 0) {
            HyperChannel hyperChannel = this;
            synchronized (hyperChannel) {
                HyperChannelNodeLink tLink = (HyperChannelNodeLink)this.serverChannelJoinedList.listBase;
                while (tLink != null) {
                    if (tLink != tNode) continue;
                    return true;
                }
                this.notifyAll();
                return false;
            }
        }
        HyperChannelNodeLink tLink = (HyperChannelNodeLink)this.serverChannelJoinedList.listBase;
        while (tLink != null) {
            if (tLink != tNode) continue;
            return true;
        }
        this.notifyAll();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSynchronous() {
        HyperChannel hyperChannel = this;
        synchronized (hyperChannel) {
            this.channelFlags &= 0xFFFFFFFD;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAsynchronous() {
        HyperChannel hyperChannel = this;
        synchronized (hyperChannel) {
            this.channelFlags |= 2;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getIO(IOReply tReply) {
        HyperNodeReadVector tReadVector = channelNode.getReadVector(this, tReply);
        if (tReadVector == null || tReply == null) {
            return -1;
        }
        IOReply iOReply = tReply;
        synchronized (iOReply) {
            HyperLinkedList hyperLinkedList = HyperNBInputHandler.readAddList;
            synchronized (hyperLinkedList) {
                HyperNBInputHandler.readAddList.dlStore(tReadVector);
                HyperNBInputHandler.readAddList.notifyAll();
            }
            tReply.notify();
            try {
                tReply.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return tReadVector.readBytes;
    }

    public OutputStream getOutputStream() {
        return this.hyperOutputStream;
    }

    public InputStream getInputStream() {
        return this.hyperInputStream;
    }

    @Override
    public void channelCleanup() {
    }

    @Override
    public long processChannelOutput(HyperLinkedList tWriteList) {
        HyperConnectionNode tNode = null;
        boolean z = false;
        int writeVectorListLength = 0;
        ByteBuffer writeBuffer = null;
        boolean y = false;
        byte[] buffer = null;
        boolean inPos = false;
        int nBytes = 0;
        boolean tBytes = false;
        boolean inByte = false;
        HyperChannelNodeLink ncLink = (HyperChannelNodeLink)this.serverChannelJoinedList.listBase;
        Object ncLink2 = null;
        HyperNodeWriteVector tWriteVector = (HyperNodeWriteVector)tWriteList.listBase;
        if (ncLink == null || tWriteVector == null) {
            return 0L;
        }
        while (tWriteVector != null) {
            writeVectorListLength = tWriteList.items;
            try {
                writeBuffer = tWriteVector.writeBuffer;
                buffer = tWriteVector.buffer;
                ncLink = (HyperChannelNodeLink)this.serverChannelJoinedList.listBase;
                while (ncLink != null) {
                    try {
                        int bLen = tWriteVector.writeBufferSize;
                        int tLen = tWriteVector.writeSize;
                        tNode = ncLink.parentNode;
                        if (tNode.socketChannel != null) {
                            nBytes = tNode.socketChannel.write(writeBuffer);
                        } else if (this.graphics == null) {
                            try {
                                byte[] a = writeBuffer.array();
                                int i = 0;
                                String tString = "";
                                for (i = 0; i < tLen; ++i) {
                                    tString = tString + (char)a[i];
                                }
                            }
                            catch (Exception any) {
                                any.printStackTrace();
                            }
                        } else if (this.channelView != null) {
                            try {
                                this.channelView.updateChannelView(this.name, this.graphics, writeBuffer);
                            }
                            catch (Exception any) {
                                this.removeChannelView();
                            }
                        }
                        if (nBytes > 0) {
                            this.totalOutBytes += (long)nBytes;
                        } else {
                            tNode.nodeFlags |= 0x18;
                        }
                    }
                    catch (IOException ioex) {
                        tNode.nodeFlags |= 0x18;
                    }
                    ncLink = (HyperChannelNodeLink)ncLink.next;
                }
            }
            catch (Exception ioex2) {
                tWriteVector.parentNode.nodeFlags |= 0x18;
            }
            tWriteVector = (HyperNodeWriteVector)tWriteVector.next;
        }
        return 1L;
    }

    @Override
    public long processChannelInput(HyperLinkedList tReadList) {
        HyperConnectionNode tNode = null;
        boolean z = false;
        int readVectorListLength = 0;
        ByteBuffer readBuffer = null;
        boolean y = false;
        byte[] buffer = null;
        boolean inPos = false;
        int nBytes = 0;
        boolean tBytes = false;
        boolean inByte = false;
        HyperChannelNodeLink ncLink = (HyperChannelNodeLink)this.serverChannelJoinedList.listBase;
        Object ncLink2 = null;
        HyperNodeReadVector readVector = (HyperNodeReadVector)tReadList.listBase;
        if (ncLink == null || readVector == null) {
            return 0L;
        }
        while (readVector != null) {
            readVectorListLength = tReadList.items;
            try {
                readBuffer = readVector.readBuffer;
                buffer = readVector.buffer;
                readBuffer.clear();
                if (readVector.socketChannel == null) continue;
                nBytes = readVector.socketChannel.read(readBuffer);
                if (nBytes < 1) {
                    readVector.parentNode.nodeFlags |= 0x18;
                    continue;
                }
                if (readVector.ioReply != null) {
                    readBuffer.flip();
                    readVector.ioReply.processInput(readVector, nBytes);
                }
                this.totalInBytes += (long)nBytes;
                ncLink = (HyperChannelNodeLink)this.serverChannelJoinedList.listBase;
                while (ncLink != null) {
                    try {
                        readBuffer.flip();
                        tNode = ncLink.parentNode;
                        this.totalOutBytes += (long)tNode.socketChannel.write(readBuffer);
                    }
                    catch (Exception ioex2) {
                        tNode.nodeFlags |= 0x18;
                    }
                    ncLink = (HyperChannelNodeLink)ncLink.next;
                }
            }
            catch (IOException ioex) {
                readVector.parentNode.nodeFlags |= 0x18;
            }
        }
        return this.totalInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannelView(ChannelView tChannelView, Graphics tGraphics) {
        Object object = graphicsLock;
        synchronized (object) {
            this.channelView = tChannelView;
            this.graphics = tGraphics;
            graphicsLock.notifyAll();
        }
    }

    public void removeChannelView() {
        this.graphics = null;
        this.channelView = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGraphics(Graphics tGraphics) {
        Object object = graphicsLock;
        synchronized (object) {
            this.graphics = tGraphics;
            graphicsLock.notifyAll();
        }
    }

    public void print() {
        System.out.println("HyperChannel [" + this.name + ']');
        System.out.println("id          = " + this.id);
        System.out.println("preempt     = " + this.waitTime);
        System.out.println("now         = " + this.now);
        System.out.println("startTime   = " + this.startTime);
        System.out.println("output      = " + this.totalOutBytes);
        System.out.println("input       = " + this.totalInBytes);
        System.out.println("iterations  = " + this.iteration);
        if (hyperChannelRegistry == null) {
            System.out.println("Registry    = inactive");
        } else {
            System.out.println("Registry    = active");
        }
        if (this.task == null) {
            System.out.println("IO          = inline");
        } else {
            System.out.println("IO          = asynchronous");
        }
        if (this.parentView != null) {
            System.out.println("view        = active");
        } else {
            System.out.println("view        = inactive");
        }
        System.out.println("Channel bits =" + Integer.toHexString(this.channelFlags));
        System.out.println("security     = " + this.securityLevel);
    }

    static {
        serverRunning = false;
    }
}

