/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.net.MalformedURLException;
import java.net.URL;

public class Gob
extends Linkable
implements HyperConstants,
TextConstants {
    volatile HyperView curView;
    Image gobPic;
    Graphics graphics;
    Image selectImage;
    Graphics selectGraphics;
    Image asynchImage1;
    Graphics asynchGraphics1;
    Image asynchImage2;
    Graphics asynchGraphics2;
    Image backGround;
    int totalAttached;
    int maxAttached;
    int attachedIndex;
    int curAttached;
    Gob[] attachedGob;
    Scanline[] scanLine;
    Gob destGob;
    Graphics destGraphics;
    int fGPen;
    int bGPen;
    int drawMode;
    String gobName;
    String infoString;
    int currentZIndex;
    Spline spline;
    double wSin;
    double hSin;
    double hyp;
    int width;
    int height;
    int depth;
    int widthBase;
    int heightBase;
    int gobNumber;
    int bottomMax;
    int topMin;
    int leftMin;
    int rightMax;
    int oldX;
    int oldY;
    int oldZ;
    int x;
    int y;
    int z;
    int[] mX;
    int[] mX2;
    int[] mY;
    int[] mY2;
    volatile int moveNum;
    int x2;
    int y2;
    int gobHx;
    int gobHy;
    int gobHz;
    int gravity;
    int dX;
    int dY;
    int dZ;
    Gob orbitGob;
    int gobOrbitRadius;
    volatile int gobFlags;
    volatile int gobFlags2;
    int gobEventFlags;
    int gobTypeFlags;
    int dispatchHoldCount;
    int gobGadIndex;
    volatile int clickX;
    volatile int clickY;
    volatile int lClickX;
    volatile int lClickY;
    int tint;
    int collisionClassMask;
    volatile long selectTime;

    public void printGobAttr(HyperView curView) {
        int cc = curView.fGPen;
        int cf = curView.curFont;
        curView.curFont = 2;
        curView.fGPen = 4;
        curView.text("x      :" + this.x, 1, 20);
        curView.text("y      :" + this.y, 1, 40);
        curView.text("z      :" + this.z, 1, 60);
        curView.text("Dx     :" + this.dX, 1, 80);
        curView.text("dY     :" + this.dY, 1, 100);
        curView.text("dZ     :" + this.dZ, 1, 120);
        curView.text("Width  :" + this.width, 1, 140);
        curView.text("Height :" + this.height, 1, 160);
        curView.text("WSin   :" + this.wSin, 1, 180);
        curView.text("HSin   :" + this.hSin, 1, 200);
        curView.text("Hyp    :" + this.hyp, 1, 220);
        curView.text("Height :" + curView.height, 1, 240);
        curView.text("Width  :" + curView.width, 1, 260);
        curView.fGPen = cc;
        curView.curFont = cf;
    }

    Gob() {
    }

    Gob(HyperView tView, String tName, int tFlags) {
        this(tView, tName, -1, -1, tFlags);
    }

    Gob(Gob tGob, String tName, int tFlags) {
        this(tGob, tName, -1, -1, tFlags);
    }

    Gob(Gob tGob, String tName, int tX, int tY, int pX, int pY, Spline tSpline, int tFlags) {
        this(tGob, tName, tX, tY, pX, pY, tFlags);
        this.spline = tSpline;
        this.x = this.spline.x[0];
        this.y = this.spline.y[0];
        this.z = this.spline.z[0];
        this.spline.targetX = this.spline.x[1];
        this.spline.targetY = this.spline.y[1];
        this.spline.targetZ = this.spline.z[1];
        this.gobFlags |= 0x8000000;
        if ((tSpline.flags & 0x800) != 0) {
            this.gobZInit();
            this.gobFlags |= 0x100000;
        }
    }

    Gob(HyperView tView, String tName, int tX, int tY, int pX, int pY) {
        this(tView, tName, tX, tY, pX, pY, 0);
    }

    Gob(Gob tGob, String tName, int tWidth, int tHeight, int pX, int pY, int tFlags) {
        this(tGob, tName, tWidth, tHeight, tFlags);
        this.move(pX, pY);
    }

    Gob(Gob tGob, String tName, int tX, int tY, int tFlags) {
        this(tGob.curView, tName, tX, tY, tFlags | 8);
        if (tGob.totalAttached < tGob.maxAttached) {
            tGob.attachedGob[tGob.totalAttached] = this;
            ++tGob.totalAttached;
        } else {
            System.out.println("GOB: attached Gobspace exceeded. Allocating");
            Gob[] tmpGob = new Gob[tGob.maxAttached + 10];
            for (int t = 0; t < tGob.totalAttached; ++t) {
                tmpGob[t] = this.attachedGob[t];
            }
            tGob.attachedGob = null;
            tGob.attachedGob = tmpGob;
            tGob.attachedGob[tGob.totalAttached] = this;
            ++tGob.totalAttached;
            tGob.maxAttached += 10;
        }
        tGob.destGob = this;
        tGob.gobFlags |= 0x20000000;
    }

    Gob(HyperView tView, String tName, int sx, int sy, int pX, int pY, int tFlags) {
        this(tView, tName, sx, sy, tFlags);
        this.move(pX, pY);
    }

    Gob(HyperView tView, String tName, int tWidth, int tHeight, int tFlags) {
        this.fGPen = 1;
        this.bGPen = 1;
        this.drawMode = 256;
        this.infoString = "";
        this.currentZIndex = 0;
        this.wSin = 0.0;
        this.hSin = 0.0;
        this.hyp = 0.0;
        this.depth = 1;
        this.widthBase = 0;
        this.heightBase = 0;
        this.gobNumber = -1;
        this.bottomMax = 0;
        this.topMin = 0;
        this.leftMin = 0;
        this.rightMax = 0;
        this.oldX = 0;
        this.oldY = 0;
        this.oldZ = 0;
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.x2 = 0;
        this.y2 = 0;
        this.gobHx = 0;
        this.gobHy = 0;
        this.gobHz = 0;
        this.gravity = 1;
        this.dX = 0;
        this.dY = 0;
        this.dZ = 0;
        this.gobOrbitRadius = 0;
        this.gobFlags = 0;
        this.gobFlags2 = 1;
        this.gobEventFlags = 0;
        this.gobTypeFlags = 0;
        this.dispatchHoldCount = 0;
        this.gobGadIndex = 0;
        this.clickX = 0;
        this.clickY = 0;
        this.lClickX = -1;
        this.lClickY = -1;
        this.tint = 0;
        this.gobName = tName;
        this.curView = tView;
        this.moveNum = -1;
        this.mX = new int[32];
        this.mX2 = new int[32];
        this.mY = new int[32];
        this.mY2 = new int[32];
        this.totalAttached = 0;
        this.maxAttached = 64;
        this.attachedIndex = 0;
        this.curAttached = 0;
        this.attachedGob = new Gob[this.maxAttached];
        this.destGraphics = this.curView.screenGraphics;
        if (tWidth == -1) {
            this.width = 75;
            this.height = 75;
            this.depth = this.curView.depth;
        } else {
            this.width = tWidth;
            this.height = tHeight;
        }
        this.gobFlags |= tFlags;
        this.bottomMax = this.curView.height - this.height - 1;
        this.topMin = this.dY;
        this.leftMin = this.dX;
        this.rightMax = this.curView.width - this.width - 1;
        try {
            this.gobPic = this.curView.createImage(this.width, this.height);
            this.graphics = this.gobPic.getGraphics();
            this.gobPic = (this.curView.ioFlags & 0x20) != 0 ? this.curView.getImageFromJar(this.gobName) : this.curView.getAppletContext().getImage(new URL(this.curView.getCodeBase(), this.gobName));
        }
        catch (MalformedURLException m) {
            this.curView.errOut("addGob();" + this.curView.getCodeBase() + this.gobName);
        }
        if ((this.gobFlags & 0x400000) != 0) {
            try {
                this.selectImage = this.curView.createImage(this.width, this.height);
                this.selectGraphics = this.selectImage.getGraphics();
                this.selectImage = (this.curView.ioFlags & 0x20) != 0 ? this.curView.getImageFromJar("sel_" + this.gobName) : this.curView.getAppletContext().getImage(new URL(this.curView.getCodeBase(), "sel_" + this.gobName));
            }
            catch (MalformedURLException m2) {
                this.curView.errOut("addGob();" + this.curView.getCodeBase() + this.gobName);
            }
        }
        this.widthBase = this.width;
        this.heightBase = this.height;
        double tw = 0.0;
        double td = 0.0;
        double th = 0.0;
        td = (double)this.depth * (double)this.depth;
        tw = (double)this.widthBase / 2.0;
        this.hyp = th = Math.sqrt(tw * tw + td);
        this.wSin = (double)this.depth / th;
        tw = (double)this.heightBase / 2.0;
        this.hSin = (double)this.depth / th;
    }

    Gob(HyperView tView, String tName, int sx, int sy, Spline tSpline, int tFlags) {
        this(tView, tName, sx, sy, tFlags | 0x8000000);
        this.destGraphics = this.curView.screenGraphics;
        this.depth = this.curView.depth;
        this.spline = tSpline;
        this.x = this.spline.x[0];
        this.y = this.spline.y[0];
        this.z = this.spline.z[0];
        this.spline.targetX = this.spline.x[1];
        this.spline.targetY = this.spline.y[1];
        this.spline.targetZ = this.spline.z[1];
        if ((tSpline.flags & 0x800) != 0) {
            this.gobZInit();
            this.gobFlags |= 0x100000;
        }
    }

    public void remove() {
        this.gobFlags &= 0xFFFFFDFF;
        this.gobFlags2 |= 2;
    }

    public void addSpline(Spline tSpline) {
        this.spline = tSpline;
        this.gobFlags |= 0x8000000;
        this.widthBase = this.width;
        this.heightBase = this.height;
        this.depth = this.curView.depth;
        if ((tSpline.flags & 0x800) != 0) {
            this.gobZInit();
            this.gobFlags |= 0x100000;
        }
    }

    public void zENA() {
        this.gobFlags |= 0x100000;
    }

    public void zOff() {
        this.gobFlags &= 0xFFEFFFFF;
    }

    public boolean inView() {
        return this.x > 0 && this.x < this.curView.width && this.y > 0 && this.y < this.curView.height;
    }

    public boolean onDisplay() {
        if (this.x > 0 && this.x < this.curView.width && this.y > 0 && this.y < this.curView.height) {
            this.gobFlags |= 0x200;
        }
        this.gobFlags &= 0xFFFFFDFF;
        return false;
    }

    public void enable() {
        this.gobFlags |= 0x200;
    }

    public void gobZInit() {
        double tw = 0.0;
        double td = 0.0;
        double th = 0.0;
        if (this.depth == 0) {
            this.depth = this.width * 100000;
        }
        td = (double)this.depth * (double)this.depth;
        tw = this.widthBase;
        this.hyp = th = Math.sqrt(tw * tw + td);
        this.wSin = (double)this.depth / th;
        tw = (double)this.heightBase / 2.0;
        th = Math.sqrt(tw * tw + td);
        this.hSin = (double)this.depth / th;
        if (this.z < 0) {
            this.z = 0;
            this.height = this.heightBase;
            this.width = this.widthBase;
        } else {
            this.width = (int)((double)this.widthBase * this.wSin / (double)this.z + 1.0);
            if (this.width < 1) {
                this.width = 2;
            }
            this.height = (int)((double)this.heightBase * this.hSin / (double)this.z + 1.0);
            if (this.height < 2) {
                this.height = 2;
            }
        }
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public void onClick() {
        this.curView.statusText("null onClick().gobNumber " + this.gobNumber);
    }

    public void onRelease() {
        System.out.println("Gob.release()");
    }

    public void remGob() {
    }

    public void addGob(Gob tGob) {
        tGob.destGob = this;
        if (this.totalAttached < this.maxAttached) {
            this.attachedGob[this.totalAttached] = tGob;
            tGob.attachedIndex = this.totalAttached++;
        } else {
            Gob[] tmpGob = new Gob[this.maxAttached + 10];
            for (int t = 0; t < this.totalAttached; ++t) {
                tmpGob[t] = this.attachedGob[t];
            }
            this.attachedGob = null;
            this.attachedGob = tmpGob;
            this.attachedGob[tGob.totalAttached] = this;
            ++this.totalAttached;
            this.maxAttached += 10;
        }
        this.gobFlags |= 0x20000000;
        tGob.gobFlags |= 8;
    }

    public void disable() {
        this.gobFlags &= 0xFFFFFDFF;
    }

    public void move(int tx, int ty) {
        this.x = tx;
        this.y = ty;
        this.x2 = tx + this.width;
        this.y2 = ty + this.height;
    }

    public void center() {
        if ((this.gobFlags & 8) == 0) {
            int tX = this.curView.width - this.width >> 1;
            int tY = this.curView.height - this.height >> 1;
            this.x = tX;
            this.y = tY;
            this.x2 = tX + this.width;
            this.y2 = tY + this.height;
        } else {
            int tX = this.destGob.width - this.width >> 1;
            int tY = this.destGob.height - this.height >> 1;
            this.x = tX;
            this.y = tY;
            this.x2 = tX + this.width;
            this.y2 = tY + this.height;
        }
    }

    public Image getImageFromJar(String fileName) {
        boolean length = false;
        if (fileName == null) {
            return null;
        }
        Image image = null;
        try {
            image = this.curView.getAppletContext().getImage(this.getClass().getResource(fileName));
        }
        catch (Exception exc) {
            HyperView.hyperViewOut(exc + " getting resource " + fileName);
            return null;
        }
        return image;
    }

    boolean isInView() {
        return this.x > 0 && this.x <= this.curView.x - this.width && this.y > 0 && this.y <= this.curView.height - this.height;
    }

    public void cleanUp() {
        if (this.gobPic != null) {
            this.gobPic.flush();
            this.graphics.dispose();
        }
        if (this.selectImage != null) {
            this.selectImage.flush();
            this.selectGraphics.dispose();
        }
        if (this.asynchImage1 != null) {
            this.asynchImage1.flush();
            this.asynchGraphics1.dispose();
        }
        if (this.asynchImage2 != null) {
            this.asynchImage2.flush();
            this.asynchGraphics2.dispose();
        }
        if (this.backGround != null) {
            this.backGround.flush();
        }
        this.destGob = null;
        this.destGraphics = null;
        this.gobName = null;
        this.infoString = null;
        if (this.spline != null) {
            this.spline.cleanUp();
        }
        this.mX = null;
        this.mX2 = null;
        this.mY = null;
        this.mY2 = null;
        this.orbitGob = null;
    }

    public void initScanline(int tInt) {
        if (this.scanLine != null) {
            return;
        }
        boolean alphaState = true;
        int endPixel = this.width - 1;
        boolean z = false;
        int[] gobPixel = null;
        Object img = null;
        boolean tempScanLinePointNumber = false;
        Scanline tScanline = null;
        Object lastScanline = null;
        this.scanLine = new Scanline[this.height];
        Scanline last = null;
        this.collisionClassMask = tInt;
        gobPixel = new int[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(this.gobPic, 0, 0, this.width, this.height, gobPixel, 0, this.width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        int tX = 0;
        int tY = 0;
        int tOffset = 0;
        System.out.println("getOutline() " + this.width * this.height + " w=" + this.width + " h=" + this.height + " l=" + gobPixel.length);
        try {
            alphaState = (gobPixel[tOffset] & 0xFFFFFF) == 0;
            for (tY = 0; tY < this.height; ++tY) {
                tScanline = null;
                last = tScanline = new Scanline();
                this.scanLine[tY] = tScanline;
                for (tX = 0; tX < this.width; ++tX) {
                    if (alphaState) {
                        System.out.print("0");
                        if ((gobPixel[tOffset] & 0xFFFFFF) != 0) {
                            tScanline.solid = alphaState = false;
                            tScanline.x = tX;
                        }
                    } else {
                        System.out.print("1");
                        if ((gobPixel[tOffset] & 0xFFFFFF) == 0) {
                            tScanline.solid = alphaState = true;
                            tScanline.x2 = tX;
                            if (tScanline.x != 0 && tScanline.x2 != 0) {
                                last = tScanline;
                                tScanline = tScanline.next = new Scanline();
                            }
                        }
                    }
                    ++tOffset;
                }
                if (!alphaState) {
                    tScanline.x2 = this.width - 1;
                }
                if (tScanline.x == 0 && tScanline.x2 == 0) {
                    last.next = null;
                }
                System.out.print("\r\n");
            }
        }
        catch (Exception any) {
            System.out.println("tX=" + tX + " tY=" + tY + " tO" + (tOffset + tX));
            any.printStackTrace();
        }
        for (int i = 0; i < this.height; ++i) {
            Scanline sc = this.scanLine[i];
            while (sc != null) {
                sc = sc.next;
            }
            System.out.print("\r\n");
        }
    }

    public void printScanLines() {
        if (this.scanLine == null) {
            this.initScanline(-1);
        }
        String s1 = "1";
        String s2 = "0";
        int tLen = this.scanLine.length;
        for (int z = 0; z < tLen; ++z) {
            if (!this.scanLine[z].solid) continue;
            int scanLen = this.scanLine[z].x2 - this.scanLine[z].x;
            String oString = this.scanLine[z].solid ? s1 : s2;
            for (int i = 0; i < scanLen; ++i) {
                System.out.print(oString);
            }
        }
    }

    int[] getPixels() {
        int[] gobPixel = null;
        gobPixel = new int[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(this.gobPic, 0, 0, this.width, this.height, gobPixel, 0, this.width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("GOB: image fetch aborted or errored");
        }
        return gobPixel;
    }

    public void collisionOn() {
        this.gobFlags |= 0x4000;
    }

    public void collisionOff() {
        this.gobFlags &= 0xFFFFBFFF;
    }

    public String toString() {
        String tString = "<GOB name = " + this.gobName + ">";
        tString = tString + "x=" + this.x + " y=" + this.y + "z=" + this.z;
        if ((this.gobFlags & 8) != 0) {
            tString = tString + this.gobName + " (a)->" + this.destGob.gobNumber;
            tString = tString + "\r\nflags1 " + Binary.toString(this.gobFlags);
            tString = tString + "\r\nflags2 " + Binary.toString(this.gobFlags2);
        } else {
            if ((this.gobFlags & 0x20000000) != 0) {
                tString = tString + "(A)->" + this.totalAttached;
            }
            tString = tString + "\r\nflags1 " + Binary.toString(this.gobFlags);
            tString = tString + "\r\nflags2 " + Binary.toString(this.gobFlags2);
        }
        tString = tString + "\r\n</GOB>\r\n";
        return tString;
    }
}

