/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;

public class FileTypes {
    char dirChar = File.separator.charAt(0);
    int MAX_FILETYPES;
    static final String[] MEMORY_ERROR = new String[]{"JVM out of memory.", null};
    String[] returnString = new String[]{"invalid directory", null};
    String[] emptyDirectoryString = new String[]{"Empty directory. ", null};
    volatile String[] suffixList;
    volatile int totalTypes;
    volatile int totalEntries;
    volatile int dirCount;
    volatile String parentDirectory;
    boolean recurse;

    FileTypes() {
        this.dirCount = 1;
        this.recurse = false;
        this.totalTypes = 0;
        this.MAX_FILETYPES = 4096;
        this.suffixList = new String[this.MAX_FILETYPES];
    }

    FileTypes(int tSize) {
        this.MAX_FILETYPES = tSize;
        this.dirCount = 0;
        this.recurse = true;
        this.totalTypes = 0;
        this.suffixList = new String[tSize];
    }

    public String[] getEntryTypes(String tString) throws Exception {
        int tTotalTypes = 0;
        String[] tSuffixList = this.suffixList;
        boolean tMatch = false;
        boolean isDir = false;
        File tFile = new File(tString);
        if (!tFile.isDirectory()) {
            this.parentDirectory = "error";
            throw new DirException(tString);
        }
        if (this.parentDirectory == null) {
            this.parentDirectory = tString;
        }
        tSuffixList = this.suffixList;
        File[] tFileList = tFile.listFiles();
        if (tFileList == null) {
            return null;
        }
        int tLength = tFileList.length;
        if (tLength > 0) {
            for (int tY = 0; tY < tLength; ++tY) {
                String tString2 = tFileList[tY].toString();
                isDir = tFileList[tY].isDirectory() && this.recurse;
                if (isDir) {
                    ++this.dirCount;
                    this.getEntryTypes(tString2);
                    continue;
                }
                tMatch = false;
                int tSuffixOffset = tString2.lastIndexOf(46);
                if (tSuffixOffset <= 0 || tString2.lastIndexOf(this.dirChar) >= tSuffixOffset) continue;
                tString2 = tString2.substring(tSuffixOffset, tString2.length());
                tTotalTypes = this.totalTypes;
                for (int tZ = 0; tZ < tTotalTypes; ++tZ) {
                    if (!tSuffixList[tZ].equals(tString2)) continue;
                    tMatch = true;
                    break;
                }
                if (!tMatch) {
                    tSuffixList[tTotalTypes++] = tString2;
                    this.totalTypes = tTotalTypes;
                    continue;
                }
                tMatch = false;
            }
        } else {
            tSuffixList = this.emptyDirectoryString;
        }
        return tSuffixList;
    }

    public void echoFileTypes() {
        int tLength = this.totalTypes;
        int tZ = 0;
        while (tZ < tLength) {
            System.out.println(this.suffixList[tZ++]);
        }
    }

    public static void main(String[] args) {
        String[] tReturnString = null;
        FileTypes tFileTypes = null;
        try {
            if (args.length == 2) {
                tFileTypes = new FileTypes(Integer.parseInt(args[1]));
            } else if (args.length == 1) {
                tFileTypes = new FileTypes();
            } else {
                System.out.println("Usage: '\"FileTypes [directory name]");
                System.out.println("Usage: '\"FileTypes [directory name] {buffersize}");
                System.exit(0);
            }
            tFileTypes.getEntryTypes(args[0]);
            tFileTypes.echoFileTypes();
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            System.out.println("\r\nbuffer too small!");
            System.out.println("Usage: '\"FileTypes [directory name] {buffersize}");
        }
        catch (Exception any) {
            any.printStackTrace();
        }
        System.out.println(tFileTypes.totalTypes + " file types in " + tFileTypes.dirCount + (tFileTypes.dirCount == 1 ? " directory." : " directories."));
    }

    class DirException
    extends Exception {
        DirException(String tPrepender) {
            super(tPrepender + " is not a valid Directory!");
        }
    }
}

