/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.Serializable;

public class Directory
implements Serializable,
DirectoryConstants {
    int filterFlags;
    int totalDirectories;
    HyperView curView;
    String parentDirName;
    String dirName;
    File dirBase;
    File parentDirFile;
    static File[] rootDevs;
    String[] fileStringList;
    File tmpFile;
    int flags;
    int[] entryFlags;
    int totalEntrys;
    int tint;
    char fileSeparator;
    static final String[] emptyDirString;
    static final int[] emptyEntryFlags;

    Directory() {
    }

    Directory(String tName, int tFilterFlags) {
        this(null, tName, tFilterFlags);
    }

    Directory(HyperView tView, String tName, int tFilterFlags) {
        this.filterFlags = tFilterFlags;
        this.tint = 0;
        this.flags = 0;
        this.curView = tView;
        this.fileSeparator = this.curView != null ? HyperView.fileSeparator : System.getProperty("file.separator").charAt(0);
        this.dirName = tName;
        this.dirBase = new File(tName);
        if (this.dirBase == null) {
            System.out.println("\r\nnew >> Directory File(" + tName + ") == null");
            System.exit(1);
        }
        if ((this.parentDirName = this.dirBase.getParent()) != null) {
            this.parentDirFile = new File(this.parentDirName);
        } else {
            this.parentDirName = "Devices";
        }
        this.fileStringList = this.dirBase.list();
        this.totalEntrys = this.fileStringList.length;
        if (this.totalEntrys < 1) {
            this.fileStringList = new String[1];
            this.fileStringList[0] = "Empty Directory";
            this.totalEntrys = 1;
        } else {
            this.entryFlags = new int[this.totalEntrys];
            this.tint = 0;
            while (this.tint < this.totalEntrys) {
                this.tmpFile = new File(this.dirName + this.fileSeparator + this.fileStringList[this.tint]);
                if (this.tmpFile.isDirectory()) {
                    int n = this.tint;
                    this.entryFlags[n] = this.entryFlags[n] | 2;
                }
                this.tmpFile = null;
                ++this.tint;
            }
        }
    }

    public int refresh(String newName, int tFilterFlags) {
        int tTotalDirectories = 0;
        File tDirBase = null;
        File tParentDirFile = null;
        String tParentDirName = null;
        String[] tFileStringList = null;
        int[] tEntryFlags = null;
        int tTotalEntrys = 0;
        this.filterFlags = tFilterFlags;
        tDirBase = new File(newName);
        if (tDirBase == null) {
            return -1;
        }
        if ((this.flags & 1) != 0) {
            this.flags &= 0xFFFFFFFE;
            tParentDirName = "-><- Devices -><-";
            tFileStringList = tDirBase.list();
            String tString = newName.toLowerCase();
            for (int timeout = 10; timeout > 0 && tFileStringList == null; --timeout) {
                if (tString.equals("a:\\") || tString.equals("fd0:") || tString.equals("df0:")) {
                    tFileStringList = new String[3];
                    tEntryFlags = new int[3];
                    tEntryFlags[0] = 0;
                    tFileStringList[0] = "        ";
                    tFileStringList[1] = "   Insert disk in drive " + newName;
                    tFileStringList[2] = tFileStringList[0];
                    tTotalEntrys = 3;
                } else {
                    tFileStringList = tDirBase.list();
                }
                HyperView.delay(1000);
            }
            if (tFileStringList == null) {
                tFileStringList = new String[1];
                tEntryFlags = new int[]{0};
                tFileStringList[0] = newName + " null ";
                tTotalEntrys = 1;
            } else {
                tTotalEntrys = tFileStringList.length;
            }
            if (tTotalEntrys < 1) {
                tFileStringList = new String[1];
                tEntryFlags = new int[]{0};
                tFileStringList[0] = "Empty Directory";
                tTotalEntrys = 1;
            } else {
                tEntryFlags = new int[tTotalEntrys];
                this.tint = 0;
                while (this.tint < tTotalEntrys) {
                    this.tmpFile = new File(newName + this.fileSeparator + tFileStringList[this.tint]);
                    if (this.tmpFile.isDirectory()) {
                        ++tTotalDirectories;
                        int n = this.tint;
                        tEntryFlags[n] = tEntryFlags[n] | 2;
                    }
                    this.tmpFile = null;
                    ++this.tint;
                }
            }
        } else {
            tParentDirName = tDirBase.getParent();
            if (tParentDirName != null) {
                tParentDirFile = new File(tParentDirName);
                tFileStringList = tDirBase.list();
                if (tFileStringList != null) {
                    tTotalEntrys = tFileStringList.length;
                } else {
                    tFileStringList = new String[3];
                    tEntryFlags = new int[3];
                    tEntryFlags[0] = 0;
                    tFileStringList[0] = "  -> " + newName + "<-";
                    tFileStringList[1] = "   Not readable :(";
                    tFileStringList[2] = "  Access denied Cullabunga!!!";
                    tTotalEntrys = 3;
                }
                if (tTotalEntrys < 1) {
                    tFileStringList = new String[1];
                    tEntryFlags = new int[]{0};
                    tFileStringList[0] = "Empty Directory";
                    tTotalEntrys = 1;
                } else {
                    tEntryFlags = new int[tTotalEntrys];
                    this.tint = 0;
                    while (this.tint < tTotalEntrys) {
                        this.tmpFile = new File(newName + this.fileSeparator + tFileStringList[this.tint]);
                        if (this.tmpFile.exists()) {
                            if (this.tmpFile.isDirectory()) {
                                ++tTotalDirectories;
                                int n = this.tint;
                                tEntryFlags[n] = tEntryFlags[n] | 2;
                            }
                        } else {
                            int n = this.tint;
                            tEntryFlags[n] = tEntryFlags[n] | 0x2000;
                        }
                        this.tmpFile = null;
                        ++this.tint;
                    }
                }
            } else {
                tParentDirName = " -><- Devices -><-";
                this.flags |= 1;
                if (rootDevs == null) {
                    Directory.listDevs();
                }
                tTotalEntrys = rootDevs.length;
                tEntryFlags = new int[tTotalEntrys];
                tFileStringList = new String[tTotalEntrys];
                this.tint = 0;
                while (this.tint < tTotalEntrys) {
                    tFileStringList[this.tint] = rootDevs[this.tint].toString();
                    tEntryFlags[this.tint] = 1;
                    ++this.tint;
                }
            }
        }
        if ((this.filterFlags & 1) != 0) {
            if (tTotalDirectories == 0) {
                if (tFileStringList == null) {
                    tFileStringList = emptyDirString;
                    tTotalEntrys = 3;
                    tEntryFlags = emptyEntryFlags;
                }
            } else {
                int tD = 0;
                String[] tDirectoryString = new String[tTotalDirectories];
                int[] tDEntryFlags = new int[tTotalDirectories];
                for (int tS = 0; tS < tTotalEntrys; ++tS) {
                    if ((tEntryFlags[tS] & 2) == 0) continue;
                    tDirectoryString[tD] = tFileStringList[tS];
                    tDEntryFlags[tD++] = tEntryFlags[tS];
                }
                tTotalEntrys = tTotalDirectories;
                tFileStringList = tDirectoryString;
                tEntryFlags = tDEntryFlags;
            }
        }
        this.dirName = newName;
        this.dirBase = null;
        this.parentDirFile = null;
        this.fileStringList = null;
        this.entryFlags = null;
        this.parentDirName = null;
        this.parentDirName = tParentDirName;
        this.dirBase = tDirBase;
        this.parentDirFile = tParentDirFile;
        this.fileStringList = tFileStringList;
        this.entryFlags = tEntryFlags;
        int tInt = this.entryFlags.length;
        this.totalEntrys = tTotalEntrys;
        this.totalDirectories = tTotalDirectories;
        return 0;
    }

    public void cleanUp() {
        int i = 0;
        int j = 0;
        this.parentDirName = null;
        this.dirName = null;
        this.dirBase = null;
        this.parentDirFile = null;
        this.curView = null;
        rootDevs = null;
        this.tmpFile = null;
        this.entryFlags = null;
        try {
            i = this.fileStringList.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (i > 0) {
            try {
                for (j = 0; j < i; ++j) {
                    this.fileStringList[j] = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fileStringList = null;
    }

    static File[] listDevs() {
        if (rootDevs == null) {
            rootDevs = File.listRoots();
        }
        return rootDevs;
    }

    static {
        emptyDirString = new String[]{"          ", "No sub directories ", "        "};
        emptyEntryFlags = new int[]{0, 0, 0};
    }
}

