/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.KeyEvent;

public class Asteroids
extends ViewPane
implements Runnable {
    Object keyWaitObject;
    boolean updated = false;
    Thread loadThread;
    Thread loopThread;
    Dimension dim = null;
    static final int DELAY = 21;
    static final int MAX_SHIPS = 5;
    static final int MAX_SHOTS = 5;
    static final int MAX_ROCKS = 8;
    static final int MAX_SCRAP = 20;
    static final int SCRAP_COUNT = 30;
    static final int HYPER_COUNT = 60;
    static final int STORM_PAUSE = 30;
    static final int UFO_PASSES = 3;
    static final int MIN_ROCK_SIDES = 8;
    static final int MAX_ROCK_SIDES = 12;
    static final int MIN_ROCK_SIZE = 20;
    static final int MAX_ROCK_SIZE = 40;
    static final int MIN_ROCK_SPEED = 2;
    static final int MAX_ROCK_SPEED = 12;
    static final int BIG_POINTS = 25;
    static final int SMALL_POINTS = 50;
    static final int UFO_POINTS = 250;
    static final int MISSLE_POINTS = 500;
    static final int NEW_SHIP_POINTS = 5000;
    static final int NEW_UFO_POINTS = 2750;
    int numStars;
    Point[] stars;
    int score;
    int highScore;
    int newShipScore;
    int newUfoScore;
    boolean loaded = false;
    boolean paused;
    boolean playing;
    boolean sound;
    boolean detail;
    boolean left = false;
    boolean right = false;
    boolean up = false;
    boolean down = false;
    AsteroidsSprite ship;
    AsteroidsSprite ufo;
    AsteroidsSprite missle;
    AsteroidsSprite[] photons = new AsteroidsSprite[5];
    AsteroidsSprite[] asteroids = new AsteroidsSprite[8];
    AsteroidsSprite[] explosions = new AsteroidsSprite[20];
    int shipsLeft;
    int shipCounter;
    int hyperCounter;
    int[] photonCounter = new int[5];
    int photonIndex;
    int ufoPassesLeft;
    int ufoCounter;
    int missleCounter;
    boolean[] asteroidIsSmall = new boolean[8];
    int asteroidsCounter;
    int asteroidsSpeed;
    int asteroidsLeft;
    int[] explosionCounter = new int[20];
    int explosionIndex;
    HyperClip crashSound;
    HyperClip explosionSound;
    HyperClip[] fireSound = new HyperClip[5];
    HyperClip missleSound;
    HyperClip saucerSound;
    HyperClip thrustersSound;
    HyperClip warpSound;
    boolean thrustersPlaying;
    boolean saucerPlaying;
    boolean misslePlaying;
    Dimension offDimension;
    Image offImage;
    Graphics offGraphics;
    Font font = new Font("Helvetica", 1, 12);
    FontMetrics fm;
    int fontWidth;
    int fontHeight;

    public String getAppletInfo() {
        return "Asteroids, Copyright 1998 by Mike Hall.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Asteroids(HyperView tView, int tx, int ty, int tWidth, int tHeight) {
        super(tView, tx, ty, tWidth, tHeight);
        int i;
        Dimension d;
        this.keyWaitObject = new Object();
        this.curView = tView;
        this.keyboard = HyperView.keyboard;
        while (this.keyboard == null) {
            this.keyboard = HyperView.keyboard;
            try {
                Asteroids asteroids = this;
                synchronized (asteroids) {
                    this.wait(200L);
                    this.notifyAll();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this.gadFlags |= 0x4108001;
        this.gobFlags |= 0x80;
        Graphics g = this.graphics;
        this.dim = d = this.getSize();
        AsteroidsSprite.width = d.width;
        AsteroidsSprite.height = d.height;
        this.numStars = AsteroidsSprite.width * AsteroidsSprite.height / 5000;
        this.stars = new Point[this.numStars];
        for (i = 0; i < this.numStars; ++i) {
            this.stars[i] = new Point((int)(Math.random() * (double)AsteroidsSprite.width), (int)(Math.random() * (double)AsteroidsSprite.height));
        }
        this.ship = new AsteroidsSprite();
        this.ship.shape.addPoint(0, -10);
        this.ship.shape.addPoint(7, 10);
        this.ship.shape.addPoint(-7, 10);
        for (i = 0; i < 5; ++i) {
            this.photons[i] = new AsteroidsSprite();
            this.photons[i].shape.addPoint(1, 1);
            this.photons[i].shape.addPoint(1, -1);
            this.photons[i].shape.addPoint(-1, 1);
            this.photons[i].shape.addPoint(-1, -1);
        }
        this.ufo = new AsteroidsSprite();
        this.ufo.shape.addPoint(-15, 0);
        this.ufo.shape.addPoint(-10, -5);
        this.ufo.shape.addPoint(-5, -5);
        this.ufo.shape.addPoint(-5, -9);
        this.ufo.shape.addPoint(5, -9);
        this.ufo.shape.addPoint(5, -5);
        this.ufo.shape.addPoint(10, -5);
        this.ufo.shape.addPoint(15, 0);
        this.ufo.shape.addPoint(10, 5);
        this.ufo.shape.addPoint(-10, 5);
        this.missle = new AsteroidsSprite();
        this.missle.shape.addPoint(0, -4);
        this.missle.shape.addPoint(1, -3);
        this.missle.shape.addPoint(1, 3);
        this.missle.shape.addPoint(2, 4);
        this.missle.shape.addPoint(-2, 4);
        this.missle.shape.addPoint(-1, 3);
        this.missle.shape.addPoint(-1, -3);
        for (i = 0; i < 8; ++i) {
            this.asteroids[i] = new AsteroidsSprite();
        }
        for (i = 0; i < 20; ++i) {
            this.explosions[i] = new AsteroidsSprite();
        }
        g.setFont(this.font);
        this.fm = g.getFontMetrics();
        this.fontWidth = this.fm.getMaxAdvance();
        this.fontHeight = this.fm.getHeight();
        this.highScore = 14325;
        this.sound = true;
        this.detail = true;
        this.initGame();
        this.endGame();
    }

    public void initGame() {
        this.score = 0;
        this.shipsLeft = 5;
        this.asteroidsSpeed = 2;
        this.newShipScore = 5000;
        this.newUfoScore = 2750;
        this.initShip();
        this.initPhotons();
        this.stopUfo();
        this.stopMissle();
        this.initAsteroids();
        this.initExplosions();
        this.playing = true;
        this.paused = false;
    }

    public void endGame() {
        this.playing = false;
        this.stopShip();
        this.stopUfo();
        this.stopMissle();
    }

    public void start() {
        this.loopThread = new Thread(this);
        this.loopThread.start();
        if (!this.loaded && this.loadThread == null) {
            this.loadThread = new Thread(this);
            this.loadThread.start();
        }
    }

    public void stop() {
        if (this.loopThread != null) {
            this.loopThread = null;
        }
        if (this.loadThread != null) {
            this.loadThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread controlThread = Thread.currentThread();
        controlThread.setPriority(1);
        long startTime = HyperView.now;
        if (!this.loaded && Thread.currentThread() == this.loadThread) {
            this.loadSounds();
            this.loaded = true;
            return;
        }
        this.graphics.setClip(this.mpX, this.mpY, this.mpWidth, this.mpHeight);
        while (true) {
            try {
                if (Thread.currentThread() != this.loopThread) break;
                if (!this.paused) {
                    this.updateShip();
                    this.updatePhotons();
                    this.updateUfo();
                    this.updateMissle();
                    this.updateAsteroids();
                    this.updateExplosions();
                    if (this.score > this.highScore) {
                        this.highScore = this.score;
                    }
                    if (this.score > this.newShipScore) {
                        this.newShipScore += 5000;
                        ++this.shipsLeft;
                    }
                    if (this.playing && this.score > this.newUfoScore && !this.ufo.active) {
                        this.newUfoScore += 2750;
                        this.ufoPassesLeft = 3;
                        this.initUfo();
                    }
                    if (this.asteroidsLeft <= 0 && --this.asteroidsCounter <= 0) {
                        this.initAsteroids();
                    }
                }
                this.update();
                try {
                    long val = Math.max(0L, (startTime += 21L) - HyperView.now);
                    if (val <= 0L) continue;
                    Asteroids asteroids = this;
                    synchronized (asteroids) {
                        this.wait(val);
                        this.notifyAll();
                    }
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
                break;
            }
        }
    }

    public void loadSounds() {
        for (int i = 0; i < 5; ++i) {
            this.fireSound[i] = new HyperClip(this.curView, "photon.au");
            this.fireSound[i].play();
            this.fireSound[i].stop();
        }
        this.crashSound = new HyperClip(this.curView, "crash.au");
        this.explosionSound = new HyperClip(this.curView, "explosion.au");
        this.missleSound = new HyperClip(this.curView, "missle.au");
        this.saucerSound = new HyperClip(this.curView, "saucer.au");
        this.thrustersSound = new HyperClip(this.curView, "thrusters.au");
        this.warpSound = new HyperClip(this.curView, "warp.au");
        if ((this.curView.ioFlags & 0x20) != 0) {
            this.crashSound.play();
            this.crashSound.stop();
            this.explosionSound.play();
            this.explosionSound.stop();
            this.missleSound.play();
            this.missleSound.stop();
            this.saucerSound.play();
            this.saucerSound.stop();
            this.thrustersSound.play();
            this.thrustersSound.stop();
            this.warpSound.play();
            this.warpSound.stop();
        }
    }

    public void initShip() {
        this.ship.active = true;
        this.ship.angle = 0.0;
        this.ship.deltaAngle = 0.0;
        this.ship.currentX = 0.0;
        this.ship.currentY = 0.0;
        this.ship.deltaX = 0.0;
        this.ship.deltaY = 0.0;
        this.ship.render();
        if (this.loaded) {
            this.thrustersSound.stop();
        }
        this.thrustersPlaying = false;
        this.hyperCounter = 0;
    }

    public void updateShip() {
        if (!this.playing) {
            return;
        }
        if (this.left) {
            this.ship.angle += 0.19634954084936207;
            if (this.ship.angle > Math.PI * 2) {
                this.ship.angle -= Math.PI * 2;
            }
        }
        if (this.right) {
            this.ship.angle -= 0.19634954084936207;
            if (this.ship.angle < 0.0) {
                this.ship.angle += Math.PI * 2;
            }
        }
        double dx = -Math.sin(this.ship.angle);
        double dy = Math.cos(this.ship.angle);
        double limit = 16.0;
        if (this.up) {
            if (this.ship.deltaX + dx > -limit && this.ship.deltaX + dx < limit) {
                this.ship.deltaX += dx;
            }
            if (this.ship.deltaY + dy > -limit && this.ship.deltaY + dy < limit) {
                this.ship.deltaY += dy;
            }
        }
        if (this.down) {
            if (this.ship.deltaX - dx > -limit && this.ship.deltaX - dx < limit) {
                this.ship.deltaX -= dx;
            }
            if (this.ship.deltaY - dy > -limit && this.ship.deltaY - dy < limit) {
                this.ship.deltaY -= dy;
            }
        }
        if (this.ship.active) {
            this.ship.advance();
            this.ship.render();
            if (this.hyperCounter > 0) {
                --this.hyperCounter;
            }
        } else if (--this.shipCounter <= 0) {
            if (this.shipsLeft > 0) {
                this.initShip();
                this.hyperCounter = 60;
            } else {
                this.endGame();
            }
        }
    }

    public void stopShip() {
        this.ship.active = false;
        this.shipCounter = 30;
        if (this.shipsLeft > 0) {
            --this.shipsLeft;
        }
        if (this.loaded) {
            this.thrustersSound.stop();
        }
        this.thrustersPlaying = false;
    }

    public void initPhotons() {
        for (int i = 0; i < 5; ++i) {
            this.photons[i].active = false;
            this.photonCounter[i] = 0;
        }
        this.photonIndex = 0;
    }

    public void updatePhotons() {
        for (int i = 0; i < 5; ++i) {
            if (!this.photons[i].active) continue;
            this.photons[i].advance();
            this.photons[i].render();
            int n = i;
            this.photonCounter[n] = this.photonCounter[n] - 1;
            if (this.photonCounter[n] >= 0) continue;
            this.photons[i].active = false;
        }
    }

    public void initUfo() {
        this.ufo.active = true;
        this.ufo.currentX = -AsteroidsSprite.width / 2;
        this.ufo.currentY = Math.random() * (double)AsteroidsSprite.height;
        this.ufo.deltaX = 2.0 + Math.random() * 10.0;
        if (Math.random() < 0.5) {
            this.ufo.deltaX = -this.ufo.deltaX;
            this.ufo.currentX = AsteroidsSprite.width / 2;
        }
        this.ufo.deltaY = 2.0 + Math.random() * 10.0;
        if (Math.random() < 0.5) {
            this.ufo.deltaY = -this.ufo.deltaY;
        }
        this.ufo.render();
        this.saucerPlaying = true;
        if (this.sound) {
            this.saucerSound.play();
        }
        this.ufoCounter = (int)Math.floor((double)AsteroidsSprite.width / Math.abs(this.ufo.deltaX));
    }

    public void updateUfo() {
        if (this.ufo.active) {
            this.ufo.advance();
            this.ufo.render();
            if (--this.ufoCounter <= 0) {
                if (--this.ufoPassesLeft > 0) {
                    this.initUfo();
                } else {
                    this.stopUfo();
                }
            } else {
                for (int i = 0; i < 5; ++i) {
                    if (!this.photons[i].active || !this.ufo.isColliding(this.photons[i])) continue;
                    if (this.sound) {
                        this.crashSound.play();
                    }
                    this.explode(this.ufo);
                    this.stopUfo();
                    this.score += 250;
                }
                int d = (int)Math.max(Math.abs(this.ufo.currentX - this.ship.currentX), Math.abs(this.ufo.currentY - this.ship.currentY));
                if (this.ship.active && this.hyperCounter <= 0 && this.ufo.active && !this.missle.active && d > 160 && Math.random() < 0.03) {
                    this.initMissle();
                }
            }
        }
    }

    public void stopUfo() {
        this.ufo.active = false;
        this.ufoCounter = 0;
        this.ufoPassesLeft = 0;
        if (this.loaded) {
            this.saucerSound.stop();
        }
        this.saucerPlaying = false;
    }

    public void initMissle() {
        this.missle.active = true;
        this.missle.angle = 0.0;
        this.missle.deltaAngle = 0.0;
        this.missle.currentX = this.ufo.currentX;
        this.missle.currentY = this.ufo.currentY;
        this.missle.deltaX = 0.0;
        this.missle.deltaY = 0.0;
        this.missle.render();
        this.missleCounter = 3 * Math.max(AsteroidsSprite.width, AsteroidsSprite.height) / 20;
        if (this.sound) {
            this.missleSound.play();
        }
        this.misslePlaying = true;
    }

    public void updateMissle() {
        if (this.missle.active) {
            if (--this.missleCounter <= 0) {
                this.stopMissle();
            } else {
                this.guideMissle();
                this.missle.advance();
                this.missle.render();
                for (int i = 0; i < 5; ++i) {
                    if (!this.photons[i].active || !this.missle.isColliding(this.photons[i])) continue;
                    if (this.sound) {
                        this.crashSound.play();
                    }
                    this.explode(this.missle);
                    this.stopMissle();
                    this.score += 500;
                }
                if (this.missle.active && this.ship.active && this.hyperCounter <= 0 && this.ship.isColliding(this.missle)) {
                    if (this.sound) {
                        this.crashSound.play();
                    }
                    this.explode(this.ship);
                    this.stopShip();
                    this.stopUfo();
                    this.stopMissle();
                }
            }
        }
    }

    public void guideMissle() {
        double angle;
        if (!this.ship.active || this.hyperCounter > 0) {
            return;
        }
        double dx = this.ship.currentX - this.missle.currentX;
        double dy = this.ship.currentY - this.missle.currentY;
        if (dx == 0.0 && dy == 0.0) {
            double d = 0.0;
        }
        if (dx == 0.0) {
            angle = dy < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        } else {
            angle = Math.atan(Math.abs(dy / dx));
            if (dy > 0.0) {
                angle = -angle;
            }
            if (dx < 0.0) {
                angle = Math.PI - angle;
            }
        }
        this.missle.angle = angle - 1.5707963267948966;
        this.missle.deltaX = 6.0 * -Math.sin(this.missle.angle);
        this.missle.deltaY = 6.0 * Math.cos(this.missle.angle);
    }

    public void stopMissle() {
        this.missle.active = false;
        this.missleCounter = 0;
        if (this.loaded) {
            this.missleSound.stop();
        }
        this.misslePlaying = false;
    }

    public void initAsteroids() {
        for (int i = 0; i < 8; ++i) {
            this.asteroids[i].shape = new Polygon();
            int s = 8 + (int)(Math.random() * 4.0);
            for (int j = 0; j < s; ++j) {
                double theta = Math.PI * 2 / (double)s * (double)j;
                double r = 20 + (int)(Math.random() * 20.0);
                int x = (int)(-Math.round(r * Math.sin(theta)));
                int y = (int)Math.round(r * Math.cos(theta));
                this.asteroids[i].shape.addPoint(x, y);
            }
            this.asteroids[i].active = true;
            this.asteroids[i].angle = 0.0;
            this.asteroids[i].deltaAngle = (Math.random() - 0.5) / 10.0;
            if (Math.random() < 0.5) {
                this.asteroids[i].currentX = -AsteroidsSprite.width / 2;
                if (Math.random() < 0.5) {
                    this.asteroids[i].currentX = AsteroidsSprite.width / 2;
                }
                this.asteroids[i].currentY = Math.random() * (double)AsteroidsSprite.height;
            } else {
                this.asteroids[i].currentX = Math.random() * (double)AsteroidsSprite.width;
                this.asteroids[i].currentY = -AsteroidsSprite.height / 2;
                if (Math.random() < 0.5) {
                    this.asteroids[i].currentY = AsteroidsSprite.height / 2;
                }
            }
            this.asteroids[i].deltaX = Math.random() * (double)this.asteroidsSpeed;
            if (Math.random() < 0.5) {
                this.asteroids[i].deltaX = -this.asteroids[i].deltaX;
            }
            this.asteroids[i].deltaY = Math.random() * (double)this.asteroidsSpeed;
            if (Math.random() < 0.5) {
                this.asteroids[i].deltaY = -this.asteroids[i].deltaY;
            }
            this.asteroids[i].render();
            this.asteroidIsSmall[i] = false;
        }
        this.asteroidsCounter = 30;
        this.asteroidsLeft = 8;
        if (this.asteroidsSpeed < 12) {
            ++this.asteroidsSpeed;
        }
    }

    public void initSmallAsteroids(int n) {
        int count = 0;
        int i = 0;
        double tempX = this.asteroids[n].currentX;
        double tempY = this.asteroids[n].currentY;
        do {
            if (this.asteroids[i].active) continue;
            this.asteroids[i].shape = new Polygon();
            int s = 8 + (int)(Math.random() * 4.0);
            for (int j = 0; j < s; ++j) {
                double theta = Math.PI * 2 / (double)s * (double)j;
                double r = (20 + (int)(Math.random() * 20.0)) / 2;
                int x = (int)(-Math.round(r * Math.sin(theta)));
                int y = (int)Math.round(r * Math.cos(theta));
                this.asteroids[i].shape.addPoint(x, y);
            }
            this.asteroids[i].active = true;
            this.asteroids[i].angle = 0.0;
            this.asteroids[i].deltaAngle = (Math.random() - 0.5) / 10.0;
            this.asteroids[i].currentX = tempX;
            this.asteroids[i].currentY = tempY;
            this.asteroids[i].deltaX = Math.random() * 2.0 * (double)this.asteroidsSpeed - (double)this.asteroidsSpeed;
            this.asteroids[i].deltaY = Math.random() * 2.0 * (double)this.asteroidsSpeed - (double)this.asteroidsSpeed;
            this.asteroids[i].render();
            this.asteroidIsSmall[i] = true;
            ++count;
            ++this.asteroidsLeft;
        } while (++i < 8 && count < 2);
    }

    public void updateAsteroids() {
        for (int i = 0; i < 8; ++i) {
            if (!this.asteroids[i].active) continue;
            this.asteroids[i].advance();
            this.asteroids[i].render();
            for (int j = 0; j < 5; ++j) {
                if (!this.photons[j].active || !this.asteroids[i].active || !this.asteroids[i].isColliding(this.photons[j])) continue;
                --this.asteroidsLeft;
                this.asteroids[i].active = false;
                this.photons[j].active = false;
                if (this.sound) {
                    this.explosionSound.play();
                }
                this.explode(this.asteroids[i]);
                if (!this.asteroidIsSmall[i]) {
                    this.score += 25;
                    this.initSmallAsteroids(i);
                    continue;
                }
                this.score += 50;
            }
            if (!this.ship.active || this.hyperCounter > 0 || !this.asteroids[i].active || !this.asteroids[i].isColliding(this.ship)) continue;
            if (this.sound) {
                this.crashSound.play();
            }
            this.explode(this.ship);
            this.stopShip();
            this.stopUfo();
            this.stopMissle();
        }
    }

    public void initExplosions() {
        for (int i = 0; i < 20; ++i) {
            this.explosions[i].shape = new Polygon();
            this.explosions[i].active = false;
            this.explosionCounter[i] = 0;
        }
        this.explosionIndex = 0;
    }

    public void explode(AsteroidsSprite s) {
        s.render();
        int c = 2;
        if (this.detail || s.sprite.npoints < 6) {
            c = 1;
        }
        for (int i = 0; i < s.sprite.npoints; i += c) {
            ++this.explosionIndex;
            if (this.explosionIndex >= 20) {
                this.explosionIndex = 0;
            }
            this.explosions[this.explosionIndex].active = true;
            this.explosions[this.explosionIndex].shape = new Polygon();
            this.explosions[this.explosionIndex].shape.addPoint(s.shape.xpoints[i], s.shape.ypoints[i]);
            int j = i + 1;
            if (j >= s.sprite.npoints) {
                j -= s.sprite.npoints;
            }
            this.explosions[this.explosionIndex].shape.addPoint(s.shape.xpoints[j], s.shape.ypoints[j]);
            this.explosions[this.explosionIndex].angle = s.angle;
            this.explosions[this.explosionIndex].deltaAngle = (Math.random() * 2.0 * Math.PI - Math.PI) / 15.0;
            this.explosions[this.explosionIndex].currentX = s.currentX;
            this.explosions[this.explosionIndex].currentY = s.currentY;
            this.explosions[this.explosionIndex].deltaX = -s.shape.xpoints[i] / 5;
            this.explosions[this.explosionIndex].deltaY = -s.shape.ypoints[i] / 5;
            this.explosionCounter[this.explosionIndex] = 30;
        }
    }

    public void updateExplosions() {
        for (int i = 0; i < 20; ++i) {
            if (!this.explosions[i].active) continue;
            this.explosions[i].advance();
            this.explosions[i].render();
            int n = i;
            this.explosionCounter[n] = this.explosionCounter[n] - 1;
            if (this.explosionCounter[n] >= 0) continue;
            this.explosions[i].active = false;
        }
    }

    @Override
    public void inKey() {
        int index = 0;
        KeyEvent tmpKey = null;
        try {
            while (this.keyboard.mainBufferIndex != this.keyboard.intBufferIndex) {
                index = this.keyboard.mainBufferIndex;
                tmpKey = this.keyboard.keyMsg[index].keyEvent;
                char tmpChar = tmpKey.getKeyChar();
                int key = tmpKey.getKeyCode();
                if ((this.keyboard.keyMsg[index].flags & 1) != 0) {
                    switch (key) {
                        case 8: {
                            break;
                        }
                        case 10: 
                        case 13: {
                            break;
                        }
                        case 37: {
                            this.left = true;
                            break;
                        }
                        case 38: {
                            this.up = true;
                            this.thrustersPlaying = true;
                            break;
                        }
                        case 39: {
                            this.right = true;
                            break;
                        }
                        case 40: {
                            this.thrustersPlaying = true;
                            this.down = true;
                            break;
                        }
                    }
                } else if ((this.keyboard.keyMsg[index].flags & 2) != 0) {
                    switch (key) {
                        case 8: {
                            break;
                        }
                        case 10: 
                        case 13: {
                            break;
                        }
                        case 37: {
                            this.left = false;
                            break;
                        }
                        case 38: {
                            this.thrustersPlaying = false;
                            this.thrustersSound.stop();
                            this.up = false;
                            break;
                        }
                        case 39: {
                            this.right = false;
                            break;
                        }
                        case 40: {
                            this.thrustersPlaying = false;
                            this.thrustersSound.stop();
                            this.down = false;
                            break;
                        }
                        case 68: {
                            this.detail = !this.detail;
                            break;
                        }
                        case 85: {
                            this.initUfo();
                            break;
                        }
                    }
                }
                if (this.thrustersPlaying) {
                    this.thrustersSound.play();
                    this.thrustersPlaying = false;
                }
                if (key == 32 && this.ship.active) {
                    ++this.photonIndex;
                    if (this.photonIndex >= 5) {
                        this.photonIndex = 0;
                    }
                    if (this.sound & !this.paused) {
                        this.fireSound[this.photonIndex].play();
                    }
                    this.photons[this.photonIndex].active = true;
                    this.photons[this.photonIndex].currentX = this.ship.currentX;
                    this.photons[this.photonIndex].currentY = this.ship.currentY;
                    this.photons[this.photonIndex].deltaX = 20.0 * -Math.sin(this.ship.angle);
                    this.photons[this.photonIndex].deltaY = 20.0 * Math.cos(this.ship.angle);
                    this.photonCounter[this.photonIndex] = Math.min(AsteroidsSprite.width, AsteroidsSprite.height) / 20;
                }
                if (key == 72 && this.ship.active && this.hyperCounter <= 0) {
                    this.ship.currentX = Math.random() * (double)AsteroidsSprite.width;
                    this.ship.currentX = Math.random() * (double)AsteroidsSprite.height;
                    this.hyperCounter = 60;
                    if (this.sound & !this.paused) {
                        this.warpSound.play();
                    }
                }
                if (key == 112) {
                    if (this.paused) {
                        if (this.sound && this.misslePlaying) {
                            this.missleSound.play();
                        }
                        if (this.sound && this.saucerPlaying) {
                            this.saucerSound.play();
                        }
                        if (this.sound && this.thrustersPlaying) {
                            this.thrustersSound.play();
                            this.thrustersPlaying = false;
                        }
                    } else {
                        if (this.misslePlaying) {
                            this.missleSound.stop();
                        }
                        if (this.saucerPlaying) {
                            this.saucerSound.stop();
                        }
                        if (this.thrustersPlaying) {
                            this.thrustersSound.stop();
                        }
                    }
                    boolean bl = this.paused = !this.paused;
                }
                if (key == 109 && this.loaded) {
                    if (this.sound) {
                        this.crashSound.stop();
                        this.explosionSound.stop();
                        for (int i = 0; i < 5; ++i) {
                            this.fireSound[i].stop();
                        }
                        this.missleSound.stop();
                        this.saucerSound.stop();
                        this.thrustersSound.stop();
                        this.warpSound.stop();
                    } else {
                        if (this.misslePlaying && !this.paused) {
                            this.missleSound.play();
                        }
                        if (this.saucerPlaying && !this.paused) {
                            this.saucerSound.play();
                        }
                        if (this.thrustersPlaying && !this.paused) {
                            this.thrustersSound.play();
                        }
                    }
                    boolean bl = this.sound = !this.sound;
                }
                if (key == 83 && this.loaded && !this.playing) {
                    this.initGame();
                }
                ++this.keyboard.mainBufferIndex;
                if (this.keyboard.mainBufferIndex < 512) continue;
                this.keyboard.mainBufferIndex = 0;
            }
        }
        catch (NullPointerException npex) {
            npex.printStackTrace();
            System.exit(1);
        }
        catch (Exception any) {
            any.printStackTrace();
            System.exit(1);
        }
    }

    public void update() {
        int i;
        Dimension d = this.dim;
        if (this.offGraphics == null || d.width != this.offDimension.width || d.height != this.offDimension.height) {
            this.offDimension = d;
            this.offImage = this.curView.createImage(this.width, this.height);
            this.offGraphics = this.offImage.getGraphics();
        }
        this.offGraphics.setColor(Color.black);
        this.offGraphics.fillRect(this.mpX, this.mpY, this.mpWidth, this.mpHeight);
        if (this.detail) {
            this.offGraphics.setColor(Color.white);
            for (i = 0; i < this.numStars; ++i) {
                this.offGraphics.setColor(this.curView.color[i + 2]);
                this.offGraphics.drawLine(this.stars[i].x, this.stars[i].y, this.stars[i].x, this.stars[i].y);
            }
        }
        for (i = 0; i < 5; ++i) {
            if (!this.photons[i].active) continue;
            this.offGraphics.setColor(this.curView.color[3]);
            this.offGraphics.drawPolygon(this.photons[i].sprite);
        }
        int c = Math.min(this.missleCounter * 24, 255);
        this.offGraphics.setColor(new Color(c, c, c));
        if (this.missle.active) {
            this.offGraphics.drawPolygon(this.missle.sprite);
            this.offGraphics.drawLine(this.missle.sprite.xpoints[this.missle.sprite.npoints - 1], this.missle.sprite.ypoints[this.missle.sprite.npoints - 1], this.missle.sprite.xpoints[0], this.missle.sprite.ypoints[0]);
        }
        int n = 1;
        for (i = 0; i < 8; ++i) {
            if (!this.asteroids[i].active) continue;
            if (this.detail) {
                this.offGraphics.setColor(Color.black);
                this.offGraphics.fillPolygon(this.asteroids[i].sprite);
            }
            this.offGraphics.setColor(this.curView.color[n++]);
            this.offGraphics.drawPolygon(this.asteroids[i].sprite);
            this.offGraphics.drawLine(this.asteroids[i].sprite.xpoints[this.asteroids[i].sprite.npoints - 1], this.asteroids[i].sprite.ypoints[this.asteroids[i].sprite.npoints - 1], this.asteroids[i].sprite.xpoints[0], this.asteroids[i].sprite.ypoints[0]);
        }
        if (this.ufo.active) {
            if (this.detail) {
                this.offGraphics.setColor(Color.black);
                this.offGraphics.fillPolygon(this.ufo.sprite);
            }
            this.offGraphics.setColor(this.curView.color[2]);
            this.offGraphics.drawPolygon(this.ufo.sprite);
            this.offGraphics.drawLine(this.ufo.sprite.xpoints[this.ufo.sprite.npoints - 1], this.ufo.sprite.ypoints[this.ufo.sprite.npoints - 1], this.ufo.sprite.xpoints[0], this.ufo.sprite.ypoints[0]);
        }
        c = 255 - 4 * this.hyperCounter;
        if (this.ship.active) {
            if (this.detail && this.hyperCounter == 0) {
                this.offGraphics.setColor(Color.black);
                this.offGraphics.fillPolygon(this.ship.sprite);
            }
            this.offGraphics.setColor(new Color(c, c, c));
            this.offGraphics.drawPolygon(this.ship.sprite);
            this.offGraphics.drawLine(this.ship.sprite.xpoints[this.ship.sprite.npoints - 1], this.ship.sprite.ypoints[this.ship.sprite.npoints - 1], this.ship.sprite.xpoints[0], this.ship.sprite.ypoints[0]);
        }
        for (i = 0; i < 20; ++i) {
            if (!this.explosions[i].active) continue;
            c = 8 * this.explosionCounter[i];
            this.offGraphics.setColor(new Color(c, c, c));
            this.offGraphics.drawPolygon(this.explosions[i].sprite);
        }
        this.offGraphics.setFont(this.font);
        this.offGraphics.setColor(Color.white);
        this.offGraphics.drawString("Score: " + this.score, this.fontWidth, this.fontHeight);
        this.offGraphics.drawString("Ships: " + this.shipsLeft, this.fontWidth, d.height);
        String s = "High: " + this.highScore;
        this.offGraphics.drawString(s, d.width - (this.fontWidth + this.fm.stringWidth(s)), this.fontHeight);
        if (!this.sound) {
            s = "Mute";
            this.offGraphics.drawString(s, d.width - (this.fontWidth + this.fm.stringWidth(s)), d.height - this.fontHeight);
        }
        if (!this.playing) {
            s = "H V - A S T E R O I D S";
            this.offGraphics.drawString(s, (d.width - this.fm.stringWidth(s)) / 2, (20 + this.fontHeight) * 2);
            s = "HyperView / JDK 1.5_1-b08 Port by Tony Swain";
            this.offGraphics.drawString(s, (d.width - this.fm.stringWidth(s)) / 2, 20 + this.fontHeight * 5);
            s = "HyperView URL: http://hyperbyte.ab.ca/hyperview";
            this.offGraphics.drawString(s, (d.width - this.fm.stringWidth(s)) / 2, 20 + this.fontHeight * 6);
            s = "Original version copyright 1998 by Mike Hall";
            this.offGraphics.drawString(s, (d.width - this.fm.stringWidth(s)) / 2, 20 + this.fontHeight * 7);
            if (!this.loaded) {
                s = "Loading sounds...";
                this.offGraphics.drawString(s, (d.width - this.fm.stringWidth(s)) / 2, 20 + this.fontHeight * 8);
            } else {
                s = "Game Over";
                this.offGraphics.drawString(s, (d.width - this.fm.stringWidth(s)) / 2, 20 + this.fontHeight * 8);
                s = "'S' to Start";
                this.offGraphics.drawString(s, (d.width - this.fm.stringWidth(s)) / 2, 20 + this.fontHeight * 9);
            }
        } else if (this.paused) {
            s = "Game Paused";
            this.offGraphics.drawString(s, (d.width - this.fm.stringWidth(s)) / 2, 20 + this.fontHeight);
        }
        this.graphics.drawImage(this.offImage, this.mpX, this.mpY, this.mpX2, this.mpY2, this.mpX, this.mpY, this.mpX2, this.mpY2, this.curView);
        this.updated = true;
    }
}

